/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.API;
import com.oracle.truffle.nfi.NFIContext;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFILibrary;
import com.oracle.truffle.nfi.NFIOptions;
import com.oracle.truffle.nfi.NFIPreBindException;
import com.oracle.truffle.nfi.NFIRootNodeFactory;
import com.oracle.truffle.nfi.NativeSource;
import com.oracle.truffle.nfi.SignatureRootNode;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIBackend;
import com.oracle.truffle.nfi.backend.spi.types.NativeLibraryDescriptor;
import org.graalvm.options.OptionValues;

class NFIRootNode
extends RootNode {
    @Node.Child
    LoadLibraryNode loadLibrary;
    @Node.Children
    LookupAndBindNode[] lookupAndBind;
    @Node.Child
    GetBackendNode getBackend;

    NFIRootNode(NFILanguage language, NativeSource.ParsedLibrary source, String backendId) {
        super((TruffleLanguage)language);
        this.loadLibrary = NFIRootNodeFactory.LoadLibraryNodeGen.create(source.getLibraryDescriptor());
        this.lookupAndBind = new LookupAndBindNode[source.preBoundSymbolsLength()];
        this.getBackend = backendId == null ? new GetDefaultBackendNode() : new GetSelectedBackendNode(backendId);
        for (int i = 0; i < this.lookupAndBind.length; ++i) {
            this.lookupAndBind[i] = NFIRootNodeFactory.LookupAndBindNodeGen.create(source.getPreBoundSymbol(i), source.getPreBoundSignature(i));
        }
    }

    public boolean isInternal() {
        return true;
    }

    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        API api = this.getBackend.execute();
        Object library = this.loadLibrary.execute(api.backend);
        if (this.lookupAndBind.length == 0) {
            return library;
        }
        NFILibrary ret = new NFILibrary(library);
        for (LookupAndBindNode l : this.lookupAndBind) {
            ret.preBindSymbol(l.name, l.execute(api, library));
        }
        return ret;
    }

    static abstract class LoadLibraryNode
    extends Node {
        private final NativeLibraryDescriptor descriptor;

        LoadLibraryNode(NativeLibraryDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        protected abstract Object execute(NFIBackend var1);

        @CompilerDirectives.TruffleBoundary
        CallTarget parseLibrary(NFIBackend backend) {
            return backend.parse(this.descriptor);
        }

        @Specialization(limit="5", guards={"backend == cachedBackend"})
        Object doCached(NFIBackend backend, @Cached(value="backend", weak=true) NFIBackend cachedBackend, @Cached(value="create(parseLibrary(cachedBackend))") DirectCallNode callNode) {
            assert (backend == cachedBackend);
            return callNode.call(new Object[0]);
        }

        @Specialization(replaces={"doCached"})
        Object doGeneric(NFIBackend backend, @Cached IndirectCallNode callNode) {
            return callNode.call(this.parseLibrary(backend), new Object[0]);
        }
    }

    static abstract class LookupAndBindNode
    extends Node {
        private final String name;
        @Node.Child
        SignatureRootNode.BuildSignatureNode signature;

        LookupAndBindNode(String name, SignatureRootNode.BuildSignatureNode signature) {
            this.name = name;
            this.signature = signature;
        }

        abstract Object execute(API var1, Object var2);

        @Specialization(limit="1")
        Object doLookupAndBind(API api, Object library, @CachedLibrary(value="library") InteropLibrary libInterop, @CachedLibrary(limit="1") SignatureLibrary signatures) {
            try {
                Object symbol = libInterop.readMember(library, this.name);
                Object sig = this.signature.execute(api);
                return signatures.bind(sig, symbol);
            }
            catch (InteropException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new NFIPreBindException(ex.getMessage(), this);
            }
        }
    }

    private final class GetDefaultBackendNode
    extends GetBackendNode {
        private GetDefaultBackendNode() {
        }

        @CompilerDirectives.TruffleBoundary
        String getDefaultBackendOption(OptionValues values) {
            return (String)values.get(NFIOptions.DEFAULT_BACKEND);
        }

        @Override
        API execute() {
            NFIContext ctx = NFIContext.get(this);
            String defaultBackendId = this.getDefaultBackendOption(ctx.env.getOptions());
            return ctx.getAPI(defaultBackendId, this);
        }
    }

    private abstract class GetBackendNode
    extends Node {
        private GetBackendNode() {
        }

        abstract API execute();
    }

    private final class GetSelectedBackendNode
    extends GetBackendNode {
        private final String backendId;

        GetSelectedBackendNode(String backendId) {
            this.backendId = backendId;
        }

        @Override
        API execute() {
            return NFIContext.get(this).getAPI(this.backendId, this);
        }
    }
}

