/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.util.AbstractList;
import java.util.List;
import java.util.function.Consumer;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotExecutionListenerDispatch
extends AbstractPolyglotImpl.AbstractExecutionListenerDispatch {
    static final Object[] EMPTY_ARRAY = new Object[0];

    PolyglotExecutionListenerDispatch(PolyglotImpl engineImpl) {
        super((AbstractPolyglotImpl)engineImpl);
    }

    public void closeExecutionListener(Object impl) {
        try {
            ((ListenerImpl)impl).closing = true;
            ((ListenerImpl)impl).binding.dispose();
        }
        catch (Throwable t) {
            throw PolyglotExecutionListenerDispatch.wrapException(((ListenerImpl)impl).engine, t);
        }
    }

    private static RuntimeException wrapException(PolyglotEngineImpl engine, Throwable t) {
        return PolyglotImpl.guestToHostException(engine, t);
    }

    static class ListenerImpl {
        final AbstractPolyglotImpl.AbstractExecutionEventDispatch executionEventDispatch;
        final PolyglotEngineImpl engine;
        final Consumer<Object> onEnter;
        final Consumer<Object> onReturn;
        final AbstractPolyglotImpl.ManagementAccess management;
        final boolean collectInputValues;
        final boolean collectReturnValues;
        final boolean collectExceptions;
        volatile EventBinding<?> binding;
        volatile boolean closing;

        ListenerImpl(AbstractPolyglotImpl.AbstractExecutionEventDispatch executionEventDispatch, PolyglotEngineImpl engine, Consumer<Object> onEnter, Consumer<Object> onReturn, boolean collectInputValues, boolean collectReturnValues, boolean collectExceptions) {
            this.executionEventDispatch = executionEventDispatch;
            this.engine = engine;
            this.onEnter = onEnter;
            this.onReturn = onReturn;
            this.management = engine.impl.getManagement();
            this.collectInputValues = collectInputValues;
            this.collectReturnValues = collectReturnValues;
            this.collectExceptions = collectExceptions;
        }
    }

    static class ReadOnlyValueList
    extends AbstractList<Object> {
        static final ReadOnlyValueList EMPTY = new ReadOnlyValueList(new Object[0]);
        private final Object[] valueArray;

        ReadOnlyValueList(Object[] valueArray) {
            this.valueArray = valueArray;
        }

        @Override
        public Object get(int index) {
            return this.valueArray[index];
        }

        @Override
        public int size() {
            return this.valueArray.length;
        }
    }

    static abstract class AbstractNode
    extends ExecutionEventNode
    implements Event {
        final ListenerImpl config;
        final EventContext context;
        final Object cachedEvent;

        AbstractNode(ListenerImpl config, EventContext context) {
            this.config = config;
            this.context = context;
            this.cachedEvent = config.management.newExecutionEvent(config.executionEventDispatch, (Object)this);
        }

        @Override
        public String getRootName() {
            RootNode rootNode = this.context.getInstrumentedNode().getRootNode();
            if (rootNode == null) {
                return null;
            }
            try {
                return rootNode.getName();
            }
            catch (Throwable t) {
                throw PolyglotImpl.guestToHostException(this.config.engine, t);
            }
        }

        @Override
        protected final void onEnter(VirtualFrame frame) {
            if (this.config.onEnter != null) {
                try {
                    this.invokeOnEnter();
                }
                catch (Throwable t) {
                    throw PolyglotImpl.hostToGuestException(this.config.engine, t);
                }
            }
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected final void invokeOnEnter() {
            this.config.onEnter.accept(this.cachedEvent);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected final void invokeReturn() {
            this.config.onReturn.accept(this.cachedEvent);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected final void invokeException() {
            this.config.onReturn.accept(this.cachedEvent);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected final void invokeReturnAllocate(List<Object> inputValues, Object returnValue) {
            this.config.onReturn.accept(this.config.management.newExecutionEvent(this.config.executionEventDispatch, (Object)new DynamicEvent(this, inputValues, returnValue, null)));
        }

        @Override
        public final Object getLocation() {
            return PolyglotImpl.getPolyglotSourceSection(this.config.engine.impl, this.context.getInstrumentedSourceSection());
        }

        @Override
        public final List<Object> getInputValues() {
            if (this.config.collectInputValues) {
                return ReadOnlyValueList.EMPTY;
            }
            return null;
        }

        @Override
        public final RuntimeException getException() {
            return null;
        }

        @Override
        public final Object getReturnValue() {
            return null;
        }

        @Override
        public final EventContext getContext() {
            return this.context;
        }

        @Override
        public final PolyglotEngineImpl getEngine() {
            return this.config.engine;
        }
    }

    static class DefaultNode
    extends AbstractNode
    implements Event {
        DefaultNode(ListenerImpl config, EventContext context) {
            super(config, context);
        }

        @Override
        protected void onReturnValue(VirtualFrame frame, Object result) {
            if (this.config.onReturn != null) {
                try {
                    this.invokeReturn();
                }
                catch (Throwable t) {
                    throw PolyglotImpl.hostToGuestException(this.config.engine, t);
                }
            }
        }

        @Override
        protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
            if (this.config.onReturn != null) {
                try {
                    this.invokeException();
                }
                catch (Throwable t) {
                    throw PolyglotImpl.hostToGuestException(this.config.engine, t);
                }
            }
        }
    }

    static class ProfilingNode
    extends AbstractNode
    implements Event {
        @CompilerDirectives.CompilationFinal
        boolean seenInputValues;
        @CompilerDirectives.CompilationFinal
        boolean seenReturnValue;
        final PolyglotLanguage language;

        ProfilingNode(ListenerImpl config, EventContext context) {
            super(config, context);
            PolyglotLanguage languageToUse = null;
            SourceSection location = context.getInstrumentedSourceSection();
            if (location != null) {
                languageToUse = config.engine.idToLanguage.get(location.getSource().getLanguage());
            }
            if (languageToUse == null) {
                assert (false);
                languageToUse = config.engine.hostLanguage;
            }
            this.language = languageToUse;
        }

        @Override
        protected void onInputValue(VirtualFrame frame, EventContext inputContext, int inputIndex, Object inputValue) {
            assert (this.config.onReturn != null && this.config.collectInputValues);
            if (!this.seenInputValues) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenInputValues = true;
            }
            this.saveInputValue(frame, inputIndex, inputValue);
        }

        @Override
        protected void onReturnValue(VirtualFrame frame, Object result) {
            if (this.config.onReturn != null) {
                try {
                    if (this.config.collectReturnValues && !this.seenReturnValue && result != null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.seenReturnValue = true;
                    }
                    if (this.seenReturnValue || this.seenInputValues) {
                        Object[] inputValues = this.seenInputValues ? this.getSavedInputValues(frame) : EMPTY_ARRAY;
                        this.invokeReturnAllocate(inputValues, result);
                    } else {
                        this.invokeReturn();
                    }
                }
                catch (Throwable t) {
                    throw PolyglotImpl.hostToGuestException(this.config.engine, t);
                }
            }
        }

        @Override
        protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
            if (this.config.onReturn != null) {
                try {
                    if (this.seenReturnValue || this.seenInputValues) {
                        Object[] inputValues = this.seenInputValues ? this.getSavedInputValues(frame) : EMPTY_ARRAY;
                        this.invokeExceptionAllocate(inputValues, exception);
                    } else if (this.config.collectExceptions) {
                        this.invokeExceptionAllocate(this.config.collectInputValues ? ReadOnlyValueList.EMPTY : (List)null, exception);
                    } else {
                        this.invokeException();
                    }
                }
                catch (Throwable t) {
                    throw PolyglotImpl.hostToGuestException(this.config.engine, t);
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void invokeExceptionAllocate(Object[] inputValues, Throwable result) {
            ReadOnlyValueList convertedInputValues;
            boolean reportInputValues;
            boolean reportException = this.config.collectExceptions;
            boolean bl = reportInputValues = this.config.collectInputValues && inputValues.length > 0;
            if (!reportException && !reportInputValues) {
                this.invokeException();
                return;
            }
            PolyglotLanguageContext languageContext = this.language.getCurrentLanguageContext();
            if (reportInputValues) {
                Object[] hostValues = new Object[inputValues.length];
                for (int i = 0; i < inputValues.length; ++i) {
                    Object guestValue = inputValues[i];
                    hostValues[i] = guestValue != null ? languageContext.asValue(inputValues[i]) : null;
                }
                convertedInputValues = new ReadOnlyValueList(hostValues);
            } else {
                convertedInputValues = ReadOnlyValueList.EMPTY;
            }
            this.invokeExceptionAllocate(convertedInputValues, result);
        }

        @CompilerDirectives.TruffleBoundary
        private void invokeReturnAllocate(Object[] inputValues, Object result) {
            boolean reportInputValues;
            boolean reportResult = this.config.collectReturnValues && result != null;
            boolean bl = reportInputValues = this.config.collectInputValues && inputValues.length > 0;
            if (!reportResult && !reportInputValues) {
                this.invokeReturn();
                return;
            }
            PolyglotLanguageContext languageContext = this.language.getCurrentLanguageContext();
            Object returnValue = reportResult ? languageContext.asValue(result) : null;
            ReadOnlyValueList convertedInputValues = reportInputValues ? new ReadOnlyValueList(languageContext.toHostValues(inputValues)) : ReadOnlyValueList.EMPTY;
            this.invokeReturnAllocate(convertedInputValues, returnValue);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected final void invokeExceptionAllocate(List<Object> inputValues, Throwable e) {
            RuntimeException ex = e != null ? PolyglotImpl.guestToHostException(this.language.getCurrentLanguageContext(), e, true) : null;
            this.config.onReturn.accept(this.config.management.newExecutionEvent(this.config.executionEventDispatch, (Object)new DynamicEvent(this, inputValues, null, ex)));
        }
    }

    static final class DynamicEvent
    implements Event {
        final AbstractNode node;
        final List<Object> inputValues;
        final Object returnValue;
        final RuntimeException exception;

        DynamicEvent(AbstractNode node, List<Object> inputValues, Object returnValue, RuntimeException ex) {
            this.node = node;
            this.inputValues = inputValues;
            this.returnValue = returnValue;
            this.exception = ex;
        }

        @Override
        public String getRootName() {
            return this.node.getRootName();
        }

        @Override
        public RuntimeException getException() {
            return this.exception;
        }

        @Override
        public Object getLocation() {
            return this.node.getLocation();
        }

        @Override
        public List<Object> getInputValues() {
            return this.inputValues;
        }

        @Override
        public Object getReturnValue() {
            return this.returnValue;
        }

        @Override
        public EventContext getContext() {
            return this.node.context;
        }

        @Override
        public PolyglotEngineImpl getEngine() {
            return this.node.getEngine();
        }
    }

    static interface Event {
        public String getRootName();

        public Object getLocation();

        public List<Object> getInputValues();

        public Object getReturnValue();

        public EventContext getContext();

        public RuntimeException getException();

        public PolyglotEngineImpl getEngine();
    }
}

