/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.CharacterStream;
import sqlj.runtime.SQLNullException;
import sqlj.runtime.Scrollable;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.ref.RTStatementJDBCBase;

public class RTResultSetJDBC
implements RTResultSet,
Scrollable {
    protected ResultSet rs;
    private boolean m_isClosed = false;
    private boolean m_isValidRow = false;
    private RTStatementJDBCBase m_parent = null;
    private int[] m_indicatorArray = null;

    public RTResultSetJDBC(ResultSet resultSet) {
        this.rs = resultSet;
    }

    RTResultSetJDBC(ResultSet resultSet, RTStatementJDBCBase rTStatementJDBCBase) {
        this.rs = resultSet;
        this.m_parent = rTStatementJDBCBase;
    }

    @Override
    public ResultSet getJDBCResultSet() {
        return this.rs;
    }

    @Override
    public boolean next() throws SQLException {
        this.m_isValidRow = this.rs.next();
        return this.m_isValidRow;
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.rs.findColumn(string);
    }

    @Override
    public String getString(int n2) throws SQLException {
        return this.rs.getString(n2);
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        return this.rs.getBytes(n2);
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        return this.rs.getDate(n2);
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        return this.rs.getTime(n2);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.rs.getTimestamp(n2);
    }

    @Override
    public boolean getBooleanNoNull(int n2) throws SQLException {
        boolean bl2 = this.rs.getBoolean(n2);
        if (this.isIndicatorSet(n2)) {
            return bl2;
        }
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return bl2;
    }

    @Override
    public byte getByteNoNull(int n2) throws SQLException {
        byte by2 = this.rs.getByte(n2);
        if (this.isIndicatorSet(n2)) {
            return by2;
        }
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return by2;
    }

    @Override
    public short getShortNoNull(int n2) throws SQLException {
        short s2 = this.rs.getShort(n2);
        if (this.isIndicatorSet(n2)) {
            return s2;
        }
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return s2;
    }

    @Override
    public int getIntNoNull(int n2) throws SQLException {
        int n3 = this.rs.getInt(n2);
        if (this.isIndicatorSet(n2)) {
            return n3;
        }
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return n3;
    }

    @Override
    public long getLongNoNull(int n2) throws SQLException {
        long l2 = this.rs.getLong(n2);
        if (this.isIndicatorSet(n2)) {
            return l2;
        }
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return l2;
    }

    @Override
    public float getFloatNoNull(int n2) throws SQLException {
        float f10 = this.rs.getFloat(n2);
        if (this.isIndicatorSet(n2)) {
            return f10;
        }
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return f10;
    }

    @Override
    public double getDoubleNoNull(int n2) throws SQLException {
        double d10 = this.rs.getDouble(n2);
        if (this.isIndicatorSet(n2)) {
            return d10;
        }
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return d10;
    }

    @Override
    public Boolean getBooleanWrapper(int n2) throws SQLException {
        boolean bl2 = this.rs.getBoolean(n2);
        return this.rs.wasNull() ? null : Boolean.valueOf(bl2);
    }

    @Override
    public Byte getByteWrapper(int n2) throws SQLException {
        byte by2 = this.rs.getByte(n2);
        return this.rs.wasNull() ? null : Byte.valueOf(by2);
    }

    @Override
    public Short getShortWrapper(int n2) throws SQLException {
        short s2 = this.rs.getShort(n2);
        return this.rs.wasNull() ? null : Short.valueOf(s2);
    }

    @Override
    public Integer getIntWrapper(int n2) throws SQLException {
        int n3 = this.rs.getInt(n2);
        return this.rs.wasNull() ? null : Integer.valueOf(n3);
    }

    @Override
    public Long getLongWrapper(int n2) throws SQLException {
        long l2 = this.rs.getLong(n2);
        return this.rs.wasNull() ? null : Long.valueOf(l2);
    }

    @Override
    public Float getFloatWrapper(int n2) throws SQLException {
        float f10 = this.rs.getFloat(n2);
        return this.rs.wasNull() ? null : Float.valueOf(f10);
    }

    @Override
    public Double getDoubleWrapper(int n2) throws SQLException {
        double d10 = this.rs.getDouble(n2);
        return this.rs.wasNull() ? null : Double.valueOf(d10);
    }

    @Override
    public AsciiStream getAsciiStreamWrapper(int n2) throws SQLException {
        InputStream inputStream = this.rs.getAsciiStream(n2);
        return inputStream == null || this.rs.wasNull() ? null : new AsciiStream(inputStream);
    }

    @Override
    public CharacterStream getCharacterStreamWrapper(int n2) throws SQLException {
        Reader reader = this.rs.getCharacterStream(n2);
        return reader == null || this.rs.wasNull() ? null : new CharacterStream(reader);
    }

    @Override
    public BinaryStream getBinaryStreamWrapper(int n2) throws SQLException {
        InputStream inputStream = this.rs.getBinaryStream(n2);
        return inputStream == null || this.rs.wasNull() ? null : new BinaryStream(inputStream);
    }

    @Override
    public UnicodeStream getUnicodeStreamWrapper(int n2) throws SQLException {
        InputStream inputStream = this.rs.getUnicodeStream(n2);
        return inputStream == null || this.rs.wasNull() ? null : new UnicodeStream(inputStream);
    }

    @Override
    public Object getObject(int n2, Class clazz) throws SQLException {
        Object object = this.rs.getObject(n2);
        if (object == null) {
            return object;
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            ProfileRefErrors.raise_INCOMPATIBLE_TYPE(clazz, object.getClass());
        }
        return object;
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.rs.getBigDecimal(n2);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.rs.getMetaData().getColumnCount();
    }

    @Override
    public boolean isValidRow() throws SQLException {
        return this.m_isValidRow;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_isClosed;
    }

    @Override
    public void close() throws SQLException {
        if (!this.m_isClosed) {
            try {
                this.m_isClosed = true;
                this.rs.close();
            }
            finally {
                if (this.m_parent != null) {
                    this.m_parent.notifyClosed(this);
                }
                this.m_indicatorArray = null;
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.rs.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.rs.clearWarnings();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.rs.getFetchSize();
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        this.rs.setFetchSize(n2);
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        return this.rs.getBlob(n2);
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        return this.rs.getClob(n2);
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        return this.rs.getRef(n2);
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        return this.rs.getSQLXML(n2);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        return this.rs.getRowId(n2);
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        return this.rs.absolute(n2);
    }

    @Override
    public void afterLast() throws SQLException {
        this.rs.afterLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.rs.beforeFirst();
    }

    @Override
    public boolean first() throws SQLException {
        return this.rs.first();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.rs.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.rs.isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.rs.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.rs.isLast();
    }

    @Override
    public boolean last() throws SQLException {
        return this.rs.last();
    }

    @Override
    public boolean previous() throws SQLException {
        return this.rs.previous();
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        return this.rs.relative(n2);
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        this.rs.setFetchDirection(n2);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.rs.getFetchDirection();
    }

    @Override
    public short getIndicator(int n2) throws SQLException {
        short s2 = 0;
        if (this.isIndicatorSet(n2)) {
            if (this.rs.wasNull()) {
                s2 = -1;
            }
        } else {
            ProfileRefErrors.raise_UNEXPECTED_CALL("getIndicator(" + n2 + ")");
        }
        return s2;
    }

    @Override
    public void setOutputIndicators(int[] nArray) throws SQLException {
        this.m_indicatorArray = nArray;
    }

    private boolean isIndicatorSet(int n2) {
        return this.m_indicatorArray != null && Arrays.binarySearch(this.m_indicatorArray, n2) >= 0;
    }
}

