/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.ImportClauseNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class ImportNode
extends Node {
    private final LiteralNode<TruffleString> moduleSpecifier;
    private final ImportClauseNode importClause;
    private final Map<TruffleString, TruffleString> attributes;

    public ImportNode(long token, int start, int finish, LiteralNode<TruffleString> moduleSpecifier, Map<TruffleString, TruffleString> attributes) {
        this(token, start, finish, moduleSpecifier, null, attributes);
    }

    public ImportNode(long token, int start, int finish, ImportClauseNode importClause, LiteralNode<TruffleString> moduleSpecifier, Map<TruffleString, TruffleString> attributes) {
        this(token, start, finish, moduleSpecifier, importClause, attributes);
    }

    private ImportNode(long token, int start, int finish, LiteralNode<TruffleString> moduleSpecifier, ImportClauseNode importClause, Map<TruffleString, TruffleString> attributes) {
        super(token, start, finish);
        this.moduleSpecifier = Objects.requireNonNull(moduleSpecifier);
        this.importClause = importClause;
        this.attributes = Objects.requireNonNull(attributes);
    }

    private ImportNode(ImportNode node, LiteralNode<TruffleString> moduleSpecifier, ImportClauseNode importClause) {
        super(node);
        this.moduleSpecifier = Objects.requireNonNull(moduleSpecifier);
        this.importClause = importClause;
        this.attributes = Objects.requireNonNull(node.attributes);
    }

    public LiteralNode<TruffleString> getModuleSpecifier() {
        return this.moduleSpecifier;
    }

    public ImportClauseNode getImportClause() {
        return this.importClause;
    }

    public Map<TruffleString, TruffleString> getAttributes() {
        return this.attributes;
    }

    public ImportNode setModuleSpecifier(LiteralNode<TruffleString> moduleSpecifier) {
        if (this.moduleSpecifier == moduleSpecifier) {
            return this;
        }
        return new ImportNode(this, moduleSpecifier, this.importClause);
    }

    public ImportNode setImportClause(ImportClauseNode importClause) {
        if (this.importClause == importClause) {
            return this;
        }
        return new ImportNode(this, this.moduleSpecifier, importClause);
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterImportNode(this)) {
            LiteralNode newModuleSpecifier = (LiteralNode)this.moduleSpecifier.accept(visitor);
            ImportClauseNode newImportClause = this.importClause == null ? null : (ImportClauseNode)this.importClause.accept(visitor);
            return visitor.leaveImportNode(this.setModuleSpecifier(newModuleSpecifier).setImportClause(newImportClause));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterImportNode(this);
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        sb.append("import");
        sb.append(' ');
        if (this.importClause != null) {
            this.importClause.toString(sb, printType);
            sb.append(' ');
            sb.append("from");
            sb.append(' ');
        }
        this.moduleSpecifier.toString(sb, printType);
        if (!this.attributes.isEmpty()) {
            sb.append(" with ");
            ImportNode.attributesToString(this.attributes, sb);
        }
        sb.append(';');
    }

    static void attributesToString(Map<TruffleString, TruffleString> attributes, StringBuilder sb) {
        sb.append("{");
        Iterator<Map.Entry<TruffleString, TruffleString>> iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TruffleString, TruffleString> attr = iterator.next();
            sb.append(attr.getKey());
            sb.append(": ");
            sb.append('\"').append(attr.getValue()).append('\"');
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
    }
}

