\name{FFTShiftImageFilter}
\alias{FFTShiftImageFilter}
\title{FFTShiftImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Shift the zero-frequency components of a Fourier transform to the
center of the image.
FFTShiftImageFilter}
\details{
The Fourier transform produces an image where the zero frequency
components are in the corner of the image, making it difficult to
understand. This filter shifts the component to the center of the
image.
For images with an odd-sized dimension, applying this filter twice
will not produce the same image as the original one without using
SetInverse(true) on one (and only one) of the two filters.
https://www.insight-journal.org/browse/publication/125
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
ForwardFFTImageFilter , InverseFFTImageFilter
FFTShift for the procedural interface
itk::FFTShiftImageFilter for the Doxygen on the original ITK class.
FFTShiftImageFilter}
%C++ includes: sitkFFTShiftImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{ FFTShiftImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{bool GetInverse() const:}{
Set/Get whether the filter must invert the transform or not. This
option has no effect if none of the size of the input image is even,
but is required to restore the original image if at least one of the
dimensions has an odd size.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self InverseOff():}{}
\item{Self InverseOn():}{
Set the value of Inverse to true or false respectfully.
}
\item{Self SetInverse(bool Inverse):}{
Set/Get whether the filter must invert the transform or not. This
option has no effect if none of the size of the input image is even,
but is required to restore the original image if at least one of the
dimensions has an odd size.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~FFTShiftImageFilter():}{
Destructor
}
}
}
