/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core.migration;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.settingsSync.core.FileState;
import com.intellij.settingsSync.core.SettingsSnapshot;
import com.intellij.settingsSync.core.SettingsSnapshotKt;
import com.intellij.settingsSync.core.migration.SettingsRepositoryToSettingsSyncMigrationKt;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J3\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u0001H\u000b0\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/settingsSync/core/migration/SettingsRepositoryToSettingsSyncMigration;", "", "<init>", "()V", "getLocalDataIfAvailable", "Lcom/intellij/settingsSync/core/SettingsSnapshot;", "appConfigDir", "Ljava/nio/file/Path;", "isLocalDataAvailable", "", "processLocalData", "T", "processor", "Lkotlin/Function1;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readLocalData", "settingsRepositoryConfigPath", "intellij.settingsSync.core"})
@SourceDebugExtension(value={"SMAP\nSettingsRepositoryToSettingsSyncMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsRepositoryToSettingsSyncMigration.kt\ncom/intellij/settingsSync/core/migration/SettingsRepositoryToSettingsSyncMigration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1#2:165\n*E\n"})
public final class SettingsRepositoryToSettingsSyncMigration {
    @Nullable
    public final SettingsSnapshot getLocalDataIfAvailable(@NotNull Path appConfigDir) {
        Intrinsics.checkNotNullParameter((Object)appConfigDir, (String)"appConfigDir");
        return (SettingsSnapshot)this.processLocalData(appConfigDir, arg_0 -> SettingsRepositoryToSettingsSyncMigration.getLocalDataIfAvailable$lambda$0(this, arg_0));
    }

    public final boolean isLocalDataAvailable(@NotNull Path appConfigDir) {
        Intrinsics.checkNotNullParameter((Object)appConfigDir, (String)"appConfigDir");
        if (PluginManager.isPluginInstalled((PluginId)PluginId.Companion.getId("org.jetbrains.settingsRepository"))) {
            return false;
        }
        return this.processLocalData(appConfigDir, SettingsRepositoryToSettingsSyncMigration::isLocalDataAvailable$lambda$0) != null;
    }

    private final <T> T processLocalData(Path appConfigDir, Function1<? super Path, ? extends T> processor) {
        try {
            Path path = appConfigDir.resolve("settingsRepository");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path path2 = path.resolve("repository");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Path configPath = path2;
            Path path3 = configPath.resolve(".git");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            Path repositoryPath = path3;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(repositoryPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return (T)processor.invoke((Object)configPath);
            }
            SettingsRepositoryToSettingsSyncMigrationKt.access$getLOG$p().info("No data from settingsRepository in 'settingsRepository' folder => no migration needed");
        }
        catch (Exception e) {
            SettingsRepositoryToSettingsSyncMigrationKt.access$getLOG$p().error("Could not read data from settings repository => no migration ", (Throwable)e);
        }
        return null;
    }

    private final SettingsSnapshot readLocalData(Path settingsRepositoryConfigPath) {
        Set fileStates = new LinkedHashSet();
        Files.list(settingsRepositoryConfigPath).forEach(arg_0 -> SettingsRepositoryToSettingsSyncMigration.readLocalData$lambda$1(arg_0 -> SettingsRepositoryToSettingsSyncMigration.readLocalData$lambda$0(settingsRepositoryConfigPath, fileStates, arg_0), arg_0));
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return new SettingsSnapshot(new SettingsSnapshot.MetaInfo(instant, SettingsSnapshotKt.getLocalApplicationInfo(), false, 4, null), fileStates, null, MapsKt.emptyMap(), SetsKt.emptySet());
    }

    private static final SettingsSnapshot getLocalDataIfAvailable$lambda$0(SettingsRepositoryToSettingsSyncMigration this$0, Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this$0.readLocalData(path);
    }

    private static final Path isLocalDataAvailable$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final Unit readLocalData$lambda$0(Path $settingsRepositoryConfigPath, Set $fileStates, Path topLevelFile) {
        Object v0;
        block2: {
            Iterable iterable = SettingsRepositoryToSettingsSyncMigrationKt.access$getOS_PREFIXES$p();
            for (Object t : iterable) {
                Pair it = (Pair)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)topLevelFile);
                if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)topLevelFile), (String)((String)it.getFirst()), (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Pair prefix = v0;
        List list = SettingsRepositoryToSettingsSyncMigrationKt.access$getSPECIAL_FILES$p();
        Intrinsics.checkNotNull((Object)topLevelFile);
        if (!list.contains(PathsKt.getName((Path)topLevelFile))) {
            Files.walkFileTree(topLevelFile, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>($settingsRepositoryConfigPath, (Pair<String, String>)prefix, topLevelFile, (Set<FileState>)$fileStates){
                final /* synthetic */ Path $settingsRepositoryConfigPath;
                final /* synthetic */ Pair<String, String> $prefix;
                final /* synthetic */ Path $topLevelFile;
                final /* synthetic */ Set<FileState> $fileStates;
                {
                    this.$settingsRepositoryConfigPath = $settingsRepositoryConfigPath;
                    this.$prefix = $prefix;
                    this.$topLevelFile = $topLevelFile;
                    this.$fileStates = $fileStates;
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.isRegularFile(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path path = this.$settingsRepositoryConfigPath.relativize(file);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
                    String relative = PathsKt.getInvariantSeparatorsPathString((Path)path);
                    String relativeWithFixedPrefix = this.$prefix != null ? StringsKt.replaceFirst$default((String)relative, (String)((String)this.$prefix.getFirst()), (String)((String)this.$prefix.getSecond()), (boolean)false, (int)4, null) : relative;
                    String fileSpec = this.$prefix != null || Intrinsics.areEqual((Object)file, (Object)this.$topLevelFile) ? "options/" + relativeWithFixedPrefix : relativeWithFixedPrefix;
                    byte[] byArray = Files.readAllBytes(file);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                    byte[] content = byArray;
                    ((Collection)this.$fileStates).add(new FileState.Modified(fileSpec, content));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return Unit.INSTANCE;
    }

    private static final void readLocalData$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

