/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.google.common.collect.Maps;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.branch.GitUpstreamBranches;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.config.GitSharedSettings;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public class GitDeleteBranchOperation
extends GitBranchOperation {
    private static final Logger LOG = Logger.getInstance(GitDeleteBranchOperation.class);
    public static final String RESTORE = GitDeleteBranchOperation.getRestore();
    public static final String VIEW_COMMITS = GitDeleteBranchOperation.getViewCommits();
    public static final String DELETE_TRACKED_BRANCH = GitDeleteBranchOperation.getDeleteTrackedBranch();
    @NotNull
    private final String myBranchName;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final GitUpstreamBranches myUpstreamBranches;
    @NotNull
    private final Map<GitRepository, UnmergedBranchInfo> myUnmergedToBranches;
    private final @Unmodifiable @NotNull Map<GitRepository, String> myDeletedBranchTips;

    GitDeleteBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<? extends GitRepository> repositories, @NotNull String branchName) {
        if (project == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(3);
        }
        if (branchName == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(4);
        }
        super(project, git, uiHandler, repositories);
        this.myBranchName = branchName;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myUpstreamBranches = new GitUpstreamBranches(repositories, branchName, this.myGit);
        this.myUnmergedToBranches = new HashMap<GitRepository, UnmergedBranchInfo>();
        this.myDeletedBranchTips = ContainerUtil.map2MapNotNull(repositories, repo -> {
            GitBranchesCollection branches = repo.getBranches();
            GitLocalBranch branch = branches.findLocalBranch(this.myBranchName);
            if (branch == null) {
                LOG.error("Couldn't find branch by name " + this.myBranchName + " in " + String.valueOf(repo));
                return null;
            }
            Hash hash = branches.getHash(branch);
            if (hash == null) {
                LOG.error("Couldn't find hash for branch " + String.valueOf(branch) + " in " + String.valueOf(repo));
                return null;
            }
            return Pair.create((Object)repo, (Object)hash.asString());
        });
    }

    @Override
    public void execute() {
        boolean fatalErrorHappened = false;
        while (this.hasMoreRepositories() && !fatalErrorHappened) {
            GitBranchNotMergedToUpstreamDetector notMergedToUpstreamDetector;
            GitSimpleEventDetector notFullyMergedDetector;
            GitRepository repository2 = this.next();
            GitCommandResult result2 = this.myGit.branchDelete(repository2, this.myBranchName, false, notFullyMergedDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.BRANCH_NOT_FULLY_MERGED), notMergedToUpstreamDetector = new GitBranchNotMergedToUpstreamDetector());
            if (result2.success()) {
                GitDeleteBranchOperation.refresh(repository2);
                this.markSuccessful(repository2);
                continue;
            }
            if (notFullyMergedDetector.isDetected()) {
                String baseBranch = notMergedToUpstreamDetector.getBaseBranch();
                if (baseBranch == null) {
                    baseBranch = (String)this.myCurrentHeads.get(repository2);
                }
                this.myUnmergedToBranches.put(repository2, new UnmergedBranchInfo(this.myDeletedBranchTips.get(repository2), GitBranchUtil.stripRefsPrefix(baseBranch)));
                GitCommandResult forceDeleteResult = this.myGit.branchDelete(repository2, this.myBranchName, true, new GitLineHandlerListener[0]);
                if (forceDeleteResult.success()) {
                    GitDeleteBranchOperation.refresh(repository2);
                    this.markSuccessful(repository2);
                    continue;
                }
                this.fatalError(this.getErrorTitle(), forceDeleteResult);
                fatalErrorHappened = true;
                continue;
            }
            this.fatalError(this.getErrorTitle(), result2);
            fatalErrorHappened = true;
        }
        if (!fatalErrorHappened) {
            this.notifySuccess();
        }
    }

    @Override
    protected void notifySuccess() {
        boolean unmergedCommits = !this.myUnmergedToBranches.isEmpty();
        HtmlBuilder message = new HtmlBuilder().appendRaw(GitBundle.message("delete.branch.operation.deleted.branch.bold", this.myBranchName));
        if (unmergedCommits) {
            message.br().append(GitBundle.message("delete.branch.operation.unmerged.commits.were.discarded", new Object[0]));
        }
        Notification notification = VcsNotifier.standardNotification().createNotification(message.toString(), NotificationType.INFORMATION);
        notification.setDisplayId("git.branch.deleted");
        notification.addAction((AnAction)NotificationAction.createSimple(() -> GitDeleteBranchOperation.getRestore(), () -> {
            notification.expire();
            this.restoreInBackground(notification);
        }));
        if (unmergedCommits) {
            notification.addAction((AnAction)NotificationAction.createSimple(() -> GitDeleteBranchOperation.getViewCommits(), () -> this.viewUnmergedCommitsInBackground(notification)));
        }
        if (!this.myUpstreamBranches.get().isEmpty() && GitDeleteBranchOperation.hasNoOtherTrackingBranch(this.myUpstreamBranches.get(), this.myBranchName) && this.trackedBranchIsNotProtected()) {
            notification.addAction((AnAction)NotificationAction.createSimple(() -> GitDeleteBranchOperation.getDeleteTrackedBranch(), () -> {
                notification.expire();
                this.deleteTrackedBranchInBackground();
            }));
        }
        this.myNotifier.notify(notification);
    }

    private boolean trackedBranchIsNotProtected() {
        return this.myUpstreamBranches.get().values().stream().noneMatch(branch -> GitSharedSettings.getInstance(this.myProject).isBranchProtected(branch.getNameForRemoteOperations()));
    }

    private static boolean hasNoOtherTrackingBranch(@NotNull Map<GitRepository, GitRemoteBranch> trackedBranches, @NotNull String localBranch) {
        if (trackedBranches == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(5);
        }
        if (localBranch == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(6);
        }
        for (GitRepository repository2 : trackedBranches.keySet()) {
            if (!ContainerUtil.exists(repository2.getBranchTrackInfos(), info -> !info.getLocalBranch().getName().equals(localBranch) && info.getRemoteBranch().equals(trackedBranches.get(repository2)))) continue;
            return false;
        }
        return true;
    }

    private static void refresh(GitRepository ... repositories) {
        if (repositories == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(7);
        }
        for (GitRepository repository2 : repositories) {
            repository2.update();
        }
    }

    @Override
    protected void rollback() {
        GitCompoundResult result2 = this.doRollback();
        if (!result2.totalSuccess()) {
            this.myNotifier.notifyError("git.branch.deletion.rollback.error", GitBundle.message("delete.branch.operation.error.during.rollback.of.branch.deletion", new Object[0]), result2.getErrorOutputWithReposIndication(), true);
        }
    }

    @NotNull
    private GitCompoundResult doRollback() {
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        for (GitRepository repository2 : this.getSuccessfulRepositories()) {
            GitCommandResult res = this.myGit.branchCreate(repository2, this.myBranchName, this.myDeletedBranchTips.get(repository2));
            result2.append(repository2, res);
            this.myUpstreamBranches.restoreUpstream(repository2);
            GitDeleteBranchOperation.refresh(repository2);
        }
        GitCompoundResult gitCompoundResult = result2;
        if (gitCompoundResult == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(8);
        }
        return gitCompoundResult;
    }

    @NlsContexts.NotificationTitle
    @NotNull
    private String getErrorTitle() {
        String string = GitBundle.message("delete.branch.operation.branch.was.not.deleted.error", this.myBranchName);
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getSuccessMessage() {
        String string = GitBundle.message("delete.branch.operation.deleted.branch", GitDeleteBranchOperation.formatBranchName(this.myBranchName));
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        String string = new HtmlBuilder().append(GitBundle.message("delete.branch.operation.however.branch.deletion.has.succeeded.for.the.following", this.getSuccessfulRepositories().size())).br().appendRaw(this.successfulRepositoriesJoined()).br().append(GitBundle.message("delete.branch.operation.you.may.rollback.not.to.let.branches.diverge", this.myBranchName)).toString();
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    protected String getOperationName() {
        String string = GitBundle.message("delete.branch.operation.name", new Object[0]);
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String formatBranchName(@NotNull String name) {
        if (name == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(13);
        }
        String string = GitUIUtil.code(name);
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(14);
        }
        return string;
    }

    private boolean showNotFullyMergedDialog(@NotNull Map<GitRepository, UnmergedBranchInfo> unmergedBranches) {
        if (unmergedBranches == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(15);
        }
        HashMap<GitRepository, List<GitCommit>> history = new HashMap<GitRepository, List<GitCommit>>();
        for (GitRepository repository2 : this.getRepositories()) {
            if (unmergedBranches.containsKey(repository2)) {
                UnmergedBranchInfo unmergedInfo = unmergedBranches.get(repository2);
                history.put(repository2, GitDeleteBranchOperation.getUnmergedCommits(repository2, unmergedInfo.myTipOfDeletedUnmergedBranch, unmergedInfo.myBaseBranch));
                continue;
            }
            history.put(repository2, Collections.emptyList());
        }
        Map baseBranches = Maps.asMap(unmergedBranches.keySet(), it -> ((UnmergedBranchInfo)unmergedBranches.get((Object)it)).myBaseBranch);
        return this.myUiHandler.showBranchIsNotFullyMergedDialog(this.myProject, history, baseBranches, this.myBranchName);
    }

    @NotNull
    private static List<GitCommit> getUnmergedCommits(@NotNull GitRepository repository2, @NotNull String branchName, @NotNull String baseBranch) {
        List<GitCommit> list;
        if (repository2 == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(16);
        }
        if (branchName == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(17);
        }
        if (baseBranch == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(18);
        }
        String range = baseBranch + ".." + branchName;
        try {
            list = GitHistoryUtils.history(repository2.getProject(), repository2.getRoot(), range);
        }
        catch (VcsException e) {
            LOG.warn("Couldn't get `git log " + range + "` in " + DvcsUtil.getShortRepositoryName((Repository)repository2), (Throwable)e);
            List<GitCommit> list2 = Collections.emptyList();
            if (list2 == null) {
                GitDeleteBranchOperation.$$$reportNull$$$0(20);
            }
            return list2;
        }
        if (list == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(19);
        }
        return list;
    }

    private void deleteTrackedBranchInBackground() {
        GitBrancher brancher = GitBrancher.getInstance(this.myProject);
        MultiMap<String, GitRepository> grouped = this.groupTrackedBranchesByName();
        for (String remoteBranch : grouped.keySet()) {
            brancher.deleteRemoteBranch(remoteBranch, new ArrayList(grouped.get((Object)remoteBranch)));
        }
    }

    @NotNull
    private MultiMap<String, GitRepository> groupTrackedBranchesByName() {
        MultiMap trackedBranchNames = MultiMap.create();
        for (GitRepository repository2 : this.myUpstreamBranches.get().keySet()) {
            GitRemoteBranch trackedBranch = this.myUpstreamBranches.get().get(repository2);
            if (trackedBranch == null) continue;
            trackedBranchNames.putValue((Object)trackedBranch.getNameForLocalOperations(), (Object)repository2);
        }
        MultiMap multiMap = trackedBranchNames;
        if (multiMap == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(21);
        }
        return multiMap;
    }

    private void restoreInBackground(final @NotNull Notification notification) {
        if (notification == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(22);
        }
        new Task.Backgroundable(this.myProject, GitBundle.message("delete.branch.operation.restoring.branch.process", this.myBranchName)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitDeleteBranchOperation.this.rollbackBranchDeletion(notification);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitDeleteBranchOperation$1", "run"));
            }
        }.queue();
    }

    private void rollbackBranchDeletion(@NotNull Notification notification) {
        GitCompoundResult result2;
        if (notification == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(23);
        }
        if ((result2 = this.doRollback()).totalSuccess()) {
            notification.expire();
        } else {
            this.myNotifier.notifyError("git.branch.deletion.rollback.error", GitBundle.message("delete.branch.operation.could.not.restore.branch.error", GitDeleteBranchOperation.formatBranchName(this.myBranchName)), result2.getErrorOutputWithReposIndication(), true);
        }
    }

    private void viewUnmergedCommitsInBackground(final @NotNull Notification notification) {
        if (notification == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(24);
        }
        new Task.Backgroundable(this.myProject, GitBundle.message("delete.branch.operation.collecting.unmerged.commits.process", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                boolean restore;
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (restore = GitDeleteBranchOperation.this.showNotFullyMergedDialog(GitDeleteBranchOperation.this.myUnmergedToBranches)) {
                    GitDeleteBranchOperation.this.rollbackBranchDeletion(notification);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitDeleteBranchOperation$2", "run"));
            }
        }.queue();
    }

    @NotNull
    @Nls
    static String getRestore() {
        String string = GitBundle.message("action.NotificationAction.GitDeleteBranchOperation.text.restore", new Object[0]);
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    @Nls
    static String getViewCommits() {
        String string = GitBundle.message("action.NotificationAction.GitDeleteBranchOperation.text.view.commits", new Object[0]);
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    @Nls
    static String getDeleteTrackedBranch() {
        String string = GitBundle.message("action.NotificationAction.GitDeleteBranchOperation.text.delete.tracked.branch", new Object[0]);
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 14, 19, 20, 21, 25, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackedBranches";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranch";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitDeleteBranchOperation";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unmergedBranches";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseBranch";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitDeleteBranchOperation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doRollback";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorTitle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessMessage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackProposal";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "formatBranchName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnmergedCommits";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "groupTrackedBranchesByName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestore";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewCommits";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteTrackedBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasNoOtherTrackingBranch";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "formatBranchName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showNotFullyMergedDialog";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getUnmergedCommits";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "restoreInBackground";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "rollbackBranchDeletion";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "viewUnmergedCommitsInBackground";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 14, 19, 20, 21, 25, 26, 27 -> new IllegalStateException(string);
        };
    }

    private static class GitBranchNotMergedToUpstreamDetector
    implements GitLineHandlerListener {
        private static final Pattern PATTERN = Pattern.compile(".*'(.*)', even though it is merged to.*");
        @Nullable
        private String myBaseBranch;

        private GitBranchNotMergedToUpstreamDetector() {
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                this.myBaseBranch = matcher.group(1);
            }
        }

        @Nullable
        public String getBaseBranch() {
            return this.myBaseBranch;
        }
    }

    static class UnmergedBranchInfo {
        @NotNull
        private final String myTipOfDeletedUnmergedBranch;
        @NotNull
        private final String myBaseBranch;

        UnmergedBranchInfo(@NotNull String tipOfDeletedUnmergedBranch, @NotNull String baseBranch) {
            if (tipOfDeletedUnmergedBranch == null) {
                UnmergedBranchInfo.$$$reportNull$$$0(0);
            }
            if (baseBranch == null) {
                UnmergedBranchInfo.$$$reportNull$$$0(1);
            }
            this.myTipOfDeletedUnmergedBranch = tipOfDeletedUnmergedBranch;
            this.myBaseBranch = baseBranch;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tipOfDeletedUnmergedBranch";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseBranch";
                    break;
                }
            }
            objectArray[1] = "git4idea/branch/GitDeleteBranchOperation$UnmergedBranchInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

