/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.view.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputHighlightingsSnapshot;
import org.jetbrains.plugins.terminal.block.output.TextStyleAdapter;
import org.jetbrains.plugins.terminal.block.ui.BlockTerminalColorPalette;
import org.jetbrains.plugins.terminal.session.impl.StyleRange;
import org.jetbrains.plugins.terminal.session.impl.TerminalOutputModelState;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;
import org.jetbrains.plugins.terminal.view.TerminalLineIndex;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.view.TerminalOutputModelSnapshot;
import org.jetbrains.plugins.terminal.view.impl.ModelChange;
import org.jetbrains.plugins.terminal.view.impl.MutableTerminalOutputModel;
import org.jetbrains.plugins.terminal.view.impl.MutableTerminalOutputModelImplKt;
import org.jetbrains.plugins.terminal.view.impl.TerminalContentChangeEventImpl;
import org.jetbrains.plugins.terminal.view.impl.TerminalCursorOffsetChangeEventImpl;
import org.jetbrains.plugins.terminal.view.impl.TerminalOutputModelSnapshotImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001mB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u0005H\u0002J\u0010\u00104\u001a\u00020/2\u0006\u00103\u001a\u00020\u000bH\u0016J\u0010\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020/H\u0016J\u0018\u00107\u001a\u00020\u000b2\u0006\u00106\u001a\u00020/2\u0006\u00108\u001a\u00020$H\u0016J\u0018\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020\u000bH\u0016J\f\u0010=\u001a\u00020\u0005*\u00020\u000bH\u0002J\f\u0010=\u001a\u00020\u0005*\u00020/H\u0002J\b\u0010>\u001a\u00020?H\u0016J&\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00162\u0006\u0010C\u001a\u00020D2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020G0FH\u0016J.\u0010H\u001a\u00020A2\u0006\u00103\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\u00052\u0006\u0010C\u001a\u00020D2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020G0FH\u0016J\u0018\u0010K\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00162\u0006\u0010L\u001a\u00020\u0005H\u0016J\u0010\u0010K\u001a\u00020A2\u0006\u00103\u001a\u00020\u000bH\u0016J\u0010\u0010M\u001a\u00020A2\u0006\u0010N\u001a\u00020/H\u0002J\b\u0010O\u001a\u00020PH\u0002J.\u0010Q\u001a\u00020P2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\u00052\u0006\u0010R\u001a\u00020D2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020G0FH\u0002J \u0010S\u001a\u00020P2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\u00052\u0006\u0010R\u001a\u00020:H\u0002J \u0010T\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\u00052\u0006\u0010R\u001a\u00020DH\u0002J(\u0010U\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\u00052\u0006\u0010R\u001a\u00020D2\u0006\u0010V\u001a\u00020\u0005H\u0002J\b\u0010W\u001a\u00020AH\u0002J\b\u0010X\u001a\u00020$H\u0002J\b\u0010Y\u001a\u00020:H\u0002J \u0010Z\u001a\u00020A2\b\b\u0002\u0010%\u001a\u00020$2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020P0\\H\u0002J\u001f\u0010]\u001a\u00020^2\u0006\u0010%\u001a\u00020$2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020^0\\H\u0082\bJ\b\u0010_\u001a\u00020`H\u0016J\u0012\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010c\u001a\u00020\u000bH\u0016J\u0018\u0010d\u001a\u00020A2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020\u0014H\u0016J\u0016\u0010h\u001a\u00020A2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020A0\\H\u0016J\b\u0010i\u001a\u00020jH\u0016J\u0010\u0010k\u001a\u00020A2\u0006\u0010l\u001a\u00020jH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u001e\u0010\u001e\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010 R\u0014\u0010(\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010 R\u0014\u0010*\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0018R\u0014\u0010,\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\rR\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006n"}, d2={"Lorg/jetbrains/plugins/terminal/view/impl/MutableTerminalOutputModelImpl;", "Lorg/jetbrains/plugins/terminal/view/impl/MutableTerminalOutputModel;", "document", "Lcom/intellij/openapi/editor/Document;", "maxOutputLength", "", "<init>", "(Lcom/intellij/openapi/editor/Document;I)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "cursorOffset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "getCursorOffset", "()Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "setCursorOffset", "(Lorg/jetbrains/plugins/terminal/view/TerminalOffset;)V", "highlightingsModel", "Lorg/jetbrains/plugins/terminal/view/impl/MutableTerminalOutputModelImpl$HighlightingsModel;", "listeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModelListener;", "trimmedLinesCount", "", "getTrimmedLinesCount", "()J", "setTrimmedLinesCount", "(J)V", "trimmedCharsCount", "getTrimmedCharsCount", "setTrimmedCharsCount", "firstLineTrimmedCharsCount", "getFirstLineTrimmedCharsCount", "()I", "setFirstLineTrimmedCharsCount", "(I)V", "contentUpdateInProgress", "", "isTypeAhead", "textLength", "getTextLength", "lineCount", "getLineCount", "modificationStamp", "getModificationStamp", "startOffset", "getStartOffset", "firstLineIndex", "Lorg/jetbrains/plugins/terminal/view/TerminalLineIndex;", "getFirstLineIndex", "()Lorg/jetbrains/plugins/terminal/view/TerminalLineIndex;", "relativeOffset", "offset", "getLineByOffset", "getStartOfLine", "line", "getEndOfLine", "includeEOL", "getText", "", "start", "end", "toRelative", "takeSnapshot", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModelSnapshot;", "updateContent", "", "absoluteLineIndex", "text", "", "styles", "", "Lorg/jetbrains/plugins/terminal/session/impl/StyleRange;", "replaceContent", "length", "newStyles", "updateCursorPosition", "columnIndex", "ensureDocumentHasLine", "lineIndex", "clear", "Lorg/jetbrains/plugins/terminal/view/impl/ModelChange;", "doReplaceContentIgnoringEqualPrefixAndOrSuffix", "newText", "doReplaceContent", "findFirstChangeOffset", "findLastChangeOffset", "newTextStart", "ensureCorrectCursorOffset", "isTrimNeeded", "trimToSize", "changeDocumentContent", "block", "Lkotlin/Function0;", "doSingleDocumentChange", "Lorg/jetbrains/plugins/terminal/view/impl/TerminalContentChangeEventImpl;", "getHighlightings", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "getHighlightingAt", "Lorg/jetbrains/plugins/terminal/block/output/HighlightingInfo;", "documentOffset", "addListener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "withTypeAhead", "dumpState", "Lorg/jetbrains/plugins/terminal/session/impl/TerminalOutputModelState;", "restoreFromState", "state", "HighlightingsModel", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMutableTerminalOutputModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableTerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/view/impl/MutableTerminalOutputModelImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,633:1\n310#1,5:650\n315#1,13:656\n310#1,5:669\n315#1,13:675\n60#2,5:634\n60#2,5:639\n60#2,5:644\n60#2,5:688\n60#2,5:693\n60#2,5:698\n1#3:649\n1#3:655\n1#3:674\n*S KotlinDebug\n*F\n+ 1 MutableTerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/view/impl/MutableTerminalOutputModelImpl\n*L\n271#1:650,5\n271#1:656,13\n285#1:669,5\n285#1:675,13\n97#1:634,5\n120#1:639,5\n144#1:644,5\n302#1:688,5\n138#1:693,5\n164#1:698,5\n271#1:655\n285#1:674\n*E\n"})
public final class MutableTerminalOutputModelImpl
implements MutableTerminalOutputModel {
    @NotNull
    private final Document document;
    private final int maxOutputLength;
    @NotNull
    private TerminalOffset cursorOffset;
    @NotNull
    private final HighlightingsModel highlightingsModel;
    @NotNull
    private final DisposableWrapperList<TerminalOutputModelListener> listeners;
    @VisibleForTesting
    private long trimmedLinesCount;
    @VisibleForTesting
    private long trimmedCharsCount;
    @VisibleForTesting
    private int firstLineTrimmedCharsCount;
    private boolean contentUpdateInProgress;
    private boolean isTypeAhead;

    public MutableTerminalOutputModelImpl(@NotNull Document document, int maxOutputLength) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.document = document;
        this.maxOutputLength = maxOutputLength;
        this.cursorOffset = TerminalOffset.ZERO;
        this.highlightingsModel = new HighlightingsModel();
        this.listeners = new DisposableWrapperList();
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public TerminalOffset getCursorOffset() {
        return this.cursorOffset;
    }

    public void setCursorOffset(@NotNull TerminalOffset terminalOffset) {
        Intrinsics.checkNotNullParameter((Object)terminalOffset, (String)"<set-?>");
        this.cursorOffset = terminalOffset;
    }

    public final long getTrimmedLinesCount() {
        return this.trimmedLinesCount;
    }

    public final void setTrimmedLinesCount(long l) {
        this.trimmedLinesCount = l;
    }

    public final long getTrimmedCharsCount() {
        return this.trimmedCharsCount;
    }

    public final void setTrimmedCharsCount(long l) {
        this.trimmedCharsCount = l;
    }

    public final int getFirstLineTrimmedCharsCount() {
        return this.firstLineTrimmedCharsCount;
    }

    public final void setFirstLineTrimmedCharsCount(int n) {
        this.firstLineTrimmedCharsCount = n;
    }

    @Override
    public int getTextLength() {
        return this.getDocument().getTextLength();
    }

    @Override
    public int getLineCount() {
        return MutableTerminalOutputModelImplKt.access$lineCountImpl(this.getDocument());
    }

    @Override
    public long getModificationStamp() {
        return MutableTerminalOutputModelImplKt.access$modificationStampImpl(this.getDocument());
    }

    @Override
    @NotNull
    public TerminalOffset getStartOffset() {
        return TerminalOffset.Companion.of(this.trimmedCharsCount);
    }

    @Override
    @NotNull
    public TerminalLineIndex getFirstLineIndex() {
        return TerminalLineIndex.Companion.of(this.trimmedLinesCount);
    }

    private final TerminalOffset relativeOffset(int offset) {
        return TerminalOffset.Companion.of(this.trimmedCharsCount + (long)offset);
    }

    @Override
    @NotNull
    public TerminalLineIndex getLineByOffset(@NotNull TerminalOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return MutableTerminalOutputModelImplKt.access$getLineByOffsetImpl(this.trimmedLinesCount, this.getDocument(), this.toRelative(offset));
    }

    @Override
    @NotNull
    public TerminalOffset getStartOfLine(@NotNull TerminalLineIndex line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return MutableTerminalOutputModelImplKt.access$getStartOfLineImpl(this.trimmedCharsCount, this.getDocument(), this.toRelative(line));
    }

    @Override
    @NotNull
    public TerminalOffset getEndOfLine(@NotNull TerminalLineIndex line, boolean includeEOL) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return MutableTerminalOutputModelImplKt.access$getEndOfLineImpl(this.trimmedCharsCount, this.getDocument(), this.toRelative(line), includeEOL);
    }

    @Override
    @NotNull
    public CharSequence getText(@NotNull TerminalOffset start2, @NotNull TerminalOffset end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return MutableTerminalOutputModelImplKt.access$getTextImpl(this.getDocument(), this.toRelative(start2), this.toRelative(end));
    }

    private final int toRelative(TerminalOffset $this$toRelative) {
        return (int)$this$toRelative.minus(this.getStartOffset());
    }

    private final int toRelative(TerminalLineIndex $this$toRelative) {
        return (int)$this$toRelative.minus(this.getFirstLineIndex());
    }

    @Override
    @NotNull
    public TerminalOutputModelSnapshot takeSnapshot() {
        Document document = this.getDocument();
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
        FrozenDocument frozenDocument = ((DocumentImpl)document).freeze();
        Intrinsics.checkNotNullExpressionValue((Object)frozenDocument, (String)"freeze(...)");
        return new TerminalOutputModelSnapshotImpl(frozenDocument, this.trimmedCharsCount, this.trimmedLinesCount, this.getCursorOffset());
    }

    @Override
    public void updateContent(long absoluteLineIndex, @NotNull String text, @NotNull List<StyleRange> styles) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(styles, (String)"styles");
        if (absoluteLineIndex < this.trimmedLinesCount) {
            MutableTerminalOutputModelImpl.changeDocumentContent$default(this, false, () -> MutableTerminalOutputModelImpl.updateContent$lambda$0(this), 1, null);
        }
        Logger $this$debug_u24default$iv = MutableTerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Content update from the relative line = " + (absoluteLineIndex - this.trimmedLinesCount) + " (absolute " + absoluteLineIndex + "), length = " + text.length() + ", current length = " + this.getDocument().getTextLength() + " chars, " + this.getDocument().getLineCount() + " lines, currently trimmed = " + this.trimmedCharsCount + " chars, " + this.trimmedLinesCount + " lines", e$iv);
        }
        TerminalLineIndex startLine = TerminalLineIndex.Companion.of(absoluteLineIndex);
        this.ensureDocumentHasLine(startLine);
        MutableTerminalOutputModelImpl.changeDocumentContent$default(this, false, () -> MutableTerminalOutputModelImpl.updateContent$lambda$2(this, startLine, text, styles), 1, null);
    }

    @Override
    public void replaceContent(@NotNull TerminalOffset offset, int length, @NotNull String text, @NotNull List<StyleRange> newStyles) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(newStyles, (String)"newStyles");
        this.changeDocumentContent(this.isTypeAhead, (Function0<ModelChange>)((Function0)() -> MutableTerminalOutputModelImpl.replaceContent$lambda$0(this, offset, length, text, newStyles)));
    }

    @Override
    public void updateCursorPosition(long absoluteLineIndex, int columnIndex) {
        Logger logger;
        TerminalLineIndex lineIndex = TerminalLineIndex.Companion.of(absoluteLineIndex);
        Logger $this$debug_u24default$iv = MutableTerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Updating the cursor position to absolute line = " + absoluteLineIndex + " (relative " + this.toRelative(lineIndex) + "), column = " + columnIndex, e$iv);
        }
        this.ensureDocumentHasLine(lineIndex);
        TerminalOffset lineStartOffset = this.getStartOfLine(lineIndex);
        TerminalOffset lineEndOffset = TerminalOutputModel.getEndOfLine$default(this, lineIndex, false, 2, null);
        int trimmedCharsInLine = Intrinsics.areEqual((Object)lineIndex, (Object)this.getFirstLineIndex()) ? this.firstLineTrimmedCharsCount : 0;
        int trimmedColumnIndex = columnIndex - trimmedCharsInLine;
        int lineLength = (int)lineEndOffset.minus(lineStartOffset);
        if (trimmedColumnIndex > lineLength) {
            int spacesToAdd = trimmedColumnIndex - lineLength;
            String spaces = StringsKt.repeat((CharSequence)" ", (int)spacesToAdd);
            MutableTerminalOutputModelImpl.changeDocumentContent$default(this, false, () -> MutableTerminalOutputModelImpl.updateCursorPosition$lambda$1(this, lineEndOffset, spaces, spacesToAdd), 1, null);
        }
        TerminalOffset newCursorOffset = lineStartOffset.plus(trimmedColumnIndex);
        Logger $this$debug_u24default$iv2 = MutableTerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("Updated the cursor position to " + newCursorOffset, e$iv2);
        }
        this.updateCursorPosition(newCursorOffset);
    }

    @Override
    public void updateCursorPosition(@NotNull TerminalOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        if (Intrinsics.areEqual((Object)this.getCursorOffset(), (Object)offset)) {
            return;
        }
        TerminalOffset oldValue = this.getCursorOffset();
        this.setCursorOffset(offset);
        TerminalCursorOffsetChangeEventImpl event = new TerminalCursorOffsetChangeEventImpl(this, oldValue, offset);
        TerminalUtilKt.fireListenersAndLogAllExceptions((List)this.listeners, MutableTerminalOutputModelImplKt.access$getLOG$p(), "Exception during handling " + event, arg_0 -> MutableTerminalOutputModelImpl.updateCursorPosition$lambda$3(event, arg_0));
    }

    private final void ensureDocumentHasLine(TerminalLineIndex lineIndex) {
        if (lineIndex.compareTo(this.getLastLineIndex()) > 0) {
            MutableTerminalOutputModelImpl.changeDocumentContent$default(this, false, () -> MutableTerminalOutputModelImpl.ensureDocumentHasLine$lambda$0(lineIndex, this), 1, null);
        }
    }

    private final ModelChange clear() {
        CharSequence oldText = this.getText(this.getStartOffset(), this.getEndOffset());
        this.trimmedLinesCount = 0L;
        this.trimmedCharsCount = 0L;
        this.firstLineTrimmedCharsCount = 0;
        this.getDocument().replaceString(0, this.getTextLength(), (CharSequence)"");
        this.highlightingsModel.clear();
        return new ModelChange(TerminalOffset.ZERO, oldText, "");
    }

    private final ModelChange doReplaceContentIgnoringEqualPrefixAndOrSuffix(TerminalOffset startOffset, int length, String newText, List<StyleRange> styles) {
        TerminalOffset endOffset = startOffset.plus(length);
        TerminalOffset effectiveStartOffset = this.findFirstChangeOffset(startOffset, length, newText);
        int skipPrefix = (int)effectiveStartOffset.minus(startOffset);
        TerminalOffset effectiveEndOffset = this.findLastChangeOffset(effectiveStartOffset, length - skipPrefix, newText, skipPrefix).plus(1L);
        int skipSuffix = (int)endOffset.minus(effectiveEndOffset);
        int effectiveLength = length - skipPrefix - skipSuffix;
        CharSequence effectiveNewText = newText.subSequence(skipPrefix, newText.length() - skipSuffix);
        ModelChange change = this.doReplaceContent(effectiveStartOffset, effectiveLength, effectiveNewText);
        this.highlightingsModel.updateHighlightings(this.toRelative(startOffset), length, newText.length(), styles);
        return change;
    }

    private final ModelChange doReplaceContent(TerminalOffset startOffset, int length, CharSequence newText) {
        int relativeStartOffset = this.toRelative(startOffset);
        int relativeEndOffset = relativeStartOffset + length;
        CharSequence oldText = this.getDocument().getImmutableCharSequence().subSequence(relativeStartOffset, relativeEndOffset);
        this.getDocument().replaceString(relativeStartOffset, relativeEndOffset, newText);
        return new ModelChange(startOffset, oldText, newText);
    }

    private final TerminalOffset findFirstChangeOffset(TerminalOffset startOffset, int length, String newText) {
        int relativeStartOffset;
        int srcIndex = relativeStartOffset = this.toRelative(startOffset);
        CharSequence charSequence = this.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence text = charSequence;
        for (int dstIndex = 0; srcIndex < relativeStartOffset + length && dstIndex < newText.length() && text.charAt(srcIndex) == newText.charAt(dstIndex); ++srcIndex, ++dstIndex) {
        }
        return this.relativeOffset(srcIndex);
    }

    private final TerminalOffset findLastChangeOffset(TerminalOffset startOffset, int length, String newText, int newTextStart) {
        int relativeStartOffset = this.toRelative(startOffset);
        int srcIndex = relativeStartOffset + length - 1;
        CharSequence charSequence = this.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence text = charSequence;
        for (int dstIndex = newText.length() - 1; srcIndex >= relativeStartOffset && dstIndex >= newTextStart && text.charAt(srcIndex) == newText.charAt(dstIndex); --srcIndex, --dstIndex) {
        }
        return this.relativeOffset(srcIndex);
    }

    private final void ensureCorrectCursorOffset() {
        if (this.getCursorOffset().compareTo(this.getStartOffset()) < 0) {
            this.updateCursorPosition(this.getStartOffset());
        }
        if (this.getCursorOffset().compareTo(this.getEndOffset()) > 0) {
            this.updateCursorPosition(this.getEndOffset());
        }
    }

    private final boolean isTrimNeeded() {
        return this.maxOutputLength > 0 && this.getDocument().getTextLength() > this.maxOutputLength;
    }

    private final CharSequence trimToSize() {
        if (!(this.maxOutputLength > 0)) {
            boolean $i$a$-check-MutableTerminalOutputModelImpl$trimToSize$32 = false;
            String $i$a$-check-MutableTerminalOutputModelImpl$trimToSize$32 = "trimToSize should only be called if trimming is enabled";
            throw new IllegalStateException($i$a$-check-MutableTerminalOutputModelImpl$trimToSize$32.toString());
        }
        int textLength = this.getDocument().getTextLength();
        if (!(textLength > this.maxOutputLength)) {
            boolean $i$a$-check-MutableTerminalOutputModelImpl$trimToSize$42 = false;
            String $i$a$-check-MutableTerminalOutputModelImpl$trimToSize$42 = "This method should be called only if text length " + textLength + " is greater than max length " + this.maxOutputLength;
            throw new IllegalStateException($i$a$-check-MutableTerminalOutputModelImpl$trimToSize$42.toString());
        }
        int lineCountBefore = this.getDocument().getLineCount();
        int removeUntilOffset = textLength - this.maxOutputLength;
        int futureFirstLineNumber = this.getDocument().getLineNumber(removeUntilOffset);
        int futureFirstLineStart = this.getDocument().getLineStartOffset(futureFirstLineNumber);
        this.highlightingsModel.removeBefore(removeUntilOffset);
        CharSequence trimmedPart = this.getDocument().getImmutableCharSequence().subSequence(0, removeUntilOffset);
        this.getDocument().deleteString(0, removeUntilOffset);
        this.trimmedCharsCount += (long)removeUntilOffset;
        this.trimmedLinesCount += (long)(lineCountBefore - this.getDocument().getLineCount());
        this.firstLineTrimmedCharsCount = removeUntilOffset - futureFirstLineStart;
        return trimmedPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void changeDocumentContent(boolean isTypeAhead, Function0<ModelChange> block) {
        TerminalContentChangeEventImpl $i$a$-check-MutableTerminalOutputModelImpl$doSingleDocumentChange$2$iv222;
        void this_$iv;
        MutableTerminalOutputModelImpl mutableTerminalOutputModelImpl = this;
        boolean isTypeAhead$iv = isTypeAhead;
        boolean $i$f$doSingleDocumentChange2 = false;
        TerminalUtilKt.fireListenersAndLogAllExceptions((List)this_$iv.listeners, MutableTerminalOutputModelImplKt.access$getLOG$p(), "Exception during handling beforeContentChanged event", (Function1)new Function1<TerminalOutputModelListener, Unit>((MutableTerminalOutputModelImpl)this_$iv){
            final /* synthetic */ MutableTerminalOutputModelImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void invoke(TerminalOutputModelListener it) {
                it.beforeContentChanged(this.this$0);
            }
        });
        if (!(!this_$iv.contentUpdateInProgress)) {
            boolean $i$a$-check-MutableTerminalOutputModelImpl$doSingleDocumentChange$2$iv222 = false;
            String $i$a$-check-MutableTerminalOutputModelImpl$doSingleDocumentChange$2$iv222 = "Recursive content updates aren't supported, schedule an update in a separate event if needed";
            throw new IllegalStateException($i$a$-check-MutableTerminalOutputModelImpl$doSingleDocumentChange$2$iv222.toString());
        }
        this_$iv.contentUpdateInProgress = true;
        try {
            boolean bl = false;
            ModelChange change = (ModelChange)block.invoke();
            $i$a$-check-MutableTerminalOutputModelImpl$doSingleDocumentChange$2$iv222 = new TerminalContentChangeEventImpl(this, change.getOffset(), change.getOldText(), change.getNewText(), isTypeAhead, false);
        }
        finally {
            this_$iv.contentUpdateInProgress = false;
        }
        TerminalContentChangeEventImpl event$iv = $i$a$-check-MutableTerminalOutputModelImpl$doSingleDocumentChange$2$iv222;
        super.ensureCorrectCursorOffset();
        TerminalUtilKt.fireListenersAndLogAllExceptions((List)this_$iv.listeners, MutableTerminalOutputModelImplKt.access$getLOG$p(), "Exception during handling " + event$iv, (Function1)new Function1<TerminalOutputModelListener, Unit>(event$iv){
            final /* synthetic */ TerminalContentChangeEventImpl $event;
            {
                this.$event = $event;
            }

            public final void invoke(TerminalOutputModelListener it) {
                it.afterContentChanged(this.$event);
            }
        });
        TerminalContentChangeEventImpl changeEvent = event$iv;
        int trimmed = 0;
        if (this.isTrimNeeded()) {
            TerminalContentChangeEventImpl $i$a$-check-MutableTerminalOutputModelImpl$doSingleDocumentChange$2$iv322;
            void this_$iv2;
            MutableTerminalOutputModelImpl $i$f$doSingleDocumentChange2 = this;
            boolean isTypeAhead$iv2 = isTypeAhead;
            boolean $i$f$doSingleDocumentChange3 = false;
            TerminalUtilKt.fireListenersAndLogAllExceptions((List)this_$iv2.listeners, MutableTerminalOutputModelImplKt.access$getLOG$p(), "Exception during handling beforeContentChanged event", (Function1)new /* invalid duplicate definition of identical inner class */);
            if (!(!this_$iv2.contentUpdateInProgress)) {
                boolean $i$a$-check-MutableTerminalOutputModelImpl$doSingleDocumentChange$2$iv322 = false;
                String $i$a$-check-MutableTerminalOutputModelImpl$doSingleDocumentChange$2$iv322 = "Recursive content updates aren't supported, schedule an update in a separate event if needed";
                throw new IllegalStateException($i$a$-check-MutableTerminalOutputModelImpl$doSingleDocumentChange$2$iv322.toString());
            }
            this_$iv2.contentUpdateInProgress = true;
            try {
                boolean bl = false;
                TerminalOffset startBeforeTrimming = this.getStartOffset();
                CharSequence trimmedSequence = this.trimToSize();
                $i$a$-check-MutableTerminalOutputModelImpl$doSingleDocumentChange$2$iv322 = new TerminalContentChangeEventImpl(this, startBeforeTrimming, trimmedSequence, "", isTypeAhead, true);
            }
            finally {
                this_$iv2.contentUpdateInProgress = false;
            }
            TerminalContentChangeEventImpl event$iv2 = $i$a$-check-MutableTerminalOutputModelImpl$doSingleDocumentChange$2$iv322;
            super.ensureCorrectCursorOffset();
            TerminalUtilKt.fireListenersAndLogAllExceptions((List)this_$iv2.listeners, MutableTerminalOutputModelImplKt.access$getLOG$p(), "Exception during handling " + event$iv2, (Function1)new /* invalid duplicate definition of identical inner class */);
            TerminalContentChangeEventImpl trimEvent = event$iv2;
            trimmed = trimEvent.getOldText().length();
        }
        TerminalOffset startOffset = changeEvent.getOffset();
        TerminalOffset effectiveStartOffset = (TerminalOffset)RangesKt.coerceAtLeast((Comparable)startOffset, (Comparable)startOffset);
        Logger $this$debug_u24default$iv = MutableTerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Content updated from offset = " + startOffset + " (effectively " + effectiveStartOffset + "), new length = " + this.getDocument().getTextLength() + " chars, " + this.getDocument().getLineCount() + " lines, currently trimmed = " + this.trimmedCharsCount + " (+" + trimmed + ") chars, " + this.trimmedLinesCount + " lines", e$iv);
        }
    }

    static /* synthetic */ void changeDocumentContent$default(MutableTerminalOutputModelImpl mutableTerminalOutputModelImpl, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        mutableTerminalOutputModelImpl.changeDocumentContent(bl, (Function0<ModelChange>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TerminalContentChangeEventImpl doSingleDocumentChange(boolean isTypeAhead, Function0<TerminalContentChangeEventImpl> block) {
        TerminalContentChangeEventImpl terminalContentChangeEventImpl;
        boolean $i$f$doSingleDocumentChange = false;
        TerminalUtilKt.fireListenersAndLogAllExceptions((List)this.listeners, MutableTerminalOutputModelImplKt.access$getLOG$p(), "Exception during handling beforeContentChanged event", (Function1)new /* invalid duplicate definition of identical inner class */);
        if (!(!this.contentUpdateInProgress)) {
            boolean bl = false;
            String string = "Recursive content updates aren't supported, schedule an update in a separate event if needed";
            throw new IllegalStateException(string.toString());
        }
        this.contentUpdateInProgress = true;
        try {
            terminalContentChangeEventImpl = (TerminalContentChangeEventImpl)block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.contentUpdateInProgress = false;
            InlineMarker.finallyEnd((int)1);
        }
        TerminalContentChangeEventImpl event = terminalContentChangeEventImpl;
        this.ensureCorrectCursorOffset();
        TerminalUtilKt.fireListenersAndLogAllExceptions((List)this.listeners, MutableTerminalOutputModelImplKt.access$getLOG$p(), "Exception during handling " + event, (Function1)new /* invalid duplicate definition of identical inner class */);
        return event;
    }

    @Override
    @NotNull
    public TerminalOutputHighlightingsSnapshot getHighlightings() {
        return this.contentUpdateInProgress ? new TerminalOutputHighlightingsSnapshot(this.getDocument(), CollectionsKt.emptyList()) : this.highlightingsModel.getHighlightingsSnapshot();
    }

    @Override
    @Nullable
    public HighlightingInfo getHighlightingAt(@NotNull TerminalOffset documentOffset) {
        Intrinsics.checkNotNullParameter((Object)documentOffset, (String)"documentOffset");
        return this.highlightingsModel.getHighlightingAt(this.toRelative(documentOffset));
    }

    @Override
    public void addListener(@NotNull Disposable parentDisposable, @NotNull TerminalOutputModelListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add((Object)listener2, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withTypeAhead(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!(!this.isTypeAhead)) {
            boolean bl = false;
            String string = "Already in the type-ahead mode";
            throw new IllegalStateException(string.toString());
        }
        this.isTypeAhead = true;
        try {
            block.invoke();
        }
        finally {
            this.isTypeAhead = false;
        }
    }

    @Override
    @NotNull
    public TerminalOutputModelState dumpState() {
        String string = this.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new TerminalOutputModelState(string, this.trimmedLinesCount, this.trimmedCharsCount, this.firstLineTrimmedCharsCount, this.toRelative(this.getCursorOffset()), this.highlightingsModel.dumpState());
    }

    @Override
    public void restoreFromState(@NotNull TerminalOutputModelState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        MutableTerminalOutputModelImpl.changeDocumentContent$default(this, false, () -> MutableTerminalOutputModelImpl.restoreFromState$lambda$0(this, state), 1, null);
    }

    private static final ModelChange updateContent$lambda$0(MutableTerminalOutputModelImpl this$0) {
        return this$0.clear();
    }

    private static final ModelChange updateContent$lambda$2(MutableTerminalOutputModelImpl this$0, TerminalLineIndex $startLine, String $text, List $styles) {
        TerminalOffset startOffset = this$0.getStartOfLine($startLine);
        return this$0.doReplaceContentIgnoringEqualPrefixAndOrSuffix(startOffset, (int)this$0.getEndOffset().minus(startOffset), $text, $styles);
    }

    private static final ModelChange replaceContent$lambda$0(MutableTerminalOutputModelImpl this$0, TerminalOffset $offset, int $length, String $text, List $newStyles) {
        return this$0.doReplaceContentIgnoringEqualPrefixAndOrSuffix($offset, $length, $text, $newStyles);
    }

    private static final ModelChange updateCursorPosition$lambda$1(MutableTerminalOutputModelImpl this$0, TerminalOffset $lineEndOffset, String $spaces, int $spacesToAdd) {
        Logger $this$debug_u24default$iv = MutableTerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Added " + $spacesToAdd + " spaces to make the column valid", e$iv);
        }
        return this$0.doReplaceContentIgnoringEqualPrefixAndOrSuffix($lineEndOffset, 0, $spaces, CollectionsKt.emptyList());
    }

    private static final Unit updateCursorPosition$lambda$3(TerminalCursorOffsetChangeEventImpl $event, TerminalOutputModelListener it) {
        it.cursorOffsetChanged($event);
        return Unit.INSTANCE;
    }

    private static final ModelChange ensureDocumentHasLine$lambda$0(TerminalLineIndex $lineIndex, MutableTerminalOutputModelImpl this$0) {
        int newLinesToAdd = (int)$lineIndex.minus(this$0.getLastLineIndex());
        String newLines = StringsKt.repeat((CharSequence)"\n", (int)newLinesToAdd);
        Logger $this$debug_u24default$iv = MutableTerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Add " + newLinesToAdd + " lines to make the line valid", e$iv);
        }
        return this$0.doReplaceContentIgnoringEqualPrefixAndOrSuffix(this$0.getEndOffset(), 0, newLines, CollectionsKt.emptyList());
    }

    private static final ModelChange restoreFromState$lambda$0(MutableTerminalOutputModelImpl this$0, TerminalOutputModelState $state) {
        CharSequence charSequence = this$0.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence oldText = charSequence;
        this$0.trimmedLinesCount = $state.getTrimmedLinesCount();
        this$0.trimmedCharsCount = $state.getTrimmedCharsCount();
        this$0.firstLineTrimmedCharsCount = $state.getFirstLineTrimmedCharsCount();
        this$0.getDocument().setText((CharSequence)$state.getText());
        this$0.highlightingsModel.restoreFromState($state.getHighlightings());
        this$0.updateCursorPosition(this$0.relativeOffset($state.getCursorOffset()));
        return new ModelChange(this$0.getStartOffset(), oldText, $state.getText());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u0011J,\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J \u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u0018J\u0014\u0010!\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/terminal/view/impl/MutableTerminalOutputModelImpl$HighlightingsModel;", "", "<init>", "(Lorg/jetbrains/plugins/terminal/view/impl/MutableTerminalOutputModelImpl;)V", "colorPalette", "Lcom/intellij/terminal/TerminalColorPalette;", "styleRanges", "", "Lorg/jetbrains/plugins/terminal/session/impl/StyleRange;", "highlightingsSnapshot", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "getHighlightingsSnapshot", "getHighlightingAt", "Lorg/jetbrains/plugins/terminal/block/output/HighlightingInfo;", "documentOffset", "", "removeBefore", "", "clear", "updateHighlightings", "relativeStartOffset", "oldLength", "newLength", "styles", "", "shift", "shiftFromIndex", "updateAffectedRanges", "affectedIndexes", "Lkotlin/ranges/IntRange;", "affectedAbsoluteOffsets", "Lkotlin/ranges/LongRange;", "dumpState", "restoreFromState", "state", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nMutableTerminalOutputModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableTerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/view/impl/MutableTerminalOutputModelImpl$HighlightingsModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,633:1\n1563#2:634\n1634#2,3:635\n1563#2:638\n1634#2,3:639\n*S KotlinDebug\n*F\n+ 1 MutableTerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/view/impl/MutableTerminalOutputModelImpl$HighlightingsModel\n*L\n405#1:634\n405#1:635,3\n480#1:638\n480#1:639,3\n*E\n"})
    private final class HighlightingsModel {
        @NotNull
        private final TerminalColorPalette colorPalette = new BlockTerminalColorPalette();
        @NotNull
        private final List<StyleRange> styleRanges = (List)new ArrayDeque();
        @Nullable
        private TerminalOutputHighlightingsSnapshot highlightingsSnapshot;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TerminalOutputHighlightingsSnapshot getHighlightingsSnapshot() {
            TerminalOutputHighlightingsSnapshot snapshot;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (this.highlightingsSnapshot != null) {
                TerminalOutputHighlightingsSnapshot terminalOutputHighlightingsSnapshot = this.highlightingsSnapshot;
                Intrinsics.checkNotNull((Object)terminalOutputHighlightingsSnapshot);
                return terminalOutputHighlightingsSnapshot;
            }
            Iterable iterable = this.styleRanges;
            MutableTerminalOutputModelImpl mutableTerminalOutputModelImpl = MutableTerminalOutputModelImpl.this;
            boolean $i$f$map = false;
            void var5_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StyleRange styleRange = (StyleRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new HighlightingInfo((int)(it.getStartOffset() - mutableTerminalOutputModelImpl.getTrimmedCharsCount()), (int)(it.getEndOffset() - mutableTerminalOutputModelImpl.getTrimmedCharsCount()), new TextStyleAdapter(it.getStyle(), this.colorPalette, it.getIgnoreContrastAdjustment())));
            }
            List documentRelativeHighlightings = (List)destination$iv$iv;
            this.highlightingsSnapshot = snapshot = new TerminalOutputHighlightingsSnapshot(MutableTerminalOutputModelImpl.this.getDocument(), documentRelativeHighlightings);
            return snapshot;
        }

        @Nullable
        public final HighlightingInfo getHighlightingAt(int documentOffset) {
            HighlightingInfo highlightingInfo;
            if (documentOffset < 0 || documentOffset >= MutableTerminalOutputModelImpl.this.getDocument().getTextLength()) {
                return null;
            }
            long absoluteOffset = (long)documentOffset + MutableTerminalOutputModelImpl.this.getTrimmedCharsCount();
            int index = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.getHighlightingAt$lambda$0(absoluteOffset, arg_0), (int)3, null);
            if (index >= 0) {
                StyleRange range = this.styleRanges.get(index);
                highlightingInfo = new HighlightingInfo((int)(range.getStartOffset() - MutableTerminalOutputModelImpl.this.getTrimmedCharsCount()), (int)(range.getEndOffset() - MutableTerminalOutputModelImpl.this.getTrimmedCharsCount()), new TextStyleAdapter(range.getStyle(), this.colorPalette, range.getIgnoreContrastAdjustment()));
            } else {
                highlightingInfo = null;
            }
            return highlightingInfo;
        }

        public final void removeBefore(int documentOffset) {
            long absoluteOffset = (long)documentOffset + MutableTerminalOutputModelImpl.this.getTrimmedCharsCount();
            int styleIndex = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.removeBefore$lambda$0(absoluteOffset, arg_0), (int)3, null);
            int removeUntilHighlightingIndex = styleIndex < 0 ? -styleIndex - 1 : styleIndex;
            int n = 0;
            while (n < removeUntilHighlightingIndex) {
                int it = n++;
                boolean bl = false;
                this.styleRanges.remove(0);
            }
            this.highlightingsSnapshot = null;
        }

        public final void clear() {
            this.styleRanges.clear();
            this.highlightingsSnapshot = null;
        }

        /*
         * WARNING - void declaration
         */
        public final void updateHighlightings(int relativeStartOffset, int oldLength, int newLength, @NotNull List<StyleRange> styles) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(styles, (String)"styles");
            long absoluteStartOffset = (long)relativeStartOffset + MutableTerminalOutputModelImpl.this.getTrimmedCharsCount();
            long absoluteEndOffset = absoluteStartOffset + (long)oldLength;
            int i = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.updateHighlightings$lambda$0(absoluteStartOffset, arg_0), (int)3, null);
            boolean bl = false;
            int lastUnaffectedIndexBefore = i >= 0 ? i : -i - 2;
            int i2 = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.updateHighlightings$lambda$2(absoluteEndOffset, arg_0), (int)3, null);
            boolean bl2 = false;
            int firstUnaffectedIndexAfter = i2 >= 0 ? i2 : -i2 - 1;
            int shift = newLength - oldLength;
            this.shift(firstUnaffectedIndexAfter, shift);
            this.updateAffectedRanges(RangesKt.until((int)(lastUnaffectedIndexBefore + 1), (int)firstUnaffectedIndexAfter), RangesKt.until((long)absoluteStartOffset, (long)absoluteEndOffset), shift);
            int i3 = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.updateHighlightings$lambda$4(absoluteEndOffset, shift, arg_0), (int)3, null);
            boolean bl3 = false;
            int insertionIndex = i3 >= 0 ? i3 : -i3 - 1;
            Iterable $this$map$iv = styles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void styleRange;
                StyleRange styleRange2 = (StyleRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(StyleRange.copy$default((StyleRange)styleRange, styleRange.getStartOffset() + absoluteStartOffset, styleRange.getEndOffset() + absoluteStartOffset, null, false, 12, null));
            }
            List absoluteStyles = (List)destination$iv$iv;
            this.styleRanges.addAll(insertionIndex, absoluteStyles);
            this.highlightingsSnapshot = null;
        }

        private final void shift(int shiftFromIndex, int shift) {
            if (shift == 0) {
                return;
            }
            int n = this.styleRanges.size();
            for (int i = shiftFromIndex; i < n; ++i) {
                StyleRange styleRange = this.styleRanges.get(i);
                this.styleRanges.set(i, StyleRange.copy$default(styleRange, styleRange.getStartOffset() + (long)shift, styleRange.getEndOffset() + (long)shift, null, false, 12, null));
            }
        }

        private final void updateAffectedRanges(IntRange affectedIndexes, LongRange affectedAbsoluteOffsets, int shift) {
            if (affectedIndexes.isEmpty()) {
                return;
            }
            long absoluteStartOffset = affectedAbsoluteOffsets.getFirst();
            long absoluteEndOffset = affectedAbsoluteOffsets.getLast() + 1L;
            List<StyleRange> affectedRanges = this.styleRanges.subList(affectedIndexes.getFirst(), affectedIndexes.getLast() + 1);
            List updatedRanges = new ArrayList();
            for (StyleRange range : affectedRanges) {
                if (range.getStartOffset() < absoluteStartOffset && range.getEndOffset() <= absoluteEndOffset) {
                    updatedRanges.add(StyleRange.copy$default(range, 0L, absoluteStartOffset, null, false, 13, null));
                    continue;
                }
                long l = affectedAbsoluteOffsets.getFirst();
                long l2 = affectedAbsoluteOffsets.getLast();
                long l3 = range.getStartOffset();
                boolean bl = l <= l3 ? l3 <= l2 : false;
                if (bl && range.getEndOffset() > absoluteEndOffset) {
                    updatedRanges.add(StyleRange.copy$default(range, absoluteEndOffset + (long)shift, range.getEndOffset() + (long)shift, null, false, 12, null));
                    continue;
                }
                if (range.getStartOffset() >= absoluteStartOffset || range.getEndOffset() <= absoluteEndOffset) continue;
                updatedRanges.add(StyleRange.copy$default(range, 0L, absoluteStartOffset, null, false, 13, null));
                updatedRanges.add(StyleRange.copy$default(range, absoluteEndOffset + (long)shift, range.getEndOffset() + (long)shift, null, false, 12, null));
            }
            affectedRanges.clear();
            affectedRanges.addAll(updatedRanges);
        }

        @NotNull
        public final List<StyleRange> dumpState() {
            return CollectionsKt.toList((Iterable)this.styleRanges);
        }

        public final void restoreFromState(@NotNull List<StyleRange> state) {
            Intrinsics.checkNotNullParameter(state, (String)"state");
            this.styleRanges.clear();
            this.styleRanges.addAll((Collection<StyleRange>)state);
            this.highlightingsSnapshot = null;
        }

        private static final int getHighlightingAt$lambda$0(long $absoluteOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getEndOffset() <= $absoluteOffset ? -1 : (it.getStartOffset() > $absoluteOffset ? 1 : 0);
        }

        private static final int removeBefore$lambda$0(long $absoluteOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getStartOffset(), (long)$absoluteOffset);
        }

        private static final int updateHighlightings$lambda$0(long $absoluteStartOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getEndOffset(), (long)$absoluteStartOffset);
        }

        private static final int updateHighlightings$lambda$2(long $absoluteEndOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getStartOffset(), (long)$absoluteEndOffset);
        }

        private static final int updateHighlightings$lambda$4(long $absoluteEndOffset, int $shift, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getStartOffset(), (long)($absoluteEndOffset + (long)$shift));
        }
    }
}

