/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.io.ClosedStorageException;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.IOCancellationCallbackHolder;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorCache;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import com.intellij.util.io.SelfDiagnosing;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.VersionUpdatedException;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import com.intellij.util.io.keyStorage.AppendableStorageBackedByResizableMappedFile;
import com.intellij.util.io.keyStorage.InlinedKeyStorage;
import com.intellij.util.io.keyStorage.NoDataException;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public abstract class PersistentEnumeratorBase<Data>
implements DataEnumeratorEx<Data>,
ScannableDataEnumeratorEx<Data>,
Forceable,
Closeable,
SelfDiagnosing {
    protected static final Logger LOG = Logger.getInstance(PersistentEnumeratorBase.class);
    protected static final boolean USE_RW_LOCK = SystemProperties.getBooleanProperty("idea.persistent.data.use.read.write.lock", false);
    private static final int META_DATA_OFFSET = 4;
    static final int DATA_START = 20;
    protected final ResizeableMappedFile myCollisionResolutionStorage;
    @NotNull
    protected final AppendableObjectStorage<Data> myKeyStorage;
    final KeyDescriptor<Data> myDataDescriptor;
    protected final Path myFile;
    private final Version myVersion;
    private final boolean myDoCaching;
    private final ReentrantReadWriteLock myLock;
    private volatile boolean myDirtyStatusUpdateInProgress;
    private boolean myClosed;
    private volatile boolean myDirty;
    private volatile boolean myCorrupted;
    private RecordBufferHandler<PersistentEnumeratorBase<?>> myRecordHandler;
    @Nullable
    private Flushable myMarkCleanCallback;

    protected PersistentEnumeratorBase(@NotNull Path file, @NotNull ResizeableMappedFile valueStorage, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @NotNull Version version, @NotNull RecordBufferHandler<? extends PersistentEnumeratorBase<?>> recordBufferHandler, boolean doCaching) throws IOException {
        if (file == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(0);
        }
        if (valueStorage == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(1);
        }
        if (dataDescriptor == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(2);
        }
        if (version == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(3);
        }
        if (recordBufferHandler == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(4);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myDataDescriptor = dataDescriptor;
        this.myFile = file;
        this.myVersion = version;
        this.myRecordHandler = recordBufferHandler;
        this.myDoCaching = doCaching;
        this.myCollisionResolutionStorage = valueStorage;
        this.lockStorageWrite();
        try {
            int sign;
            if (!Files.exists(file, new LinkOption[0])) {
                if (file.getFileSystem().isReadOnly()) {
                    throw new IOException(file + " in " + file.getFileSystem() + " is not exist");
                }
                Path parent = file.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.createFile(file, new FileAttribute[0]);
            }
            boolean created = false;
            if (this.myCollisionResolutionStorage.length() == 0L) {
                try {
                    this.markDirty(true);
                    this.putMetaData(0L);
                    this.putMetaData2(0L);
                    this.setupEmptyFile();
                    this.doFlush();
                    created = true;
                }
                catch (RuntimeException e) {
                    LOG.info(e);
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw e;
                }
                catch (IOException e) {
                    LOG.info(e);
                    throw e;
                }
                catch (Exception e) {
                    LOG.info(e);
                    throw new CorruptedException("PersistentEnumerator storage corrupted " + file, (Throwable)e);
                }
            }
            try {
                sign = this.myCollisionResolutionStorage.getInt(0L);
            }
            catch (Exception e) {
                LOG.info(e);
                sign = this.myVersion.dirtyMagic;
            }
            if (sign != this.myVersion.correctlyClosedMagic) {
                if (sign != this.myVersion.dirtyMagic) {
                    throw new VersionUpdatedException(file, Integer.toHexString(this.myVersion.correctlyClosedMagic), Integer.toHexString(sign));
                }
                throw new CorruptedException("PersistentEnumerator storage corrupted " + file);
            }
            if (dataDescriptor instanceof InlineKeyDescriptor) {
                this.myKeyStorage = new InlinedKeyStorage((InlineKeyDescriptor)dataDescriptor);
            } else {
                try {
                    this.myKeyStorage = new AppendableStorageBackedByResizableMappedFile<Data>(this.keyStreamFile(), initialSize, this.myCollisionResolutionStorage.getStorageLockContext(), 0x100000, false, dataDescriptor);
                }
                catch (Throwable t) {
                    LOG.info(t);
                    throw new CorruptedException(file, t);
                }
            }
            if (IndexDebugProperties.IS_UNIT_TEST_MODE && LOG.isTraceEnabled()) {
                LOG.debug("PersistentEnumeratorBase at " + this.myFile + " has been open (new = " + created + ")");
            }
        }
        catch (Throwable t) {
            Exception errorOnClose = ExceptionUtil.runAndCatch((ThrowableRunnable<? extends Exception>)((ThrowableRunnable)valueStorage::close));
            if (errorOnClose != null) {
                t.addSuppressed(errorOnClose);
            }
            throw t;
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    @NotNull
    protected Lock getWriteLock() {
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        if (writeLock == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(5);
        }
        return writeLock;
    }

    @NotNull
    protected Lock getReadLock() {
        Lock lock = USE_RW_LOCK ? this.myLock.readLock() : this.myLock.writeLock();
        if (lock == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(6);
        }
        return lock;
    }

    void lockStorageRead() {
        this.myCollisionResolutionStorage.lockRead();
    }

    void unlockStorageRead() {
        this.myCollisionResolutionStorage.unlockRead();
    }

    void lockStorageWrite() {
        this.myCollisionResolutionStorage.lockWrite();
    }

    void unlockStorageWrite() {
        this.myCollisionResolutionStorage.unlockWrite();
    }

    protected abstract void setupEmptyFile() throws IOException;

    @NotNull
    final RecordBufferHandler<PersistentEnumeratorBase<?>> getRecordHandler() {
        RecordBufferHandler<PersistentEnumeratorBase<?>> recordBufferHandler = this.myRecordHandler;
        if (recordBufferHandler == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(7);
        }
        return recordBufferHandler;
    }

    public void setRecordHandler(@NotNull RecordBufferHandler<PersistentEnumeratorBase<?>> recordHandler) {
        if (recordHandler == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(8);
        }
        this.myRecordHandler = recordHandler;
    }

    void setMarkCleanCallback(@NotNull Flushable markCleanCallback) {
        if (markCleanCallback == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(9);
        }
        this.myMarkCleanCallback = markCleanCallback;
    }

    public Data getValue(int keyId, int processingKey) throws IOException {
        return this.valueOf(keyId);
    }

    @Override
    public int tryEnumerate(Data value) throws IOException {
        return this.doEnumerate(value, true, false);
    }

    private int doEnumerate(Data value, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        int cachedId;
        if (this.myDoCaching && !saveNewValue && (cachedId = PersistentEnumeratorCache.getCachedId(value, this)) != 0) {
            return cachedId;
        }
        int id = (Integer)this.catchCorruption(() -> this.enumerateImpl(value, onlyCheckForExisting, saveNewValue));
        if (this.myDoCaching && id != 0) {
            PersistentEnumeratorCache.cacheId(value, id, this);
        }
        return id;
    }

    @Override
    public int enumerate(Data value) throws IOException {
        return this.doEnumerate(value, false, false);
    }

    protected void putMetaData(long data) throws IOException {
        this.lockStorageWrite();
        try {
            if (this.myCollisionResolutionStorage.length() < 12L || this.getMetaData() != data) {
                this.myCollisionResolutionStorage.putLong(4L, data);
            }
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    protected long getMetaData() throws IOException {
        this.lockStorageRead();
        try {
            long l = this.myCollisionResolutionStorage.getLong(4L);
            return l;
        }
        finally {
            this.unlockStorageRead();
        }
    }

    void putMetaData2(long data) throws IOException {
        this.lockStorageWrite();
        try {
            if (this.myCollisionResolutionStorage.length() < 20L || this.getMetaData2() != data) {
                this.myCollisionResolutionStorage.putLong(12L, data);
            }
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    long getMetaData2() throws IOException {
        this.lockStorageRead();
        try {
            long l = this.myCollisionResolutionStorage.getLong(12L);
            return l;
        }
        finally {
            this.unlockStorageRead();
        }
    }

    public boolean processAllDataObject(final @NotNull Processor<? super Data> processor, final @Nullable DataFilter filter2) throws IOException {
        if (processor == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(10);
        }
        return this.traverseAllRecords(new RecordsProcessor(){

            @Override
            public boolean process(int record) throws IOException {
                if (filter2 == null || filter2.accept(record)) {
                    return processor.process(PersistentEnumeratorBase.this.valueOf(record));
                }
                return true;
            }
        });
    }

    public boolean forEach(final @NotNull ScannableDataEnumeratorEx.ValueReader<? super Data> reader, final @Nullable DataFilter filter2) throws IOException {
        if (reader == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(11);
        }
        return this.traverseAllRecords(new RecordsProcessor(){

            @Override
            public boolean process(int record) throws IOException {
                if (filter2 == null || filter2.accept(record)) {
                    Object value = PersistentEnumeratorBase.this.valueOf(record);
                    return reader.read(record, value);
                }
                return true;
            }
        });
    }

    @Override
    public boolean forEach(@NotNull ScannableDataEnumeratorEx.ValueReader<? super Data> reader) throws IOException {
        if (reader == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(12);
        }
        return this.forEach(reader, null);
    }

    @NotNull
    public Collection<Data> getAllDataObjects(@Nullable DataFilter filter2) throws IOException {
        ArrayList values2 = new ArrayList();
        this.processAllDataObject(new CommonProcessors.CollectProcessor(values2), filter2);
        ArrayList arrayList = values2;
        if (arrayList == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public abstract boolean traverseAllRecords(RecordsProcessor var1) throws IOException;

    protected abstract int enumerateImpl(Data var1, boolean var2, boolean var3) throws IOException;

    protected boolean isKeyAtIndex(Data value, int idx) throws IOException {
        if (this.myKeyStorage instanceof InlinedKeyStorage) {
            return false;
        }
        int addr = this.indexToAddr(idx);
        if (this.myKeyStorage.checkBytesAreTheSame(addr, value)) {
            return true;
        }
        if (this.myDataDescriptor instanceof DifferentSerializableBytesImplyNonEqualityPolicy) {
            return false;
        }
        Data actualValue = this.valueOf(idx);
        if (actualValue == null) {
            return value == null;
        }
        return this.myDataDescriptor.isEqual(actualValue, value);
    }

    protected int writeData(Data value, int hashCode) {
        try {
            this.markDirty(true);
            int dataOff = this.doWriteData(value);
            return this.setupValueId(hashCode, dataOff);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getLargestId() {
        return this.myKeyStorage.getCurrentLength();
    }

    protected int doWriteData(Data value) throws IOException {
        return this.myKeyStorage.append(value);
    }

    protected int setupValueId(int hashCode, int dataOff) throws IOException {
        byte[] buf = this.myRecordHandler.getRecordBuffer(this);
        this.myRecordHandler.setupRecord(this, hashCode, dataOff, buf);
        int pos = this.myRecordHandler.recordWriteOffset(this, buf);
        this.myCollisionResolutionStorage.put(pos, buf, 0, buf.length);
        return pos;
    }

    public boolean iterateData(@NotNull Processor<? super Data> processor) throws IOException {
        if (processor == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(14);
        }
        return this.iterateData((int offset, ? super Data data) -> processor.process((Object)data));
    }

    boolean iterateData(@NotNull AppendableObjectStorage.StorageObjectProcessor<? super Data> processor) throws IOException {
        if (processor == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(15);
        }
        return this.myKeyStorage.processAll(processor);
    }

    private Path keyStreamFile() {
        return this.myFile.resolveSibling(this.myFile.getFileName() + ".keystream");
    }

    @Override
    public Data valueOf(@Range(from=1L, to=0x7FFFFFFFL) int idx) throws IOException {
        if (idx <= 0) {
            return null;
        }
        return (Data)this.catchCorruption(() -> this.findValueFor(idx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Data findValueFor(@Range(from=1L, to=0x7FFFFFFFL) int idx) throws IOException {
        boolean shouldLock = this.shouldLockOnValueOf();
        if (shouldLock) {
            this.lockStorageRead();
        }
        try {
            int addr = this.indexToAddr(idx);
            Data Data2 = this.myKeyStorage.read(addr, shouldLock);
            return Data2;
        }
        finally {
            if (shouldLock) {
                this.unlockStorageRead();
            }
        }
    }

    protected abstract boolean shouldLockOnValueOf();

    int reEnumerate(Data key) throws IOException {
        if (!this.canReEnumerate()) {
            throw new IncorrectOperationException();
        }
        return this.doEnumerate(key, false, true);
    }

    boolean canReEnumerate() {
        return false;
    }

    protected abstract int indexToAddr(int var1) throws IOException;

    @Override
    public void close() throws IOException {
        this.getWriteLock().lock();
        try {
            this.lockStorageWrite();
            try {
                if (!this.myClosed) {
                    this.myClosed = true;
                    this.doClose();
                    if (IndexDebugProperties.IS_UNIT_TEST_MODE && LOG.isTraceEnabled()) {
                        LOG.info("PersistentEnumeratorBase at " + this.myFile + " has been closed");
                    }
                }
            }
            finally {
                this.unlockStorageWrite();
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    protected void doClose() throws IOException {
        IOCancellationCallbackHolder.INSTANCE.interactWithUI();
        this.getWriteLock().lock();
        try {
            try {
                this.force();
                this.myKeyStorage.close();
            }
            finally {
                this.myCollisionResolutionStorage.close();
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public boolean isClosed() {
        this.getReadLock().lock();
        try {
            boolean bl = this.myClosed;
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public boolean isDirty() {
        return this.myDirty;
    }

    public boolean isCorrupted() {
        return this.myCorrupted;
    }

    protected void doFlush() throws IOException {
        this.markDirty(false);
        this.myCollisionResolutionStorage.force();
    }

    @Override
    public void force() {
        if (!this.isDirty()) {
            return;
        }
        this.getWriteLock().lock();
        try {
            this.lockStorageWrite();
            try {
                if (this.isDirty()) {
                    if (this.myKeyStorage.isDirty()) {
                        this.myKeyStorage.force();
                    }
                    if (this.myCollisionResolutionStorage.isDirty()) {
                        this.doFlush();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.unlockStorageWrite();
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    protected final void markDirty(boolean dirty) throws IOException {
        if (dirty && this.myDirty && !this.myDirtyStatusUpdateInProgress) {
            return;
        }
        this.lockStorageWrite();
        try {
            if (this.myDirty) {
                if (!dirty) {
                    this.myDirtyStatusUpdateInProgress = true;
                    if (this.myMarkCleanCallback != null) {
                        this.myMarkCleanCallback.flush();
                    }
                    if (!this.myCorrupted) {
                        this.myCollisionResolutionStorage.putInt(0L, this.myVersion.correctlyClosedMagic);
                        this.myDirty = false;
                    }
                    this.myDirtyStatusUpdateInProgress = false;
                }
            } else if (dirty) {
                this.myDirtyStatusUpdateInProgress = true;
                this.myCollisionResolutionStorage.putInt(0L, this.myVersion.dirtyMagic);
                this.myDirtyStatusUpdateInProgress = false;
                this.myDirty = true;
            }
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    protected void markCorrupted() {
        if (IndexDebugProperties.IS_UNIT_TEST_MODE && LOG.isTraceEnabled()) {
            this.dumpKeysOnCorruption();
        }
        this.getWriteLock().lock();
        try {
            if (!this.myCorrupted) {
                this.myCorrupted = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Marking corrupted:" + this.myFile, new Throwable());
                }
                try {
                    StorageLockContext lockContext = this.myCollisionResolutionStorage.getStorageLockContext();
                    PersistentEnumeratorBase.runWithStorageReadLocksTemporaryReleased(lockContext, (ThrowableRunnable<IOException>)((ThrowableRunnable)() -> {
                        this.markDirty(true);
                        this.force();
                    }));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    protected void dumpKeysOnCorruption() {
    }

    protected boolean trySelfHeal() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public <V> V catchCorruption(ThrowableComputable<V, IOException> operation) throws IOException {
        if (this.isCorrupted()) {
            throw new CorruptedException("PersistentEnumerator storage corrupted " + this.myFile);
        }
        try {
            try {
                return (V)operation.compute();
            }
            catch (Throwable th) {
                try {
                    if (!(th instanceof NoDataException) && this.trySelfHeal()) {
                        return (V)operation.compute();
                    }
                    throw th;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    this.markCorrupted();
                    throw new RuntimeException(e);
                }
            }
        }
        catch (NoDataException e) {
            return null;
        }
        catch (ClosedStorageException e) {
            throw e;
        }
        catch (IOException io) {
            LOG.error(io);
            this.markCorrupted();
            throw io;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runWithStorageReadLocksTemporaryReleased(@NotNull StorageLockContext lockContext, @NotNull ThrowableRunnable<IOException> task) throws IOException {
        int readLocksActuallyReleased;
        if (lockContext == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(16);
        }
        if (task == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(17);
        }
        Lock readLock = lockContext.readLock();
        try {
            int readLocksToRelease = lockContext.readLockHolds();
            for (readLocksActuallyReleased = 0; readLocksActuallyReleased < readLocksToRelease; ++readLocksActuallyReleased) {
                readLock.unlock();
            }
            task.run();
        }
        finally {
            for (int i = 0; i < readLocksActuallyReleased; ++i) {
                readLock.lock();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueStorage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordBufferHandler";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/PersistentEnumeratorBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markCleanCallback";
                break;
            }
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lockContext";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/PersistentEnumeratorBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWriteLock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadLock";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordHandler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDataObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setRecordHandler";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setMarkCleanCallback";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAllDataObject";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "iterateData";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runWithStorageReadLocksTemporaryReleased";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Version {
        private static final int DIRTY_MAGIC = -1161946761;
        private static final int CORRECTLY_CLOSED_MAGIC = 247118589;
        private final int correctlyClosedMagic;
        private final int dirtyMagic;

        public Version(int version) {
            this(247118589 + version, -1161946761);
        }

        private Version(int _correctlyClosedMagic, int _dirtyMagic) {
            this.correctlyClosedMagic = _correctlyClosedMagic;
            this.dirtyMagic = _dirtyMagic;
            assert (this.correctlyClosedMagic != this.dirtyMagic);
        }
    }

    protected static abstract class RecordBufferHandler<T extends PersistentEnumeratorBase<?>> {
        protected RecordBufferHandler() {
        }

        abstract int recordWriteOffset(T var1, byte[] var2) throws IOException;

        abstract byte @NotNull [] getRecordBuffer(T var1);

        abstract void setupRecord(T var1, int var2, int var3, byte[] var4);
    }

    public static interface DataFilter {
        public boolean accept(int var1) throws IOException;
    }

    public static abstract class RecordsProcessor {
        private int myKey;

        public abstract boolean process(int var1) throws IOException;

        void setCurrentKey(int key) {
            this.myKey = key;
        }

        int getCurrentKey() {
            return this.myKey;
        }
    }
}

