/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.logic;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;

@ThreadSafe
public class PredicateDrivenFunction<T, U>
implements Function<T, U> {
    @Nonnull
    private final Predicate<? super T> predicate;
    @Nonnull
    private final Function<? super T, U> trueFunction;
    @Nonnull
    private final Function<? super T, U> falseFunction;

    public PredicateDrivenFunction(@Nonnull @ParameterName(name="condition") Predicate<? super T> condition, @Nullable @ParameterName(name="whenTrue") Function<? super T, U> whenTrue, @Nullable @ParameterName(name="whenFalse") Function<? super T, U> whenFalse) {
        this.predicate = Constraint.isNotNull(condition, "Input predicate cannot be null");
        this.trueFunction = whenTrue != null ? whenTrue : FunctionSupport.constant(null);
        this.falseFunction = whenFalse != null ? whenFalse : FunctionSupport.constant(null);
    }

    @Override
    public U apply(@Nullable T input) {
        return this.predicate.test(input) ? this.trueFunction.apply(input) : this.falseFunction.apply(input);
    }
}

