/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import io.netty.handler.codec.http2.Http2Settings;
import java.time.Duration;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class Http2SettingsSpec {
    final @Nullable Boolean connectProtocolEnabled;
    final @Nullable Long headerTableSize;
    final @Nullable Integer initialWindowSize;
    final @Nullable Long maxConcurrentStreams;
    final @Nullable Integer maxDecodedRstFramesPerWindow;
    final @Nullable Integer maxDecodedRstFramesSecondsPerWindow;
    final @Nullable Integer maxEncodedRstFramesPerWindow;
    final @Nullable Integer maxEncodedRstFramesSecondsPerWindow;
    final @Nullable Integer maxFrameSize;
    final Long maxHeaderListSize;
    final @Nullable Long maxStreams;
    final Integer pingAckDropThreshold;
    final @Nullable Duration pingAckTimeout;
    final @Nullable Boolean pushEnabled;

    public static Builder builder() {
        return new Build();
    }

    public @Nullable Boolean connectProtocolEnabled() {
        return this.connectProtocolEnabled;
    }

    public @Nullable Long headerTableSize() {
        return this.headerTableSize;
    }

    public @Nullable Integer initialWindowSize() {
        return this.initialWindowSize;
    }

    public @Nullable Long maxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public @Nullable Integer maxDecodedRstFramesPerWindow() {
        return this.maxDecodedRstFramesPerWindow;
    }

    public @Nullable Integer maxDecodedRstFramesSecondsPerWindow() {
        return this.maxDecodedRstFramesSecondsPerWindow;
    }

    public @Nullable Integer maxEncodedRstFramesPerWindow() {
        return this.maxEncodedRstFramesPerWindow;
    }

    public @Nullable Integer maxEncodedRstFramesSecondsPerWindow() {
        return this.maxEncodedRstFramesSecondsPerWindow;
    }

    public @Nullable Integer maxFrameSize() {
        return this.maxFrameSize;
    }

    public Long maxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public @Nullable Long maxStreams() {
        return this.maxStreams;
    }

    public Integer pingAckDropThreshold() {
        return this.pingAckDropThreshold;
    }

    public @Nullable Duration pingAckTimeout() {
        return this.pingAckTimeout;
    }

    public @Nullable Boolean pushEnabled() {
        return this.pushEnabled;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Http2SettingsSpec)) {
            return false;
        }
        Http2SettingsSpec that = (Http2SettingsSpec)o;
        return Objects.equals(this.connectProtocolEnabled, that.connectProtocolEnabled) && Objects.equals(this.headerTableSize, that.headerTableSize) && Objects.equals(this.initialWindowSize, that.initialWindowSize) && Objects.equals(this.maxConcurrentStreams, that.maxConcurrentStreams) && Objects.equals(this.maxDecodedRstFramesPerWindow, that.maxDecodedRstFramesPerWindow) && Objects.equals(this.maxDecodedRstFramesSecondsPerWindow, that.maxDecodedRstFramesSecondsPerWindow) && Objects.equals(this.maxEncodedRstFramesPerWindow, that.maxEncodedRstFramesPerWindow) && Objects.equals(this.maxEncodedRstFramesSecondsPerWindow, that.maxEncodedRstFramesSecondsPerWindow) && Objects.equals(this.maxFrameSize, that.maxFrameSize) && this.maxHeaderListSize.equals(that.maxHeaderListSize) && Objects.equals(this.maxStreams, that.maxStreams) && this.pingAckDropThreshold.equals(that.pingAckDropThreshold) && Objects.equals(this.pingAckTimeout, that.pingAckTimeout) && Objects.equals(this.pushEnabled, that.pushEnabled);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.connectProtocolEnabled == null ? 0 : Boolean.hashCode(this.connectProtocolEnabled));
        result = 31 * result + (this.headerTableSize == null ? 0 : Long.hashCode(this.headerTableSize));
        result = 31 * result + (this.initialWindowSize == null ? 0 : this.initialWindowSize);
        result = 31 * result + (this.maxConcurrentStreams == null ? 0 : Long.hashCode(this.maxConcurrentStreams));
        result = 31 * result + (this.maxDecodedRstFramesPerWindow == null ? 0 : this.maxDecodedRstFramesPerWindow);
        result = 31 * result + (this.maxDecodedRstFramesSecondsPerWindow == null ? 0 : this.maxDecodedRstFramesSecondsPerWindow);
        result = 31 * result + (this.maxEncodedRstFramesPerWindow == null ? 0 : this.maxEncodedRstFramesPerWindow);
        result = 31 * result + (this.maxEncodedRstFramesSecondsPerWindow == null ? 0 : this.maxEncodedRstFramesSecondsPerWindow);
        result = 31 * result + (this.maxFrameSize == null ? 0 : this.maxFrameSize);
        result = 31 * result + Long.hashCode(this.maxHeaderListSize);
        result = 31 * result + (this.maxStreams == null ? 0 : Long.hashCode(this.maxStreams));
        result = 31 * result + this.pingAckDropThreshold;
        result = 31 * result + (this.pingAckTimeout == null ? 0 : Objects.hashCode(this.pingAckTimeout));
        result = 31 * result + (this.pushEnabled == null ? 0 : Boolean.hashCode(this.pushEnabled));
        return result;
    }

    Http2SettingsSpec(Build build) {
        Http2Settings settings = build.http2Settings;
        this.connectProtocolEnabled = build.connectProtocolEnabled;
        this.headerTableSize = settings.headerTableSize();
        this.initialWindowSize = settings.initialWindowSize();
        this.maxConcurrentStreams = settings.maxConcurrentStreams() != null ? Long.valueOf(build.maxStreams != null ? Math.min(settings.maxConcurrentStreams(), build.maxStreams) : settings.maxConcurrentStreams()) : build.maxStreams;
        this.maxDecodedRstFramesPerWindow = build.maxDecodedRstFramesPerWindow;
        this.maxDecodedRstFramesSecondsPerWindow = build.maxDecodedRstFramesSecondsPerWindow;
        this.maxEncodedRstFramesPerWindow = build.maxEncodedRstFramesPerWindow;
        this.maxEncodedRstFramesSecondsPerWindow = build.maxEncodedRstFramesSecondsPerWindow;
        this.maxFrameSize = settings.maxFrameSize();
        this.maxHeaderListSize = settings.maxHeaderListSize();
        this.maxStreams = build.maxStreams;
        this.pingAckDropThreshold = build.pingAckDropThreshold;
        this.pingAckTimeout = build.pingAckTimeout;
        this.pushEnabled = settings.pushEnabled();
    }

    static final class Build
    implements Builder {
        static final int DEFAULT_PING_ACK_DROP_THRESHOLD = 1;
        @Nullable Boolean connectProtocolEnabled;
        @Nullable Integer maxDecodedRstFramesPerWindow;
        @Nullable Integer maxDecodedRstFramesSecondsPerWindow;
        @Nullable Integer maxEncodedRstFramesPerWindow;
        @Nullable Integer maxEncodedRstFramesSecondsPerWindow;
        @Nullable Long maxStreams;
        Integer pingAckDropThreshold = 1;
        @Nullable Duration pingAckTimeout;
        final Http2Settings http2Settings = Http2Settings.defaultSettings();

        Build() {
        }

        @Override
        public Http2SettingsSpec build() {
            return new Http2SettingsSpec(this);
        }

        @Override
        public Builder connectProtocolEnabled(boolean connectProtocolEnabled) {
            this.connectProtocolEnabled = connectProtocolEnabled;
            return this;
        }

        @Override
        public Builder headerTableSize(long headerTableSize) {
            this.http2Settings.headerTableSize(headerTableSize);
            return this;
        }

        @Override
        public Builder initialWindowSize(int initialWindowSize) {
            this.http2Settings.initialWindowSize(initialWindowSize);
            return this;
        }

        @Override
        public Builder maxConcurrentStreams(long maxConcurrentStreams) {
            this.http2Settings.maxConcurrentStreams(maxConcurrentStreams);
            return this;
        }

        @Override
        public Builder maxDecodedRstFramesPerWindow(int maxDecodedRstFramesPerWindow, int maxDecodedRstFramesSecondsPerWindow) {
            if (maxDecodedRstFramesPerWindow < 0) {
                throw new IllegalArgumentException("maxDecodedRstFramesPerWindow must be positive or zero");
            }
            if (maxDecodedRstFramesSecondsPerWindow < 0) {
                throw new IllegalArgumentException("maxDecodedRstFramesSecondsPerWindow must be positive or zero");
            }
            this.maxDecodedRstFramesPerWindow = maxDecodedRstFramesPerWindow;
            this.maxDecodedRstFramesSecondsPerWindow = maxDecodedRstFramesSecondsPerWindow;
            return this;
        }

        @Override
        public Builder maxEncodedRstFramesPerWindow(int maxEncodedRstFramesPerWindow, int maxEncodedRstFramesSecondsPerWindow) {
            if (maxEncodedRstFramesPerWindow < 0) {
                throw new IllegalArgumentException("maxEncodedRstFramesPerWindow must be positive or zero");
            }
            if (maxEncodedRstFramesSecondsPerWindow < 0) {
                throw new IllegalArgumentException("maxEncodedRstFramesSecondsPerWindow must be positive or zero");
            }
            this.maxEncodedRstFramesPerWindow = maxEncodedRstFramesPerWindow;
            this.maxEncodedRstFramesSecondsPerWindow = maxEncodedRstFramesSecondsPerWindow;
            return this;
        }

        @Override
        public Builder maxFrameSize(int maxFrameSize) {
            this.http2Settings.maxFrameSize(maxFrameSize);
            return this;
        }

        @Override
        public Builder maxHeaderListSize(long maxHeaderListSize) {
            this.http2Settings.maxHeaderListSize(maxHeaderListSize);
            return this;
        }

        @Override
        public Builder maxStreams(long maxStreams) {
            if (maxStreams < 1L) {
                throw new IllegalArgumentException("maxStreams must be positive");
            }
            this.maxStreams = maxStreams;
            return this;
        }

        @Override
        public Builder pingAckDropThreshold(int pingAckDropThreshold) {
            if (pingAckDropThreshold < 1) {
                throw new IllegalArgumentException("pingAckDropThreshold must be positive");
            }
            this.pingAckDropThreshold = pingAckDropThreshold;
            return this;
        }

        @Override
        public Builder pingAckTimeout(Duration pingAckTimeout) {
            Objects.requireNonNull(pingAckTimeout, "pingAckTimeout");
            if (pingAckTimeout.isNegative() || pingAckTimeout.isZero()) {
                throw new IllegalArgumentException("pingAckTimeout must be positive");
            }
            this.pingAckTimeout = pingAckTimeout;
            return this;
        }
    }

    public static interface Builder {
        public Http2SettingsSpec build();

        public Builder connectProtocolEnabled(boolean var1);

        public Builder headerTableSize(long var1);

        public Builder initialWindowSize(int var1);

        public Builder maxConcurrentStreams(long var1);

        public Builder maxDecodedRstFramesPerWindow(int var1, int var2);

        public Builder maxEncodedRstFramesPerWindow(int var1, int var2);

        public Builder maxFrameSize(int var1);

        public Builder maxHeaderListSize(long var1);

        public Builder maxStreams(long var1);

        default public Builder pingAckDropThreshold(int pingAckDropThreshold) {
            return this;
        }

        default public Builder pingAckTimeout(Duration pingAckTimeout) {
            return this;
        }
    }
}

