/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import java.util.SplittableRandom;
import org.tribuo.RealIDInfo;
import org.tribuo.SkeletalVariableInfo;

public class RealInfo
extends SkeletalVariableInfo {
    private static final long serialVersionUID = 1L;
    protected double max = Double.NEGATIVE_INFINITY;
    protected double min = Double.POSITIVE_INFINITY;
    protected double mean = 0.0;
    protected double sumSquares = 0.0;

    public RealInfo(String name) {
        super(name);
    }

    public RealInfo(String name, int count) {
        super(name, count);
    }

    public RealInfo(String name, int count, double max, double min, double mean, double sumSquares) {
        super(name, count);
        this.max = max;
        this.min = min;
        this.mean = mean;
        this.sumSquares = sumSquares;
    }

    public RealInfo(RealInfo other) {
        this(other, other.name);
    }

    protected RealInfo(RealInfo other, String newName) {
        super(newName, other.count);
        this.max = other.max;
        this.min = other.min;
        this.mean = other.mean;
        this.sumSquares = other.sumSquares;
    }

    @Override
    protected void observe(double value) {
        if (value != 0.0) {
            super.observe(value);
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
            double delta = value - this.mean;
            this.mean += delta / (double)this.count;
            double delta2 = value - this.mean;
            this.sumSquares += delta * delta2;
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public double getVariance() {
        return this.sumSquares / (double)(this.count - 1);
    }

    @Override
    public RealInfo copy() {
        return new RealInfo(this);
    }

    @Override
    public RealIDInfo makeIDInfo(int id) {
        return new RealIDInfo(this, id);
    }

    @Override
    public RealInfo rename(String newName) {
        return new RealInfo(this, newName);
    }

    @Override
    public double uniformSample(SplittableRandom rng) {
        return rng.nextDouble() * this.max - this.min;
    }

    @Override
    public String toString() {
        return String.format("RealFeature(name=%s,count=%d,max=%f,min=%f,mean=%f,variance=%f)", this.name, this.count, this.max, this.min, this.mean, this.sumSquares / (double)(this.count - 1));
    }
}

