/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Location
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Location> {
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uri").getter(S3Location.getter(S3Location::uri)).setter(S3Location.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()}).build();
    private static final SdkField<String> BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketOwner").getter(S3Location.getter(S3Location::bucketOwner)).setter(S3Location.setter(Builder::bucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URI_FIELD, BUCKET_OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3Location.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String uri;
    private final String bucketOwner;

    private S3Location(BuilderImpl builder) {
        this.uri = builder.uri;
        this.bucketOwner = builder.bucketOwner;
    }

    public final String uri() {
        return this.uri;
    }

    public final String bucketOwner() {
        return this.bucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location)obj;
        return Objects.equals(this.uri(), other.uri()) && Objects.equals(this.bucketOwner(), other.bucketOwner());
    }

    public final String toString() {
        return ToString.builder((String)"S3Location").add("Uri", (Object)this.uri()).add("BucketOwner", (Object)this.bucketOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "bucketOwner": {
                return Optional.ofNullable(clazz.cast(this.bucketOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("uri", URI_FIELD);
        map.put("bucketOwner", BUCKET_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Location, T> g) {
        return obj -> g.apply((S3Location)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String uri;
        private String bucketOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Location model) {
            this.uri(model.uri);
            this.bucketOwner(model.bucketOwner);
        }

        public final String getUri() {
            return this.uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getBucketOwner() {
            return this.bucketOwner;
        }

        public final void setBucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
        }

        @Override
        public final Builder bucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
            return this;
        }

        public S3Location build() {
            return new S3Location(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Location> {
        public Builder uri(String var1);

        public Builder bucketOwner(String var1);
    }
}

