/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.Application;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.repository.RepositoryFactory;
import ai.djl.repository.RepositoryFactoryImpl;
import ai.djl.util.Progress;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public interface Repository {
    public static Repository newInstance(String name, Path path) {
        return RepositoryFactoryImpl.getFactory().newInstance(name, path.toUri());
    }

    public static Repository newInstance(String name, String url) {
        return RepositoryFactoryImpl.getFactory().newInstance(name, URI.create(url));
    }

    public static void registerRepositoryFactory(RepositoryFactory factory) {
        RepositoryFactoryImpl.registerRepositoryFactory(factory);
    }

    default public MRL model(Application application, String groupId, String artifactId) {
        return this.model(application, groupId, artifactId, null, null);
    }

    default public MRL model(Application application, String groupId, String artifactId, String version) {
        return MRL.model(this, application, groupId, artifactId, version, null);
    }

    default public MRL model(Application application, String groupId, String artifactId, String version, String artifactName) {
        return MRL.model(this, application, groupId, artifactId, version, artifactName);
    }

    default public MRL dataset(Application application, String groupId, String artifactId) {
        return this.dataset(application, groupId, artifactId, null);
    }

    default public MRL dataset(Application application, String groupId, String artifactId, String version) {
        return MRL.dataset(this, application, groupId, artifactId, version);
    }

    public boolean isRemote();

    public String getName();

    public URI getBaseUri();

    public Metadata locate(MRL var1) throws IOException;

    public Artifact resolve(MRL var1, Map<String, String> var2) throws IOException;

    public InputStream openStream(Artifact.Item var1, String var2) throws IOException;

    public Path getFile(Artifact.Item var1, String var2) throws IOException;

    public String[] listDirectory(Artifact.Item var1, String var2) throws IOException;

    default public void prepare(Artifact artifact) throws IOException {
        this.prepare(artifact, null);
    }

    public void prepare(Artifact var1, Progress var2) throws IOException;

    public Path getCacheDirectory() throws IOException;

    default public Path getResourceDirectory(Artifact artifact) throws IOException {
        return this.getCacheDirectory().resolve(artifact.getResourceUri().getPath());
    }

    public List<MRL> getResources();

    public void addResource(MRL var1);
}

