/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.netty4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import org.opensearch.ExceptionsHelper;
import org.opensearch.http.AbstractHttpServerTransport;
import org.opensearch.http.HttpChannel;
import org.opensearch.http.HttpPipelinedRequest;
import org.opensearch.http.HttpRequest;
import org.opensearch.http.netty4.Netty4HttpChannel;

@ChannelHandler.Sharable
class Netty4HttpRequestHandler
extends SimpleChannelInboundHandler<HttpPipelinedRequest> {
    private final AbstractHttpServerTransport serverTransport;
    private final AttributeKey<Netty4HttpChannel> channelKey;

    Netty4HttpRequestHandler(AbstractHttpServerTransport serverTransport, AttributeKey<Netty4HttpChannel> channelKey) {
        this.serverTransport = serverTransport;
        this.channelKey = channelKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, HttpPipelinedRequest httpRequest) {
        Netty4HttpChannel channel = (Netty4HttpChannel)ctx.channel().attr(this.channelKey).get();
        boolean success = false;
        try {
            this.serverTransport.incomingRequest((HttpRequest)httpRequest, (HttpChannel)channel);
            success = true;
        }
        finally {
            if (!success) {
                httpRequest.release();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
        Netty4HttpChannel channel = (Netty4HttpChannel)ctx.channel().attr(this.channelKey).get();
        if (cause instanceof Error) {
            this.serverTransport.onException((HttpChannel)channel, new Exception(cause));
        } else {
            this.serverTransport.onException((HttpChannel)channel, (Exception)cause);
        }
    }
}

