/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.metrics;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.metrics.MeanMetric;
import org.opensearch.common.metrics.OperationStats;

public class OperationMetrics {
    private final MeanMetric time = new MeanMetric();
    private final AtomicLong current = new AtomicLong();
    private final CounterMetric failed = new CounterMetric();
    private TimeUnit targetTimeUnit = TimeUnit.MILLISECONDS;

    public OperationMetrics() {
    }

    public OperationMetrics(TimeUnit targetTimeUnit) {
        this.targetTimeUnit = targetTimeUnit;
    }

    public void before() {
        this.current.incrementAndGet();
    }

    public void beforeN(int n) {
        this.current.addAndGet(n);
    }

    public void after(long currentTime) {
        this.current.decrementAndGet();
        this.time.inc(currentTime);
    }

    public void afterN(int n, long currentTime) {
        this.current.addAndGet(-n);
        for (int i = 0; i < n; ++i) {
            this.time.inc(currentTime);
        }
    }

    public void failed() {
        this.failed.inc();
    }

    public void failedN(int n) {
        for (int i = 0; i < n; ++i) {
            this.failed.inc();
        }
    }

    public void add(OperationMetrics other) {
        this.failed.inc(other.failed.count());
        this.time.add(other.time);
    }

    public OperationStats createStats() {
        return new OperationStats(this.time.count(), this.targetTimeUnit.convert(this.time.sum(), TimeUnit.NANOSECONDS), this.current.get(), this.failed.count(), this.targetTimeUnit);
    }
}

