/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.resultsetmanagement;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.xmpp.resultsetmanagement.Result;

public abstract class ResultSet<E extends Result>
extends AbstractCollection<E> {
    private static final Collection<String> validRequestFields = new ArrayList<String>();
    public static final String NAMESPACE_RESULT_SET_MANAGEMENT = "http://jabber.org/protocol/rsm";

    public List<E> getAfter(E result, int maxAmount) {
        return this.getAfter(result.getUID(), maxAmount);
    }

    public abstract List<E> getAfter(String var1, int var2);

    public List<E> getBefore(E result, int maxAmount) {
        return this.getBefore(result.getUID(), maxAmount);
    }

    public abstract List<E> getBefore(String var1, int var2);

    public abstract List<E> getFirst(int var1);

    public abstract List<E> getLast(int var1);

    public abstract E get(int var1);

    public abstract List<E> get(int var1, int var2);

    public String getUID(int index) {
        return this.get(index).getUID();
    }

    public abstract int indexOf(String var1);

    public int indexOf(E element) {
        return this.indexOf(element.getUID());
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    public List<E> applyRSMDirectives(Element rsmElement) {
        List<E> result;
        int index;
        int max;
        if (rsmElement == null || !ResultSet.isValidRSMRequest(rsmElement)) {
            throw new IllegalArgumentException("The 'rsmElement' argument must be a valid, non-null RSM element.");
        }
        Element maxEl = rsmElement.element("max");
        int n = max = maxEl == null ? Integer.MAX_VALUE : Integer.parseInt(maxEl.getText());
        if (max == 0) {
            return Collections.emptyList();
        }
        Element afterElement = rsmElement.element("after");
        Element beforeElement = rsmElement.element("before");
        Element indexElement = rsmElement.element("index");
        String afterPointerUID = null;
        String beforePointerUID = null;
        boolean isForwardOriented = true;
        if (afterElement != null) {
            afterPointerUID = afterElement.getText();
        }
        if (beforeElement != null) {
            beforePointerUID = beforeElement.getText();
            if (afterPointerUID == null) {
                isForwardOriented = false;
            }
        }
        if (indexElement != null && (index = Integer.parseInt(indexElement.getText())) > 0) {
            afterPointerUID = this.getUID(index - 1);
        }
        if (afterPointerUID != null && afterPointerUID.equals("")) {
            afterPointerUID = null;
        }
        if (beforePointerUID != null && beforePointerUID.equals("")) {
            beforePointerUID = null;
        }
        if (isForwardOriented) {
            result = afterPointerUID == null ? this.getFirst(max) : this.getAfter(afterPointerUID, max);
            if (beforePointerUID != null) {
                Result e;
                ArrayList<Result> subList = new ArrayList<Result>(result.size());
                Iterator<E> iterator = result.iterator();
                while (iterator.hasNext() && !(e = (Result)iterator.next()).getUID().equals(beforePointerUID)) {
                    subList.add(e);
                }
                result = subList;
            }
        } else {
            result = beforePointerUID == null ? this.getLast(max) : this.getBefore(beforePointerUID, max);
            if (afterPointerUID != null) {
                Result e;
                ArrayList<Result> subList = new ArrayList<Result>(result.size());
                Collections.reverse(result);
                Iterator<E> iterator = result.iterator();
                while (iterator.hasNext() && !(e = (Result)iterator.next()).getUID().equals(beforePointerUID)) {
                    subList.add(e);
                }
                result = subList;
                Collections.reverse(result);
            }
        }
        return result;
    }

    public Element generateSetElementFromResults(List<E> returnedResults) {
        if (returnedResults == null) {
            throw new IllegalArgumentException("Argument 'returnedResults' cannot be null.");
        }
        Element setElement = DocumentHelper.createElement((QName)QName.get((String)"set", (String)NAMESPACE_RESULT_SET_MANAGEMENT));
        setElement.addElement("count").setText(String.valueOf(this.size()));
        if (returnedResults.size() > 0) {
            Element firstElement = setElement.addElement("first");
            firstElement.addText(((Result)returnedResults.get(0)).getUID());
            firstElement.addAttribute("index", String.valueOf(this.indexOf((Result)returnedResults.get(0))));
            setElement.addElement("last").addText(((Result)returnedResults.get(returnedResults.size() - 1)).getUID());
        }
        return setElement;
    }

    public static boolean isValidRSMRequest(Element rsmElement) {
        if (rsmElement == null) {
            throw new IllegalArgumentException("The argument 'rsmElement' cannot be null.");
        }
        if (!rsmElement.getName().equals("set")) {
            return false;
        }
        if (!rsmElement.getNamespaceURI().equals(NAMESPACE_RESULT_SET_MANAGEMENT)) {
            return false;
        }
        Element maxElement = rsmElement.element("max");
        if (maxElement != null) {
            String sMax = maxElement.getText();
            if (sMax == null || sMax.isEmpty()) {
                return false;
            }
            try {
                if (Integer.parseInt(sMax) < 0) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        List allElements = rsmElement.elements();
        HashSet<String> allNames = new HashSet<String>();
        for (Element element : allElements) {
            String name = element.getName();
            if (!validRequestFields.contains(name)) {
                return false;
            }
            allNames.add(name);
            if (!name.equals("index")) continue;
            String value = element.getText();
            if (value == null || value.equals("")) {
                return false;
            }
            try {
                if (Integer.parseInt(value) >= 0) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return !allNames.contains("index") || !allNames.contains("before") && !allNames.contains("after");
    }

    static {
        validRequestFields.add("max");
        validRequestFields.add("before");
        validRequestFields.add("after");
        validRequestFields.add("index");
    }

    class Itr
    implements Iterator<E> {
        int cursor = 0;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ResultSet.this.size();
        }

        @Override
        public E next() {
            return ResultSet.this.get(this.cursor++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

