<?php

declare (strict_types=1);
namespace OCA\News\Vendor\FeedIo;

use OCA\News\Vendor\FeedIo\Reader\FixerSet;
use OCA\News\Vendor\FeedIo\Rule\DateTimeBuilderInterface;
interface SpecificationInterface
{
    public function getFixerSet(): FixerSet;
    public function getDateTimeBuilder(): DateTimeBuilderInterface;
    public function newParser(string $format, StandardAbstract $standard): ParserAbstract;
    public function addStandard(string $name, StandardAbstract $standardAbstract): self;
    public function getStandard(string $name): StandardAbstract;
    public function getAllStandards(): array;
}
