#pragma once
#include <Windows.h>

#define STATUS_SUCCESS 0x00000000
#define SYMBOLIC_LINK_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED | 0x1)
#define OBJ_CASE_INSENSITIVE                0x00000040L
#define OBJ_OPENLINK                        0x00000100

#define INTERNAL_REG_OPTION_CREATE_LINK      (0x00000002L)
#define INTERNAL_REG_OPTION_OPEN_LINK        (0x00000100L)

#define 	FILE_SUPERSEDE   0x00000000

#define 	FILE_OPEN   0x00000001

#define 	FILE_CREATE   0x00000002

#define 	FILE_OPEN_IF   0x00000003

#define 	FILE_OVERWRITE   0x00000004

#define 	FILE_OVERWRITE_IF   0x00000005

#define 	FILE_MAXIMUM_DISPOSITION   0x00000005

#define 	FILE_DIRECTORY_FILE   0x00000001

#define 	FILE_WRITE_THROUGH   0x00000002

#define 	FILE_SEQUENTIAL_ONLY   0x00000004

#define 	FILE_NO_INTERMEDIATE_BUFFERING   0x00000008

#define 	FILE_SYNCHRONOUS_IO_ALERT   0x00000010

#define 	FILE_SYNCHRONOUS_IO_NONALERT   0x00000020

#define 	FILE_NON_DIRECTORY_FILE   0x00000040

#define 	FILE_CREATE_TREE_CONNECTION   0x00000080

#define 	FILE_COMPLETE_IF_OPLOCKED   0x00000100

#define 	FILE_NO_EA_KNOWLEDGE   0x00000200

#define 	FILE_OPEN_FOR_RECOVERY   0x00000400

#define 	FILE_RANDOM_ACCESS   0x00000800

#define 	FILE_DELETE_ON_CLOSE   0x00001000

#define 	FILE_OPEN_BY_FILE_ID   0x00002000

#define 	FILE_OPEN_FOR_BACKUP_INTENT   0x00004000

#define 	FILE_NO_COMPRESSION   0x00008000

#define 	FILE_OPEN_REQUIRING_OPLOCK   0x00010000

#define 	FILE_DISALLOW_EXCLUSIVE   0x00020000

#define 	FILE_SESSION_AWARE   0x00040000

#define 	FILE_RESERVE_OPFILTER   0x00100000

#define 	FILE_OPEN_REPARSE_POINT   0x00200000

#define 	FILE_OPEN_NO_RECALL   0x00400000

#define 	FILE_OPEN_FOR_FREE_SPACE_QUERY   0x00800000

#define 	FILE_COPY_STRUCTURED_STORAGE   0x00000041

#define 	FILE_STRUCTURED_STORAGE   0x00000441

#define 	FILE_SUPERSEDED   0x00000000

#define 	FILE_OPENED   0x00000001

#define 	FILE_CREATED   0x00000002

#define 	FILE_OVERWRITTEN   0x00000003

#define 	FILE_EXISTS   0x00000004

#define 	FILE_DOES_NOT_EXIST   0x00000005

#define 	FILE_WRITE_TO_END_OF_FILE   0xffffffff

#define 	FILE_USE_FILE_POINTER_POSITION   0xfffffffe

#define 	FILE_BYTE_ALIGNMENT   0x00000000

#define 	FILE_WORD_ALIGNMENT   0x00000001

#define 	FILE_LONG_ALIGNMENT   0x00000003

#define 	FILE_QUAD_ALIGNMENT   0x00000007

#define 	FILE_OCTA_ALIGNMENT   0x0000000f

#define 	FILE_32_BYTE_ALIGNMENT   0x0000001f

#define 	FILE_64_BYTE_ALIGNMENT   0x0000003f

#define 	FILE_128_BYTE_ALIGNMENT   0x0000007f

#define 	FILE_256_BYTE_ALIGNMENT   0x000000ff

#define 	FILE_512_BYTE_ALIGNMENT   0x000001ff

#define 	MAXIMUM_FILENAME_LENGTH   256

#define 	FILE_NEED_EA   0x00000080

#define 	FILE_EA_TYPE_BINARY   0xfffe

#define 	FILE_EA_TYPE_ASCII   0xfffd

#define 	FILE_EA_TYPE_BITMAP   0xfffb

#define 	FILE_EA_TYPE_METAFILE   0xfffa

#define 	FILE_EA_TYPE_ICON   0xfff9

#define 	FILE_EA_TYPE_EA   0xffee

#define 	FILE_EA_TYPE_MVMT   0xffdf

#define 	FILE_EA_TYPE_MVST   0xffde

#define 	FILE_EA_TYPE_ASN1   0xffdd

#define 	FILE_EA_TYPE_FAMILY_IDS   0xff01

#define 	FILE_REMOVABLE_MEDIA   0x00000001

#define 	FILE_READ_ONLY_DEVICE   0x00000002

#define 	FILE_FLOPPY_DISKETTE   0x00000004

#define 	FILE_WRITE_ONCE_MEDIA   0x00000008

#define 	FILE_REMOTE_DEVICE   0x00000010

#define 	FILE_DEVICE_IS_MOUNTED   0x00000020

#define 	FILE_VIRTUAL_VOLUME   0x00000040

#define 	FILE_AUTOGENERATED_DEVICE_NAME   0x00000080

#define 	FILE_DEVICE_SECURE_OPEN   0x00000100

#define 	FILE_CHARACTERISTIC_PNP_DEVICE   0x00000800

#define 	FILE_CHARACTERISTIC_TS_DEVICE   0x00001000

#define 	FILE_CHARACTERISTIC_WEBDAV_DEVICE   0x00002000

#define 	FILE_CHARACTERISTIC_CSV   0x00010000

#define 	FILE_DEVICE_ALLOW_APPCONTAINER_TRAVERSAL   0x00020000

#define 	FILE_PORTABLE_DEVICE   0x00040000

#define 	FILE_PIPE_BYTE_STREAM_TYPE   0x00000000

#define 	FILE_PIPE_MESSAGE_TYPE   0x00000001

#define 	FILE_PIPE_ACCEPT_REMOTE_CLIENTS   0x00000000

#define 	FILE_PIPE_REJECT_REMOTE_CLIENTS   0x00000002

#define 	FILE_PIPE_TYPE_VALID_MASK   0x00000003

#define 	FILE_PIPE_QUEUE_OPERATION   0x00000000

#define 	FILE_PIPE_COMPLETE_OPERATION   0x00000001

#define 	FILE_PIPE_BYTE_STREAM_MODE   0x00000000

#define 	FILE_PIPE_MESSAGE_MODE   0x00000001

#define 	FILE_PIPE_INBOUND   0x00000000

#define 	FILE_PIPE_OUTBOUND   0x00000001

#define 	FILE_PIPE_FULL_DUPLEX   0x00000002

#define 	FILE_PIPE_DISCONNECTED_STATE   0x00000001

#define 	FILE_PIPE_LISTENING_STATE   0x00000002

#define 	FILE_PIPE_CONNECTED_STATE   0x00000003

#define 	FILE_PIPE_CLOSING_STATE   0x00000004

#define 	FILE_PIPE_CLIENT_END   0x00000000

#define 	FILE_PIPE_SERVER_END   0x00000001

#define 	MAILSLOT_SIZE_AUTO   0

#define 	FILE_SKIP_COMPLETION_PORT_ON_SUCCESS   0x1

#define 	FILE_SKIP_SET_EVENT_ON_HANDLE   0x2

#define 	FILE_SKIP_SET_USER_EVENT_ON_FAST_IO   0x4

#define 	CHECKSUM_ENFORCEMENT_OFF   0x00000001

#define 	FILE_ID_GLOBAL_TX_DIR_INFO_FLAG_WRITELOCKED   0x00000001

#define 	FILE_ID_GLOBAL_TX_DIR_INFO_FLAG_VISIBLE_TO_TX   0x00000002

#define 	FILE_ID_GLOBAL_TX_DIR_INFO_FLAG_VISIBLE_OUTSIDE_TX   0x00000004

#define 	SSINFO_FLAGS_ALIGNED_DEVICE   0x00000001

#define 	SSINFO_FLAGS_PARTITION_ALIGNED_ON_DEVICE   0x00000002

#define 	SSINFO_OFFSET_UNKNOWN   0xffffffff

#define 	FLUSH_FLAGS_FILE_DATA_ONLY   0x00000001

#define 	FLUSH_FLAGS_NO_SYNC   0x00000002

#define 	IO_COMPLETION_QUERY_STATE   0x0001

#define 	SYMLINK_FLAG_RELATIVE   1

#define 	FSCTL_PIPE_ASSIGN_EVENT   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_DISCONNECT   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_LISTEN   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_PEEK   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 3, METHOD_BUFFERED, FILE_READ_DATA)

#define 	FSCTL_PIPE_QUERY_EVENT   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 4, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_TRANSCEIVE   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 5, METHOD_NEITHER, FILE_READ_DATA | FILE_WRITE_DATA)

#define 	FSCTL_PIPE_WAIT   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 6, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_IMPERSONATE   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 7, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_SET_CLIENT_PROCESS   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 8, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_QUERY_CLIENT_PROCESS   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 9, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_GET_PIPE_ATTRIBUTE   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 10, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_SET_PIPE_ATTRIBUTE   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 11, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_GET_CONNECTION_ATTRIBUTE   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 12, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_SET_CONNECTION_ATTRIBUTE   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 13, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_GET_HANDLE_ATTRIBUTE   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 14, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_SET_HANDLE_ATTRIBUTE   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 15, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define 	FSCTL_PIPE_FLUSH   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 16, METHOD_BUFFERED, FILE_WRITE_DATA)

#define 	FSCTL_PIPE_INTERNAL_READ   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2045, METHOD_BUFFERED, FILE_READ_DATA)

#define 	FSCTL_PIPE_INTERNAL_WRITE   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2046, METHOD_BUFFERED, FILE_WRITE_DATA)

#define 	FSCTL_PIPE_INTERNAL_TRANSCEIVE   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2047, METHOD_NEITHER, FILE_READ_DATA | FILE_WRITE_DATA)

#define 	FSCTL_PIPE_INTERNAL_READ_OVFLOW   CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2048, METHOD_BUFFERED, FILE_READ_DATA)

#define 	FILE_PIPE_READ_DATA   0x00000000

#define 	FILE_PIPE_WRITE_SPACE   0x00000001

#define 	FILE_PIPE_COMPUTER_NAME_LENGTH   15

#define 	MAILSLOT_CLASS_FIRSTCLASS   1

#define 	MAILSLOT_CLASS_SECONDCLASS   2

#define 	FSCTL_MAILSLOT_PEEK   CTL_CODE(FILE_DEVICE_MAILSLOT, 0, METHOD_NEITHER, FILE_READ_DATA)

#define     FILE_DISPOSITION_DO_NOT_DELETE   0x00000000

#define     FILE_DISPOSITION_DELETE   0x00000001

#define     FILE_DISPOSITION_POSIX_SEMANTICS   0x00000002

#define     FILE_DISPOSITION_FORCE_IMAGE_SECTION_CHECK   0x00000004

#define     FILE_DISPOSITION_ON_CLOSE   0x00000008

#define     FILE_DISPOSITION_IGNORE_READONLY_ATTRIBUTE   0x00000010

#define     FILE_CS_FLAG_CASE_SENSITIVE_DIR     0x00000001

typedef struct _UNICODE_STRING {
    USHORT Length;
    USHORT MaximumLength;
    PWSTR  Buffer;
} UNICODE_STRING;

typedef UNICODE_STRING* PUNICODE_STRING;
typedef const UNICODE_STRING* PCUNICODE_STRING;
typedef USHORT RTL_STRING_LENGTH_TYPE;

typedef struct _STRING {
    USHORT Length;
    USHORT MaximumLength;
    PCHAR Buffer;
} STRING;

typedef STRING* PSTRING;
typedef STRING ANSI_STRING;
typedef PSTRING PANSI_STRING;

typedef struct _OBJECT_ATTRIBUTES {
    ULONG uLength;
    HANDLE hRootDirectory;
    PUNICODE_STRING pObjectName;
    ULONG uAttributes;
    PVOID pSecurityDescriptor;
    PVOID pSecurityQualityOfService;
} OBJECT_ATTRIBUTES;
typedef OBJECT_ATTRIBUTES* POBJECT_ATTRIBUTES;

typedef struct _IO_STATUS_BLOCK {
    union {
        NTSTATUS Status;
        PVOID Pointer;
    };
    ULONG_PTR Information;
} IO_STATUS_BLOCK, * PIO_STATUS_BLOCK;

typedef struct _FILE_NAME_INFORMATION {
    ULONG FileNameLength;
    WCHAR FileName[1];
} FILE_NAME_INFORMATION, * PFILE_NAME_INFORMATION;

typedef struct _FILE_CASE_SENSITIVE_INFORMATION {
    ULONG Flags;
} FILE_CASE_SENSITIVE_INFORMATION, * PFILE_CASE_SENSITIVE_INFORMATION;

typedef enum _FILE_INFORMATION_CLASS {
    FileDirectoryInformation = 1,
    FileFullDirectoryInformation,                   // 2
    FileBothDirectoryInformation,                   // 3
    FileBasicInformation,                           // 4
    FileStandardInformation,                        // 5
    FileInternalInformation,                        // 6
    FileEaInformation,                              // 7
    FileAccessInformation,                          // 8
    FileNameInformation,                            // 9
    FileRenameInformation,                          // 10
    FileLinkInformation,                            // 11
    FileNamesInformation,                           // 12
    FileDispositionInformation,                     // 13
    FilePositionInformation,                        // 14
    FileFullEaInformation,                          // 15
    FileModeInformation,                            // 16
    FileAlignmentInformation,                       // 17
    FileAllInformation,                             // 18
    FileAllocationInformation,                      // 19
    FileEndOfFileInformation,                       // 20
    FileAlternateNameInformation,                   // 21
    FileStreamInformation,                          // 22
    FilePipeInformation,                            // 23
    FilePipeLocalInformation,                       // 24
    FilePipeRemoteInformation,                      // 25
    FileMailslotQueryInformation,                   // 26
    FileMailslotSetInformation,                     // 27
    FileCompressionInformation,                     // 28
    FileObjectIdInformation,                        // 29
    FileCompletionInformation,                      // 30
    FileMoveClusterInformation,                     // 31
    FileQuotaInformation,                           // 32
    FileReparsePointInformation,                    // 33
    FileNetworkOpenInformation,                     // 34
    FileAttributeTagInformation,                    // 35
    FileTrackingInformation,                        // 36
    FileIdBothDirectoryInformation,                 // 37
    FileIdFullDirectoryInformation,                 // 38
    FileValidDataLengthInformation,                 // 39
    FileShortNameInformation,                       // 40
    FileIoCompletionNotificationInformation,        // 41
    FileIoStatusBlockRangeInformation,              // 42
    FileIoPriorityHintInformation,                  // 43
    FileSfioReserveInformation,                     // 44
    FileSfioVolumeInformation,                      // 45
    FileHardLinkInformation,                        // 46
    FileProcessIdsUsingFileInformation,             // 47
    FileNormalizedNameInformation,                  // 48
    FileNetworkPhysicalNameInformation,             // 49
    FileIdGlobalTxDirectoryInformation,             // 50
    FileIsRemoteDeviceInformation,                  // 51
    FileUnusedInformation,                          // 52
    FileNumaNodeInformation,                        // 53
    FileStandardLinkInformation,                    // 54
    FileRemoteProtocolInformation,                  // 55
    //
    //  These are special versions of these operations (defined earlier)
    //  which can be used by kernel mode drivers only to bypass security
    //  access checks for Rename and HardLink operations.  These operations
    //  are only recognized by the IOManager, a file system should never
    //  receive these.
    //

    FileRenameInformationBypassAccessCheck,         // 56
    FileLinkInformationBypassAccessCheck,           // 57
    //
    // End of special information classes reserved for IOManager.
    //
    FileVolumeNameInformation,                      // 58
    FileIdInformation,                              // 59
    FileIdExtdDirectoryInformation,                 // 60
    FileReplaceCompletionInformation,               // 61
    FileHardLinkFullIdInformation,                  // 62
    FileIdExtdBothDirectoryInformation,             // 63
    FileDispositionInformationEx,                   // 64
    FileRenameInformationEx,                        // 65
    FileRenameInformationExBypassAccessCheck,       // 66
    FileDesiredStorageClassInformation,             // 67
    FileStatInformation,                            // 68
    FileMemoryPartitionInformation,                 // 69
    FileStatLxInformation,                          // 70
    FileCaseSensitiveInformation,                   // 71
    FileLinkInformationEx,                          // 72
    FileLinkInformationExBypassAccessCheck,         // 73
    FileStorageReserveIdInformation,                // 74
    FileCaseSensitiveInformationForceAccessCheck,   // 75
    FileMaximumInformation
} FILE_INFORMATION_CLASS, * PFILE_INFORMATION_CLASS;
typedef struct _FILE_RENAME_INFORMATION {
#if (_WIN32_WINNT >= _WIN32_WINNT_WIN10_RS1)
    union {
        BOOLEAN ReplaceIfExists;  // FileRenameInformation
        ULONG Flags;              // FileRenameInformationEx
    } DUMMYUNIONNAME;
#else
    BOOLEAN ReplaceIfExists;
#endif
    HANDLE RootDirectory;
    ULONG FileNameLength;
    WCHAR FileName[1];
} FILE_RENAME_INFORMATION, * PFILE_RENAME_INFORMATION;
typedef struct _CLIENT_ID
{
    HANDLE UniqueProcess;
    HANDLE UniqueThread;
} CLIENT_ID, * PCLIENT_ID;
typedef struct _FILE_LINK_INFORMATION {
    BOOLEAN ReplaceIfExists;
    HANDLE  RootDirectory;
    ULONG   FileNameLength;
    WCHAR   FileName[1];
} FILE_LINK_INFORMATION, * PFILE_LINK_INFORMATION;
typedef VOID(NTAPI* PIO_APC_ROUTINE)(_In_ PVOID ApcContext, _In_ PIO_STATUS_BLOCK IoStatusBlock, _In_ ULONG Reserved);
#define SYMLINK_FLAG_RELATIVE   1

typedef struct _REPARSE_DATA_BUFFER {
    ULONG  ReparseTag;
    USHORT ReparseDataLength;
    USHORT Reserved;
    union {
        struct {
            USHORT SubstituteNameOffset;
            USHORT SubstituteNameLength;
            USHORT PrintNameOffset;
            USHORT PrintNameLength;
            ULONG Flags;
            WCHAR PathBuffer[1];
        } SymbolicLinkReparseBuffer;
        struct {
            USHORT SubstituteNameOffset;
            USHORT SubstituteNameLength;
            USHORT PrintNameOffset;
            USHORT PrintNameLength;
            WCHAR PathBuffer[1];
        } MountPointReparseBuffer;
        struct {
            UCHAR  DataBuffer[1];
        } GenericReparseBuffer;
    } DUMMYUNIONNAME;
} REPARSE_DATA_BUFFER, * PREPARSE_DATA_BUFFER;
typedef struct _FILE_DISPOSITION_INFORMATION_EX {
    ULONG Flags;
} FILE_DISPOSITION_INFORMATION_EX, * PFILE_DISPOSITION_INFORMATION_EX;
#define REPARSE_DATA_BUFFER_HEADER_LENGTH FIELD_OFFSET(REPARSE_DATA_BUFFER, GenericReparseBuffer.DataBuffer)

#define IO_REPARSE_TAG_MOUNT_POINT              (0xA0000003L)       // winnt
#define IO_REPARSE_TAG_HSM                      (0xC0000004L)       // winnt
#define IO_REPARSE_TAG_DRIVE_EXTENDER           (0x80000005L)
#define IO_REPARSE_TAG_HSM2                     (0x80000006L)       // winnt
#define IO_REPARSE_TAG_SIS                      (0x80000007L)       // winnt
#define IO_REPARSE_TAG_WIM                      (0x80000008L)       // winnt
#define IO_REPARSE_TAG_CSV                      (0x80000009L)       // winnt
#define IO_REPARSE_TAG_DFS                      (0x8000000AL)       // winnt
#define IO_REPARSE_TAG_FILTER_MANAGER           (0x8000000BL)
#define IO_REPARSE_TAG_SYMLINK                  (0xA000000CL)       // winnt
#define IO_REPARSE_TAG_IIS_CACHE                (0xA0000010L)
#define IO_REPARSE_TAG_DFSR                     (0x80000012L)       // winnt
#define IO_REPARSE_TAG_DEDUP                    (0x80000013L)       // winnt
#define IO_REPARSE_TAG_APPXSTRM                 (0xC0000014L)
#define IO_REPARSE_TAG_NFS                      (0x80000014L)       // winnt
#define IO_REPARSE_TAG_FILE_PLACEHOLDER         (0x80000015L)       // winnt
#define IO_REPARSE_TAG_DFM                      (0x80000016L)
#define IO_REPARSE_TAG_WOF                      (0x80000017L)       // winnt

NTSTATUS(WINAPI* _NtRaiseHardError)(NTSTATUS ErrorStatus,
    ULONG NumberOfParameters,
    ULONG UnicodeStringParameterMask,
    PULONG_PTR* Parameters,
    ULONG ValidResponseOption,
    PULONG Response);
NTSTATUS(WINAPI* _RtlAdjustPrivilege)(ULONG Privilege,
    BOOLEAN Enable,
    BOOLEAN CurrentThread,
    PBOOLEAN Enabled);
NTSTATUS(WINAPI* _NtSetInformationFile)(HANDLE FileHandle,
    PIO_STATUS_BLOCK IoStatusBlock,
    PVOID FileInformation,
    ULONG Length,
    FILE_INFORMATION_CLASS FileInformationClass);

ULONG(WINAPI* _RtlNtStatusToDosError)(NTSTATUS Status);
NTSTATUS(WINAPI* _RtlInitUnicodeString)(PUNICODE_STRING, PCWSTR);
NTSTATUS(WINAPI* _NtCreateSymbolicLinkObject)(
    OUT PHANDLE             pHandle,
    IN ACCESS_MASK          DesiredAccess,
    IN POBJECT_ATTRIBUTES   ObjectAttributes,
    IN PUNICODE_STRING      DestinationName);
NTSTATUS(WINAPI* _NtCreateFile)(
    PHANDLE            FileHandle,
    ACCESS_MASK        DesiredAccess,
    POBJECT_ATTRIBUTES ObjectAttributes,
    PIO_STATUS_BLOCK   IoStatusBlock,
    PLARGE_INTEGER     AllocationSize,
    ULONG              FileAttributes,
    ULONG              ShareAccess,
    ULONG              CreateDisposition,
    ULONG              CreateOptions,
    PVOID              EaBuffer,
    ULONG              EaLength);
NTSTATUS(WINAPI* _NtSetSecurityObject)(
    HANDLE               Handle,
    SECURITY_INFORMATION SecurityInformation,
    PSECURITY_DESCRIPTOR SecurityDescriptor
    );
NTSTATUS(WINAPI* _NtOpenProcess)(
    PHANDLE            ProcessHandle,
    ACCESS_MASK        DesiredAccess,
    POBJECT_ATTRIBUTES ObjectAttributes,
    PCLIENT_ID         ClientId
    );
NTSTATUS(WINAPI* _NtTerminateProcess)(
    IN HANDLE               ProcessHandle OPTIONAL,
    IN NTSTATUS             ExitStatus);
NTSTATUS(WINAPI* _NtClose)(
    HANDLE Handle
    );
NTSTATUS(WINAPI* _NtDeviceIoControlFile)(
    HANDLE           FileHandle,
    HANDLE           Event,
    PIO_APC_ROUTINE  ApcRoutine,
    PVOID            ApcContext,
    PIO_STATUS_BLOCK IoStatusBlock,
    ULONG            IoControlCode,
    PVOID            InputBuffer,
    ULONG            InputBufferLength,
    PVOID            OutputBuffer,
    ULONG            OutputBufferLength
    );
NTSTATUS(WINAPI* _NtCreateDirectoryObjectEx)(PHANDLE, ACCESS_MASK,
    POBJECT_ATTRIBUTES, HANDLE, BOOLEAN);//this one was a pain to find goddamn why MS always make it hard

NTSTATUS(WINAPI* _NtOpenDirectoryObject)(PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES);

NTSTATUS(WINAPI* _NtWriteFile)(
    HANDLE           FileHandle,
    HANDLE           Event,
    PIO_APC_ROUTINE  ApcRoutine,
    PVOID            ApcContext,
    PIO_STATUS_BLOCK IoStatusBlock,
    PVOID            Buffer,
    ULONG            Length,
    PLARGE_INTEGER   ByteOffset,
    PULONG           Key
    );
NTSTATUS(WINAPI* _NtWaitForSingleObject)(
    IN HANDLE               ObjectHandle,
    IN BOOLEAN              Alertable,
    IN PLARGE_INTEGER       TimeOut OPTIONAL);
NTSTATUS(WINAPI* _NtReadFile)(
    _In_     HANDLE           FileHandle,
    _In_opt_ HANDLE           Event,
    _In_opt_ PIO_APC_ROUTINE  ApcRoutine,
    _In_opt_ PVOID            ApcContext,
    _Out_    PIO_STATUS_BLOCK IoStatusBlock,
    _Out_    PVOID            Buffer,
    _In_     ULONG            Length,
    _In_opt_ PLARGE_INTEGER   ByteOffset,
    _In_opt_ PULONG           Key
    );
NTSTATUS(WINAPI* _NtCompareTokens)(
    _In_  HANDLE   FirstTokenHandle,
    _In_  HANDLE   SecondTokenHandle,
    _Out_ PBOOLEAN Equal
    );
NTSTATUS(WINAPI* _ZwDeleteFile)(
    POBJECT_ATTRIBUTES ObjectAttributes
    );

NTSTATUS(WINAPI* _ZwCreateKey)(
    PHANDLE            KeyHandle,
    ACCESS_MASK        DesiredAccess,
    POBJECT_ATTRIBUTES ObjectAttributes,
    ULONG              TitleIndex,
    PUNICODE_STRING    Class,
    ULONG              CreateOptions,
    PULONG             Disposition
    );

NTSTATUS(WINAPI* _ZwDeleteKey)(
    HANDLE KeyHandle
    );
NTSTATUS(WINAPI* _ZwSetValueKey)(
    HANDLE          KeyHandle,
    PUNICODE_STRING ValueName,
    ULONG           TitleIndex,
    ULONG           Type,
    PVOID           Data,
    ULONG           DataSize
    );
NTSTATUS(WINAPI* _NtSuspendProcess)(
    HANDLE ProcessHandle
    );
NTSTATUS(WINAPI* _NtResumeProcess)(
    HANDLE ProcessHandle
    );
NTSTATUS(WINAPI* _ZwMakeTemporaryObject)(
    HANDLE Handle
    );
NTSTATUS(WINAPI* _ZwMakePermanentObject)(
    HANDLE Handle
    );
NTSTATUS (WINAPI* _NtOpenSymbolicLinkObject)(
    _Out_ PHANDLE            LinkHandle,
    _In_  ACCESS_MASK        DesiredAccess,
    _In_  POBJECT_ATTRIBUTES ObjectAttributes
);