/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.repository.Proxy;
import org.apache.maven.repository.legacy.UpdateCheckManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.internal.impl.TrackingFileManager;

@Component(role=UpdateCheckManager.class)
public class DefaultUpdateCheckManager
extends AbstractLogEnabled
implements UpdateCheckManager {
    @Requirement
    private TrackingFileManager trackingFileManager;
    private static final String ERROR_KEY_SUFFIX = ".error";
    public static final String LAST_UPDATE_TAG = ".lastUpdated";
    private static final String TOUCHFILE_NAME = "resolver-status.properties";

    public DefaultUpdateCheckManager() {
    }

    public DefaultUpdateCheckManager(Logger logger, TrackingFileManager trackingFileManager) {
        this.enableLogging(logger);
        this.trackingFileManager = trackingFileManager;
    }

    @Override
    public boolean isUpdateRequired(Artifact artifact, ArtifactRepository repository) {
        Date lastCheckDate;
        ArtifactRepositoryPolicy policy;
        File file = artifact.getFile();
        ArtifactRepositoryPolicy artifactRepositoryPolicy = policy = artifact.isSnapshot() ? repository.getSnapshots() : repository.getReleases();
        if (!policy.isEnabled()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Skipping update check for " + artifact + " (" + file + ") from " + repository.getId() + " (" + repository.getUrl() + ")");
            }
            return false;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Determining update check for " + artifact + " (" + file + ") from " + repository.getId() + " (" + repository.getUrl() + ")");
        }
        if (file == null) {
            return true;
        }
        if (file.exists()) {
            lastCheckDate = new Date(file.lastModified());
        } else {
            File touchfile = this.getTouchfile(artifact);
            lastCheckDate = this.readLastUpdated(touchfile, this.getRepositoryKey(repository));
        }
        return lastCheckDate == null || policy.checkOutOfDate(lastCheckDate);
    }

    @Override
    public boolean isUpdateRequired(RepositoryMetadata metadata, ArtifactRepository repository, File file) {
        ArtifactRepositoryPolicy policy = metadata.getPolicy(repository);
        if (!policy.isEnabled()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Skipping update check for " + metadata.getKey() + " (" + file + ") from " + repository.getId() + " (" + repository.getUrl() + ")");
            }
            return false;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Determining update check for " + metadata.getKey() + " (" + file + ") from " + repository.getId() + " (" + repository.getUrl() + ")");
        }
        if (file == null) {
            return true;
        }
        Date lastCheckDate = this.readLastUpdated(metadata, repository, file);
        return lastCheckDate == null || policy.checkOutOfDate(lastCheckDate);
    }

    private Date readLastUpdated(RepositoryMetadata metadata, ArtifactRepository repository, File file) {
        File touchfile = this.getTouchfile(metadata, file);
        String key = this.getMetadataKey(repository, file);
        return this.readLastUpdated(touchfile, key);
    }

    @Override
    public String getError(Artifact artifact, ArtifactRepository repository) {
        File touchFile = this.getTouchfile(artifact);
        return this.getError(touchFile, this.getRepositoryKey(repository));
    }

    @Override
    public void touch(Artifact artifact, ArtifactRepository repository, String error) {
        File file = artifact.getFile();
        File touchfile = this.getTouchfile(artifact);
        if (file.exists()) {
            this.trackingFileManager.delete(touchfile);
        } else {
            this.writeLastUpdated(touchfile, this.getRepositoryKey(repository), error);
        }
    }

    @Override
    public void touch(RepositoryMetadata metadata, ArtifactRepository repository, File file) {
        File touchfile = this.getTouchfile(metadata, file);
        String key = this.getMetadataKey(repository, file);
        this.writeLastUpdated(touchfile, key, null);
    }

    String getMetadataKey(ArtifactRepository repository, File file) {
        return repository.getId() + '.' + file.getName() + LAST_UPDATE_TAG;
    }

    String getRepositoryKey(ArtifactRepository repository) {
        Authentication auth;
        StringBuilder buffer = new StringBuilder(256);
        Proxy proxy = repository.getProxy();
        if (proxy != null) {
            if (proxy.getUserName() != null) {
                int hash = (proxy.getUserName() + proxy.getPassword()).hashCode();
                buffer.append(hash).append('@');
            }
            buffer.append(proxy.getHost()).append(':').append(proxy.getPort()).append('>');
        }
        if ((auth = repository.getAuthentication()) != null) {
            int hash = (auth.getUsername() + auth.getPassword()).hashCode();
            buffer.append(hash).append('@');
        }
        buffer.append(repository.getUrl());
        return buffer.toString();
    }

    private void writeLastUpdated(File touchfile, String key, String error) {
        HashMap<String, String> update = new HashMap<String, String>();
        update.put(key, Long.toString(System.currentTimeMillis()));
        update.put(key + ERROR_KEY_SUFFIX, error);
        this.trackingFileManager.update(touchfile, update);
    }

    Date readLastUpdated(File touchfile, String key) {
        String rawVal;
        this.getLogger().debug("Searching for " + key + " in resolution tracking file.");
        Properties props = this.read(touchfile);
        if (props != null && (rawVal = props.getProperty(key)) != null) {
            try {
                return new Date(Long.parseLong(rawVal));
            }
            catch (NumberFormatException e) {
                this.getLogger().debug("Cannot parse lastUpdated date: '" + rawVal + "'. Ignoring.", (Throwable)e);
            }
        }
        return null;
    }

    private String getError(File touchFile, String key) {
        Properties props = this.read(touchFile);
        if (props != null) {
            return props.getProperty(key + ERROR_KEY_SUFFIX);
        }
        return null;
    }

    private Properties read(File touchfile) {
        return this.trackingFileManager.read(touchfile);
    }

    File getTouchfile(Artifact artifact) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(artifact.getArtifactId());
        sb.append('-').append(artifact.getBaseVersion());
        if (artifact.getClassifier() != null) {
            sb.append('-').append(artifact.getClassifier());
        }
        sb.append('.').append(artifact.getType()).append(LAST_UPDATE_TAG);
        return new File(artifact.getFile().getParentFile(), sb.toString());
    }

    File getTouchfile(RepositoryMetadata metadata, File file) {
        return new File(file.getParent(), TOUCHFILE_NAME);
    }
}

