/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.jdbc.jdbcResultSet;

public class jdbcStatement
implements Statement {
    volatile boolean isClosed;
    private boolean isEscapeProcessing = true;
    protected jdbcConnection connection;
    protected int maxRows;
    protected Result resultIn;
    protected int rsType = 1003;
    protected Result resultOut = new Result(65547);
    protected Result batchResultOut = null;

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.fetchResult(string);
        return new jdbcResultSet(this, this.resultIn, this.connection.connProperties, this.connection.isNetConn);
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.fetchResult(string);
        if (this.resultIn == null || this.resultIn.isData()) {
            throw new SQLException(Trace.getMessage(142));
        }
        if (this.resultIn.isError()) {
            Util.throwError(this.resultIn);
        }
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.batchResultOut = null;
        this.connection = null;
        this.resultIn = null;
        this.resultOut = null;
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw Util.sqlException(62);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw Util.sqlException(62);
        }
        this.maxRows = n;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
        this.isEscapeProcessing = bl;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw Util.sqlException(62);
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.fetchResult(string);
        return this.resultIn.isData();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.resultIn == null || !this.resultIn.isData() ? null : new jdbcResultSet(this, this.resultIn, this.connection.connProperties, this.connection.isNetConn);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.resultIn == null || this.resultIn.isData() ? -1 : this.resultIn.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        this.resultIn = null;
        return false;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkClosed();
        if (n != 1000) {
            throw Util.notSupported();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.rsType;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.checkClosed();
        if (this.isEscapeProcessing) {
            string = this.connection.nativeSQL(string);
        }
        if (this.batchResultOut == null) {
            this.batchResultOut = new Result(8, new int[]{12}, 0);
        }
        this.batchResultOut.add(new Object[]{string});
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        if (this.batchResultOut != null) {
            this.batchResultOut.clear();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        if (this.batchResultOut == null) {
            this.batchResultOut = new Result(8, new int[]{12}, 0);
        }
        int n = this.batchResultOut.getSize();
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.batchResultOut);
        }
        catch (HsqlException hsqlException) {
            this.batchResultOut.clear();
            throw Util.sqlException(hsqlException);
        }
        this.batchResultOut.clear();
        if (this.resultIn.isError()) {
            Util.throwError(this.resultIn);
        }
        if ((nArray = this.resultIn.getUpdateCounts()).length != n) {
            throw new BatchUpdateException("failed batch", nArray);
        }
        return nArray;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    jdbcStatement(jdbcConnection jdbcConnection2, int n) {
        this.connection = jdbcConnection2;
        this.rsType = n;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.sqlException(126);
        }
        if (this.connection.isClosed) {
            throw Util.sqlException(2);
        }
    }

    private void fetchResult(String string) throws SQLException {
        if (this.isEscapeProcessing) {
            string = this.connection.nativeSQL(string);
        }
        this.resultIn = null;
        this.resultOut.setMainString(string);
        this.resultOut.setMaxRows(this.maxRows);
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
            if (this.resultIn.isError()) {
                throw new HsqlException(this.resultIn);
            }
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

