/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.lang.invoke.MethodHandles;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Locking;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.community.dialect.RDMSOS2200SqlAstTranslator;
import org.hibernate.community.dialect.sequence.RDMSSequenceSupport;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadUpdateLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteUpdateLockingStrategy;
import org.hibernate.dialect.lock.internal.LockingSupportSimple;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.pagination.FetchLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.internal.NonLockingClauseStrategy;
import org.hibernate.sql.ast.spi.LockingClauseStrategy;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.jboss.logging.Logger;

public class RDMSOS2200Dialect
extends Dialect {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)RDMSOS2200Dialect.class.getName());

    public RDMSOS2200Dialect() {
        super((DatabaseVersion)SimpleDatabaseVersion.ZERO_VERSION);
    }

    public RDMSOS2200Dialect(DialectResolutionInfo info) {
        super(info);
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: 
            case 16: {
                return "smallint";
            }
            case -5: {
                return "numeric(19,0)";
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 4001: 
            case 4002: {
                return "unicode($l)";
            }
            case 2005: 
            case 2011: {
                return "clob($l)";
            }
            case -3: 
            case -2: 
            case 2004: 
            case 4003: {
                return "blob($l)";
            }
            case 2014: {
                return this.columnType(93);
            }
        }
        return super.columnType(sqlTypeCode);
    }

    public boolean useMaterializedLobWhenCapacityExceeded() {
        return false;
    }

    public int getMaxVarbinaryLength() {
        return -1;
    }

    public DatabaseVersion getVersion() {
        return SimpleDatabaseVersion.ZERO_VERSION;
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == -7) {
            return jdbcTypeRegistry.getDescriptor(16);
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    public int getDefaultDecimalPrecision() {
        return 21;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.cosh();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.cot();
        functionFactory.log();
        functionFactory.log10();
        functionFactory.pi();
        functionFactory.rand();
        functionFactory.trunc();
        functionFactory.soundex();
        functionFactory.trim2();
        functionFactory.space();
        functionFactory.repeat();
        functionFactory.initcap();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.translate();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.lastDay();
        functionFactory.ceiling_ceil();
        functionFactory.concat_pipeOperator();
        functionFactory.ascii();
        functionFactory.chr_char();
        functionFactory.insert();
        functionFactory.addMonths();
        functionFactory.monthsBetween();
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new RDMSOS2200SqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1000L;
    }

    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case SECOND: {
                return "(second(?2)+microsecond(?2)/1e6)";
            }
            case DAY_OF_WEEK: {
                return "dayofweek(?2)";
            }
            case DAY_OF_MONTH: {
                return "dayofmonth(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
        }
        return "?1(?2)";
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: {
                return "timestampadd('SQL_TSI_FRAC_SECOND',(?2)/1e3,?3)";
            }
            case NATIVE: {
                return "timestampadd('SQL_TSI_FRAC_SECOND',?2,?3)";
            }
        }
        return "dateadd('?1',?2,?3)";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NANOSECOND: {
                return "timestampdiff('SQL_TSI_FRAC_SECOND',?2,?3)*1e3";
            }
            case NATIVE: {
                return "timestampdiff('SQL_TSI_FRAC_SECOND',?2,?3)";
            }
        }
        return "dateadd('?1',?2,?3)";
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public LockingSupport getLockingSupport() {
        return LockingSupportSimple.NO_OUTER_JOIN;
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getNullColumnString() {
        return " null";
    }

    public SequenceSupport getSequenceSupport() {
        return RDMSSequenceSupport.INSTANCE;
    }

    public String getCascadeConstraintsString() {
        return " including contents";
    }

    public LimitHandler getLimitHandler() {
        return FetchLimitHandler.INSTANCE;
    }

    public boolean supportsOrderByInSubquery() {
        return false;
    }

    protected LockingStrategy buildPessimisticWriteStrategy(EntityPersister lockable, LockMode lockMode, Locking.Scope lockScope) {
        return new PessimisticWriteUpdateLockingStrategy(lockable, lockMode);
    }

    protected LockingStrategy buildPessimisticReadStrategy(EntityPersister lockable, LockMode lockMode, Locking.Scope lockScope) {
        return new PessimisticReadUpdateLockingStrategy(lockable, lockMode);
    }

    public LockingClauseStrategy getLockingClauseStrategy(QuerySpec querySpec, LockOptions lockOptions) {
        return NonLockingClauseStrategy.NON_CLAUSE_STRATEGY;
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat((String)format, (boolean)true, (boolean)false).replace("SSSSSS", "MLS").replace("SSSSS", "MLS").replace("SSSS", "MLS").replace("SSS", "MLS").replace("SS", "MLS").replace("S", "MLS").result());
    }

    public String trimPattern(TrimSpec specification, boolean isWhitespace) {
        return AbstractTransactSQLDialect.replaceLtrimRtrim((TrimSpec)specification, (boolean)isWhitespace);
    }

    public String getDual() {
        return "rdms.rdms_dummy";
    }

    public String getFromDualForSelectOnly() {
        return " from " + this.getDual() + " where key_col=1";
    }

    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }
}

