/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote.transaction;

import java.util.function.Consumer;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.query.ClientSessionQueryConditionalRemover;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.query.UserSessionQueryConditionalRemover;
import org.keycloak.models.sessions.infinispan.remote.transaction.ClientSessionChangeLogTransaction;
import org.keycloak.models.sessions.infinispan.remote.transaction.UserSessionChangeLogTransaction;
import org.keycloak.models.sessions.infinispan.transaction.DatabaseUpdate;
import org.keycloak.models.sessions.infinispan.transaction.NonBlockingTransaction;

public class UserSessionTransaction
implements NonBlockingTransaction {
    private final UserSessionChangeLogTransaction userSessions;
    private final ClientSessionChangeLogTransaction clientSessions;
    private final UserSessionChangeLogTransaction offlineUserSessions;
    private final ClientSessionChangeLogTransaction offlineClientSessions;

    public UserSessionTransaction(UserSessionChangeLogTransaction userSessions, UserSessionChangeLogTransaction offlineUserSessions, ClientSessionChangeLogTransaction clientSessions, ClientSessionChangeLogTransaction offlineClientSessions) {
        this.userSessions = userSessions;
        this.offlineUserSessions = offlineUserSessions;
        this.clientSessions = clientSessions;
        this.offlineClientSessions = offlineClientSessions;
    }

    @Override
    public void asyncCommit(AggregateCompletionStage<Void> stage, Consumer<DatabaseUpdate> databaseUpdates) {
        this.userSessions.asyncCommit(stage, databaseUpdates);
        this.clientSessions.asyncCommit(stage, databaseUpdates);
        this.offlineUserSessions.asyncCommit(stage, databaseUpdates);
        this.offlineClientSessions.asyncCommit(stage, databaseUpdates);
    }

    @Override
    public void asyncRollback(AggregateCompletionStage<Void> stage) {
        this.userSessions.asyncRollback(stage);
        this.clientSessions.asyncRollback(stage);
        this.offlineUserSessions.asyncRollback(stage);
        this.offlineClientSessions.asyncRollback(stage);
    }

    public ClientSessionChangeLogTransaction getClientSessions(boolean offline) {
        return offline ? this.offlineClientSessions : this.clientSessions;
    }

    public UserSessionChangeLogTransaction getUserSessions(boolean offline) {
        return offline ? this.offlineUserSessions : this.userSessions;
    }

    public void removeAllSessionsByRealmId(String realmId) {
        ((ClientSessionQueryConditionalRemover)this.clientSessions.getConditionalRemover()).removeByRealmId(realmId);
        ((UserSessionQueryConditionalRemover)this.userSessions.getConditionalRemover()).removeByRealmId(realmId);
        ((ClientSessionQueryConditionalRemover)this.offlineClientSessions.getConditionalRemover()).removeByRealmId(realmId);
        ((UserSessionQueryConditionalRemover)this.offlineUserSessions.getConditionalRemover()).removeByRealmId(realmId);
    }

    public void removeOnlineSessionsByRealmId(String realmId) {
        ((ClientSessionQueryConditionalRemover)this.clientSessions.getConditionalRemover()).removeByRealmId(realmId);
        ((UserSessionQueryConditionalRemover)this.userSessions.getConditionalRemover()).removeByRealmId(realmId);
    }

    public void removeAllSessionByUserId(String realmId, String userId) {
        ((UserSessionQueryConditionalRemover)this.userSessions.getConditionalRemover()).removeByUserId(realmId, userId);
        ((ClientSessionQueryConditionalRemover)this.clientSessions.getConditionalRemover()).removeByUserId(realmId, userId);
    }

    public void removeUserSessionById(String userSessionId, boolean offline) {
        this.getUserSessions(offline).remove(userSessionId);
        this.getClientSessions(offline).removeByUserSessionId(userSessionId);
    }
}

