/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.uuid;

import java.lang.reflect.Member;
import java.util.EnumSet;
import java.util.Locale;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.annotations.UuidGenerator;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.id.uuid.CustomVersionOneStrategy;
import org.hibernate.id.uuid.StandardRandomStrategy;
import org.hibernate.id.uuid.UuidValueGenerator;
import org.hibernate.id.uuid.UuidVersion6Strategy;
import org.hibernate.id.uuid.UuidVersion7Strategy;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.type.descriptor.java.UUIDJavaType;

public class UuidGenerator
implements BeforeExecutionGenerator {
    private final UuidValueGenerator generator;
    private final UUIDJavaType.ValueTransformer valueTransformer;

    @Internal
    public UuidGenerator(Class<?> memberType) {
        this.generator = StandardRandomStrategy.INSTANCE;
        this.valueTransformer = this.determineProperTransformer(memberType);
    }

    @Internal
    public UuidGenerator(org.hibernate.annotations.UuidGenerator config, MemberDetails memberDetails) {
        this.generator = UuidGenerator.determineValueGenerator(config, memberDetails.getDeclaringType().getName(), memberDetails.getName());
        Class memberType = memberDetails.getType().determineRawClass().toJavaClass();
        this.valueTransformer = this.determineProperTransformer(memberType);
    }

    @Internal
    public UuidGenerator(org.hibernate.annotations.UuidGenerator config, Member idMember) {
        this.generator = UuidGenerator.determineValueGenerator(config, idMember.getDeclaringClass().getName(), idMember.getName());
        Class<?> propertyType = ReflectHelper.getPropertyType(idMember);
        this.valueTransformer = this.determineProperTransformer(propertyType);
    }

    public UuidGenerator(org.hibernate.annotations.UuidGenerator config, Member member, GeneratorCreationContext creationContext) {
        this(config, member);
    }

    @Override
    public EnumSet<EventType> getEventTypes() {
        return EventTypeSets.INSERT_ONLY;
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object owner, Object currentValue, EventType eventType) {
        return this.valueTransformer.transform(this.generator.generateUuid(session));
    }

    @Internal
    public UuidValueGenerator getValueGenerator() {
        return this.generator;
    }

    @Internal
    public UUIDJavaType.ValueTransformer getValueTransformer() {
        return this.valueTransformer;
    }

    private static UuidValueGenerator determineValueGenerator(org.hibernate.annotations.UuidGenerator config, String memberDeclaringClassName, String memberName) {
        if (config != null) {
            if (config.algorithm() != UuidValueGenerator.class) {
                if (config.style() != UuidGenerator.Style.AUTO) {
                    throw new MappingException(String.format(Locale.ROOT, "Style [%s] should not be specified with custom UUID value generator : %s.%s", config.style().name(), memberDeclaringClassName, memberName));
                }
                return UuidGenerator.instantiateCustomGenerator(config.algorithm());
            }
            if (config.style() == UuidGenerator.Style.TIME) {
                return new CustomVersionOneStrategy();
            }
            if (config.style() == UuidGenerator.Style.VERSION_6) {
                return UuidVersion6Strategy.INSTANCE;
            }
            if (config.style() == UuidGenerator.Style.VERSION_7) {
                return UuidVersion7Strategy.INSTANCE;
            }
        }
        return StandardRandomStrategy.INSTANCE;
    }

    private static UuidValueGenerator instantiateCustomGenerator(Class<? extends UuidValueGenerator> algorithmClass) {
        try {
            return algorithmClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new HibernateException("Unable to instantiate " + algorithmClass.getName(), e);
        }
    }

    private UUIDJavaType.ValueTransformer determineProperTransformer(Class<?> propertyType) {
        if (UUID.class.isAssignableFrom(propertyType)) {
            return UUIDJavaType.PassThroughTransformer.INSTANCE;
        }
        if (String.class.isAssignableFrom(propertyType)) {
            return UUIDJavaType.ToStringTransformer.INSTANCE;
        }
        if (byte[].class.isAssignableFrom(propertyType)) {
            return UUIDJavaType.ToBytesTransformer.INSTANCE;
        }
        throw new HibernateException("Unanticipated return type [" + propertyType.getName() + "] for UUID conversion");
    }
}

