#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 servant-swagger
version:              1.2.1
visibility:           public
id:                   servant-swagger-1.2.1-D0cx1prhmOVB19hkzQWdee
key:                  servant-swagger-1.2.1-D0cx1prhmOVB19hkzQWdee
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           haskell-servant-maintainers@googlegroups.com
author:               Servant Contributors
homepage:
    https://github.com/haskell-servant/servant/tree/master/servant-swagger#readme

synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  ce87865f568b428ab430bdc94a481e70
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-9.6.6/site-local/servant-swagger-1.2.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/servant-swagger-1.2.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/servant-swagger-1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-servant-swagger
hs-libraries:         HSservant-swagger-1.2.1-D0cx1prhmOVB19hkzQWdee
depends:
    QuickCheck-2.15.0.1-4mIWiyi0MCz4O9NEuBQDps
    aeson-2.1.2.1-JZeWX2s1eQL7Ta3HF3w6fW
    aeson-pretty-0.8.10-LBJ177aL2uN3HrqwVlBpw9 base-4.18.2.1
    base-compat-0.14.1-4heBy5B59ewBpEOwRrJlc4 bytestring-0.11.5.3
    hspec-2.11.4-DsuBXVi1VAG3EB3oodlHQU
    http-media-0.8.1.1-DL0qfuVtDEXDosAyMXP7O8
    insert-ordered-containers-0.2.5.3-68KZlbg0u7nEIXHoneqXPO
    lens-5.3.3-6yFfjYmjPBKuNNVCwyEN9
    servant-0.20.3.0-I7BOiVG6ySg7nH8LlU5YHl
    singleton-bool-0.1.8-HzfV4UnRPmnZgXjmF9X0
    swagger2-2.8.10-2us3e1fIx0BDGkxwlM6s6W text-2.0.2
    unordered-containers-0.2.20.1-8SON4238u8N3rDHPceHjHx

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

