/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.build.BuildIncluder;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildInclusionCoordinator;
import org.gradle.internal.composite.BuildIncludeListener;
import org.gradle.internal.reflect.Instantiator;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class DefaultBuildIncluder
implements BuildIncluder {
    private final BuildStateRegistry buildRegistry;
    private final BuildInclusionCoordinator coordinator;
    private final PublicBuildPath publicBuildPath;
    private final Instantiator instantiator;
    private final GradleInternal gradle;
    private final BuildIncludeListener buildIncludeListener;
    private final List<BuildDefinition> pluginBuildDefinitions = new ArrayList<BuildDefinition>();

    public DefaultBuildIncluder(BuildStateRegistry buildRegistry, BuildInclusionCoordinator coordinator, PublicBuildPath publicBuildPath, Instantiator instantiator, GradleInternal gradle, BuildIncludeListener buildIncludeListener) {
        this.buildRegistry = buildRegistry;
        this.coordinator = coordinator;
        this.publicBuildPath = publicBuildPath;
        this.instantiator = instantiator;
        this.gradle = gradle;
        this.buildIncludeListener = buildIncludeListener;
    }

    @Override
    public CompositeBuildParticipantBuildState includeBuild(IncludedBuildSpec includedBuildSpec) {
        RootBuildState rootBuild = this.buildRegistry.getRootBuild();
        BuildDefinition buildDefinition = this.toBuildDefinition(includedBuildSpec, this.gradle);
        if (includedBuildSpec.rootDir.equals(rootBuild.getBuildRootDir())) {
            this.buildRegistry.onRootBuildInclude(rootBuild, this.gradle.getOwner(), buildDefinition.isPluginBuild());
            this.coordinator.prepareRootBuildForInclusion();
            return rootBuild;
        }
        IncludedBuildState build = this.buildRegistry.addIncludedBuild(buildDefinition, this.gradle.getOwner());
        try {
            this.coordinator.prepareForInclusion(build, buildDefinition.isPluginBuild());
        }
        catch (Exception e) {
            this.buildIncludeListener.buildInclusionFailed(build);
            throw e;
        }
        return build;
    }

    @Override
    public void registerPluginBuild(IncludedBuildSpec includedBuildSpec) {
        this.pluginBuildDefinitions.add(this.toBuildDefinition(includedBuildSpec, this.gradle));
    }

    @Override
    public Collection<IncludedBuildState> getRegisteredPluginBuilds() {
        return this.pluginBuildDefinitions.stream().map(buildDefinition -> {
            IncludedBuildState build = this.buildRegistry.addIncludedBuild((BuildDefinition)buildDefinition, this.gradle.getOwner());
            this.coordinator.prepareForInclusion(build, true);
            return build;
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<IncludedBuildState> getIncludedBuildsForPluginResolution() {
        BuildState thisBuild = this.gradle.getOwner();
        return this.buildRegistry.getIncludedBuilds().stream().filter(build -> build != thisBuild && !build.isImplicitBuild() && !build.isPluginBuild()).collect(Collectors.toList());
    }

    @Override
    public void prepareForPluginResolution(IncludedBuildState build) {
        this.coordinator.prepareForPluginResolution(build);
    }

    private BuildDefinition toBuildDefinition(IncludedBuildSpec includedBuildSpec, GradleInternal gradle) {
        gradle.getOwner().assertCanAdd(includedBuildSpec);
        return includedBuildSpec.toBuildDefinition(gradle.getStartParameter(), this.publicBuildPath, this.instantiator);
    }
}

