/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal.feature;

import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.testkit.runner.UnsupportedFeatureException;
import org.gradle.testkit.runner.internal.feature.FeatureCheck;
import org.gradle.testkit.runner.internal.feature.TestKitFeature;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.util.GradleVersion;

public class BuildResultOutputFeatureCheck
implements FeatureCheck {
    private final GradleVersion targetGradleVersion;
    private final boolean embedded;

    public BuildResultOutputFeatureCheck(GradleVersion targetGradleVersion, boolean embedded) {
        this.targetGradleVersion = targetGradleVersion;
        this.embedded = embedded;
    }

    @Override
    public void verify() {
        if (!this.supportsVersion() && this.embedded) {
            throw new UnsupportedFeatureException("capture build output in debug mode with the GradleRunner", this.targetGradleVersion, TestKitFeature.CAPTURE_BUILD_RESULT_OUTPUT_IN_DEBUG.getSince());
        }
        if (this.targetGradleVersion.compareTo(DefaultGradleConnector.MINIMUM_SUPPORTED_GRADLE_VERSION) < 0) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecate((String)"Capturing build output in debug mode with the GradleRunner for the version of Gradle you are using (%s) is deprecated with TestKit. TestKit will only support the last 5 major versions in future.").willBecomeAnErrorInGradle10().withUserManual("third_party_integration", "sec:embedding_compatibility")).nagUser();
        }
    }

    private boolean supportsVersion() {
        return this.targetGradleVersion.compareTo(TestKitFeature.CAPTURE_BUILD_RESULT_OUTPUT_IN_DEBUG.getSince()) >= 0;
    }
}

