---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Lob publishable API key'
---

## Description

The response body contains content that matches the pattern of a Lob Publishable API key was identified. Publishable API keys are only used for US verifications, international verifications, and US autocomplete requests. A malicious actor with access to this key can execute limited functions under your account.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate a Publishable API key:

- Sign in to your account and go to <https://dashboard.lob.com/>
- In the bottom left corner select the gear icon / "Settings" menu option
- Under "Settings" select the "API Keys" tab
- Identify if the key was a live or test environment key in the "Publishable API Keys" section
- Select the rotate arrow icon of the identified key
- When prompted, select "Yes" in the "Rotate Publishable API Key" dialog

For more information, please see [Lob's documentation on API keys](https://docs.lob.com/#tag/Authentication/API-Keys).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.71 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
