---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token LinkedIn client secret'
---

## Description

The response body contains content that matches the pattern of a LinkedIn client secret was identified. Client secrets are used when allowing users to sign in to your application. Depending on the scopes requested, a malicious actor could impersonate the service to access users' information.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To regenerate your client secret:

- Sign in to your LinkedIn account and visit <https://www.linkedin.com/developers/apps/>
- Find the application that contains the identified secret and select its name
- Select the "Auth" tab
- Select "Generate a new Client Secret" in the "Application credentials" section
- If "Generate a new Client Secret" does not exist, you most likely have two active secrets, delete one, and it should appear
- Select the "X" next to the secret that was identified to remove it
- When prompted, select "Confirm" in the "Remove the Primary Client Secret" dialog

For more information, please see [LinkedIn's documentation on API access](https://learn.microsoft.com/en-us/linkedin/learning/getting-started/request-access).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.69 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
