/*
 * Decompiled with CFR 0.152.
 */
package datagraph.data.graph.panel;

import datagraph.data.graph.DataDegVertex;
import datagraph.data.graph.DegController;
import datagraph.data.graph.DegVertex;
import datagraph.data.graph.panel.DtComponentPathComparator;
import datagraph.data.graph.panel.model.column.CompactDataColumnModel;
import datagraph.data.graph.panel.model.column.ExpandedDataColumnModel;
import datagraph.data.graph.panel.model.row.DataRowObject;
import datagraph.data.graph.panel.model.row.DataTrableRowModel;
import datagraph.graph.explore.EgVertex;
import docking.GenericHeader;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.widgets.trable.GTrable;
import docking.widgets.trable.GTrableColumnModel;
import docking.widgets.trable.GTrableRowModel;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.util.HTMLUtilities;
import ghidra.util.NumericUtilities;
import ghidra.util.datastruct.Range;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import resources.Icons;

public class DataVertexPanel
extends JPanel {
    private GenericHeader genericHeader;
    private GTrable<DataRowObject> gTrable;
    private DataTrableRowModel model;
    private JScrollPane scroll;
    private int headerHeight;
    private Comparator<int[]> pathComparator = new DtComponentPathComparator();
    private Dimension userSize;
    private Rectangle preferredShape = new Rectangle(0, 0, 0, 0);
    private DataDegVertex vertex;
    private DegController controller;
    private Map<EgVertex, IncomingEdgeOffsetInfo> incomingEdgeOffsetMap = new HashMap<EgVertex, IncomingEdgeOffsetInfo>();
    private Map<EgVertex, OutgoingEdgeOffsetInfo> outgoingEdgeOffsetMap = new HashMap<EgVertex, OutgoingEdgeOffsetInfo>();
    private boolean cachedOutgoingOffsetsValid;
    private boolean cachedIncomingOffsetsValid;
    private GTrableColumnModel<DataRowObject> dataColumnModel;

    public DataVertexPanel(DegController controller, DataDegVertex vertex, boolean compactFormat) {
        super(new BorderLayout());
        this.controller = controller;
        this.vertex = vertex;
        this.buildComponent(vertex.getData(), compactFormat);
        this.addKeyListener(new DataVertexKeyListener());
        this.updateTitle();
        this.headerHeight = this.genericHeader.getPreferredSize().height;
        this.scroll.getViewport().addChangeListener(e -> this.invalidateCaches());
    }

    public void setCompactFormat(boolean b) {
        if (!this.isExpandable()) {
            return;
        }
        this.dataColumnModel = b ? new CompactDataColumnModel() : new ExpandedDataColumnModel();
        this.gTrable.setColumnModel(this.dataColumnModel);
        this.userSize = null;
        this.updateShape();
    }

    public void addOutgoingEdge(EgVertex end, int[] componentPath) {
        this.cleanUpDeletedEdges();
        this.outgoingEdgeOffsetMap.put(end, new OutgoingEdgeOffsetInfo(componentPath));
        this.cachedOutgoingOffsetsValid = false;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Component source = event.getComponent();
        if (SwingUtilities.isDescendingFrom(source, (Component)this.genericHeader)) {
            if (!(source instanceof JComponent)) {
                return null;
            }
            JComponent jComponent = (JComponent)source;
            return jComponent.getToolTipText();
        }
        int row = this.gTrable.getRow(event.getPoint());
        DataRowObject rowObject = this.model.getRow(row);
        Data data = rowObject.getData();
        StringBuilder sb = new StringBuilder("<html>");
        sb.append("<TABLE>");
        DataType dataType = data.getDataType();
        Address address = data.getAddress();
        int rootOffset = data.getRootOffset();
        sb.append(this.row("Address: ", address.toString()));
        sb.append(this.row("Offset: ", NumericUtilities.toHexString((long)rootOffset)));
        sb.append(this.row("Data Type: ", dataType.getName()));
        sb.append("</TABLE>");
        return sb.toString();
    }

    private String row(Object ... cols) {
        StringBuilder sb = new StringBuilder("<TR>");
        for (Object col : cols) {
            String escaped = this.escapeHtml(col);
            sb.append("<TD>").append(escaped).append("</TD>");
        }
        sb.append("</TR>");
        return sb.toString();
    }

    private String escapeHtml(Object obj) {
        return obj == null ? "" : HTMLUtilities.friendlyEncodeHTML((String)obj.toString());
    }

    public void addIncommingEdge(EgVertex start, Address address) {
        this.cleanUpDeletedEdges();
        if (!address.equals((Object)this.vertex.getAddress())) {
            this.incomingEdgeOffsetMap.put(start, new IncomingEdgeOffsetInfo(address));
            this.cachedIncomingOffsetsValid = false;
        }
    }

    public int getIncommingEdgeOffsetFromCenter(EgVertex v) {
        IncomingEdgeOffsetInfo info;
        if (!this.cachedIncomingOffsetsValid) {
            this.computeIncomingEdgeOffset();
        }
        if ((info = this.incomingEdgeOffsetMap.get((Object)v)) == null) {
            return -this.getSize().height / 2 + this.headerHeight / 2;
        }
        int yOffsetFromTop = info.yOffset;
        return yOffsetFromTop - this.getSize().height / 2;
    }

    public int getOutgoingEdgeOffsetFromCenter(EgVertex v) {
        OutgoingEdgeOffsetInfo linkInfo;
        if (!this.cachedOutgoingOffsetsValid) {
            this.computeOutgoingEdgeOffsets();
        }
        int yOffsetFromTop = (linkInfo = this.outgoingEdgeOffsetMap.get((Object)v)) != null ? linkInfo.yOffset : 0;
        return yOffsetFromTop - this.getSize().height / 2;
    }

    public void addAction(DockingAction action) {
        this.genericHeader.actionAdded((DockingActionIf)action);
        this.genericHeader.update();
        this.headerHeight = this.genericHeader.getPreferredSize().height;
    }

    public void setSizeByUser(Dimension size) {
        this.userSize = size;
        this.updateShape();
        this.controller.repaint();
    }

    public Shape getShape() {
        return this.preferredShape;
    }

    public boolean updateShape() {
        int height;
        this.gTrable.invalidate();
        Dimension preferredSize = this.scroll.getPreferredSize();
        int width = this.userSize != null ? this.userSize.width : preferredSize.width;
        int n = height = this.userSize != null ? this.userSize.height : preferredSize.height + this.headerHeight;
        if (!this.isOpen()) {
            height = preferredSize.height + this.headerHeight;
        }
        if (this.preferredShape.width == width && this.preferredShape.height == height) {
            return false;
        }
        this.preferredShape.width = width;
        this.preferredShape.height = height;
        return true;
    }

    public void setSelected(boolean selected) {
        this.genericHeader.setSelected(selected);
        if (selected) {
            this.navigate(this.gTrable.getSelectedRow());
        }
    }

    public void setFocused(boolean focused) {
        if (focused) {
            this.navigate(this.gTrable.getSelectedRow());
        }
    }

    public void dispose() {
        this.vertex = null;
    }

    public int getScrollRowOffset() {
        return this.gTrable.getRowOffcut();
    }

    public void openPointerReference(int row) {
        DataRowObject dataDisplayRow = this.model.getRow(row);
        if (dataDisplayRow.hasOutgoingReferences()) {
            Data data = dataDisplayRow.getData();
            this.controller.addOutGoingReferences(this.vertex, data);
        }
    }

    public int getHeaderHeight() {
        return this.headerHeight;
    }

    public int comparePaths(DegVertex v1, DegVertex v2) {
        OutgoingEdgeOffsetInfo edgeInfo1 = this.outgoingEdgeOffsetMap.get(v1);
        OutgoingEdgeOffsetInfo edgeInfo2 = this.outgoingEdgeOffsetMap.get(v2);
        return this.pathComparator.compare(edgeInfo1.componentPath, edgeInfo2.componentPath);
    }

    public void setIsRoot(boolean b) {
        if (b) {
            this.genericHeader.setIcon(Icons.HOME_ICON);
        } else {
            this.genericHeader.setIcon(null);
        }
    }

    public void updateHeader() {
        this.genericHeader.update();
    }

    public void expandRecursivley(int rowIndex) {
        this.gTrable.expandRowRecursively(rowIndex);
    }

    public void expandAll() {
        this.gTrable.expandAll();
    }

    public void collapseAll() {
        this.gTrable.collapseAll();
    }

    public boolean isExpandable() {
        return this.model.getRow(0).isExpandable();
    }

    public void expand(int row) {
        this.model.expandRow(row);
    }

    public void setData(Data newData) {
        boolean isFirstLevelOpen = this.model.isExpanded(0);
        this.model.setData(newData);
        if (isFirstLevelOpen) {
            this.model.expandRow(0);
        }
    }

    public String getTitle() {
        return this.genericHeader.getTitle();
    }

    public List<DataRowObject> getRowObjects() {
        ArrayList<DataRowObject> list = new ArrayList<DataRowObject>();
        int n = this.model.getRowCount();
        for (int i = 0; i < n; ++i) {
            DataRowObject row = this.model.getRow(i);
            list.add(row);
        }
        return list;
    }

    public DockingActionIf getAction(String name) {
        return this.genericHeader.getAction(name);
    }

    private void cleanUpDeletedEdges() {
        Set<DegVertex> outgoingVertices = this.controller.getOutgoingVertices(this.vertex);
        this.outgoingEdgeOffsetMap.keySet().retainAll(outgoingVertices);
        Set<DegVertex> incomingVertices = this.controller.getIncomingVertices(this.vertex);
        this.incomingEdgeOffsetMap.keySet().retainAll(incomingVertices);
    }

    private void invalidateCaches() {
        this.cachedIncomingOffsetsValid = false;
        this.cachedOutgoingOffsetsValid = false;
    }

    private void buildComponent(Data data, boolean compact) {
        this.model = new DataTrableRowModel(data);
        if (!this.isExpandable()) {
            compact = true;
        }
        this.dataColumnModel = compact ? new CompactDataColumnModel() : new ExpandedDataColumnModel();
        this.model.expandRow(0);
        this.gTrable = new GTrable((GTrableRowModel)this.model, this.dataColumnModel);
        this.gTrable.setPreferredVisibleRowCount(1, 15);
        this.gTrable.addCellClickedListener(this::cellClicked);
        this.model.addListener(this::modelDataChanged);
        this.gTrable.addSelectedRowConsumer(this::selectedRowChanged);
        this.scroll = new JScrollPane((Component)this.gTrable);
        this.scroll.getViewport().addChangeListener(e -> this.controller.repaint());
        this.add((Component)this.scroll, "Center");
        this.genericHeader = new GenericHeader();
        this.genericHeader.setComponent((Component)this.scroll);
        this.add((Component)this.genericHeader, "North");
    }

    private void modelDataChanged() {
        if (this.updateShape()) {
            this.controller.relayoutGraph();
        }
        this.cachedOutgoingOffsetsValid = false;
        this.cachedIncomingOffsetsValid = false;
        this.controller.repaint();
    }

    private void computeIncomingEdgeOffset() {
        this.cachedIncomingOffsetsValid = true;
        if (this.incomingEdgeOffsetMap.isEmpty()) {
            return;
        }
        int rowHeight = this.gTrable.getRowHeight();
        int rowOffset = this.gTrable.getRowOffcut();
        Dimension size = this.getSize();
        List<Address> visibleAddresses = this.getVisibleAddresses();
        Address minAddress = visibleAddresses.get(0);
        Address maxAddress = visibleAddresses.get(visibleAddresses.size() - 1);
        for (IncomingEdgeOffsetInfo info : this.incomingEdgeOffsetMap.values()) {
            Address address = info.address;
            if (address.compareTo((Object)minAddress) < 0) {
                info.yOffset = this.headerHeight;
                continue;
            }
            if (address.compareTo((Object)maxAddress) > 0) {
                info.yOffset = size.height;
                continue;
            }
            int index = this.getIndex(visibleAddresses, address);
            int offset = index * rowHeight - rowOffset + rowHeight / 2 + this.headerHeight;
            if (size.height > this.headerHeight) {
                offset = Math.clamp((long)offset, this.headerHeight, size.height);
            }
            info.yOffset = offset;
        }
    }

    private void computeOutgoingEdgeOffsets() {
        this.cachedOutgoingOffsetsValid = true;
        int rowHeight = this.gTrable.getRowHeight();
        int rowOffset = this.gTrable.getRowOffcut();
        Dimension size = this.getSize();
        List<int[]> paths = this.getVisibleDataPaths();
        int[] minPath = paths.get(0);
        for (OutgoingEdgeOffsetInfo info : this.outgoingEdgeOffsetMap.values()) {
            int[] path = info.componentPath;
            if (this.pathComparator.compare(path, minPath) < 0) {
                info.yOffset = this.headerHeight;
                continue;
            }
            int index = this.getIndex(paths, path);
            int offset = index * rowHeight - rowOffset + rowHeight / 2 + this.headerHeight;
            if (size.height > this.headerHeight) {
                offset = Math.clamp((long)offset, this.headerHeight, size.height);
            }
            info.yOffset = offset;
        }
    }

    private int getIndex(List<int[]> paths, int[] componentPath) {
        int index = Collections.binarySearch(paths, componentPath, this.pathComparator);
        if (index < 0) {
            index = -index - 2;
        }
        return index;
    }

    private int getIndex(List<Address> addresses, Address address) {
        int index = Collections.binarySearch(addresses, address);
        if (index < 0) {
            index = -index - 2;
        }
        while (index < addresses.size() - 1 && addresses.get(index + 1).equals((Object)address)) {
            ++index;
        }
        return index;
    }

    private void updateTitle() {
        Data data = this.model.getData();
        String title = "@ " + data.getAddressString(false, false);
        String label = data.getLabel();
        if (label != null) {
            title = label + " " + title;
        }
        this.genericHeader.setTitle(title);
    }

    private boolean isOpen() {
        return this.model.getRow(0).isExpanded();
    }

    private List<Address> getVisibleAddresses() {
        Range visibleRows = this.gTrable.getVisibleRows();
        ArrayList<Address> visiblePaths = new ArrayList<Address>((int)visibleRows.size());
        for (int i = visibleRows.min; i <= visibleRows.max; ++i) {
            DataRowObject displayRow = this.model.getRow(i);
            Data data = displayRow.getData();
            visiblePaths.add(data.getAddress());
        }
        return visiblePaths;
    }

    private List<int[]> getVisibleDataPaths() {
        Range visibleRows = this.gTrable.getVisibleRows();
        ArrayList<int[]> visiblePaths = new ArrayList<int[]>((int)visibleRows.size());
        for (int i = visibleRows.min; i <= visibleRows.max; ++i) {
            DataRowObject displayRow = this.model.getRow(i);
            Data data = displayRow.getData();
            visiblePaths.add(data.getComponentPath());
        }
        return visiblePaths;
    }

    private void cellClicked(int row, int column, MouseEvent ev) {
        if (this.isPointerButtonColumn(column)) {
            this.openPointerReference(row);
        }
    }

    private boolean isPointerButtonColumn(int column) {
        boolean isCompact = this.dataColumnModel instanceof CompactDataColumnModel;
        int pointerColumn = isCompact ? 2 : 3;
        return column == pointerColumn;
    }

    private void selectedRowChanged(int row) {
        this.controller.repaint();
        this.navigate(row);
    }

    private void navigate(int row) {
        if (row < 0) {
            row = 0;
        }
        DataRowObject dataDisplayRow = this.model.getRow(row);
        Data data = dataDisplayRow.getData();
        this.controller.navigateOut(data.getAddress(), data.getComponentPath());
    }

    public boolean isSelectedRowExpandable() {
        int row = this.gTrable.getSelectedRow();
        if (row < 0) {
            return false;
        }
        return this.model.isExpandable(row);
    }

    public void expandSelectedRowRecursively() {
        int row = this.gTrable.getSelectedRow();
        if (row >= 0) {
            this.gTrable.expandRowRecursively(row);
        }
    }

    private class DataVertexKeyListener
    implements KeyListener {
        private DataVertexKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.redispatchEvent((Component)DataVertexPanel.this.gTrable, e);
            e.consume();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.redispatchEvent((Component)DataVertexPanel.this.gTrable, e);
            e.consume();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.redispatchEvent((Component)DataVertexPanel.this.gTrable, e);
            e.consume();
        }
    }

    private static class OutgoingEdgeOffsetInfo {
        public int[] componentPath;
        public int yOffset;

        OutgoingEdgeOffsetInfo(int[] componentPath) {
            this.componentPath = componentPath;
            this.yOffset = 0;
        }
    }

    private static class IncomingEdgeOffsetInfo {
        public Address address;
        public int yOffset;

        IncomingEdgeOffsetInfo(Address toAddress) {
            this.address = toAddress;
        }
    }
}

