/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.gzip;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.gzip.GZipFileSystem;
import ghidra.file.formats.gzip.GZipUtil;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class GZipFileSystemFactory
implements GFileSystemFactoryByteProvider<GZipFileSystem>,
GFileSystemProbeBytesOnly {
    public static final int PROBE_BYTES_REQUIRED = 2;

    public GZipFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        GZipFileSystem fs = new GZipFileSystem(byteProvider, targetFSRL, fsService, monitor);
        return fs;
    }

    public int getBytesRequired() {
        return 2;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return GZipUtil.isGZip(startBytes);
    }
}

