/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Directory
implements StructConverter {
    public static final String NAME = "MINIDUMP_DIRECTORY";
    public static final int THREAD_LIST_STREAM = 3;
    public static final int MODULE_LIST_STREAM = 4;
    public static final int MEMORY_LIST_STREAM = 5;
    public static final int EXCEPTION_STREAM = 6;
    public static final int SYSTEM_INFO_STREAM = 7;
    public static final int THREAD_EX_LIST_STREAM = 8;
    public static final int MEMORY64_LIST_STREAM = 9;
    public static final int HANDLE_LIST_STREAM = 12;
    public static final int UNLOADED_MODULE_LIST_STREAM = 14;
    public static final int MISC_INFO_STREAM = 15;
    public static final int MEMORY_INFO_LIST_STREAM = 16;
    public static final int TOKEN_LIST_STREAM = 19;
    private static final String[] names = new String[]{"UnusedStream", "ReservedStream0", "ReservedStream1", "ThreadListStream", "ModuleListStream", "MemoryListStream", "ExceptionStream", "SystemInfoStream ", "ThreadExListStream", "Memory64ListStream", "CommentStreamA", "CommentStreamW", "HandleDataStream", "FunctionTableStream", "UnloadedModuleListStream", "MiscInfoStream", "MemoryInfoListStream", "ThreadInfoListStream", "HandleOperationListStream", "TokenStream", "JavaScriptDataStream", "SystemMemoryInfoStream", "ProcessVmCountersStream", "IptTraceStream", "ThreadNamesStream"};
    private int streamType;
    private int dataSize;
    private long rva;
    private DumpFileReader reader;
    private long index;

    Directory(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setStreamType(this.reader.readNextInt());
        this.setDataSize(this.reader.readNextInt());
        this.setRVA(this.reader.readNextInt());
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "StreamType", null);
        struct.add(DWORD, 4, "DataSize", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "RVA", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public void setStreamType(int streamType) {
        this.streamType = streamType;
    }

    public int getStreamType() {
        return this.streamType;
    }

    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setRVA(long rva) {
        this.rva = rva;
    }

    public long getRVA() {
        return this.rva;
    }

    public String getReadableName() {
        return names[this.streamType];
    }
}

