/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AlignmentType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PackingType;
import java.util.Set;

public interface Composite
extends DataType {
    @Override
    public void setDescription(String var1);

    public int getNumComponents();

    public int getNumDefinedComponents();

    public DataTypeComponent getComponent(int var1) throws IndexOutOfBoundsException;

    public DataTypeComponent[] getComponents();

    public DataTypeComponent[] getDefinedComponents();

    public DataTypeComponent add(DataType var1) throws IllegalArgumentException;

    public DataTypeComponent add(DataType var1, int var2) throws IllegalArgumentException;

    public DataTypeComponent add(DataType var1, String var2, String var3) throws IllegalArgumentException;

    public DataTypeComponent addBitField(DataType var1, int var2, String var3, String var4) throws InvalidDataTypeException;

    public DataTypeComponent add(DataType var1, int var2, String var3, String var4) throws IllegalArgumentException;

    public DataTypeComponent insert(int var1, DataType var2) throws IndexOutOfBoundsException, IllegalArgumentException;

    public DataTypeComponent insert(int var1, DataType var2, int var3) throws IndexOutOfBoundsException, IllegalArgumentException;

    public DataTypeComponent insert(int var1, DataType var2, int var3, String var4, String var5) throws IndexOutOfBoundsException, IllegalArgumentException;

    public void delete(int var1) throws IndexOutOfBoundsException;

    public void delete(Set<Integer> var1) throws IndexOutOfBoundsException;

    public boolean isPartOf(DataType var1);

    @Override
    public void dataTypeAlignmentChanged(DataType var1);

    public void repack();

    public PackingType getPackingType();

    default public boolean isPackingEnabled() {
        return this.getPackingType() != PackingType.DISABLED;
    }

    public void setPackingEnabled(boolean var1);

    default public boolean hasExplicitPackingValue() {
        return this.getPackingType() == PackingType.EXPLICIT;
    }

    default public boolean hasDefaultPacking() {
        return this.getPackingType() == PackingType.DEFAULT;
    }

    public int getExplicitPackingValue();

    public void setExplicitPackingValue(int var1);

    default public void pack(int packingValue) {
        this.setExplicitPackingValue(packingValue);
    }

    public void setToDefaultPacking();

    @Override
    public int getAlignment();

    public AlignmentType getAlignmentType();

    default public boolean isDefaultAligned() {
        return this.getAlignmentType() == AlignmentType.DEFAULT;
    }

    default public boolean isMachineAligned() {
        return this.getAlignmentType() == AlignmentType.MACHINE;
    }

    default public boolean hasExplicitMinimumAlignment() {
        return this.getAlignmentType() == AlignmentType.EXPLICIT;
    }

    public int getExplicitMinimumAlignment();

    public void setExplicitMinimumAlignment(int var1);

    default public void align(int minAlignment) {
        this.setExplicitMinimumAlignment(minAlignment);
    }

    public void setToDefaultAligned();

    public void setToMachineAligned();
}

