/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial.hyper;

import ghidra.util.database.spatial.BoundedShape;
import ghidra.util.database.spatial.Query;
import ghidra.util.database.spatial.hyper.Dimension;
import ghidra.util.database.spatial.hyper.EuclideanHyperSpace;
import ghidra.util.database.spatial.hyper.HyperBox;
import ghidra.util.database.spatial.hyper.HyperDirection;
import ghidra.util.database.spatial.hyper.HyperPoint;
import java.util.Comparator;

public abstract class AbstractHyperBoxQuery<P extends HyperPoint, DS extends BoundedShape<NS>, NS extends HyperBox<P, NS>, Q extends AbstractHyperBoxQuery<P, DS, NS, Q>>
implements Query<DS, NS> {
    protected final NS ls;
    protected final NS us;
    protected final EuclideanHyperSpace<P, NS> space;
    protected final HyperDirection direction;
    protected Comparator<NS> comparator;

    protected static <P extends HyperPoint, NS extends HyperBox<P, NS>, Q extends AbstractHyperBoxQuery<P, ?, NS, Q>> Q intersecting(NS shape, HyperDirection direction, QueryFactory<NS, Q> factory) {
        NS full = shape.space().getFull();
        NS ls = shape.immutable(full.lCorner(), shape.uCorner());
        NS us = shape.immutable(shape.lCorner(), full.uCorner());
        return factory.create(ls, us, direction);
    }

    protected static <P extends HyperPoint, NS extends HyperBox<P, NS>, Q extends AbstractHyperBoxQuery<P, ?, NS, Q>> Q enclosing(NS shape, HyperDirection direction, QueryFactory<NS, Q> factory) {
        NS full = shape.space().getFull();
        NS ls = shape.immutable(full.lCorner(), shape.lCorner());
        NS us = shape.immutable(shape.uCorner(), full.uCorner());
        return factory.create(ls, us, direction);
    }

    protected static <P extends HyperPoint, NS extends HyperBox<P, NS>, Q extends AbstractHyperBoxQuery<P, ?, NS, Q>> Q enclosed(NS shape, HyperDirection direction, QueryFactory<NS, Q> factory) {
        NS full = shape.space().getFull();
        NS ls = shape.immutable(shape.lCorner(), full.uCorner());
        NS us = shape.immutable(full.lCorner(), shape.uCorner());
        return factory.create(ls, us, direction);
    }

    protected static <P extends HyperPoint, NS extends HyperBox<P, NS>, Q extends AbstractHyperBoxQuery<P, ?, NS, Q>> Q equalTo(NS shape, HyperDirection direction, QueryFactory<NS, Q> factory) {
        NS ls = shape.immutable(shape.lCorner(), shape.lCorner());
        NS us = shape.immutable(shape.uCorner(), shape.uCorner());
        return factory.create(ls, us, direction);
    }

    public AbstractHyperBoxQuery(NS ls, NS us, EuclideanHyperSpace<P, NS> space, HyperDirection direction) {
        this.ls = ls;
        this.us = us;
        this.space = space;
        this.direction = direction;
    }

    @Override
    public boolean terminateEarlyData(DS shape) {
        return this.terminateEarlyNode((NS)((HyperBox)shape.getBounds()));
    }

    private <T> boolean dimTerminateEarlyNode(Dimension<T, P, NS> dim, NS shape) {
        return this.direction.forward() ? dim.compare(dim.lower(shape), dim.upper(this.us)) > 0 : dim.compare(dim.upper(shape), dim.lower(this.ls)) < 0;
    }

    @Override
    public boolean terminateEarlyNode(NS shape) {
        Dimension<?, P, NS> dim = this.space.getDimensions().get(this.direction.dimension());
        return this.dimTerminateEarlyNode(dim, shape);
    }

    @Override
    public Comparator<NS> getBoundsComparator() {
        if (this.comparator == null) {
            Dimension<?, P, NS> dim = this.space.getDimensions().get(this.direction.dimension());
            this.comparator = this.createBoundsComparator(dim);
        }
        return this.comparator;
    }

    protected <T> Comparator<NS> createBoundsComparator(Dimension<T, P, NS> dim) {
        if (this.direction.forward()) {
            return Comparator.comparing(dim::lower, dim::compare);
        }
        return Comparator.comparing(dim::upper, (a, b) -> dim.compare(b, a));
    }

    private <T> boolean isNone(Dimension<T, P, NS> dim, NS shape) {
        if (dim.compare(dim.lower(shape), dim.upper(this.ls)) > 0) {
            return true;
        }
        if (dim.compare(dim.lower(shape), dim.upper(this.us)) > 0) {
            return true;
        }
        if (dim.compare(dim.upper(shape), dim.lower(this.us)) < 0) {
            return true;
        }
        return dim.compare(dim.upper(shape), dim.lower(this.ls)) < 0;
    }

    private <T> boolean isSome(Dimension<T, P, NS> dim, NS shape) {
        if (dim.compare(dim.lower(shape), dim.lower(this.ls)) < 0) {
            return true;
        }
        if (dim.compare(dim.lower(shape), dim.lower(this.us)) < 0) {
            return true;
        }
        if (dim.compare(dim.upper(shape), dim.upper(this.us)) > 0) {
            return true;
        }
        return dim.compare(dim.upper(shape), dim.upper(this.ls)) > 0;
    }

    @Override
    public Query.QueryInclusion testNode(NS shape) {
        for (Dimension<?, P, NS> dim : this.space.getDimensions()) {
            if (!this.isNone(dim, shape)) continue;
            return Query.QueryInclusion.NONE;
        }
        for (Dimension<?, P, NS> dim : this.space.getDimensions()) {
            if (!this.isSome(dim, shape)) continue;
            return Query.QueryInclusion.SOME;
        }
        return Query.QueryInclusion.ALL;
    }

    protected abstract Q create(NS var1, NS var2, HyperDirection var3);

    public Q and(Q query) {
        NS ir1 = this.ls.intersection(((AbstractHyperBoxQuery)query).ls);
        NS ir2 = this.us.intersection(((AbstractHyperBoxQuery)query).us);
        return this.create(ir1, ir2, ((AbstractHyperBoxQuery)query).direction != null ? ((AbstractHyperBoxQuery)query).direction : this.direction);
    }

    public HyperDirection getDirection() {
        if (this.direction == null) {
            return new HyperDirection(0, true);
        }
        return this.direction;
    }

    public Q starting(HyperDirection newDirection) {
        return this.create(this.ls, this.us, newDirection);
    }

    public static interface QueryFactory<NS extends HyperBox<?, NS>, Q extends AbstractHyperBoxQuery<?, ?, NS, Q>> {
        public Q create(NS var1, NS var2, HyperDirection var3);
    }
}

