/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldCacheAcceleratorDof
implements StructConverter {
    private long sectionAddress;
    private int sectionSize;
    private int imageIndex;

    public DyldCacheAcceleratorDof(BinaryReader reader) throws IOException {
        this.sectionAddress = reader.readNextLong();
        this.sectionSize = reader.readNextInt();
        this.imageIndex = reader.readNextInt();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_accelerator_dof", 0);
        struct.add(QWORD, "sectionAddress", "");
        struct.add(DWORD, "sectionSize", "");
        struct.add(DWORD, "imageIndex", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

