/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.mcpserver;

import com.sun.net.httpserver.Headers;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;

class ModelContextProtocolAuthValidator {
    private static final int UNAUTHORIZED_ERROR_CODE = -32001;
    private static final String UNAUTHORIZED_MESSAGE = "Unauthorized";
    private static final String GENERATED_MCP_TOKEN_MESSAGE = "ai_mcp_token_generated_message";
    private final ResourceController resourceController;
    private final String apiKeyPropertyName;
    private final String apiKeyHeaderName;
    private final Supplier<String> apiKeyGenerator;
    private final Consumer<String> apiKeyNotifier;

    ModelContextProtocolAuthValidator(ResourceController resourceController, String apiKeyPropertyName, String apiKeyHeaderName) {
        this(resourceController, apiKeyPropertyName, apiKeyHeaderName, () -> UUID.randomUUID().toString(), apiKey -> SwingUtilities.invokeLater(() -> UITools.showMessage((String)TextUtils.format((String)GENERATED_MCP_TOKEN_MESSAGE, (Object[])new Object[]{apiKey}), (int)1)));
    }

    ModelContextProtocolAuthValidator(ResourceController resourceController, String apiKeyPropertyName, String apiKeyHeaderName, Supplier<String> apiKeyGenerator, Consumer<String> apiKeyNotifier) {
        this.resourceController = resourceController;
        this.apiKeyPropertyName = apiKeyPropertyName;
        this.apiKeyHeaderName = apiKeyHeaderName;
        this.apiKeyGenerator = apiKeyGenerator;
        this.apiKeyNotifier = apiKeyNotifier;
    }

    Object validateRequest(Headers requestHeaders) {
        String configuredApiKey = this.trimToEmpty(this.resourceController.getProperty(this.apiKeyPropertyName, ""));
        if (configuredApiKey.isEmpty()) {
            String generatedApiKey = this.generateApiKey();
            this.resourceController.setProperty(this.apiKeyPropertyName, generatedApiKey);
            this.apiKeyNotifier.accept(generatedApiKey);
            return this.buildUnauthorizedResponse();
        }
        String providedApiKey = this.trimToEmpty(requestHeaders == null ? null : requestHeaders.getFirst(this.apiKeyHeaderName));
        if (!configuredApiKey.equals(providedApiKey)) {
            return this.buildUnauthorizedResponse();
        }
        return null;
    }

    private String generateApiKey() {
        String generatedApiKey = this.trimToEmpty(this.apiKeyGenerator.get());
        if (!generatedApiKey.isEmpty()) {
            return generatedApiKey;
        }
        return UUID.randomUUID().toString();
    }

    private String trimToEmpty(String value) {
        return value == null ? "" : value.trim();
    }

    private Object buildUnauthorizedResponse() {
        LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>();
        error.put("code", -32001);
        error.put("message", UNAUTHORIZED_MESSAGE);
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("jsonrpc", "2.0");
        response.put("id", null);
        response.put("error", error);
        return response;
    }
}

