﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/workspaces/WorkSpacesRequest.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>
#include <aws/workspaces/model/BundleAssociatedResourceType.h>

#include <utility>

namespace Aws {
namespace WorkSpaces {
namespace Model {

/**
 */
class DescribeBundleAssociationsRequest : public WorkSpacesRequest {
 public:
  AWS_WORKSPACES_API DescribeBundleAssociationsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeBundleAssociations"; }

  AWS_WORKSPACES_API Aws::String SerializePayload() const override;

  AWS_WORKSPACES_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The identifier of the bundle.</p>
   */
  inline const Aws::String& GetBundleId() const { return m_bundleId; }
  inline bool BundleIdHasBeenSet() const { return m_bundleIdHasBeenSet; }
  template <typename BundleIdT = Aws::String>
  void SetBundleId(BundleIdT&& value) {
    m_bundleIdHasBeenSet = true;
    m_bundleId = std::forward<BundleIdT>(value);
  }
  template <typename BundleIdT = Aws::String>
  DescribeBundleAssociationsRequest& WithBundleId(BundleIdT&& value) {
    SetBundleId(std::forward<BundleIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource types of the associated resource.</p>
   */
  inline const Aws::Vector<BundleAssociatedResourceType>& GetAssociatedResourceTypes() const { return m_associatedResourceTypes; }
  inline bool AssociatedResourceTypesHasBeenSet() const { return m_associatedResourceTypesHasBeenSet; }
  template <typename AssociatedResourceTypesT = Aws::Vector<BundleAssociatedResourceType>>
  void SetAssociatedResourceTypes(AssociatedResourceTypesT&& value) {
    m_associatedResourceTypesHasBeenSet = true;
    m_associatedResourceTypes = std::forward<AssociatedResourceTypesT>(value);
  }
  template <typename AssociatedResourceTypesT = Aws::Vector<BundleAssociatedResourceType>>
  DescribeBundleAssociationsRequest& WithAssociatedResourceTypes(AssociatedResourceTypesT&& value) {
    SetAssociatedResourceTypes(std::forward<AssociatedResourceTypesT>(value));
    return *this;
  }
  inline DescribeBundleAssociationsRequest& AddAssociatedResourceTypes(BundleAssociatedResourceType value) {
    m_associatedResourceTypesHasBeenSet = true;
    m_associatedResourceTypes.push_back(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_bundleId;

  Aws::Vector<BundleAssociatedResourceType> m_associatedResourceTypes;
  bool m_bundleIdHasBeenSet = false;
  bool m_associatedResourceTypesHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
