/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "EventTargetInlines.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "JSEventTarget.h"
#include "WebAnimation.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class WEBCORE_EXPORT JSWebAnimation : public JSEventTarget {
public:
    using Base = JSEventTarget;
    using DOMWrapped = WebAnimation;
    static JSWebAnimation* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<WebAnimation>&& impl)
    {
        SUPPRESS_UNCOUNTED_LOCAL auto& vm = globalObject->vm();
        JSWebAnimation* ptr = new (NotNull, JSC::allocateCell<JSWebAnimation>(vm)) JSWebAnimation(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(vm);
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static WebAnimation* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info(), JSC::NonArray);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    WebAnimation& wrapped() const
    {
        return static_cast<WebAnimation&>(Base::wrapped());
    }

    Ref<WebAnimation> protectedWrapped() const;

protected:
    JSWebAnimation(JSC::Structure*, JSDOMGlobalObject&, Ref<WebAnimation>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};

class WEBCORE_EXPORT JSWebAnimationOwner final : public JSC::WeakHandleOwner {
public:
    bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::AbstractSlotVisitor&, ASCIILiteral*) final;
    void finalize(JSC::Handle<JSC::Unknown>, void* context) final;
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, WebAnimation*)
{
    static NeverDestroyed<JSWebAnimationOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(WebAnimation* wrappableObject)
{
    return wrappableObject;
}

WEBCORE_EXPORT JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, WebAnimation&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebAnimation* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<WebAnimation>&&);
ALWAYS_INLINE JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebAnimation& impl) { return toJSNewlyCreated(lexicalGlobalObject, globalObject, Ref { impl }); }
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<WebAnimation>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

// Custom constructor
JSC::EncodedJSValue constructJSWebAnimation(JSC::JSGlobalObject*, JSC::CallFrame&);

template<> struct JSDOMWrapperConverterTraits<WebAnimation> {
    using WrapperClass = JSWebAnimation;
    using ToWrappedReturnType = WebAnimation*;
};
String convertEnumerationToString(WebAnimation::PlayState);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, WebAnimation::PlayState);

template<> std::optional<WebAnimation::PlayState> parseEnumerationFromString<WebAnimation::PlayState>(const String&);
template<> std::optional<WebAnimation::PlayState> parseEnumeration<WebAnimation::PlayState>(JSC::JSGlobalObject&, JSC::JSValue);
template<> ASCIILiteral expectedEnumerationValues<WebAnimation::PlayState>();

String convertEnumerationToString(WebAnimation::ReplaceState);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, WebAnimation::ReplaceState);

template<> std::optional<WebAnimation::ReplaceState> parseEnumerationFromString<WebAnimation::ReplaceState>(const String&);
template<> std::optional<WebAnimation::ReplaceState> parseEnumeration<WebAnimation::ReplaceState>(JSC::JSGlobalObject&, JSC::JSValue);
template<> ASCIILiteral expectedEnumerationValues<WebAnimation::ReplaceState>();


} // namespace WebCore
