/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTClipControl.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsEXTClipControlPrototypeFunction_clipControlEXT);

class JSEXTClipControlPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTClipControlPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTClipControlPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTClipControlPrototype>(vm)) JSEXTClipControlPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTClipControlPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTClipControlPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTClipControlPrototype, JSEXTClipControlPrototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 7> JSEXTClipControlPrototypeTableValues {
    HashTableValue { "clipControlEXT"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsEXTClipControlPrototypeFunction_clipControlEXT, 2 } },
    HashTableValue { "LOWER_LEFT_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CA1 } },
    HashTableValue { "UPPER_LEFT_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8CA2 } },
    HashTableValue { "NEGATIVE_ONE_TO_ONE_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x935E } },
    HashTableValue { "ZERO_TO_ONE_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x935F } },
    HashTableValue { "CLIP_ORIGIN_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x935C } },
    HashTableValue { "CLIP_DEPTH_MODE_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x935D } },
};

const ClassInfo JSEXTClipControlPrototype::s_info = { "EXTClipControl"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTClipControlPrototype) };

void JSEXTClipControlPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTClipControl::info(), JSEXTClipControlPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTClipControl::s_info = { "EXTClipControl"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTClipControl) };

JSEXTClipControl::JSEXTClipControl(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTClipControl>&& impl)
    : JSDOMWrapper<EXTClipControl>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTClipControl>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTClipControl::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTClipControlPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTClipControlPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTClipControl::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTClipControl>(vm, globalObject);
}

void JSEXTClipControl::destroy(JSC::JSCell* cell)
{
    JSEXTClipControl* thisObject = static_cast<JSEXTClipControl*>(cell);
    thisObject->JSEXTClipControl::~JSEXTClipControl();
}

static inline JSC::EncodedJSValue jsEXTClipControlPrototypeFunction_clipControlEXTBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSEXTClipControl>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto originConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (originConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto depthConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (depthConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clipControlEXT(originConversionResult.releaseReturnValue(), depthConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsEXTClipControlPrototypeFunction_clipControlEXT, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSEXTClipControl>::call<jsEXTClipControlPrototypeFunction_clipControlEXTBody>(*lexicalGlobalObject, *callFrame, "clipControlEXT");
}

JSC::GCClient::IsoSubspace* JSEXTClipControl::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTClipControl, UseCustomHeapCellType::No>(vm, "JSEXTClipControl"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTClipControl.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTClipControl = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTClipControl.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTClipControl = std::forward<decltype(space)>(space); }
    );
}

void JSEXTClipControl::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTClipControl*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTClipControlOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTClipControl = jsCast<JSEXTClipControl*>(handle.slot()->asCell());
    auto& owner = jsEXTClipControl->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsEXTClipControl"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTClipControlOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTClipControl = static_cast<JSEXTClipControl*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTClipControl->protectedWrapped().ptr(), jsEXTClipControl);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTClipControl@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14EXTClipControlE[]; }
#endif
template<std::same_as<EXTClipControl> T>
static inline void verifyVTable(EXTClipControl* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTClipControl@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14EXTClipControlE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTClipControl has subclasses. If EXTClipControl has subclasses that get passed
        // to toJS() we currently require EXTClipControl you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTClipControl>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTClipControl>(impl.ptr());
#endif
    return createWrapper<EXTClipControl>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTClipControl& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTClipControl* JSEXTClipControl::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTClipControl*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
