/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHistory.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSerializedScriptValue.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "SerializedScriptValue.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

String convertEnumerationToString(History::ScrollRestoration enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("auto"),
        MAKE_STATIC_STRING_IMPL("manual"),
    };
    static_assert(static_cast<size_t>(History::ScrollRestoration::Auto) == 0, "History::ScrollRestoration::Auto is not 0 as expected");
    static_assert(static_cast<size_t>(History::ScrollRestoration::Manual) == 1, "History::ScrollRestoration::Manual is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, History::ScrollRestoration enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<History::ScrollRestoration> parseEnumerationFromString<History::ScrollRestoration>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, History::ScrollRestoration>, 2> mappings {
        std::pair<ComparableASCIILiteral, History::ScrollRestoration> { "auto"_s, History::ScrollRestoration::Auto },
        std::pair<ComparableASCIILiteral, History::ScrollRestoration> { "manual"_s, History::ScrollRestoration::Manual },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<History::ScrollRestoration> parseEnumeration<History::ScrollRestoration>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<History::ScrollRestoration>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<History::ScrollRestoration>()
{
    return "\"auto\", \"manual\""_s;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsHistoryPrototypeFunction_back);
static JSC_DECLARE_HOST_FUNCTION(jsHistoryPrototypeFunction_forward);
static JSC_DECLARE_HOST_FUNCTION(jsHistoryPrototypeFunction_go);
static JSC_DECLARE_HOST_FUNCTION(jsHistoryPrototypeFunction_pushState);
static JSC_DECLARE_HOST_FUNCTION(jsHistoryPrototypeFunction_replaceState);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsHistoryConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsHistory_length);
static JSC_DECLARE_CUSTOM_GETTER(jsHistory_scrollRestoration);
static JSC_DECLARE_CUSTOM_SETTER(setJSHistory_scrollRestoration);
static JSC_DECLARE_CUSTOM_GETTER(jsHistory_state);

class JSHistoryPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHistoryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHistoryPrototype* ptr = new (NotNull, JSC::allocateCell<JSHistoryPrototype>(vm)) JSHistoryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHistoryPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHistoryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHistoryPrototype, JSHistoryPrototype::Base);

using JSHistoryDOMConstructor = JSDOMConstructorNotConstructable<JSHistory>;

template<> const ClassInfo JSHistoryDOMConstructor::s_info = { "History"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHistoryDOMConstructor) };

template<> JSValue JSHistoryDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSHistoryDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "History"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSHistory::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 9> JSHistoryPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsHistoryConstructor, 0 } },
    HashTableValue { "length"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHistory_length, 0 } },
    HashTableValue { "scrollRestoration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHistory_scrollRestoration, setJSHistory_scrollRestoration } },
    HashTableValue { "state"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHistory_state, 0 } },
    HashTableValue { "back"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHistoryPrototypeFunction_back, 0 } },
    HashTableValue { "forward"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHistoryPrototypeFunction_forward, 0 } },
    HashTableValue { "go"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHistoryPrototypeFunction_go, 0 } },
    HashTableValue { "pushState"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHistoryPrototypeFunction_pushState, 2 } },
    HashTableValue { "replaceState"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHistoryPrototypeFunction_replaceState, 2 } },
};

const ClassInfo JSHistoryPrototype::s_info = { "History"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHistoryPrototype) };

void JSHistoryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHistory::info(), JSHistoryPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSHistory::s_info = { "History"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHistory) };

JSHistory::JSHistory(Structure* structure, JSDOMGlobalObject& globalObject, Ref<History>&& impl)
    : JSDOMWrapper<History>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, History>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSHistory::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSHistoryPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSHistoryPrototype::create(vm, &globalObject, structure);
}

JSObject* JSHistory::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHistory>(vm, globalObject);
}

JSValue JSHistory::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHistoryDOMConstructor, DOMConstructorID::History>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSHistory::destroy(JSC::JSCell* cell)
{
    JSHistory* thisObject = static_cast<JSHistory*>(cell);
    thisObject->JSHistory::~JSHistory();
}

JSC_DEFINE_CUSTOM_GETTER(jsHistoryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHistoryPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHistory::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsHistory_lengthGetter(JSGlobalObject& lexicalGlobalObject, JSHistory& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.length())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHistory_length, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHistory>::get<jsHistory_lengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHistory_scrollRestorationGetter(JSGlobalObject& lexicalGlobalObject, JSHistory& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<History::ScrollRestoration>>(lexicalGlobalObject, throwScope, impl.scrollRestoration())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHistory_scrollRestoration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHistory>::get<jsHistory_scrollRestorationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHistory_scrollRestorationSetter(JSGlobalObject& lexicalGlobalObject, JSHistory& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<History::ScrollRestoration>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (!optionalNativeValue) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setScrollRestoration(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHistory_scrollRestoration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHistory>::set<setJSHistory_scrollRestorationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHistory_stateGetter(JSGlobalObject& lexicalGlobalObject, JSHistory& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.state(lexicalGlobalObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsHistory_state, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHistory>::get<jsHistory_stateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsHistoryPrototypeFunction_backBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHistory>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RefPtr context = (*castedThis).globalObject()->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.back(document.get()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHistoryPrototypeFunction_back, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHistory>::call<jsHistoryPrototypeFunction_backBody>(*lexicalGlobalObject, *callFrame, "back");
}

static inline JSC::EncodedJSValue jsHistoryPrototypeFunction_forwardBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHistory>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RefPtr context = (*castedThis).globalObject()->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.forward(document.get()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHistoryPrototypeFunction_forward, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHistory>::call<jsHistoryPrototypeFunction_forwardBody>(*lexicalGlobalObject, *callFrame, "forward");
}

static inline JSC::EncodedJSValue jsHistoryPrototypeFunction_goBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHistory>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RefPtr context = (*castedThis).globalObject()->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto deltaConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument0.value());
    if (deltaConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.go(document.get(), deltaConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHistoryPrototypeFunction_go, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHistory>::call<jsHistoryPrototypeFunction_goBody>(*lexicalGlobalObject, *callFrame, "go");
}

static inline JSC::EncodedJSValue jsHistoryPrototypeFunction_pushStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHistory>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dataConversionResult = convert<IDLSerializedScriptValue<SerializedScriptValue>>(*lexicalGlobalObject, argument0.value());
    if (dataConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto unusedConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    if (unusedConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto urlConversionResult = convertOptionalWithDefault<IDLNullable<IDLUSVString>>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLNullable<IDLUSVString>> { return typename Converter<IDLNullable<IDLUSVString>>::ReturnType { String() }; });
    if (urlConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.pushState(dataConversionResult.releaseReturnValue(), unusedConversionResult.releaseReturnValue(), urlConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHistoryPrototypeFunction_pushState, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHistory>::call<jsHistoryPrototypeFunction_pushStateBody>(*lexicalGlobalObject, *callFrame, "pushState");
}

static inline JSC::EncodedJSValue jsHistoryPrototypeFunction_replaceStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHistory>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dataConversionResult = convert<IDLSerializedScriptValue<SerializedScriptValue>>(*lexicalGlobalObject, argument0.value());
    if (dataConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto unusedConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    if (unusedConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto urlConversionResult = convertOptionalWithDefault<IDLNullable<IDLUSVString>>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLNullable<IDLUSVString>> { return typename Converter<IDLNullable<IDLUSVString>>::ReturnType { String() }; });
    if (urlConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.replaceState(dataConversionResult.releaseReturnValue(), unusedConversionResult.releaseReturnValue(), urlConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHistoryPrototypeFunction_replaceState, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHistory>::call<jsHistoryPrototypeFunction_replaceStateBody>(*lexicalGlobalObject, *callFrame, "replaceState");
}

JSC::GCClient::IsoSubspace* JSHistory::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSHistory, UseCustomHeapCellType::No>(vm, "JSHistory"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForHistory.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForHistory = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForHistory.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForHistory = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSHistory::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSHistory*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSHistory);

template<typename Visitor>
void JSHistory::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSHistory*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSHistory::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSHistory::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSHistory::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHistory*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSHistoryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsHistory = jsCast<JSHistory*>(handle.slot()->asCell());
    auto* owner = WTF::getPtr(jsHistory->wrapped().window());
    if (!owner)
        return false;
    if (reason) [[unlikely]]
        *reason = "Reachable from Window"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSHistoryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHistory = static_cast<JSHistory*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsHistory->protectedWrapped().ptr(), jsHistory);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7History@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore7HistoryE[]; }
#endif
template<std::same_as<History> T>
static inline void verifyVTable(History* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7History@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore7HistoryE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // History has subclasses. If History has subclasses that get passed
        // to toJS() we currently require History you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<History>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<History>(impl.ptr());
#endif
    return createWrapper<History>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, History& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

History* JSHistory::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHistory*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
