/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUVertexBufferLayout.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSGPUVertexAttribute.h"
#include "JSGPUVertexStepMode.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUVertexBufferLayout>> convertDictionary<GPUVertexBufferLayout>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUVertexBufferLayout result;
    JSValue arrayStrideValue;
    if (isNullOrUndefined)
        arrayStrideValue = jsUndefined();
    else {
        arrayStrideValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "arrayStride"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (arrayStrideValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "arrayStride"_s, "GPUVertexBufferLayout"_s, "unsigned long long"_s);
        return ConversionResultException { };
    }
    auto arrayStrideConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, arrayStrideValue);
    if (arrayStrideConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.arrayStride = arrayStrideConversionResult.releaseReturnValue();
    JSValue attributesValue;
    if (isNullOrUndefined)
        attributesValue = jsUndefined();
    else {
        attributesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attributes"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (attributesValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "attributes"_s, "GPUVertexBufferLayout"_s, "sequence"_s);
        return ConversionResultException { };
    }
    auto attributesConversionResult = convert<IDLSequence<IDLDictionary<GPUVertexAttribute>>>(lexicalGlobalObject, attributesValue);
    if (attributesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.attributes = attributesConversionResult.releaseReturnValue();
    JSValue stepModeValue;
    if (isNullOrUndefined)
        stepModeValue = jsUndefined();
    else {
        stepModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stepMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto stepModeConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUVertexStepMode>>(lexicalGlobalObject, stepModeValue, [&]() -> ConversionResult<IDLEnumeration<GPUVertexStepMode>> { return Converter<IDLEnumeration<GPUVertexStepMode>>::ReturnType { GPUVertexStepMode::Vertex }; });
    if (stepModeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.stepMode = stepModeConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

