/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderPassDescriptor.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUQuerySet.h"
#include "JSGPURenderPassColorAttachment.h"
#include "JSGPURenderPassDepthStencilAttachment.h"
#include "JSGPURenderPassTimestampWrites.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPURenderPassDescriptor>> convertDictionary<GPURenderPassDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPURenderPassDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        if (labelConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue colorAttachmentsValue;
    if (isNullOrUndefined)
        colorAttachmentsValue = jsUndefined();
    else {
        colorAttachmentsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorAttachments"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (colorAttachmentsValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "colorAttachments"_s, "GPURenderPassDescriptor"_s, "sequence"_s);
        return ConversionResultException { };
    }
    auto colorAttachmentsConversionResult = convert<IDLSequence<IDLNullable<IDLDictionary<GPURenderPassColorAttachment>>>>(lexicalGlobalObject, colorAttachmentsValue);
    if (colorAttachmentsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.colorAttachments = colorAttachmentsConversionResult.releaseReturnValue();
    JSValue depthStencilAttachmentValue;
    if (isNullOrUndefined)
        depthStencilAttachmentValue = jsUndefined();
    else {
        depthStencilAttachmentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthStencilAttachment"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!depthStencilAttachmentValue.isUndefined()) {
        auto depthStencilAttachmentConversionResult = convert<IDLDictionary<GPURenderPassDepthStencilAttachment>>(lexicalGlobalObject, depthStencilAttachmentValue);
        if (depthStencilAttachmentConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.depthStencilAttachment = depthStencilAttachmentConversionResult.releaseReturnValue();
    }
    JSValue maxDrawCountValue;
    if (isNullOrUndefined)
        maxDrawCountValue = jsUndefined();
    else {
        maxDrawCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxDrawCount"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto maxDrawCountConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, maxDrawCountValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType { 50000000 }; });
    if (maxDrawCountConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.maxDrawCount = maxDrawCountConversionResult.releaseReturnValue();
    JSValue occlusionQuerySetValue;
    if (isNullOrUndefined)
        occlusionQuerySetValue = jsUndefined();
    else {
        occlusionQuerySetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "occlusionQuerySet"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!occlusionQuerySetValue.isUndefined()) {
        auto occlusionQuerySetConversionResult = convert<IDLInterface<GPUQuerySet>>(lexicalGlobalObject, occlusionQuerySetValue);
        if (occlusionQuerySetConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.occlusionQuerySet = occlusionQuerySetConversionResult.releaseReturnValue();
    }
    JSValue timestampWritesValue;
    if (isNullOrUndefined)
        timestampWritesValue = jsUndefined();
    else {
        timestampWritesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestampWrites"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!timestampWritesValue.isUndefined()) {
        auto timestampWritesConversionResult = convert<IDLDictionary<GPURenderPassTimestampWrites>>(lexicalGlobalObject, timestampWritesValue);
        if (timestampWritesConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.timestampWrites = timestampWritesConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore

