/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTRenderSnorm.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

class JSEXTRenderSnormPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTRenderSnormPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTRenderSnormPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTRenderSnormPrototype>(vm)) JSEXTRenderSnormPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTRenderSnormPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTRenderSnormPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTRenderSnormPrototype, JSEXTRenderSnormPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSEXTRenderSnormPrototype::s_info = { "EXTRenderSnorm"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTRenderSnormPrototype) };

void JSEXTRenderSnormPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTRenderSnorm::s_info = { "EXTRenderSnorm"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTRenderSnorm) };

JSEXTRenderSnorm::JSEXTRenderSnorm(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTRenderSnorm>&& impl)
    : JSDOMWrapper<EXTRenderSnorm>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTRenderSnorm>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTRenderSnorm::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTRenderSnormPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTRenderSnormPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTRenderSnorm::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTRenderSnorm>(vm, globalObject);
}

void JSEXTRenderSnorm::destroy(JSC::JSCell* cell)
{
    JSEXTRenderSnorm* thisObject = static_cast<JSEXTRenderSnorm*>(cell);
    thisObject->JSEXTRenderSnorm::~JSEXTRenderSnorm();
}

JSC::GCClient::IsoSubspace* JSEXTRenderSnorm::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTRenderSnorm, UseCustomHeapCellType::No>(vm, "JSEXTRenderSnorm"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTRenderSnorm.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTRenderSnorm = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTRenderSnorm.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTRenderSnorm = std::forward<decltype(space)>(space); }
    );
}

void JSEXTRenderSnorm::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTRenderSnorm*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTRenderSnormOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTRenderSnorm = jsCast<JSEXTRenderSnorm*>(handle.slot()->asCell());
    auto& owner = jsEXTRenderSnorm->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsEXTRenderSnorm"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTRenderSnormOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTRenderSnorm = static_cast<JSEXTRenderSnorm*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTRenderSnorm->protectedWrapped().ptr(), jsEXTRenderSnorm);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTRenderSnorm@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14EXTRenderSnormE[]; }
#endif
template<std::same_as<EXTRenderSnorm> T>
static inline void verifyVTable(EXTRenderSnorm* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTRenderSnorm@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14EXTRenderSnormE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTRenderSnorm has subclasses. If EXTRenderSnorm has subclasses that get passed
        // to toJS() we currently require EXTRenderSnorm you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTRenderSnorm>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTRenderSnorm>(impl.ptr());
#endif
    return createWrapper<EXTRenderSnorm>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTRenderSnorm& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTRenderSnorm* JSEXTRenderSnorm::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTRenderSnorm*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
