/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCustomElementRegistry.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "CustomElementReactionQueue.h"
#include "DocumentInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCustomElementRegistryPrototypeFunction_define);
static JSC_DECLARE_HOST_FUNCTION(jsCustomElementRegistryPrototypeFunction_get);
static JSC_DECLARE_HOST_FUNCTION(jsCustomElementRegistryPrototypeFunction_getName);
static JSC_DECLARE_HOST_FUNCTION(jsCustomElementRegistryPrototypeFunction_whenDefined);
static JSC_DECLARE_HOST_FUNCTION(jsCustomElementRegistryPrototypeFunction_upgrade);
static JSC_DECLARE_HOST_FUNCTION(jsCustomElementRegistryPrototypeFunction_initialize);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCustomElementRegistryConstructor);

class JSCustomElementRegistryPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCustomElementRegistryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCustomElementRegistryPrototype* ptr = new (NotNull, JSC::allocateCell<JSCustomElementRegistryPrototype>(vm)) JSCustomElementRegistryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCustomElementRegistryPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCustomElementRegistryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCustomElementRegistryPrototype, JSCustomElementRegistryPrototype::Base);

using JSCustomElementRegistryDOMConstructor = JSDOMConstructor<JSCustomElementRegistry>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCustomElementRegistryDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCustomElementRegistryDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())->settingsValues().scopedCustomElementRegistryEnabled) {
        throwTypeError(lexicalGlobalObject, throwScope, "Illegal constructor"_s);
        return JSValue::encode(jsNull());
    }
    auto* context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "CustomElementRegistry"_s);
    auto object = CustomElementRegistry::create(*context);
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CustomElementRegistry>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CustomElementRegistry>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCustomElementRegistryDOMConstructorConstruct, JSCustomElementRegistryDOMConstructor::construct);

template<> const ClassInfo JSCustomElementRegistryDOMConstructor::s_info = { "CustomElementRegistry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCustomElementRegistryDOMConstructor) };

template<> JSValue JSCustomElementRegistryDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCustomElementRegistryDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CustomElementRegistry"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCustomElementRegistry::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 7> JSCustomElementRegistryPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCustomElementRegistryConstructor, 0 } },
    HashTableValue { "define"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCustomElementRegistryPrototypeFunction_define, 2 } },
    HashTableValue { "get"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCustomElementRegistryPrototypeFunction_get, 1 } },
    HashTableValue { "getName"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCustomElementRegistryPrototypeFunction_getName, 1 } },
    HashTableValue { "whenDefined"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCustomElementRegistryPrototypeFunction_whenDefined, 1 } },
    HashTableValue { "upgrade"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCustomElementRegistryPrototypeFunction_upgrade, 1 } },
    HashTableValue { "initialize"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCustomElementRegistryPrototypeFunction_initialize, 1 } },
};

const ClassInfo JSCustomElementRegistryPrototype::s_info = { "CustomElementRegistry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCustomElementRegistryPrototype) };

void JSCustomElementRegistryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCustomElementRegistry::info(), JSCustomElementRegistryPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCustomElementRegistry::s_info = { "CustomElementRegistry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCustomElementRegistry) };

JSCustomElementRegistry::JSCustomElementRegistry(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CustomElementRegistry>&& impl)
    : JSDOMWrapper<CustomElementRegistry>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CustomElementRegistry>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCustomElementRegistry::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCustomElementRegistryPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSCustomElementRegistryPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCustomElementRegistry::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCustomElementRegistry>(vm, globalObject);
}

JSValue JSCustomElementRegistry::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCustomElementRegistryDOMConstructor, DOMConstructorID::CustomElementRegistry>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCustomElementRegistry::destroy(JSC::JSCell* cell)
{
    JSCustomElementRegistry* thisObject = static_cast<JSCustomElementRegistry*>(cell);
    thisObject->JSCustomElementRegistry::~JSCustomElementRegistry();
}

JSC_DEFINE_CUSTOM_GETTER(jsCustomElementRegistryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCustomElementRegistryPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCustomElementRegistry::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsCustomElementRegistryPrototypeFunction_defineBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCustomElementRegistry>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    RELEASE_AND_RETURN(throwScope, (JSValue::encode(castedThis->define(*lexicalGlobalObject, *callFrame))));
}

JSC_DEFINE_HOST_FUNCTION(jsCustomElementRegistryPrototypeFunction_define, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCustomElementRegistry>::call<jsCustomElementRegistryPrototypeFunction_defineBody>(*lexicalGlobalObject, *callFrame, "define");
}

static inline JSC::EncodedJSValue jsCustomElementRegistryPrototypeFunction_getBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCustomElementRegistry>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nameConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (nameConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLAny>(*lexicalGlobalObject, throwScope, impl.get(nameConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsCustomElementRegistryPrototypeFunction_get, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCustomElementRegistry>::call<jsCustomElementRegistryPrototypeFunction_getBody>(*lexicalGlobalObject, *callFrame, "get");
}

static inline JSC::EncodedJSValue jsCustomElementRegistryPrototypeFunction_getNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCustomElementRegistry>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto constructorConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (constructorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, throwScope, impl.getName(constructorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsCustomElementRegistryPrototypeFunction_getName, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCustomElementRegistry>::call<jsCustomElementRegistryPrototypeFunction_getNameBody>(*lexicalGlobalObject, *callFrame, "getName");
}

static inline JSC::EncodedJSValue jsCustomElementRegistryPrototypeFunction_whenDefinedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSCustomElementRegistry>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    RELEASE_AND_RETURN(throwScope, (JSValue::encode(castedThis->whenDefined(*lexicalGlobalObject, *callFrame))));
}

JSC_DEFINE_HOST_FUNCTION(jsCustomElementRegistryPrototypeFunction_whenDefined, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSCustomElementRegistry>::callReturningOwnPromise<jsCustomElementRegistryPrototypeFunction_whenDefinedBody>(*lexicalGlobalObject, *callFrame, "whenDefined");
}

static inline JSC::EncodedJSValue jsCustomElementRegistryPrototypeFunction_upgradeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCustomElementRegistry>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto rootConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "root"_s, "CustomElementRegistry"_s, "upgrade"_s, "Node"_s); });
    if (rootConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.upgrade(*rootConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCustomElementRegistryPrototypeFunction_upgrade, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCustomElementRegistry>::call<jsCustomElementRegistryPrototypeFunction_upgradeBody>(*lexicalGlobalObject, *callFrame, "upgrade");
}

static inline JSC::EncodedJSValue jsCustomElementRegistryPrototypeFunction_initializeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCustomElementRegistry>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto rootConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "root"_s, "CustomElementRegistry"_s, "initialize"_s, "Node"_s); });
    if (rootConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.initialize(*rootConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCustomElementRegistryPrototypeFunction_initialize, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCustomElementRegistry>::call<jsCustomElementRegistryPrototypeFunction_initializeBody>(*lexicalGlobalObject, *callFrame, "initialize");
}

JSC::GCClient::IsoSubspace* JSCustomElementRegistry::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCustomElementRegistry, UseCustomHeapCellType::No>(vm, "JSCustomElementRegistry"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCustomElementRegistry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCustomElementRegistry = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCustomElementRegistry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCustomElementRegistry = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSCustomElementRegistry::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSCustomElementRegistry*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSCustomElementRegistry);

template<typename Visitor>
void JSCustomElementRegistry::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSCustomElementRegistry*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSCustomElementRegistry::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSCustomElementRegistry::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSCustomElementRegistry::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCustomElementRegistry*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSCustomElementRegistryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsCustomElementRegistry = jsCast<JSCustomElementRegistry*>(handle.slot()->asCell());
    ScriptExecutionContext* owner = WTF::getPtr(jsCustomElementRegistry->wrapped().scriptExecutionContext());
    if (!owner)
        return false;
    if (reason) [[unlikely]]
        *reason = "Reachable from ScriptExecutionContext"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSCustomElementRegistryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCustomElementRegistry = static_cast<JSCustomElementRegistry*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCustomElementRegistry->protectedWrapped().ptr(), jsCustomElementRegistry);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CustomElementRegistry@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21CustomElementRegistryE[]; }
#endif
template<std::same_as<CustomElementRegistry> T>
static inline void verifyVTable(CustomElementRegistry* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CustomElementRegistry@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21CustomElementRegistryE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CustomElementRegistry has subclasses. If CustomElementRegistry has subclasses that get passed
        // to toJS() we currently require CustomElementRegistry you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CustomElementRegistry>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CustomElementRegistry>(impl.ptr());
#endif
    return createWrapper<CustomElementRegistry>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CustomElementRegistry& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CustomElementRegistry* JSCustomElementRegistry::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCustomElementRegistry*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
