/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#include "config.h"
#include "InspectorBackendDispatchers.h"

#include "InspectorFrontendRouter.h"
#include <wtf/NeverDestroyed.h>
#include <wtf/text/MakeString.h>

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
#include "InspectorAlternateBackendDispatchers.h"
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

namespace Inspector {

AnimationBackendDispatcherHandler::~AnimationBackendDispatcherHandler() { }
AuditBackendDispatcherHandler::~AuditBackendDispatcherHandler() { }
BrowserBackendDispatcherHandler::~BrowserBackendDispatcherHandler() { }
#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
CPUProfilerBackendDispatcherHandler::~CPUProfilerBackendDispatcherHandler() { }
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
CSSBackendDispatcherHandler::~CSSBackendDispatcherHandler() { }
CanvasBackendDispatcherHandler::~CanvasBackendDispatcherHandler() { }
ConsoleBackendDispatcherHandler::~ConsoleBackendDispatcherHandler() { }
DOMBackendDispatcherHandler::~DOMBackendDispatcherHandler() { }
DOMDebuggerBackendDispatcherHandler::~DOMDebuggerBackendDispatcherHandler() { }
DOMStorageBackendDispatcherHandler::~DOMStorageBackendDispatcherHandler() { }
DebuggerBackendDispatcherHandler::~DebuggerBackendDispatcherHandler() { }
HeapBackendDispatcherHandler::~HeapBackendDispatcherHandler() { }
IndexedDBBackendDispatcherHandler::~IndexedDBBackendDispatcherHandler() { }
InspectorBackendDispatcherHandler::~InspectorBackendDispatcherHandler() { }
LayerTreeBackendDispatcherHandler::~LayerTreeBackendDispatcherHandler() { }
#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
MemoryBackendDispatcherHandler::~MemoryBackendDispatcherHandler() { }
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
NetworkBackendDispatcherHandler::~NetworkBackendDispatcherHandler() { }
PageBackendDispatcherHandler::~PageBackendDispatcherHandler() { }
RuntimeBackendDispatcherHandler::~RuntimeBackendDispatcherHandler() { }
ScriptProfilerBackendDispatcherHandler::~ScriptProfilerBackendDispatcherHandler() { }
ServiceWorkerBackendDispatcherHandler::~ServiceWorkerBackendDispatcherHandler() { }
TargetBackendDispatcherHandler::~TargetBackendDispatcherHandler() { }
TimelineBackendDispatcherHandler::~TimelineBackendDispatcherHandler() { }
WorkerBackendDispatcherHandler::~WorkerBackendDispatcherHandler() { }

Ref<AnimationBackendDispatcher> AnimationBackendDispatcher::create(BackendDispatcher& backendDispatcher, AnimationBackendDispatcherHandler* agent)
{
    return adoptRef(*new AnimationBackendDispatcher(backendDispatcher, agent));
}

AnimationBackendDispatcher::AnimationBackendDispatcher(BackendDispatcher& backendDispatcher, AnimationBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Animation"_s, this);
}

void AnimationBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<AnimationBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (AnimationBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "enable"_s, &AnimationBackendDispatcher::enable },
        { "disable"_s, &AnimationBackendDispatcher::disable },
        { "requestEffect"_s, &AnimationBackendDispatcher::requestEffect },
        { "requestEffectTarget"_s, &AnimationBackendDispatcher::requestEffectTarget },
        { "resolveAnimation"_s, &AnimationBackendDispatcher::resolveAnimation },
        { "startTracking"_s, &AnimationBackendDispatcher::startTracking },
        { "stopTracking"_s, &AnimationBackendDispatcher::stopTracking },
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Animation."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void AnimationBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AnimationBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AnimationBackendDispatcher::requestEffect(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_animationId = m_backendDispatcher->getString(protocol_parameters.get(), "animationId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Animation.requestEffect' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->requestEffect(protocol_requestId, in_animationId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->requestEffect(in_animationId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_opt_effect = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    if (!!out_opt_effect)
        protocol_jsonMessage->setObject("effect"_s, out_opt_effect.releaseNonNull());
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AnimationBackendDispatcher::requestEffectTarget(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_animationId = m_backendDispatcher->getString(protocol_parameters.get(), "animationId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Animation.requestEffectTarget' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->requestEffectTarget(protocol_requestId, in_animationId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->requestEffectTarget(in_animationId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_effectTarget = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("effectTarget"_s, WTFMove(out_effectTarget));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AnimationBackendDispatcher::resolveAnimation(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_animationId = m_backendDispatcher->getString(protocol_parameters.get(), "animationId"_s, true);
    auto in_opt_objectGroup = m_backendDispatcher->getString(protocol_parameters.get(), "objectGroup"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Animation.resolveAnimation' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->resolveAnimation(protocol_requestId, in_animationId, in_opt_objectGroup);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->resolveAnimation(in_animationId, in_opt_objectGroup);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_object = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("object"_s, WTFMove(out_object));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AnimationBackendDispatcher::startTracking(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->startTracking(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->startTracking();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AnimationBackendDispatcher::stopTracking(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->stopTracking(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->stopTracking();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<AuditBackendDispatcher> AuditBackendDispatcher::create(BackendDispatcher& backendDispatcher, AuditBackendDispatcherHandler* agent)
{
    return adoptRef(*new AuditBackendDispatcher(backendDispatcher, agent));
}

AuditBackendDispatcher::AuditBackendDispatcher(BackendDispatcher& backendDispatcher, AuditBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Audit"_s, this);
}

void AuditBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<AuditBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    if (protocol_method == "setup"_s) {
        setup(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "run"_s) {
        run(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "teardown"_s) {
        teardown(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }

    m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Audit."_s, protocol_method, "' was not found"_s));
}

void AuditBackendDispatcher::setup(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_contextId = m_backendDispatcher->getInteger(protocol_parameters.get(), "contextId"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Audit.setup' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setup(protocol_requestId, WTFMove(in_opt_contextId));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setup(WTFMove(in_opt_contextId));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AuditBackendDispatcher::run(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_test = m_backendDispatcher->getString(protocol_parameters.get(), "test"_s, true);
    auto in_opt_contextId = m_backendDispatcher->getInteger(protocol_parameters.get(), "contextId"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Audit.run' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->run(protocol_requestId, in_test, WTFMove(in_opt_contextId));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->run(in_test, WTFMove(in_opt_contextId));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_result, out_opt_wasThrown] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("result"_s, WTFMove(out_result));
    if (!!out_opt_wasThrown)
        protocol_jsonMessage->setBoolean("wasThrown"_s, *out_opt_wasThrown);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AuditBackendDispatcher::teardown(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->teardown(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->teardown();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<BrowserBackendDispatcher> BrowserBackendDispatcher::create(BackendDispatcher& backendDispatcher, BrowserBackendDispatcherHandler* agent)
{
    return adoptRef(*new BrowserBackendDispatcher(backendDispatcher, agent));
}

BrowserBackendDispatcher::BrowserBackendDispatcher(BackendDispatcher& backendDispatcher, BrowserBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Browser"_s, this);
}

void BrowserBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<BrowserBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    if (protocol_method == "enable"_s) {
        enable(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "disable"_s) {
        disable(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }

    m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Browser."_s, protocol_method, "' was not found"_s));
}

void BrowserBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void BrowserBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
Ref<CPUProfilerBackendDispatcher> CPUProfilerBackendDispatcher::create(BackendDispatcher& backendDispatcher, CPUProfilerBackendDispatcherHandler* agent)
{
    return adoptRef(*new CPUProfilerBackendDispatcher(backendDispatcher, agent));
}

CPUProfilerBackendDispatcher::CPUProfilerBackendDispatcher(BackendDispatcher& backendDispatcher, CPUProfilerBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("CPUProfiler"_s, this);
}

void CPUProfilerBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<CPUProfilerBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    if (protocol_method == "startTracking"_s) {
        startTracking(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "stopTracking"_s) {
        stopTracking(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }

    m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'CPUProfiler."_s, protocol_method, "' was not found"_s));
}

void CPUProfilerBackendDispatcher::startTracking(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->startTracking(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->startTracking();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CPUProfilerBackendDispatcher::stopTracking(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->stopTracking(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->stopTracking();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

Ref<CSSBackendDispatcher> CSSBackendDispatcher::create(BackendDispatcher& backendDispatcher, CSSBackendDispatcherHandler* agent)
{
    return adoptRef(*new CSSBackendDispatcher(backendDispatcher, agent));
}

CSSBackendDispatcher::CSSBackendDispatcher(BackendDispatcher& backendDispatcher, CSSBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("CSS"_s, this);
}

void CSSBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<CSSBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (CSSBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "enable"_s, &CSSBackendDispatcher::enable },
        { "disable"_s, &CSSBackendDispatcher::disable },
        { "getMatchedStylesForNode"_s, &CSSBackendDispatcher::getMatchedStylesForNode },
        { "getInlineStylesForNode"_s, &CSSBackendDispatcher::getInlineStylesForNode },
        { "getComputedStyleForNode"_s, &CSSBackendDispatcher::getComputedStyleForNode },
        { "getFontDataForNode"_s, &CSSBackendDispatcher::getFontDataForNode },
        { "getAllStyleSheets"_s, &CSSBackendDispatcher::getAllStyleSheets },
        { "getStyleSheet"_s, &CSSBackendDispatcher::getStyleSheet },
        { "getStyleSheetText"_s, &CSSBackendDispatcher::getStyleSheetText },
        { "setStyleSheetText"_s, &CSSBackendDispatcher::setStyleSheetText },
        { "setStyleText"_s, &CSSBackendDispatcher::setStyleText },
        { "setRuleSelector"_s, &CSSBackendDispatcher::setRuleSelector },
        { "setGroupingHeaderText"_s, &CSSBackendDispatcher::setGroupingHeaderText },
        { "createStyleSheet"_s, &CSSBackendDispatcher::createStyleSheet },
        { "addRule"_s, &CSSBackendDispatcher::addRule },
        { "getSupportedCSSProperties"_s, &CSSBackendDispatcher::getSupportedCSSProperties },
        { "getSupportedSystemFontFamilyNames"_s, &CSSBackendDispatcher::getSupportedSystemFontFamilyNames },
        { "forcePseudoState"_s, &CSSBackendDispatcher::forcePseudoState },
        { "setLayoutContextTypeChangedMode"_s, &CSSBackendDispatcher::setLayoutContextTypeChangedMode },
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'CSS."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void CSSBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::getMatchedStylesForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_opt_includePseudo = m_backendDispatcher->getBoolean(protocol_parameters.get(), "includePseudo"_s, false);
    auto in_opt_includeInherited = m_backendDispatcher->getBoolean(protocol_parameters.get(), "includeInherited"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.getMatchedStylesForNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getMatchedStylesForNode(protocol_requestId, *in_nodeId, WTFMove(in_opt_includePseudo), WTFMove(in_opt_includeInherited));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getMatchedStylesForNode(*in_nodeId, WTFMove(in_opt_includePseudo), WTFMove(in_opt_includeInherited));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_opt_matchedCSSRules, out_opt_pseudoElements, out_opt_inherited] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    if (!!out_opt_matchedCSSRules)
        protocol_jsonMessage->setArray("matchedCSSRules"_s, out_opt_matchedCSSRules.releaseNonNull());
    if (!!out_opt_pseudoElements)
        protocol_jsonMessage->setArray("pseudoElements"_s, out_opt_pseudoElements.releaseNonNull());
    if (!!out_opt_inherited)
        protocol_jsonMessage->setArray("inherited"_s, out_opt_inherited.releaseNonNull());
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::getInlineStylesForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.getInlineStylesForNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getInlineStylesForNode(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getInlineStylesForNode(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_opt_inlineStyle, out_opt_attributesStyle] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    if (!!out_opt_inlineStyle)
        protocol_jsonMessage->setObject("inlineStyle"_s, out_opt_inlineStyle.releaseNonNull());
    if (!!out_opt_attributesStyle)
        protocol_jsonMessage->setObject("attributesStyle"_s, out_opt_attributesStyle.releaseNonNull());
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::getComputedStyleForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.getComputedStyleForNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getComputedStyleForNode(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getComputedStyleForNode(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_computedStyle = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("computedStyle"_s, WTFMove(out_computedStyle));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::getFontDataForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.getFontDataForNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getFontDataForNode(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getFontDataForNode(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_primaryFont = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("primaryFont"_s, WTFMove(out_primaryFont));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::getAllStyleSheets(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getAllStyleSheets(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getAllStyleSheets();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_headers = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("headers"_s, WTFMove(out_headers));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::getStyleSheet(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_styleSheetId = m_backendDispatcher->getString(protocol_parameters.get(), "styleSheetId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.getStyleSheet' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getStyleSheet(protocol_requestId, in_styleSheetId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getStyleSheet(in_styleSheetId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_styleSheet = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("styleSheet"_s, WTFMove(out_styleSheet));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::getStyleSheetText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_styleSheetId = m_backendDispatcher->getString(protocol_parameters.get(), "styleSheetId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.getStyleSheetText' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getStyleSheetText(protocol_requestId, in_styleSheetId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getStyleSheetText(in_styleSheetId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_text = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("text"_s, out_text);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::setStyleSheetText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_styleSheetId = m_backendDispatcher->getString(protocol_parameters.get(), "styleSheetId"_s, true);
    auto in_text = m_backendDispatcher->getString(protocol_parameters.get(), "text"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.setStyleSheetText' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setStyleSheetText(protocol_requestId, in_styleSheetId, in_text);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setStyleSheetText(in_styleSheetId, in_text);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::setStyleText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_styleId = m_backendDispatcher->getObject(protocol_parameters.get(), "styleId"_s, true);
    auto in_text = m_backendDispatcher->getString(protocol_parameters.get(), "text"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.setStyleText' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setStyleText(protocol_requestId, in_styleId.releaseNonNull(), in_text);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setStyleText(in_styleId.releaseNonNull(), in_text);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_style = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("style"_s, WTFMove(out_style));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::setRuleSelector(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_ruleId = m_backendDispatcher->getObject(protocol_parameters.get(), "ruleId"_s, true);
    auto in_selector = m_backendDispatcher->getString(protocol_parameters.get(), "selector"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.setRuleSelector' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setRuleSelector(protocol_requestId, in_ruleId.releaseNonNull(), in_selector);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setRuleSelector(in_ruleId.releaseNonNull(), in_selector);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_rule = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("rule"_s, WTFMove(out_rule));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::setGroupingHeaderText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_ruleId = m_backendDispatcher->getObject(protocol_parameters.get(), "ruleId"_s, true);
    auto in_headerText = m_backendDispatcher->getString(protocol_parameters.get(), "headerText"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.setGroupingHeaderText' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setGroupingHeaderText(protocol_requestId, in_ruleId.releaseNonNull(), in_headerText);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setGroupingHeaderText(in_ruleId.releaseNonNull(), in_headerText);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_grouping = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("grouping"_s, WTFMove(out_grouping));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::createStyleSheet(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_frameId = m_backendDispatcher->getString(protocol_parameters.get(), "frameId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.createStyleSheet' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->createStyleSheet(protocol_requestId, in_frameId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->createStyleSheet(in_frameId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_styleSheetId = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("styleSheetId"_s, out_styleSheetId);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::addRule(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_styleSheetId = m_backendDispatcher->getString(protocol_parameters.get(), "styleSheetId"_s, true);
    auto in_selector = m_backendDispatcher->getString(protocol_parameters.get(), "selector"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.addRule' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->addRule(protocol_requestId, in_styleSheetId, in_selector);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->addRule(in_styleSheetId, in_selector);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_rule = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("rule"_s, WTFMove(out_rule));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::getSupportedCSSProperties(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getSupportedCSSProperties(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getSupportedCSSProperties();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_cssProperties = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("cssProperties"_s, WTFMove(out_cssProperties));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::getSupportedSystemFontFamilyNames(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getSupportedSystemFontFamilyNames(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getSupportedSystemFontFamilyNames();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_fontFamilyNames = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("fontFamilyNames"_s, WTFMove(out_fontFamilyNames));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::forcePseudoState(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_forcedPseudoClasses = m_backendDispatcher->getArray(protocol_parameters.get(), "forcedPseudoClasses"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.forcePseudoState' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->forcePseudoState(protocol_requestId, *in_nodeId, in_forcedPseudoClasses.releaseNonNull());
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->forcePseudoState(*in_nodeId, in_forcedPseudoClasses.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CSSBackendDispatcher::setLayoutContextTypeChangedMode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_mode_json = m_backendDispatcher->getString(protocol_parameters.get(), "mode"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'CSS.setLayoutContextTypeChangedMode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setLayoutContextTypeChangedMode(protocol_requestId, in_mode_json);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_mode = Protocol::Helpers::parseEnumValueFromString<Protocol::CSS::LayoutContextTypeChangedMode>(in_mode_json);
    if (!in_mode) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown mode: "_s, in_mode_json));
        return;
    }

    auto result = m_agent->setLayoutContextTypeChangedMode(*in_mode);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<CanvasBackendDispatcher> CanvasBackendDispatcher::create(BackendDispatcher& backendDispatcher, CanvasBackendDispatcherHandler* agent)
{
    return adoptRef(*new CanvasBackendDispatcher(backendDispatcher, agent));
}

CanvasBackendDispatcher::CanvasBackendDispatcher(BackendDispatcher& backendDispatcher, CanvasBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Canvas"_s, this);
}

void CanvasBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<CanvasBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (CanvasBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "enable"_s, &CanvasBackendDispatcher::enable },
        { "disable"_s, &CanvasBackendDispatcher::disable },
        { "requestNode"_s, &CanvasBackendDispatcher::requestNode },
        { "requestContent"_s, &CanvasBackendDispatcher::requestContent },
        { "requestClientNodes"_s, &CanvasBackendDispatcher::requestClientNodes },
        { "resolveContext"_s, &CanvasBackendDispatcher::resolveContext },
        { "setRecordingAutoCaptureFrameCount"_s, &CanvasBackendDispatcher::setRecordingAutoCaptureFrameCount },
        { "startRecording"_s, &CanvasBackendDispatcher::startRecording },
        { "stopRecording"_s, &CanvasBackendDispatcher::stopRecording },
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
        { "requestShaderSource"_s, &CanvasBackendDispatcher::requestShaderSource },
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
        { "updateShader"_s, &CanvasBackendDispatcher::updateShader },
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
        { "setShaderProgramDisabled"_s, &CanvasBackendDispatcher::setShaderProgramDisabled },
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
        { "setShaderProgramHighlighted"_s, &CanvasBackendDispatcher::setShaderProgramHighlighted },
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Canvas."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void CanvasBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CanvasBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CanvasBackendDispatcher::requestNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_canvasId = m_backendDispatcher->getString(protocol_parameters.get(), "canvasId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Canvas.requestNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->requestNode(protocol_requestId, in_canvasId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->requestNode(in_canvasId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_nodeId = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setInteger("nodeId"_s, out_nodeId);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CanvasBackendDispatcher::requestContent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_canvasId = m_backendDispatcher->getString(protocol_parameters.get(), "canvasId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Canvas.requestContent' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->requestContent(protocol_requestId, in_canvasId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->requestContent(in_canvasId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_content = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("content"_s, out_content);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CanvasBackendDispatcher::requestClientNodes(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_canvasId = m_backendDispatcher->getString(protocol_parameters.get(), "canvasId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Canvas.requestClientNodes' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->requestClientNodes(protocol_requestId, in_canvasId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->requestClientNodes(in_canvasId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_clientNodeIds = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("clientNodeIds"_s, WTFMove(out_clientNodeIds));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CanvasBackendDispatcher::resolveContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_canvasId = m_backendDispatcher->getString(protocol_parameters.get(), "canvasId"_s, true);
    auto in_opt_objectGroup = m_backendDispatcher->getString(protocol_parameters.get(), "objectGroup"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Canvas.resolveContext' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->resolveContext(protocol_requestId, in_canvasId, in_opt_objectGroup);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->resolveContext(in_canvasId, in_opt_objectGroup);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_object = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("object"_s, WTFMove(out_object));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CanvasBackendDispatcher::setRecordingAutoCaptureFrameCount(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_count = m_backendDispatcher->getInteger(protocol_parameters.get(), "count"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Canvas.setRecordingAutoCaptureFrameCount' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setRecordingAutoCaptureFrameCount(protocol_requestId, *in_count);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setRecordingAutoCaptureFrameCount(*in_count);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CanvasBackendDispatcher::startRecording(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_canvasId = m_backendDispatcher->getString(protocol_parameters.get(), "canvasId"_s, true);
    auto in_opt_frameCount = m_backendDispatcher->getInteger(protocol_parameters.get(), "frameCount"_s, false);
    auto in_opt_memoryLimit = m_backendDispatcher->getInteger(protocol_parameters.get(), "memoryLimit"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Canvas.startRecording' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->startRecording(protocol_requestId, in_canvasId, WTFMove(in_opt_frameCount), WTFMove(in_opt_memoryLimit));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->startRecording(in_canvasId, WTFMove(in_opt_frameCount), WTFMove(in_opt_memoryLimit));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void CanvasBackendDispatcher::stopRecording(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_canvasId = m_backendDispatcher->getString(protocol_parameters.get(), "canvasId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Canvas.stopRecording' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->stopRecording(protocol_requestId, in_canvasId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->stopRecording(in_canvasId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
void CanvasBackendDispatcher::requestShaderSource(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_programId = m_backendDispatcher->getString(protocol_parameters.get(), "programId"_s, true);
    auto in_shaderType_json = m_backendDispatcher->getString(protocol_parameters.get(), "shaderType"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Canvas.requestShaderSource' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->requestShaderSource(protocol_requestId, in_programId, in_shaderType_json);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_shaderType = Protocol::Helpers::parseEnumValueFromString<Protocol::Canvas::ShaderType>(in_shaderType_json);
    if (!in_shaderType) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown shaderType: "_s, in_shaderType_json));
        return;
    }

    auto result = m_agent->requestShaderSource(in_programId, *in_shaderType);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_source = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("source"_s, out_source);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL

#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
void CanvasBackendDispatcher::updateShader(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_programId = m_backendDispatcher->getString(protocol_parameters.get(), "programId"_s, true);
    auto in_shaderType_json = m_backendDispatcher->getString(protocol_parameters.get(), "shaderType"_s, true);
    auto in_source = m_backendDispatcher->getString(protocol_parameters.get(), "source"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Canvas.updateShader' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->updateShader(protocol_requestId, in_programId, in_shaderType_json, in_source);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_shaderType = Protocol::Helpers::parseEnumValueFromString<Protocol::Canvas::ShaderType>(in_shaderType_json);
    if (!in_shaderType) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown shaderType: "_s, in_shaderType_json));
        return;
    }

    auto result = m_agent->updateShader(in_programId, *in_shaderType, in_source);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL

#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
void CanvasBackendDispatcher::setShaderProgramDisabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_programId = m_backendDispatcher->getString(protocol_parameters.get(), "programId"_s, true);
    auto in_disabled = m_backendDispatcher->getBoolean(protocol_parameters.get(), "disabled"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Canvas.setShaderProgramDisabled' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setShaderProgramDisabled(protocol_requestId, in_programId, *in_disabled);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setShaderProgramDisabled(in_programId, *in_disabled);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL

#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
void CanvasBackendDispatcher::setShaderProgramHighlighted(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_programId = m_backendDispatcher->getString(protocol_parameters.get(), "programId"_s, true);
    auto in_highlighted = m_backendDispatcher->getBoolean(protocol_parameters.get(), "highlighted"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Canvas.setShaderProgramHighlighted' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setShaderProgramHighlighted(protocol_requestId, in_programId, *in_highlighted);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setShaderProgramHighlighted(in_programId, *in_highlighted);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL

Ref<ConsoleBackendDispatcher> ConsoleBackendDispatcher::create(BackendDispatcher& backendDispatcher, ConsoleBackendDispatcherHandler* agent)
{
    return adoptRef(*new ConsoleBackendDispatcher(backendDispatcher, agent));
}

ConsoleBackendDispatcher::ConsoleBackendDispatcher(BackendDispatcher& backendDispatcher, ConsoleBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Console"_s, this);
}

void ConsoleBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<ConsoleBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (ConsoleBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "enable"_s, &ConsoleBackendDispatcher::enable },
        { "disable"_s, &ConsoleBackendDispatcher::disable },
        { "clearMessages"_s, &ConsoleBackendDispatcher::clearMessages },
        { "setConsoleClearAPIEnabled"_s, &ConsoleBackendDispatcher::setConsoleClearAPIEnabled },
        { "getLoggingChannels"_s, &ConsoleBackendDispatcher::getLoggingChannels },
        { "setLoggingChannelLevel"_s, &ConsoleBackendDispatcher::setLoggingChannelLevel },
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Console."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void ConsoleBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void ConsoleBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void ConsoleBackendDispatcher::clearMessages(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->clearMessages(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->clearMessages();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void ConsoleBackendDispatcher::setConsoleClearAPIEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_enable = m_backendDispatcher->getBoolean(protocol_parameters.get(), "enable"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Console.setConsoleClearAPIEnabled' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setConsoleClearAPIEnabled(protocol_requestId, *in_enable);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setConsoleClearAPIEnabled(*in_enable);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void ConsoleBackendDispatcher::getLoggingChannels(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getLoggingChannels(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getLoggingChannels();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_channels = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("channels"_s, WTFMove(out_channels));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void ConsoleBackendDispatcher::setLoggingChannelLevel(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_source_json = m_backendDispatcher->getString(protocol_parameters.get(), "source"_s, true);
    auto in_level_json = m_backendDispatcher->getString(protocol_parameters.get(), "level"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Console.setLoggingChannelLevel' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setLoggingChannelLevel(protocol_requestId, in_source_json, in_level_json);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_source = Protocol::Helpers::parseEnumValueFromString<Protocol::Console::ChannelSource>(in_source_json);
    if (!in_source) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown source: "_s, in_source_json));
        return;
    }

    auto in_level = Protocol::Helpers::parseEnumValueFromString<Protocol::Console::ChannelLevel>(in_level_json);
    if (!in_level) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown level: "_s, in_level_json));
        return;
    }

    auto result = m_agent->setLoggingChannelLevel(*in_source, *in_level);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<DOMBackendDispatcher> DOMBackendDispatcher::create(BackendDispatcher& backendDispatcher, DOMBackendDispatcherHandler* agent)
{
    return adoptRef(*new DOMBackendDispatcher(backendDispatcher, agent));
}

DOMBackendDispatcher::DOMBackendDispatcher(BackendDispatcher& backendDispatcher, DOMBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("DOM"_s, this);
}

void DOMBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<DOMBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (DOMBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "getDocument"_s, &DOMBackendDispatcher::getDocument },
        { "requestChildNodes"_s, &DOMBackendDispatcher::requestChildNodes },
        { "requestAssignedSlot"_s, &DOMBackendDispatcher::requestAssignedSlot },
        { "requestAssignedNodes"_s, &DOMBackendDispatcher::requestAssignedNodes },
        { "querySelector"_s, &DOMBackendDispatcher::querySelector },
        { "querySelectorAll"_s, &DOMBackendDispatcher::querySelectorAll },
        { "setNodeName"_s, &DOMBackendDispatcher::setNodeName },
        { "setNodeValue"_s, &DOMBackendDispatcher::setNodeValue },
        { "removeNode"_s, &DOMBackendDispatcher::removeNode },
        { "setAttributeValue"_s, &DOMBackendDispatcher::setAttributeValue },
        { "setAttributesAsText"_s, &DOMBackendDispatcher::setAttributesAsText },
        { "removeAttribute"_s, &DOMBackendDispatcher::removeAttribute },
        { "getSupportedEventNames"_s, &DOMBackendDispatcher::getSupportedEventNames },
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
        { "getDataBindingsForNode"_s, &DOMBackendDispatcher::getDataBindingsForNode },
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
        { "getAssociatedDataForNode"_s, &DOMBackendDispatcher::getAssociatedDataForNode },
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
        { "getEventListenersForNode"_s, &DOMBackendDispatcher::getEventListenersForNode },
        { "setEventListenerDisabled"_s, &DOMBackendDispatcher::setEventListenerDisabled },
        { "setBreakpointForEventListener"_s, &DOMBackendDispatcher::setBreakpointForEventListener },
        { "removeBreakpointForEventListener"_s, &DOMBackendDispatcher::removeBreakpointForEventListener },
        { "getAccessibilityPropertiesForNode"_s, &DOMBackendDispatcher::getAccessibilityPropertiesForNode },
        { "getOuterHTML"_s, &DOMBackendDispatcher::getOuterHTML },
        { "setOuterHTML"_s, &DOMBackendDispatcher::setOuterHTML },
        { "insertAdjacentHTML"_s, &DOMBackendDispatcher::insertAdjacentHTML },
        { "performSearch"_s, &DOMBackendDispatcher::performSearch },
        { "getSearchResults"_s, &DOMBackendDispatcher::getSearchResults },
        { "discardSearchResults"_s, &DOMBackendDispatcher::discardSearchResults },
        { "requestNode"_s, &DOMBackendDispatcher::requestNode },
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
        { "setInspectModeEnabled"_s, &DOMBackendDispatcher::setInspectModeEnabled },
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
        { "setInspectModeEnabled"_s, &DOMBackendDispatcher::setInspectModeEnabled },
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
        { "highlightRect"_s, &DOMBackendDispatcher::highlightRect },
        { "highlightQuad"_s, &DOMBackendDispatcher::highlightQuad },
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
        { "highlightSelector"_s, &DOMBackendDispatcher::highlightSelector },
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
        { "highlightSelector"_s, &DOMBackendDispatcher::highlightSelector },
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
        { "highlightNode"_s, &DOMBackendDispatcher::highlightNode },
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
        { "highlightNode"_s, &DOMBackendDispatcher::highlightNode },
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
        { "highlightNodeList"_s, &DOMBackendDispatcher::highlightNodeList },
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
        { "highlightNodeList"_s, &DOMBackendDispatcher::highlightNodeList },
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
        { "hideHighlight"_s, &DOMBackendDispatcher::hideHighlight },
        { "highlightFrame"_s, &DOMBackendDispatcher::highlightFrame },
        { "showGridOverlay"_s, &DOMBackendDispatcher::showGridOverlay },
        { "hideGridOverlay"_s, &DOMBackendDispatcher::hideGridOverlay },
        { "showFlexOverlay"_s, &DOMBackendDispatcher::showFlexOverlay },
        { "hideFlexOverlay"_s, &DOMBackendDispatcher::hideFlexOverlay },
        { "pushNodeByPathToFrontend"_s, &DOMBackendDispatcher::pushNodeByPathToFrontend },
        { "resolveNode"_s, &DOMBackendDispatcher::resolveNode },
        { "getAttributes"_s, &DOMBackendDispatcher::getAttributes },
        { "moveTo"_s, &DOMBackendDispatcher::moveTo },
        { "undo"_s, &DOMBackendDispatcher::undo },
        { "redo"_s, &DOMBackendDispatcher::redo },
        { "markUndoableState"_s, &DOMBackendDispatcher::markUndoableState },
        { "focus"_s, &DOMBackendDispatcher::focus },
        { "setInspectedNode"_s, &DOMBackendDispatcher::setInspectedNode },
        { "setAllowEditingUserAgentShadowTrees"_s, &DOMBackendDispatcher::setAllowEditingUserAgentShadowTrees },
        { "getMediaStats"_s, &DOMBackendDispatcher::getMediaStats },
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'DOM."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void DOMBackendDispatcher::getDocument(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getDocument(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getDocument();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_root = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("root"_s, WTFMove(out_root));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::requestChildNodes(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_opt_depth = m_backendDispatcher->getInteger(protocol_parameters.get(), "depth"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.requestChildNodes' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->requestChildNodes(protocol_requestId, *in_nodeId, WTFMove(in_opt_depth));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->requestChildNodes(*in_nodeId, WTFMove(in_opt_depth));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::requestAssignedSlot(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.requestAssignedSlot' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->requestAssignedSlot(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->requestAssignedSlot(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_opt_slotElementId = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    if (!!out_opt_slotElementId)
        protocol_jsonMessage->setInteger("slotElementId"_s, *out_opt_slotElementId);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::requestAssignedNodes(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_slotElementId = m_backendDispatcher->getInteger(protocol_parameters.get(), "slotElementId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.requestAssignedNodes' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->requestAssignedNodes(protocol_requestId, *in_slotElementId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->requestAssignedNodes(*in_slotElementId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_assignedNodeIds = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("assignedNodeIds"_s, WTFMove(out_assignedNodeIds));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::querySelector(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_selector = m_backendDispatcher->getString(protocol_parameters.get(), "selector"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.querySelector' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->querySelector(protocol_requestId, *in_nodeId, in_selector);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->querySelector(*in_nodeId, in_selector);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_opt_nodeId = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    if (!!out_opt_nodeId)
        protocol_jsonMessage->setInteger("nodeId"_s, *out_opt_nodeId);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::querySelectorAll(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_selector = m_backendDispatcher->getString(protocol_parameters.get(), "selector"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.querySelectorAll' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->querySelectorAll(protocol_requestId, *in_nodeId, in_selector);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->querySelectorAll(*in_nodeId, in_selector);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_nodeIds = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("nodeIds"_s, WTFMove(out_nodeIds));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::setNodeName(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_name = m_backendDispatcher->getString(protocol_parameters.get(), "name"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.setNodeName' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setNodeName(protocol_requestId, *in_nodeId, in_name);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setNodeName(*in_nodeId, in_name);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_nodeId = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setInteger("nodeId"_s, out_nodeId);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::setNodeValue(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_value = m_backendDispatcher->getString(protocol_parameters.get(), "value"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.setNodeValue' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setNodeValue(protocol_requestId, *in_nodeId, in_value);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setNodeValue(*in_nodeId, in_value);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::removeNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.removeNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->removeNode(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->removeNode(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::setAttributeValue(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_name = m_backendDispatcher->getString(protocol_parameters.get(), "name"_s, true);
    auto in_value = m_backendDispatcher->getString(protocol_parameters.get(), "value"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.setAttributeValue' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setAttributeValue(protocol_requestId, *in_nodeId, in_name, in_value);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setAttributeValue(*in_nodeId, in_name, in_value);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::setAttributesAsText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_text = m_backendDispatcher->getString(protocol_parameters.get(), "text"_s, true);
    auto in_opt_name = m_backendDispatcher->getString(protocol_parameters.get(), "name"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.setAttributesAsText' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setAttributesAsText(protocol_requestId, *in_nodeId, in_text, in_opt_name);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setAttributesAsText(*in_nodeId, in_text, in_opt_name);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::removeAttribute(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_name = m_backendDispatcher->getString(protocol_parameters.get(), "name"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.removeAttribute' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->removeAttribute(protocol_requestId, *in_nodeId, in_name);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->removeAttribute(*in_nodeId, in_name);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::getSupportedEventNames(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getSupportedEventNames(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getSupportedEventNames();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_eventNames = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("eventNames"_s, WTFMove(out_eventNames));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
void DOMBackendDispatcher::getDataBindingsForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.getDataBindingsForNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getDataBindingsForNode(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getDataBindingsForNode(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_dataBindings = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("dataBindings"_s, WTFMove(out_dataBindings));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS

#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
void DOMBackendDispatcher::getAssociatedDataForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.getAssociatedDataForNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getAssociatedDataForNode(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getAssociatedDataForNode(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_opt_associatedData = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    if (!!out_opt_associatedData)
        protocol_jsonMessage->setString("associatedData"_s, out_opt_associatedData);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS

void DOMBackendDispatcher::getEventListenersForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_opt_includeAncestors = m_backendDispatcher->getBoolean(protocol_parameters.get(), "includeAncestors"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.getEventListenersForNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getEventListenersForNode(protocol_requestId, *in_nodeId, WTFMove(in_opt_includeAncestors));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getEventListenersForNode(*in_nodeId, WTFMove(in_opt_includeAncestors));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_listeners = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("listeners"_s, WTFMove(out_listeners));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::setEventListenerDisabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_eventListenerId = m_backendDispatcher->getInteger(protocol_parameters.get(), "eventListenerId"_s, true);
    auto in_disabled = m_backendDispatcher->getBoolean(protocol_parameters.get(), "disabled"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.setEventListenerDisabled' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setEventListenerDisabled(protocol_requestId, *in_eventListenerId, *in_disabled);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setEventListenerDisabled(*in_eventListenerId, *in_disabled);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::setBreakpointForEventListener(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_eventListenerId = m_backendDispatcher->getInteger(protocol_parameters.get(), "eventListenerId"_s, true);
    auto in_opt_options = m_backendDispatcher->getObject(protocol_parameters.get(), "options"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.setBreakpointForEventListener' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setBreakpointForEventListener(protocol_requestId, *in_eventListenerId, WTFMove(in_opt_options));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setBreakpointForEventListener(*in_eventListenerId, WTFMove(in_opt_options));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::removeBreakpointForEventListener(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_eventListenerId = m_backendDispatcher->getInteger(protocol_parameters.get(), "eventListenerId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.removeBreakpointForEventListener' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->removeBreakpointForEventListener(protocol_requestId, *in_eventListenerId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->removeBreakpointForEventListener(*in_eventListenerId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::getAccessibilityPropertiesForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.getAccessibilityPropertiesForNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getAccessibilityPropertiesForNode(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getAccessibilityPropertiesForNode(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_properties = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("properties"_s, WTFMove(out_properties));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::getOuterHTML(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.getOuterHTML' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getOuterHTML(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getOuterHTML(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_outerHTML = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("outerHTML"_s, out_outerHTML);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::setOuterHTML(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_outerHTML = m_backendDispatcher->getString(protocol_parameters.get(), "outerHTML"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.setOuterHTML' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setOuterHTML(protocol_requestId, *in_nodeId, in_outerHTML);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setOuterHTML(*in_nodeId, in_outerHTML);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::insertAdjacentHTML(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_position = m_backendDispatcher->getString(protocol_parameters.get(), "position"_s, true);
    auto in_html = m_backendDispatcher->getString(protocol_parameters.get(), "html"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.insertAdjacentHTML' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->insertAdjacentHTML(protocol_requestId, *in_nodeId, in_position, in_html);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->insertAdjacentHTML(*in_nodeId, in_position, in_html);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::performSearch(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_query = m_backendDispatcher->getString(protocol_parameters.get(), "query"_s, true);
    auto in_opt_nodeIds = m_backendDispatcher->getArray(protocol_parameters.get(), "nodeIds"_s, false);
    auto in_opt_caseSensitive = m_backendDispatcher->getBoolean(protocol_parameters.get(), "caseSensitive"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.performSearch' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->performSearch(protocol_requestId, in_query, WTFMove(in_opt_nodeIds), WTFMove(in_opt_caseSensitive));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->performSearch(in_query, WTFMove(in_opt_nodeIds), WTFMove(in_opt_caseSensitive));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_searchId, out_resultCount] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("searchId"_s, out_searchId);
    protocol_jsonMessage->setInteger("resultCount"_s, out_resultCount);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::getSearchResults(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_searchId = m_backendDispatcher->getString(protocol_parameters.get(), "searchId"_s, true);
    auto in_fromIndex = m_backendDispatcher->getInteger(protocol_parameters.get(), "fromIndex"_s, true);
    auto in_toIndex = m_backendDispatcher->getInteger(protocol_parameters.get(), "toIndex"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.getSearchResults' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getSearchResults(protocol_requestId, in_searchId, *in_fromIndex, *in_toIndex);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getSearchResults(in_searchId, *in_fromIndex, *in_toIndex);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_nodeIds = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("nodeIds"_s, WTFMove(out_nodeIds));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::discardSearchResults(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_searchId = m_backendDispatcher->getString(protocol_parameters.get(), "searchId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.discardSearchResults' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->discardSearchResults(protocol_requestId, in_searchId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->discardSearchResults(in_searchId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::requestNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_objectId = m_backendDispatcher->getString(protocol_parameters.get(), "objectId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.requestNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->requestNode(protocol_requestId, in_objectId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->requestNode(in_objectId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_nodeId = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setInteger("nodeId"_s, out_nodeId);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
void DOMBackendDispatcher::setInspectModeEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_enabled = m_backendDispatcher->getBoolean(protocol_parameters.get(), "enabled"_s, true);
    auto in_opt_highlightConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "highlightConfig"_s, false);
    auto in_opt_gridOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "gridOverlayConfig"_s, false);
    auto in_opt_flexOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "flexOverlayConfig"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.setInspectModeEnabled' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setInspectModeEnabled(protocol_requestId, *in_enabled, WTFMove(in_opt_highlightConfig), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setInspectModeEnabled(*in_enabled, WTFMove(in_opt_highlightConfig), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY

#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
void DOMBackendDispatcher::setInspectModeEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_enabled = m_backendDispatcher->getBoolean(protocol_parameters.get(), "enabled"_s, true);
    auto in_opt_highlightConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "highlightConfig"_s, false);
    auto in_opt_gridOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "gridOverlayConfig"_s, false);
    auto in_opt_flexOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "flexOverlayConfig"_s, false);
    auto in_opt_showRulers = m_backendDispatcher->getBoolean(protocol_parameters.get(), "showRulers"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.setInspectModeEnabled' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setInspectModeEnabled(protocol_requestId, *in_enabled, WTFMove(in_opt_highlightConfig), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig), WTFMove(in_opt_showRulers));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setInspectModeEnabled(*in_enabled, WTFMove(in_opt_highlightConfig), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig), WTFMove(in_opt_showRulers));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)

void DOMBackendDispatcher::highlightRect(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_x = m_backendDispatcher->getInteger(protocol_parameters.get(), "x"_s, true);
    auto in_y = m_backendDispatcher->getInteger(protocol_parameters.get(), "y"_s, true);
    auto in_width = m_backendDispatcher->getInteger(protocol_parameters.get(), "width"_s, true);
    auto in_height = m_backendDispatcher->getInteger(protocol_parameters.get(), "height"_s, true);
    auto in_opt_color = m_backendDispatcher->getObject(protocol_parameters.get(), "color"_s, false);
    auto in_opt_outlineColor = m_backendDispatcher->getObject(protocol_parameters.get(), "outlineColor"_s, false);
    auto in_opt_usePageCoordinates = m_backendDispatcher->getBoolean(protocol_parameters.get(), "usePageCoordinates"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.highlightRect' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->highlightRect(protocol_requestId, *in_x, *in_y, *in_width, *in_height, WTFMove(in_opt_color), WTFMove(in_opt_outlineColor), WTFMove(in_opt_usePageCoordinates));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->highlightRect(*in_x, *in_y, *in_width, *in_height, WTFMove(in_opt_color), WTFMove(in_opt_outlineColor), WTFMove(in_opt_usePageCoordinates));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::highlightQuad(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_quad = m_backendDispatcher->getArray(protocol_parameters.get(), "quad"_s, true);
    auto in_opt_color = m_backendDispatcher->getObject(protocol_parameters.get(), "color"_s, false);
    auto in_opt_outlineColor = m_backendDispatcher->getObject(protocol_parameters.get(), "outlineColor"_s, false);
    auto in_opt_usePageCoordinates = m_backendDispatcher->getBoolean(protocol_parameters.get(), "usePageCoordinates"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.highlightQuad' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->highlightQuad(protocol_requestId, in_quad.releaseNonNull(), WTFMove(in_opt_color), WTFMove(in_opt_outlineColor), WTFMove(in_opt_usePageCoordinates));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->highlightQuad(in_quad.releaseNonNull(), WTFMove(in_opt_color), WTFMove(in_opt_outlineColor), WTFMove(in_opt_usePageCoordinates));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
void DOMBackendDispatcher::highlightSelector(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_selectorString = m_backendDispatcher->getString(protocol_parameters.get(), "selectorString"_s, true);
    auto in_opt_frameId = m_backendDispatcher->getString(protocol_parameters.get(), "frameId"_s, false);
    auto in_highlightConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "highlightConfig"_s, true);
    auto in_opt_gridOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "gridOverlayConfig"_s, false);
    auto in_opt_flexOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "flexOverlayConfig"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.highlightSelector' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->highlightSelector(protocol_requestId, in_selectorString, in_opt_frameId, in_highlightConfig.releaseNonNull(), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->highlightSelector(in_selectorString, in_opt_frameId, in_highlightConfig.releaseNonNull(), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY

#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
void DOMBackendDispatcher::highlightSelector(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_selectorString = m_backendDispatcher->getString(protocol_parameters.get(), "selectorString"_s, true);
    auto in_opt_frameId = m_backendDispatcher->getString(protocol_parameters.get(), "frameId"_s, false);
    auto in_highlightConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "highlightConfig"_s, true);
    auto in_opt_gridOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "gridOverlayConfig"_s, false);
    auto in_opt_flexOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "flexOverlayConfig"_s, false);
    auto in_opt_showRulers = m_backendDispatcher->getBoolean(protocol_parameters.get(), "showRulers"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.highlightSelector' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->highlightSelector(protocol_requestId, in_selectorString, in_opt_frameId, in_highlightConfig.releaseNonNull(), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig), WTFMove(in_opt_showRulers));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->highlightSelector(in_selectorString, in_opt_frameId, in_highlightConfig.releaseNonNull(), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig), WTFMove(in_opt_showRulers));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)

#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
void DOMBackendDispatcher::highlightNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, false);
    auto in_opt_objectId = m_backendDispatcher->getString(protocol_parameters.get(), "objectId"_s, false);
    auto in_highlightConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "highlightConfig"_s, true);
    auto in_opt_gridOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "gridOverlayConfig"_s, false);
    auto in_opt_flexOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "flexOverlayConfig"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.highlightNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->highlightNode(protocol_requestId, WTFMove(in_opt_nodeId), in_opt_objectId, in_highlightConfig.releaseNonNull(), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->highlightNode(WTFMove(in_opt_nodeId), in_opt_objectId, in_highlightConfig.releaseNonNull(), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY

#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
void DOMBackendDispatcher::highlightNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, false);
    auto in_opt_objectId = m_backendDispatcher->getString(protocol_parameters.get(), "objectId"_s, false);
    auto in_highlightConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "highlightConfig"_s, true);
    auto in_opt_gridOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "gridOverlayConfig"_s, false);
    auto in_opt_flexOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "flexOverlayConfig"_s, false);
    auto in_opt_showRulers = m_backendDispatcher->getBoolean(protocol_parameters.get(), "showRulers"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.highlightNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->highlightNode(protocol_requestId, WTFMove(in_opt_nodeId), in_opt_objectId, in_highlightConfig.releaseNonNull(), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig), WTFMove(in_opt_showRulers));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->highlightNode(WTFMove(in_opt_nodeId), in_opt_objectId, in_highlightConfig.releaseNonNull(), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig), WTFMove(in_opt_showRulers));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)

#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
void DOMBackendDispatcher::highlightNodeList(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeIds = m_backendDispatcher->getArray(protocol_parameters.get(), "nodeIds"_s, true);
    auto in_highlightConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "highlightConfig"_s, true);
    auto in_opt_gridOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "gridOverlayConfig"_s, false);
    auto in_opt_flexOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "flexOverlayConfig"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.highlightNodeList' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->highlightNodeList(protocol_requestId, in_nodeIds.releaseNonNull(), in_highlightConfig.releaseNonNull(), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->highlightNodeList(in_nodeIds.releaseNonNull(), in_highlightConfig.releaseNonNull(), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY

#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
void DOMBackendDispatcher::highlightNodeList(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeIds = m_backendDispatcher->getArray(protocol_parameters.get(), "nodeIds"_s, true);
    auto in_highlightConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "highlightConfig"_s, true);
    auto in_opt_gridOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "gridOverlayConfig"_s, false);
    auto in_opt_flexOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "flexOverlayConfig"_s, false);
    auto in_opt_showRulers = m_backendDispatcher->getBoolean(protocol_parameters.get(), "showRulers"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.highlightNodeList' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->highlightNodeList(protocol_requestId, in_nodeIds.releaseNonNull(), in_highlightConfig.releaseNonNull(), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig), WTFMove(in_opt_showRulers));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->highlightNodeList(in_nodeIds.releaseNonNull(), in_highlightConfig.releaseNonNull(), WTFMove(in_opt_gridOverlayConfig), WTFMove(in_opt_flexOverlayConfig), WTFMove(in_opt_showRulers));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)

void DOMBackendDispatcher::hideHighlight(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->hideHighlight(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->hideHighlight();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::highlightFrame(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_frameId = m_backendDispatcher->getString(protocol_parameters.get(), "frameId"_s, true);
    auto in_opt_contentColor = m_backendDispatcher->getObject(protocol_parameters.get(), "contentColor"_s, false);
    auto in_opt_contentOutlineColor = m_backendDispatcher->getObject(protocol_parameters.get(), "contentOutlineColor"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.highlightFrame' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->highlightFrame(protocol_requestId, in_frameId, WTFMove(in_opt_contentColor), WTFMove(in_opt_contentOutlineColor));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->highlightFrame(in_frameId, WTFMove(in_opt_contentColor), WTFMove(in_opt_contentOutlineColor));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::showGridOverlay(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_gridOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "gridOverlayConfig"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.showGridOverlay' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->showGridOverlay(protocol_requestId, *in_nodeId, in_gridOverlayConfig.releaseNonNull());
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->showGridOverlay(*in_nodeId, in_gridOverlayConfig.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::hideGridOverlay(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.hideGridOverlay' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->hideGridOverlay(protocol_requestId, WTFMove(in_opt_nodeId));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->hideGridOverlay(WTFMove(in_opt_nodeId));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::showFlexOverlay(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_flexOverlayConfig = m_backendDispatcher->getObject(protocol_parameters.get(), "flexOverlayConfig"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.showFlexOverlay' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->showFlexOverlay(protocol_requestId, *in_nodeId, in_flexOverlayConfig.releaseNonNull());
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->showFlexOverlay(*in_nodeId, in_flexOverlayConfig.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::hideFlexOverlay(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.hideFlexOverlay' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->hideFlexOverlay(protocol_requestId, WTFMove(in_opt_nodeId));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->hideFlexOverlay(WTFMove(in_opt_nodeId));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::pushNodeByPathToFrontend(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_path = m_backendDispatcher->getString(protocol_parameters.get(), "path"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.pushNodeByPathToFrontend' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->pushNodeByPathToFrontend(protocol_requestId, in_path);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->pushNodeByPathToFrontend(in_path);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_nodeId = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setInteger("nodeId"_s, out_nodeId);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::resolveNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_opt_objectGroup = m_backendDispatcher->getString(protocol_parameters.get(), "objectGroup"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.resolveNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->resolveNode(protocol_requestId, *in_nodeId, in_opt_objectGroup);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->resolveNode(*in_nodeId, in_opt_objectGroup);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_object = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("object"_s, WTFMove(out_object));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::getAttributes(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.getAttributes' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getAttributes(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getAttributes(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_attributes = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("attributes"_s, WTFMove(out_attributes));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::moveTo(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_targetNodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "targetNodeId"_s, true);
    auto in_opt_insertBeforeNodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "insertBeforeNodeId"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.moveTo' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->moveTo(protocol_requestId, *in_nodeId, *in_targetNodeId, WTFMove(in_opt_insertBeforeNodeId));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->moveTo(*in_nodeId, *in_targetNodeId, WTFMove(in_opt_insertBeforeNodeId));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_nodeId = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setInteger("nodeId"_s, out_nodeId);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::undo(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->undo(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->undo();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::redo(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->redo(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->redo();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::markUndoableState(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->markUndoableState(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->markUndoableState();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::focus(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.focus' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->focus(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->focus(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::setInspectedNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.setInspectedNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setInspectedNode(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setInspectedNode(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::setAllowEditingUserAgentShadowTrees(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_allow = m_backendDispatcher->getBoolean(protocol_parameters.get(), "allow"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.setAllowEditingUserAgentShadowTrees' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setAllowEditingUserAgentShadowTrees(protocol_requestId, *in_allow);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setAllowEditingUserAgentShadowTrees(*in_allow);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMBackendDispatcher::getMediaStats(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOM.getMediaStats' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getMediaStats(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getMediaStats(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_mediaStats = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("mediaStats"_s, WTFMove(out_mediaStats));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<DOMDebuggerBackendDispatcher> DOMDebuggerBackendDispatcher::create(BackendDispatcher& backendDispatcher, DOMDebuggerBackendDispatcherHandler* agent)
{
    return adoptRef(*new DOMDebuggerBackendDispatcher(backendDispatcher, agent));
}

DOMDebuggerBackendDispatcher::DOMDebuggerBackendDispatcher(BackendDispatcher& backendDispatcher, DOMDebuggerBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("DOMDebugger"_s, this);
}

void DOMDebuggerBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<DOMDebuggerBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (DOMDebuggerBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "setDOMBreakpoint"_s, &DOMDebuggerBackendDispatcher::setDOMBreakpoint },
        { "removeDOMBreakpoint"_s, &DOMDebuggerBackendDispatcher::removeDOMBreakpoint },
        { "setEventBreakpoint"_s, &DOMDebuggerBackendDispatcher::setEventBreakpoint },
        { "removeEventBreakpoint"_s, &DOMDebuggerBackendDispatcher::removeEventBreakpoint },
        { "setURLBreakpoint"_s, &DOMDebuggerBackendDispatcher::setURLBreakpoint },
        { "removeURLBreakpoint"_s, &DOMDebuggerBackendDispatcher::removeURLBreakpoint },
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'DOMDebugger."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void DOMDebuggerBackendDispatcher::setDOMBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_type_json = m_backendDispatcher->getString(protocol_parameters.get(), "type"_s, true);
    auto in_opt_options = m_backendDispatcher->getObject(protocol_parameters.get(), "options"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOMDebugger.setDOMBreakpoint' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setDOMBreakpoint(protocol_requestId, *in_nodeId, in_type_json, WTFMove(in_opt_options));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_type = Protocol::Helpers::parseEnumValueFromString<Protocol::DOMDebugger::DOMBreakpointType>(in_type_json);
    if (!in_type) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown type: "_s, in_type_json));
        return;
    }

    auto result = m_agent->setDOMBreakpoint(*in_nodeId, *in_type, WTFMove(in_opt_options));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMDebuggerBackendDispatcher::removeDOMBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    auto in_type_json = m_backendDispatcher->getString(protocol_parameters.get(), "type"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOMDebugger.removeDOMBreakpoint' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->removeDOMBreakpoint(protocol_requestId, *in_nodeId, in_type_json);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_type = Protocol::Helpers::parseEnumValueFromString<Protocol::DOMDebugger::DOMBreakpointType>(in_type_json);
    if (!in_type) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown type: "_s, in_type_json));
        return;
    }

    auto result = m_agent->removeDOMBreakpoint(*in_nodeId, *in_type);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMDebuggerBackendDispatcher::setEventBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_breakpointType_json = m_backendDispatcher->getString(protocol_parameters.get(), "breakpointType"_s, true);
    auto in_opt_eventName = m_backendDispatcher->getString(protocol_parameters.get(), "eventName"_s, false);
    auto in_opt_caseSensitive = m_backendDispatcher->getBoolean(protocol_parameters.get(), "caseSensitive"_s, false);
    auto in_opt_isRegex = m_backendDispatcher->getBoolean(protocol_parameters.get(), "isRegex"_s, false);
    auto in_opt_options = m_backendDispatcher->getObject(protocol_parameters.get(), "options"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOMDebugger.setEventBreakpoint' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setEventBreakpoint(protocol_requestId, in_breakpointType_json, in_opt_eventName, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex), WTFMove(in_opt_options));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_breakpointType = Protocol::Helpers::parseEnumValueFromString<Protocol::DOMDebugger::EventBreakpointType>(in_breakpointType_json);
    if (!in_breakpointType) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown breakpointType: "_s, in_breakpointType_json));
        return;
    }

    auto result = m_agent->setEventBreakpoint(*in_breakpointType, in_opt_eventName, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex), WTFMove(in_opt_options));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMDebuggerBackendDispatcher::removeEventBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_breakpointType_json = m_backendDispatcher->getString(protocol_parameters.get(), "breakpointType"_s, true);
    auto in_opt_eventName = m_backendDispatcher->getString(protocol_parameters.get(), "eventName"_s, false);
    auto in_opt_caseSensitive = m_backendDispatcher->getBoolean(protocol_parameters.get(), "caseSensitive"_s, false);
    auto in_opt_isRegex = m_backendDispatcher->getBoolean(protocol_parameters.get(), "isRegex"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOMDebugger.removeEventBreakpoint' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->removeEventBreakpoint(protocol_requestId, in_breakpointType_json, in_opt_eventName, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_breakpointType = Protocol::Helpers::parseEnumValueFromString<Protocol::DOMDebugger::EventBreakpointType>(in_breakpointType_json);
    if (!in_breakpointType) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown breakpointType: "_s, in_breakpointType_json));
        return;
    }

    auto result = m_agent->removeEventBreakpoint(*in_breakpointType, in_opt_eventName, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMDebuggerBackendDispatcher::setURLBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, true);
    auto in_opt_isRegex = m_backendDispatcher->getBoolean(protocol_parameters.get(), "isRegex"_s, false);
    auto in_opt_options = m_backendDispatcher->getObject(protocol_parameters.get(), "options"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOMDebugger.setURLBreakpoint' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setURLBreakpoint(protocol_requestId, in_url, WTFMove(in_opt_isRegex), WTFMove(in_opt_options));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setURLBreakpoint(in_url, WTFMove(in_opt_isRegex), WTFMove(in_opt_options));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMDebuggerBackendDispatcher::removeURLBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, true);
    auto in_opt_isRegex = m_backendDispatcher->getBoolean(protocol_parameters.get(), "isRegex"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOMDebugger.removeURLBreakpoint' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->removeURLBreakpoint(protocol_requestId, in_url, WTFMove(in_opt_isRegex));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->removeURLBreakpoint(in_url, WTFMove(in_opt_isRegex));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<DOMStorageBackendDispatcher> DOMStorageBackendDispatcher::create(BackendDispatcher& backendDispatcher, DOMStorageBackendDispatcherHandler* agent)
{
    return adoptRef(*new DOMStorageBackendDispatcher(backendDispatcher, agent));
}

DOMStorageBackendDispatcher::DOMStorageBackendDispatcher(BackendDispatcher& backendDispatcher, DOMStorageBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("DOMStorage"_s, this);
}

void DOMStorageBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<DOMStorageBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (DOMStorageBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "enable"_s, &DOMStorageBackendDispatcher::enable },
        { "disable"_s, &DOMStorageBackendDispatcher::disable },
        { "getDOMStorageItems"_s, &DOMStorageBackendDispatcher::getDOMStorageItems },
        { "setDOMStorageItem"_s, &DOMStorageBackendDispatcher::setDOMStorageItem },
        { "removeDOMStorageItem"_s, &DOMStorageBackendDispatcher::removeDOMStorageItem },
        { "clearDOMStorageItems"_s, &DOMStorageBackendDispatcher::clearDOMStorageItems },
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'DOMStorage."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void DOMStorageBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMStorageBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMStorageBackendDispatcher::getDOMStorageItems(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_storageId = m_backendDispatcher->getObject(protocol_parameters.get(), "storageId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOMStorage.getDOMStorageItems' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getDOMStorageItems(protocol_requestId, in_storageId.releaseNonNull());
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getDOMStorageItems(in_storageId.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_entries = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("entries"_s, WTFMove(out_entries));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMStorageBackendDispatcher::setDOMStorageItem(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_storageId = m_backendDispatcher->getObject(protocol_parameters.get(), "storageId"_s, true);
    auto in_key = m_backendDispatcher->getString(protocol_parameters.get(), "key"_s, true);
    auto in_value = m_backendDispatcher->getString(protocol_parameters.get(), "value"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOMStorage.setDOMStorageItem' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setDOMStorageItem(protocol_requestId, in_storageId.releaseNonNull(), in_key, in_value);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setDOMStorageItem(in_storageId.releaseNonNull(), in_key, in_value);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMStorageBackendDispatcher::removeDOMStorageItem(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_storageId = m_backendDispatcher->getObject(protocol_parameters.get(), "storageId"_s, true);
    auto in_key = m_backendDispatcher->getString(protocol_parameters.get(), "key"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOMStorage.removeDOMStorageItem' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->removeDOMStorageItem(protocol_requestId, in_storageId.releaseNonNull(), in_key);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->removeDOMStorageItem(in_storageId.releaseNonNull(), in_key);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DOMStorageBackendDispatcher::clearDOMStorageItems(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_storageId = m_backendDispatcher->getObject(protocol_parameters.get(), "storageId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'DOMStorage.clearDOMStorageItems' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->clearDOMStorageItems(protocol_requestId, in_storageId.releaseNonNull());
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->clearDOMStorageItems(in_storageId.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<DebuggerBackendDispatcher> DebuggerBackendDispatcher::create(BackendDispatcher& backendDispatcher, DebuggerBackendDispatcherHandler* agent)
{
    return adoptRef(*new DebuggerBackendDispatcher(backendDispatcher, agent));
}

DebuggerBackendDispatcher::DebuggerBackendDispatcher(BackendDispatcher& backendDispatcher, DebuggerBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Debugger"_s, this);
}

void DebuggerBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<DebuggerBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (DebuggerBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "enable"_s, &DebuggerBackendDispatcher::enable },
        { "disable"_s, &DebuggerBackendDispatcher::disable },
        { "setAsyncStackTraceDepth"_s, &DebuggerBackendDispatcher::setAsyncStackTraceDepth },
        { "setBreakpointsActive"_s, &DebuggerBackendDispatcher::setBreakpointsActive },
        { "setBreakpointByUrl"_s, &DebuggerBackendDispatcher::setBreakpointByUrl },
        { "setBreakpoint"_s, &DebuggerBackendDispatcher::setBreakpoint },
        { "removeBreakpoint"_s, &DebuggerBackendDispatcher::removeBreakpoint },
        { "addSymbolicBreakpoint"_s, &DebuggerBackendDispatcher::addSymbolicBreakpoint },
        { "removeSymbolicBreakpoint"_s, &DebuggerBackendDispatcher::removeSymbolicBreakpoint },
        { "continueUntilNextRunLoop"_s, &DebuggerBackendDispatcher::continueUntilNextRunLoop },
        { "continueToLocation"_s, &DebuggerBackendDispatcher::continueToLocation },
        { "stepNext"_s, &DebuggerBackendDispatcher::stepNext },
        { "stepOver"_s, &DebuggerBackendDispatcher::stepOver },
        { "stepInto"_s, &DebuggerBackendDispatcher::stepInto },
        { "stepOut"_s, &DebuggerBackendDispatcher::stepOut },
        { "pause"_s, &DebuggerBackendDispatcher::pause },
        { "resume"_s, &DebuggerBackendDispatcher::resume },
        { "searchInContent"_s, &DebuggerBackendDispatcher::searchInContent },
        { "getScriptSource"_s, &DebuggerBackendDispatcher::getScriptSource },
        { "getFunctionDetails"_s, &DebuggerBackendDispatcher::getFunctionDetails },
        { "getBreakpointLocations"_s, &DebuggerBackendDispatcher::getBreakpointLocations },
        { "setPauseOnDebuggerStatements"_s, &DebuggerBackendDispatcher::setPauseOnDebuggerStatements },
        { "setPauseOnExceptions"_s, &DebuggerBackendDispatcher::setPauseOnExceptions },
        { "setPauseOnAssertions"_s, &DebuggerBackendDispatcher::setPauseOnAssertions },
        { "setPauseOnMicrotasks"_s, &DebuggerBackendDispatcher::setPauseOnMicrotasks },
        { "setPauseForInternalScripts"_s, &DebuggerBackendDispatcher::setPauseForInternalScripts },
        { "evaluateOnCallFrame"_s, &DebuggerBackendDispatcher::evaluateOnCallFrame },
        { "setShouldBlackboxURL"_s, &DebuggerBackendDispatcher::setShouldBlackboxURL },
        { "setBlackboxBreakpointEvaluations"_s, &DebuggerBackendDispatcher::setBlackboxBreakpointEvaluations },
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Debugger."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void DebuggerBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::setAsyncStackTraceDepth(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_depth = m_backendDispatcher->getInteger(protocol_parameters.get(), "depth"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.setAsyncStackTraceDepth' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setAsyncStackTraceDepth(protocol_requestId, *in_depth);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setAsyncStackTraceDepth(*in_depth);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::setBreakpointsActive(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_active = m_backendDispatcher->getBoolean(protocol_parameters.get(), "active"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.setBreakpointsActive' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setBreakpointsActive(protocol_requestId, *in_active);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setBreakpointsActive(*in_active);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::setBreakpointByUrl(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_lineNumber = m_backendDispatcher->getInteger(protocol_parameters.get(), "lineNumber"_s, true);
    auto in_opt_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, false);
    auto in_opt_urlRegex = m_backendDispatcher->getString(protocol_parameters.get(), "urlRegex"_s, false);
    auto in_opt_columnNumber = m_backendDispatcher->getInteger(protocol_parameters.get(), "columnNumber"_s, false);
    auto in_opt_options = m_backendDispatcher->getObject(protocol_parameters.get(), "options"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.setBreakpointByUrl' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setBreakpointByUrl(protocol_requestId, *in_lineNumber, in_opt_url, in_opt_urlRegex, WTFMove(in_opt_columnNumber), WTFMove(in_opt_options));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setBreakpointByUrl(*in_lineNumber, in_opt_url, in_opt_urlRegex, WTFMove(in_opt_columnNumber), WTFMove(in_opt_options));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_breakpointId, out_locations] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("breakpointId"_s, out_breakpointId);
    protocol_jsonMessage->setArray("locations"_s, WTFMove(out_locations));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::setBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_location = m_backendDispatcher->getObject(protocol_parameters.get(), "location"_s, true);
    auto in_opt_options = m_backendDispatcher->getObject(protocol_parameters.get(), "options"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.setBreakpoint' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setBreakpoint(protocol_requestId, in_location.releaseNonNull(), WTFMove(in_opt_options));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setBreakpoint(in_location.releaseNonNull(), WTFMove(in_opt_options));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_breakpointId, out_actualLocation] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("breakpointId"_s, out_breakpointId);
    protocol_jsonMessage->setObject("actualLocation"_s, WTFMove(out_actualLocation));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::removeBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_breakpointId = m_backendDispatcher->getString(protocol_parameters.get(), "breakpointId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.removeBreakpoint' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->removeBreakpoint(protocol_requestId, in_breakpointId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->removeBreakpoint(in_breakpointId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::addSymbolicBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_symbol = m_backendDispatcher->getString(protocol_parameters.get(), "symbol"_s, true);
    auto in_opt_caseSensitive = m_backendDispatcher->getBoolean(protocol_parameters.get(), "caseSensitive"_s, false);
    auto in_opt_isRegex = m_backendDispatcher->getBoolean(protocol_parameters.get(), "isRegex"_s, false);
    auto in_opt_options = m_backendDispatcher->getObject(protocol_parameters.get(), "options"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.addSymbolicBreakpoint' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->addSymbolicBreakpoint(protocol_requestId, in_symbol, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex), WTFMove(in_opt_options));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->addSymbolicBreakpoint(in_symbol, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex), WTFMove(in_opt_options));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::removeSymbolicBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_symbol = m_backendDispatcher->getString(protocol_parameters.get(), "symbol"_s, true);
    auto in_opt_caseSensitive = m_backendDispatcher->getBoolean(protocol_parameters.get(), "caseSensitive"_s, false);
    auto in_opt_isRegex = m_backendDispatcher->getBoolean(protocol_parameters.get(), "isRegex"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.removeSymbolicBreakpoint' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->removeSymbolicBreakpoint(protocol_requestId, in_symbol, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->removeSymbolicBreakpoint(in_symbol, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::continueUntilNextRunLoop(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->continueUntilNextRunLoop(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->continueUntilNextRunLoop();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::continueToLocation(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_location = m_backendDispatcher->getObject(protocol_parameters.get(), "location"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.continueToLocation' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->continueToLocation(protocol_requestId, in_location.releaseNonNull());
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->continueToLocation(in_location.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::stepNext(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->stepNext(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->stepNext();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::stepOver(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->stepOver(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->stepOver();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::stepInto(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->stepInto(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->stepInto();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::stepOut(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->stepOut(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->stepOut();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::pause(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->pause(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->pause();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::resume(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->resume(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->resume();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::searchInContent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_scriptId = m_backendDispatcher->getString(protocol_parameters.get(), "scriptId"_s, true);
    auto in_query = m_backendDispatcher->getString(protocol_parameters.get(), "query"_s, true);
    auto in_opt_caseSensitive = m_backendDispatcher->getBoolean(protocol_parameters.get(), "caseSensitive"_s, false);
    auto in_opt_isRegex = m_backendDispatcher->getBoolean(protocol_parameters.get(), "isRegex"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.searchInContent' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->searchInContent(protocol_requestId, in_scriptId, in_query, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->searchInContent(in_scriptId, in_query, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_result = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("result"_s, WTFMove(out_result));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::getScriptSource(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_scriptId = m_backendDispatcher->getString(protocol_parameters.get(), "scriptId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.getScriptSource' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getScriptSource(protocol_requestId, in_scriptId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getScriptSource(in_scriptId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_scriptSource = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("scriptSource"_s, out_scriptSource);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::getFunctionDetails(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_functionId = m_backendDispatcher->getString(protocol_parameters.get(), "functionId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.getFunctionDetails' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getFunctionDetails(protocol_requestId, in_functionId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getFunctionDetails(in_functionId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_details = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("details"_s, WTFMove(out_details));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::getBreakpointLocations(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_start = m_backendDispatcher->getObject(protocol_parameters.get(), "start"_s, true);
    auto in_end = m_backendDispatcher->getObject(protocol_parameters.get(), "end"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.getBreakpointLocations' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getBreakpointLocations(protocol_requestId, in_start.releaseNonNull(), in_end.releaseNonNull());
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getBreakpointLocations(in_start.releaseNonNull(), in_end.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_locations = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("locations"_s, WTFMove(out_locations));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::setPauseOnDebuggerStatements(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_enabled = m_backendDispatcher->getBoolean(protocol_parameters.get(), "enabled"_s, true);
    auto in_opt_options = m_backendDispatcher->getObject(protocol_parameters.get(), "options"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.setPauseOnDebuggerStatements' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setPauseOnDebuggerStatements(protocol_requestId, *in_enabled, WTFMove(in_opt_options));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setPauseOnDebuggerStatements(*in_enabled, WTFMove(in_opt_options));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::setPauseOnExceptions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_state = m_backendDispatcher->getString(protocol_parameters.get(), "state"_s, true);
    auto in_opt_options = m_backendDispatcher->getObject(protocol_parameters.get(), "options"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.setPauseOnExceptions' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setPauseOnExceptions(protocol_requestId, in_state, WTFMove(in_opt_options));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setPauseOnExceptions(in_state, WTFMove(in_opt_options));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::setPauseOnAssertions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_enabled = m_backendDispatcher->getBoolean(protocol_parameters.get(), "enabled"_s, true);
    auto in_opt_options = m_backendDispatcher->getObject(protocol_parameters.get(), "options"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.setPauseOnAssertions' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setPauseOnAssertions(protocol_requestId, *in_enabled, WTFMove(in_opt_options));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setPauseOnAssertions(*in_enabled, WTFMove(in_opt_options));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::setPauseOnMicrotasks(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_enabled = m_backendDispatcher->getBoolean(protocol_parameters.get(), "enabled"_s, true);
    auto in_opt_options = m_backendDispatcher->getObject(protocol_parameters.get(), "options"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.setPauseOnMicrotasks' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setPauseOnMicrotasks(protocol_requestId, *in_enabled, WTFMove(in_opt_options));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setPauseOnMicrotasks(*in_enabled, WTFMove(in_opt_options));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::setPauseForInternalScripts(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_shouldPause = m_backendDispatcher->getBoolean(protocol_parameters.get(), "shouldPause"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.setPauseForInternalScripts' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setPauseForInternalScripts(protocol_requestId, *in_shouldPause);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setPauseForInternalScripts(*in_shouldPause);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::evaluateOnCallFrame(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_callFrameId = m_backendDispatcher->getString(protocol_parameters.get(), "callFrameId"_s, true);
    auto in_expression = m_backendDispatcher->getString(protocol_parameters.get(), "expression"_s, true);
    auto in_opt_objectGroup = m_backendDispatcher->getString(protocol_parameters.get(), "objectGroup"_s, false);
    auto in_opt_includeCommandLineAPI = m_backendDispatcher->getBoolean(protocol_parameters.get(), "includeCommandLineAPI"_s, false);
    auto in_opt_doNotPauseOnExceptionsAndMuteConsole = m_backendDispatcher->getBoolean(protocol_parameters.get(), "doNotPauseOnExceptionsAndMuteConsole"_s, false);
    auto in_opt_returnByValue = m_backendDispatcher->getBoolean(protocol_parameters.get(), "returnByValue"_s, false);
    auto in_opt_generatePreview = m_backendDispatcher->getBoolean(protocol_parameters.get(), "generatePreview"_s, false);
    auto in_opt_saveResult = m_backendDispatcher->getBoolean(protocol_parameters.get(), "saveResult"_s, false);
    auto in_opt_emulateUserGesture = m_backendDispatcher->getBoolean(protocol_parameters.get(), "emulateUserGesture"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.evaluateOnCallFrame' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->evaluateOnCallFrame(protocol_requestId, in_callFrameId, in_expression, in_opt_objectGroup, WTFMove(in_opt_includeCommandLineAPI), WTFMove(in_opt_doNotPauseOnExceptionsAndMuteConsole), WTFMove(in_opt_returnByValue), WTFMove(in_opt_generatePreview), WTFMove(in_opt_saveResult), WTFMove(in_opt_emulateUserGesture));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->evaluateOnCallFrame(in_callFrameId, in_expression, in_opt_objectGroup, WTFMove(in_opt_includeCommandLineAPI), WTFMove(in_opt_doNotPauseOnExceptionsAndMuteConsole), WTFMove(in_opt_returnByValue), WTFMove(in_opt_generatePreview), WTFMove(in_opt_saveResult), WTFMove(in_opt_emulateUserGesture));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_result, out_opt_wasThrown, out_opt_savedResultIndex] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("result"_s, WTFMove(out_result));
    if (!!out_opt_wasThrown)
        protocol_jsonMessage->setBoolean("wasThrown"_s, *out_opt_wasThrown);
    if (!!out_opt_savedResultIndex)
        protocol_jsonMessage->setInteger("savedResultIndex"_s, *out_opt_savedResultIndex);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::setShouldBlackboxURL(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, true);
    auto in_shouldBlackbox = m_backendDispatcher->getBoolean(protocol_parameters.get(), "shouldBlackbox"_s, true);
    auto in_opt_caseSensitive = m_backendDispatcher->getBoolean(protocol_parameters.get(), "caseSensitive"_s, false);
    auto in_opt_isRegex = m_backendDispatcher->getBoolean(protocol_parameters.get(), "isRegex"_s, false);
    auto in_opt_sourceRanges = m_backendDispatcher->getArray(protocol_parameters.get(), "sourceRanges"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.setShouldBlackboxURL' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setShouldBlackboxURL(protocol_requestId, in_url, *in_shouldBlackbox, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex), WTFMove(in_opt_sourceRanges));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setShouldBlackboxURL(in_url, *in_shouldBlackbox, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex), WTFMove(in_opt_sourceRanges));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void DebuggerBackendDispatcher::setBlackboxBreakpointEvaluations(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_blackboxBreakpointEvaluations = m_backendDispatcher->getBoolean(protocol_parameters.get(), "blackboxBreakpointEvaluations"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Debugger.setBlackboxBreakpointEvaluations' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setBlackboxBreakpointEvaluations(protocol_requestId, *in_blackboxBreakpointEvaluations);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setBlackboxBreakpointEvaluations(*in_blackboxBreakpointEvaluations);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<HeapBackendDispatcher> HeapBackendDispatcher::create(BackendDispatcher& backendDispatcher, HeapBackendDispatcherHandler* agent)
{
    return adoptRef(*new HeapBackendDispatcher(backendDispatcher, agent));
}

HeapBackendDispatcher::HeapBackendDispatcher(BackendDispatcher& backendDispatcher, HeapBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Heap"_s, this);
}

void HeapBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<HeapBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (HeapBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "enable"_s, &HeapBackendDispatcher::enable },
        { "disable"_s, &HeapBackendDispatcher::disable },
        { "gc"_s, &HeapBackendDispatcher::gc },
        { "snapshot"_s, &HeapBackendDispatcher::snapshot },
        { "startTracking"_s, &HeapBackendDispatcher::startTracking },
        { "stopTracking"_s, &HeapBackendDispatcher::stopTracking },
        { "getPreview"_s, &HeapBackendDispatcher::getPreview },
        { "getRemoteObject"_s, &HeapBackendDispatcher::getRemoteObject },
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Heap."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void HeapBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void HeapBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void HeapBackendDispatcher::gc(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->gc(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->gc();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void HeapBackendDispatcher::snapshot(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->snapshot(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->snapshot();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_timestamp, out_snapshotData] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setDouble("timestamp"_s, out_timestamp);
    protocol_jsonMessage->setString("snapshotData"_s, out_snapshotData);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void HeapBackendDispatcher::startTracking(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->startTracking(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->startTracking();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void HeapBackendDispatcher::stopTracking(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->stopTracking(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->stopTracking();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void HeapBackendDispatcher::getPreview(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_heapObjectId = m_backendDispatcher->getInteger(protocol_parameters.get(), "heapObjectId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Heap.getPreview' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getPreview(protocol_requestId, *in_heapObjectId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getPreview(*in_heapObjectId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_opt_string, out_opt_functionDetails, out_opt_preview] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    if (!!out_opt_string)
        protocol_jsonMessage->setString("string"_s, out_opt_string);
    if (!!out_opt_functionDetails)
        protocol_jsonMessage->setObject("functionDetails"_s, out_opt_functionDetails.releaseNonNull());
    if (!!out_opt_preview)
        protocol_jsonMessage->setObject("preview"_s, out_opt_preview.releaseNonNull());
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void HeapBackendDispatcher::getRemoteObject(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_heapObjectId = m_backendDispatcher->getInteger(protocol_parameters.get(), "heapObjectId"_s, true);
    auto in_opt_objectGroup = m_backendDispatcher->getString(protocol_parameters.get(), "objectGroup"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Heap.getRemoteObject' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getRemoteObject(protocol_requestId, *in_heapObjectId, in_opt_objectGroup);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getRemoteObject(*in_heapObjectId, in_opt_objectGroup);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_result = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("result"_s, WTFMove(out_result));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<IndexedDBBackendDispatcher> IndexedDBBackendDispatcher::create(BackendDispatcher& backendDispatcher, IndexedDBBackendDispatcherHandler* agent)
{
    return adoptRef(*new IndexedDBBackendDispatcher(backendDispatcher, agent));
}

IndexedDBBackendDispatcher::IndexedDBBackendDispatcher(BackendDispatcher& backendDispatcher, IndexedDBBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("IndexedDB"_s, this);
}

void IndexedDBBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<IndexedDBBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (IndexedDBBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "enable"_s, &IndexedDBBackendDispatcher::enable },
        { "disable"_s, &IndexedDBBackendDispatcher::disable },
        { "requestDatabaseNames"_s, &IndexedDBBackendDispatcher::requestDatabaseNames },
        { "requestDatabase"_s, &IndexedDBBackendDispatcher::requestDatabase },
        { "requestData"_s, &IndexedDBBackendDispatcher::requestData },
        { "clearObjectStore"_s, &IndexedDBBackendDispatcher::clearObjectStore },
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'IndexedDB."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void IndexedDBBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void IndexedDBBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

IndexedDBBackendDispatcherHandler::RequestDatabaseNamesCallback::RequestDatabaseNamesCallback(Ref<BackendDispatcher>&& backendDispatcher, int id) : BackendDispatcher::CallbackBase(WTFMove(backendDispatcher), id) { }

void IndexedDBBackendDispatcherHandler::RequestDatabaseNamesCallback::sendSuccess(Ref<JSON::ArrayOf<String>>&& databaseNames)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("databaseNames"_s, WTFMove(databaseNames));
    CallbackBase::sendSuccess(WTFMove(protocol_jsonMessage));
}

void IndexedDBBackendDispatcher::requestDatabaseNames(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_securityOrigin = m_backendDispatcher->getString(protocol_parameters.get(), "securityOrigin"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'IndexedDB.requestDatabaseNames' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->requestDatabaseNames(protocol_requestId, in_securityOrigin);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    m_agent->requestDatabaseNames(in_securityOrigin, adoptRef(*new IndexedDBBackendDispatcherHandler::RequestDatabaseNamesCallback(m_backendDispatcher.copyRef(), protocol_requestId)));
}

IndexedDBBackendDispatcherHandler::RequestDatabaseCallback::RequestDatabaseCallback(Ref<BackendDispatcher>&& backendDispatcher, int id) : BackendDispatcher::CallbackBase(WTFMove(backendDispatcher), id) { }

void IndexedDBBackendDispatcherHandler::RequestDatabaseCallback::sendSuccess(Ref<Protocol::IndexedDB::DatabaseWithObjectStores>&& databaseWithObjectStores)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("databaseWithObjectStores"_s, WTFMove(databaseWithObjectStores));
    CallbackBase::sendSuccess(WTFMove(protocol_jsonMessage));
}

void IndexedDBBackendDispatcher::requestDatabase(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_securityOrigin = m_backendDispatcher->getString(protocol_parameters.get(), "securityOrigin"_s, true);
    auto in_databaseName = m_backendDispatcher->getString(protocol_parameters.get(), "databaseName"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'IndexedDB.requestDatabase' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->requestDatabase(protocol_requestId, in_securityOrigin, in_databaseName);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    m_agent->requestDatabase(in_securityOrigin, in_databaseName, adoptRef(*new IndexedDBBackendDispatcherHandler::RequestDatabaseCallback(m_backendDispatcher.copyRef(), protocol_requestId)));
}

IndexedDBBackendDispatcherHandler::RequestDataCallback::RequestDataCallback(Ref<BackendDispatcher>&& backendDispatcher, int id) : BackendDispatcher::CallbackBase(WTFMove(backendDispatcher), id) { }

void IndexedDBBackendDispatcherHandler::RequestDataCallback::sendSuccess(Ref<JSON::ArrayOf<Protocol::IndexedDB::DataEntry>>&& objectStoreDataEntries, bool hasMore)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("objectStoreDataEntries"_s, WTFMove(objectStoreDataEntries));
    protocol_jsonMessage->setBoolean("hasMore"_s, hasMore);
    CallbackBase::sendSuccess(WTFMove(protocol_jsonMessage));
}

void IndexedDBBackendDispatcher::requestData(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_securityOrigin = m_backendDispatcher->getString(protocol_parameters.get(), "securityOrigin"_s, true);
    auto in_databaseName = m_backendDispatcher->getString(protocol_parameters.get(), "databaseName"_s, true);
    auto in_objectStoreName = m_backendDispatcher->getString(protocol_parameters.get(), "objectStoreName"_s, true);
    auto in_indexName = m_backendDispatcher->getString(protocol_parameters.get(), "indexName"_s, true);
    auto in_skipCount = m_backendDispatcher->getInteger(protocol_parameters.get(), "skipCount"_s, true);
    auto in_pageSize = m_backendDispatcher->getInteger(protocol_parameters.get(), "pageSize"_s, true);
    auto in_opt_keyRange = m_backendDispatcher->getObject(protocol_parameters.get(), "keyRange"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'IndexedDB.requestData' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->requestData(protocol_requestId, in_securityOrigin, in_databaseName, in_objectStoreName, in_indexName, *in_skipCount, *in_pageSize, WTFMove(in_opt_keyRange));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    m_agent->requestData(in_securityOrigin, in_databaseName, in_objectStoreName, in_indexName, *in_skipCount, *in_pageSize, WTFMove(in_opt_keyRange), adoptRef(*new IndexedDBBackendDispatcherHandler::RequestDataCallback(m_backendDispatcher.copyRef(), protocol_requestId)));
}

IndexedDBBackendDispatcherHandler::ClearObjectStoreCallback::ClearObjectStoreCallback(Ref<BackendDispatcher>&& backendDispatcher, int id) : BackendDispatcher::CallbackBase(WTFMove(backendDispatcher), id) { }

void IndexedDBBackendDispatcherHandler::ClearObjectStoreCallback::sendSuccess()
{
    auto protocol_jsonMessage = JSON::Object::create();

    CallbackBase::sendSuccess(WTFMove(protocol_jsonMessage));
}

void IndexedDBBackendDispatcher::clearObjectStore(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_securityOrigin = m_backendDispatcher->getString(protocol_parameters.get(), "securityOrigin"_s, true);
    auto in_databaseName = m_backendDispatcher->getString(protocol_parameters.get(), "databaseName"_s, true);
    auto in_objectStoreName = m_backendDispatcher->getString(protocol_parameters.get(), "objectStoreName"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'IndexedDB.clearObjectStore' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->clearObjectStore(protocol_requestId, in_securityOrigin, in_databaseName, in_objectStoreName);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    m_agent->clearObjectStore(in_securityOrigin, in_databaseName, in_objectStoreName, adoptRef(*new IndexedDBBackendDispatcherHandler::ClearObjectStoreCallback(m_backendDispatcher.copyRef(), protocol_requestId)));
}

Ref<InspectorBackendDispatcher> InspectorBackendDispatcher::create(BackendDispatcher& backendDispatcher, InspectorBackendDispatcherHandler* agent)
{
    return adoptRef(*new InspectorBackendDispatcher(backendDispatcher, agent));
}

InspectorBackendDispatcher::InspectorBackendDispatcher(BackendDispatcher& backendDispatcher, InspectorBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Inspector"_s, this);
}

void InspectorBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<InspectorBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    if (protocol_method == "enable"_s) {
        enable(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "disable"_s) {
        disable(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "initialized"_s) {
        initialized(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }

    m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Inspector."_s, protocol_method, "' was not found"_s));
}

void InspectorBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void InspectorBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void InspectorBackendDispatcher::initialized(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->initialized(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->initialized();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<LayerTreeBackendDispatcher> LayerTreeBackendDispatcher::create(BackendDispatcher& backendDispatcher, LayerTreeBackendDispatcherHandler* agent)
{
    return adoptRef(*new LayerTreeBackendDispatcher(backendDispatcher, agent));
}

LayerTreeBackendDispatcher::LayerTreeBackendDispatcher(BackendDispatcher& backendDispatcher, LayerTreeBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("LayerTree"_s, this);
}

void LayerTreeBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<LayerTreeBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    if (protocol_method == "enable"_s) {
        enable(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "disable"_s) {
        disable(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "layersForNode"_s) {
        layersForNode(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "reasonsForCompositingLayer"_s) {
        reasonsForCompositingLayer(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }

    m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'LayerTree."_s, protocol_method, "' was not found"_s));
}

void LayerTreeBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void LayerTreeBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void LayerTreeBackendDispatcher::layersForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'LayerTree.layersForNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->layersForNode(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->layersForNode(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_layers = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("layers"_s, WTFMove(out_layers));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void LayerTreeBackendDispatcher::reasonsForCompositingLayer(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_layerId = m_backendDispatcher->getString(protocol_parameters.get(), "layerId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'LayerTree.reasonsForCompositingLayer' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->reasonsForCompositingLayer(protocol_requestId, in_layerId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->reasonsForCompositingLayer(in_layerId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_compositingReasons = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("compositingReasons"_s, WTFMove(out_compositingReasons));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
Ref<MemoryBackendDispatcher> MemoryBackendDispatcher::create(BackendDispatcher& backendDispatcher, MemoryBackendDispatcherHandler* agent)
{
    return adoptRef(*new MemoryBackendDispatcher(backendDispatcher, agent));
}

MemoryBackendDispatcher::MemoryBackendDispatcher(BackendDispatcher& backendDispatcher, MemoryBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Memory"_s, this);
}

void MemoryBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<MemoryBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    if (protocol_method == "enable"_s) {
        enable(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "disable"_s) {
        disable(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "startTracking"_s) {
        startTracking(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "stopTracking"_s) {
        stopTracking(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }

    m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Memory."_s, protocol_method, "' was not found"_s));
}

void MemoryBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void MemoryBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void MemoryBackendDispatcher::startTracking(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->startTracking(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->startTracking();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void MemoryBackendDispatcher::stopTracking(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->stopTracking(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->stopTracking();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

Ref<NetworkBackendDispatcher> NetworkBackendDispatcher::create(BackendDispatcher& backendDispatcher, NetworkBackendDispatcherHandler* agent)
{
    return adoptRef(*new NetworkBackendDispatcher(backendDispatcher, agent));
}

NetworkBackendDispatcher::NetworkBackendDispatcher(BackendDispatcher& backendDispatcher, NetworkBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Network"_s, this);
}

void NetworkBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<NetworkBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (NetworkBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "enable"_s, &NetworkBackendDispatcher::enable },
        { "disable"_s, &NetworkBackendDispatcher::disable },
        { "setExtraHTTPHeaders"_s, &NetworkBackendDispatcher::setExtraHTTPHeaders },
        { "getResponseBody"_s, &NetworkBackendDispatcher::getResponseBody },
        { "setResourceCachingDisabled"_s, &NetworkBackendDispatcher::setResourceCachingDisabled },
        { "loadResource"_s, &NetworkBackendDispatcher::loadResource },
        { "getSerializedCertificate"_s, &NetworkBackendDispatcher::getSerializedCertificate },
        { "resolveWebSocket"_s, &NetworkBackendDispatcher::resolveWebSocket },
        { "setInterceptionEnabled"_s, &NetworkBackendDispatcher::setInterceptionEnabled },
        { "addInterception"_s, &NetworkBackendDispatcher::addInterception },
        { "removeInterception"_s, &NetworkBackendDispatcher::removeInterception },
        { "interceptContinue"_s, &NetworkBackendDispatcher::interceptContinue },
        { "interceptWithRequest"_s, &NetworkBackendDispatcher::interceptWithRequest },
        { "interceptWithResponse"_s, &NetworkBackendDispatcher::interceptWithResponse },
        { "interceptRequestWithResponse"_s, &NetworkBackendDispatcher::interceptRequestWithResponse },
        { "interceptRequestWithError"_s, &NetworkBackendDispatcher::interceptRequestWithError },
#if defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING
        { "setEmulatedConditions"_s, &NetworkBackendDispatcher::setEmulatedConditions },
#endif // defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Network."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void NetworkBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void NetworkBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void NetworkBackendDispatcher::setExtraHTTPHeaders(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_headers = m_backendDispatcher->getObject(protocol_parameters.get(), "headers"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.setExtraHTTPHeaders' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setExtraHTTPHeaders(protocol_requestId, in_headers.releaseNonNull());
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setExtraHTTPHeaders(in_headers.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void NetworkBackendDispatcher::getResponseBody(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_requestId = m_backendDispatcher->getString(protocol_parameters.get(), "requestId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.getResponseBody' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getResponseBody(protocol_requestId, in_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getResponseBody(in_requestId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_body, out_base64Encoded] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("body"_s, out_body);
    protocol_jsonMessage->setBoolean("base64Encoded"_s, out_base64Encoded);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void NetworkBackendDispatcher::setResourceCachingDisabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_disabled = m_backendDispatcher->getBoolean(protocol_parameters.get(), "disabled"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.setResourceCachingDisabled' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setResourceCachingDisabled(protocol_requestId, *in_disabled);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setResourceCachingDisabled(*in_disabled);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

NetworkBackendDispatcherHandler::LoadResourceCallback::LoadResourceCallback(Ref<BackendDispatcher>&& backendDispatcher, int id) : BackendDispatcher::CallbackBase(WTFMove(backendDispatcher), id) { }

void NetworkBackendDispatcherHandler::LoadResourceCallback::sendSuccess(const String& content, const String& mimeType, int status)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("content"_s, content);
    protocol_jsonMessage->setString("mimeType"_s, mimeType);
    protocol_jsonMessage->setInteger("status"_s, status);
    CallbackBase::sendSuccess(WTFMove(protocol_jsonMessage));
}

void NetworkBackendDispatcher::loadResource(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_frameId = m_backendDispatcher->getString(protocol_parameters.get(), "frameId"_s, true);
    auto in_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.loadResource' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->loadResource(protocol_requestId, in_frameId, in_url);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    m_agent->loadResource(in_frameId, in_url, adoptRef(*new NetworkBackendDispatcherHandler::LoadResourceCallback(m_backendDispatcher.copyRef(), protocol_requestId)));
}

void NetworkBackendDispatcher::getSerializedCertificate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_requestId = m_backendDispatcher->getString(protocol_parameters.get(), "requestId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.getSerializedCertificate' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getSerializedCertificate(protocol_requestId, in_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getSerializedCertificate(in_requestId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_serializedCertificate = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("serializedCertificate"_s, out_serializedCertificate);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void NetworkBackendDispatcher::resolveWebSocket(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_requestId = m_backendDispatcher->getString(protocol_parameters.get(), "requestId"_s, true);
    auto in_opt_objectGroup = m_backendDispatcher->getString(protocol_parameters.get(), "objectGroup"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.resolveWebSocket' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->resolveWebSocket(protocol_requestId, in_requestId, in_opt_objectGroup);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->resolveWebSocket(in_requestId, in_opt_objectGroup);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_object = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("object"_s, WTFMove(out_object));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void NetworkBackendDispatcher::setInterceptionEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_enabled = m_backendDispatcher->getBoolean(protocol_parameters.get(), "enabled"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.setInterceptionEnabled' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setInterceptionEnabled(protocol_requestId, *in_enabled);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setInterceptionEnabled(*in_enabled);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void NetworkBackendDispatcher::addInterception(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, true);
    auto in_stage_json = m_backendDispatcher->getString(protocol_parameters.get(), "stage"_s, true);
    auto in_opt_caseSensitive = m_backendDispatcher->getBoolean(protocol_parameters.get(), "caseSensitive"_s, false);
    auto in_opt_isRegex = m_backendDispatcher->getBoolean(protocol_parameters.get(), "isRegex"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.addInterception' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->addInterception(protocol_requestId, in_url, in_stage_json, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_stage = Protocol::Helpers::parseEnumValueFromString<Protocol::Network::NetworkStage>(in_stage_json);
    if (!in_stage) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown stage: "_s, in_stage_json));
        return;
    }

    auto result = m_agent->addInterception(in_url, *in_stage, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void NetworkBackendDispatcher::removeInterception(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, true);
    auto in_stage_json = m_backendDispatcher->getString(protocol_parameters.get(), "stage"_s, true);
    auto in_opt_caseSensitive = m_backendDispatcher->getBoolean(protocol_parameters.get(), "caseSensitive"_s, false);
    auto in_opt_isRegex = m_backendDispatcher->getBoolean(protocol_parameters.get(), "isRegex"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.removeInterception' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->removeInterception(protocol_requestId, in_url, in_stage_json, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_stage = Protocol::Helpers::parseEnumValueFromString<Protocol::Network::NetworkStage>(in_stage_json);
    if (!in_stage) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown stage: "_s, in_stage_json));
        return;
    }

    auto result = m_agent->removeInterception(in_url, *in_stage, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void NetworkBackendDispatcher::interceptContinue(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_requestId = m_backendDispatcher->getString(protocol_parameters.get(), "requestId"_s, true);
    auto in_stage_json = m_backendDispatcher->getString(protocol_parameters.get(), "stage"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.interceptContinue' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->interceptContinue(protocol_requestId, in_requestId, in_stage_json);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_stage = Protocol::Helpers::parseEnumValueFromString<Protocol::Network::NetworkStage>(in_stage_json);
    if (!in_stage) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown stage: "_s, in_stage_json));
        return;
    }

    auto result = m_agent->interceptContinue(in_requestId, *in_stage);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void NetworkBackendDispatcher::interceptWithRequest(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_requestId = m_backendDispatcher->getString(protocol_parameters.get(), "requestId"_s, true);
    auto in_opt_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, false);
    auto in_opt_method = m_backendDispatcher->getString(protocol_parameters.get(), "method"_s, false);
    auto in_opt_headers = m_backendDispatcher->getObject(protocol_parameters.get(), "headers"_s, false);
    auto in_opt_postData = m_backendDispatcher->getString(protocol_parameters.get(), "postData"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.interceptWithRequest' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->interceptWithRequest(protocol_requestId, in_requestId, in_opt_url, in_opt_method, WTFMove(in_opt_headers), in_opt_postData);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->interceptWithRequest(in_requestId, in_opt_url, in_opt_method, WTFMove(in_opt_headers), in_opt_postData);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void NetworkBackendDispatcher::interceptWithResponse(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_requestId = m_backendDispatcher->getString(protocol_parameters.get(), "requestId"_s, true);
    auto in_content = m_backendDispatcher->getString(protocol_parameters.get(), "content"_s, true);
    auto in_base64Encoded = m_backendDispatcher->getBoolean(protocol_parameters.get(), "base64Encoded"_s, true);
    auto in_opt_mimeType = m_backendDispatcher->getString(protocol_parameters.get(), "mimeType"_s, false);
    auto in_opt_status = m_backendDispatcher->getInteger(protocol_parameters.get(), "status"_s, false);
    auto in_opt_statusText = m_backendDispatcher->getString(protocol_parameters.get(), "statusText"_s, false);
    auto in_opt_headers = m_backendDispatcher->getObject(protocol_parameters.get(), "headers"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.interceptWithResponse' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->interceptWithResponse(protocol_requestId, in_requestId, in_content, *in_base64Encoded, in_opt_mimeType, WTFMove(in_opt_status), in_opt_statusText, WTFMove(in_opt_headers));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->interceptWithResponse(in_requestId, in_content, *in_base64Encoded, in_opt_mimeType, WTFMove(in_opt_status), in_opt_statusText, WTFMove(in_opt_headers));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void NetworkBackendDispatcher::interceptRequestWithResponse(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_requestId = m_backendDispatcher->getString(protocol_parameters.get(), "requestId"_s, true);
    auto in_content = m_backendDispatcher->getString(protocol_parameters.get(), "content"_s, true);
    auto in_base64Encoded = m_backendDispatcher->getBoolean(protocol_parameters.get(), "base64Encoded"_s, true);
    auto in_mimeType = m_backendDispatcher->getString(protocol_parameters.get(), "mimeType"_s, true);
    auto in_status = m_backendDispatcher->getInteger(protocol_parameters.get(), "status"_s, true);
    auto in_statusText = m_backendDispatcher->getString(protocol_parameters.get(), "statusText"_s, true);
    auto in_headers = m_backendDispatcher->getObject(protocol_parameters.get(), "headers"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.interceptRequestWithResponse' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->interceptRequestWithResponse(protocol_requestId, in_requestId, in_content, *in_base64Encoded, in_mimeType, *in_status, in_statusText, in_headers.releaseNonNull());
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->interceptRequestWithResponse(in_requestId, in_content, *in_base64Encoded, in_mimeType, *in_status, in_statusText, in_headers.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void NetworkBackendDispatcher::interceptRequestWithError(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_requestId = m_backendDispatcher->getString(protocol_parameters.get(), "requestId"_s, true);
    auto in_errorType_json = m_backendDispatcher->getString(protocol_parameters.get(), "errorType"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.interceptRequestWithError' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->interceptRequestWithError(protocol_requestId, in_requestId, in_errorType_json);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_errorType = Protocol::Helpers::parseEnumValueFromString<Protocol::Network::ResourceErrorType>(in_errorType_json);
    if (!in_errorType) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown errorType: "_s, in_errorType_json));
        return;
    }

    auto result = m_agent->interceptRequestWithError(in_requestId, *in_errorType);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

#if defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING
void NetworkBackendDispatcher::setEmulatedConditions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_bytesPerSecondLimit = m_backendDispatcher->getInteger(protocol_parameters.get(), "bytesPerSecondLimit"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Network.setEmulatedConditions' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setEmulatedConditions(protocol_requestId, WTFMove(in_opt_bytesPerSecondLimit));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setEmulatedConditions(WTFMove(in_opt_bytesPerSecondLimit));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING

Ref<PageBackendDispatcher> PageBackendDispatcher::create(BackendDispatcher& backendDispatcher, PageBackendDispatcherHandler* agent)
{
    return adoptRef(*new PageBackendDispatcher(backendDispatcher, agent));
}

PageBackendDispatcher::PageBackendDispatcher(BackendDispatcher& backendDispatcher, PageBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Page"_s, this);
}

void PageBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<PageBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (PageBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "enable"_s, &PageBackendDispatcher::enable },
        { "disable"_s, &PageBackendDispatcher::disable },
        { "reload"_s, &PageBackendDispatcher::reload },
        { "navigate"_s, &PageBackendDispatcher::navigate },
        { "overrideUserAgent"_s, &PageBackendDispatcher::overrideUserAgent },
        { "overrideSetting"_s, &PageBackendDispatcher::overrideSetting },
        { "overrideUserPreference"_s, &PageBackendDispatcher::overrideUserPreference },
        { "getCookies"_s, &PageBackendDispatcher::getCookies },
        { "setCookie"_s, &PageBackendDispatcher::setCookie },
        { "deleteCookie"_s, &PageBackendDispatcher::deleteCookie },
        { "getResourceTree"_s, &PageBackendDispatcher::getResourceTree },
        { "getResourceContent"_s, &PageBackendDispatcher::getResourceContent },
        { "setBootstrapScript"_s, &PageBackendDispatcher::setBootstrapScript },
        { "searchInResource"_s, &PageBackendDispatcher::searchInResource },
        { "searchInResources"_s, &PageBackendDispatcher::searchInResources },
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
        { "setShowRulers"_s, &PageBackendDispatcher::setShowRulers },
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
        { "setShowPaintRects"_s, &PageBackendDispatcher::setShowPaintRects },
        { "setEmulatedMedia"_s, &PageBackendDispatcher::setEmulatedMedia },
        { "snapshotNode"_s, &PageBackendDispatcher::snapshotNode },
        { "snapshotRect"_s, &PageBackendDispatcher::snapshotRect },
#if (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
        { "archive"_s, &PageBackendDispatcher::archive },
#endif // (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
#if !(defined(WTF_PLATFORM_COCOA) && WTF_PLATFORM_COCOA)
        { "setScreenSizeOverride"_s, &PageBackendDispatcher::setScreenSizeOverride },
#endif // !(defined(WTF_PLATFORM_COCOA) && WTF_PLATFORM_COCOA)
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Page."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void PageBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::reload(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_ignoreCache = m_backendDispatcher->getBoolean(protocol_parameters.get(), "ignoreCache"_s, false);
    auto in_opt_revalidateAllResources = m_backendDispatcher->getBoolean(protocol_parameters.get(), "revalidateAllResources"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.reload' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->reload(protocol_requestId, WTFMove(in_opt_ignoreCache), WTFMove(in_opt_revalidateAllResources));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->reload(WTFMove(in_opt_ignoreCache), WTFMove(in_opt_revalidateAllResources));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::navigate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.navigate' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->navigate(protocol_requestId, in_url);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->navigate(in_url);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::overrideUserAgent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_value = m_backendDispatcher->getString(protocol_parameters.get(), "value"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.overrideUserAgent' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->overrideUserAgent(protocol_requestId, in_opt_value);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->overrideUserAgent(in_opt_value);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::overrideSetting(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_setting_json = m_backendDispatcher->getString(protocol_parameters.get(), "setting"_s, true);
    auto in_opt_value = m_backendDispatcher->getBoolean(protocol_parameters.get(), "value"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.overrideSetting' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->overrideSetting(protocol_requestId, in_setting_json, WTFMove(in_opt_value));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_setting = Protocol::Helpers::parseEnumValueFromString<Protocol::Page::Setting>(in_setting_json);
    if (!in_setting) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown setting: "_s, in_setting_json));
        return;
    }

    auto result = m_agent->overrideSetting(*in_setting, WTFMove(in_opt_value));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::overrideUserPreference(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_name_json = m_backendDispatcher->getString(protocol_parameters.get(), "name"_s, true);
    auto in_opt_value_json = m_backendDispatcher->getString(protocol_parameters.get(), "value"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.overrideUserPreference' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->overrideUserPreference(protocol_requestId, in_name_json, in_opt_value_json);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_name = Protocol::Helpers::parseEnumValueFromString<Protocol::Page::UserPreferenceName>(in_name_json);
    if (!in_name) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown name: "_s, in_name_json));
        return;
    }

    auto in_opt_value = Protocol::Helpers::parseEnumValueFromString<Protocol::Page::UserPreferenceValue>(in_opt_value_json);

    auto result = m_agent->overrideUserPreference(*in_name, WTFMove(in_opt_value));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::getCookies(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getCookies(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getCookies();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_cookies = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("cookies"_s, WTFMove(out_cookies));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::setCookie(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_cookie = m_backendDispatcher->getObject(protocol_parameters.get(), "cookie"_s, true);
    auto in_opt_shouldPartition = m_backendDispatcher->getBoolean(protocol_parameters.get(), "shouldPartition"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.setCookie' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setCookie(protocol_requestId, in_cookie.releaseNonNull(), WTFMove(in_opt_shouldPartition));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setCookie(in_cookie.releaseNonNull(), WTFMove(in_opt_shouldPartition));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::deleteCookie(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_cookieName = m_backendDispatcher->getString(protocol_parameters.get(), "cookieName"_s, true);
    auto in_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.deleteCookie' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->deleteCookie(protocol_requestId, in_cookieName, in_url);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->deleteCookie(in_cookieName, in_url);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::getResourceTree(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getResourceTree(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getResourceTree();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_frameTree = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("frameTree"_s, WTFMove(out_frameTree));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::getResourceContent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_frameId = m_backendDispatcher->getString(protocol_parameters.get(), "frameId"_s, true);
    auto in_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.getResourceContent' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getResourceContent(protocol_requestId, in_frameId, in_url);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getResourceContent(in_frameId, in_url);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_content, out_base64Encoded] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("content"_s, out_content);
    protocol_jsonMessage->setBoolean("base64Encoded"_s, out_base64Encoded);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::setBootstrapScript(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_source = m_backendDispatcher->getString(protocol_parameters.get(), "source"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.setBootstrapScript' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setBootstrapScript(protocol_requestId, in_opt_source);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setBootstrapScript(in_opt_source);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::searchInResource(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_frameId = m_backendDispatcher->getString(protocol_parameters.get(), "frameId"_s, true);
    auto in_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, true);
    auto in_query = m_backendDispatcher->getString(protocol_parameters.get(), "query"_s, true);
    auto in_opt_caseSensitive = m_backendDispatcher->getBoolean(protocol_parameters.get(), "caseSensitive"_s, false);
    auto in_opt_isRegex = m_backendDispatcher->getBoolean(protocol_parameters.get(), "isRegex"_s, false);
    auto in_opt_requestId = m_backendDispatcher->getString(protocol_parameters.get(), "requestId"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.searchInResource' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->searchInResource(protocol_requestId, in_frameId, in_url, in_query, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex), in_opt_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->searchInResource(in_frameId, in_url, in_query, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex), in_opt_requestId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_result = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("result"_s, WTFMove(out_result));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::searchInResources(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_text = m_backendDispatcher->getString(protocol_parameters.get(), "text"_s, true);
    auto in_opt_caseSensitive = m_backendDispatcher->getBoolean(protocol_parameters.get(), "caseSensitive"_s, false);
    auto in_opt_isRegex = m_backendDispatcher->getBoolean(protocol_parameters.get(), "isRegex"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.searchInResources' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->searchInResources(protocol_requestId, in_text, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->searchInResources(in_text, WTFMove(in_opt_caseSensitive), WTFMove(in_opt_isRegex));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_result = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("result"_s, WTFMove(out_result));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
void PageBackendDispatcher::setShowRulers(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_result = m_backendDispatcher->getBoolean(protocol_parameters.get(), "result"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.setShowRulers' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setShowRulers(protocol_requestId, *in_result);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setShowRulers(*in_result);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)

void PageBackendDispatcher::setShowPaintRects(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_result = m_backendDispatcher->getBoolean(protocol_parameters.get(), "result"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.setShowPaintRects' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setShowPaintRects(protocol_requestId, *in_result);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setShowPaintRects(*in_result);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::setEmulatedMedia(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_media = m_backendDispatcher->getString(protocol_parameters.get(), "media"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.setEmulatedMedia' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setEmulatedMedia(protocol_requestId, in_media);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setEmulatedMedia(in_media);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::snapshotNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_nodeId = m_backendDispatcher->getInteger(protocol_parameters.get(), "nodeId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.snapshotNode' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->snapshotNode(protocol_requestId, *in_nodeId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->snapshotNode(*in_nodeId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_dataURL = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("dataURL"_s, out_dataURL);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void PageBackendDispatcher::snapshotRect(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_x = m_backendDispatcher->getInteger(protocol_parameters.get(), "x"_s, true);
    auto in_y = m_backendDispatcher->getInteger(protocol_parameters.get(), "y"_s, true);
    auto in_width = m_backendDispatcher->getInteger(protocol_parameters.get(), "width"_s, true);
    auto in_height = m_backendDispatcher->getInteger(protocol_parameters.get(), "height"_s, true);
    auto in_coordinateSystem_json = m_backendDispatcher->getString(protocol_parameters.get(), "coordinateSystem"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.snapshotRect' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->snapshotRect(protocol_requestId, *in_x, *in_y, *in_width, *in_height, in_coordinateSystem_json);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto in_coordinateSystem = Protocol::Helpers::parseEnumValueFromString<Protocol::Page::CoordinateSystem>(in_coordinateSystem_json);
    if (!in_coordinateSystem) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown coordinateSystem: "_s, in_coordinateSystem_json));
        return;
    }

    auto result = m_agent->snapshotRect(*in_x, *in_y, *in_width, *in_height, *in_coordinateSystem);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_dataURL = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("dataURL"_s, out_dataURL);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

#if (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
void PageBackendDispatcher::archive(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->archive(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->archive();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_data = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("data"_s, out_data);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)

#if !(defined(WTF_PLATFORM_COCOA) && WTF_PLATFORM_COCOA)
void PageBackendDispatcher::setScreenSizeOverride(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_width = m_backendDispatcher->getInteger(protocol_parameters.get(), "width"_s, false);
    auto in_opt_height = m_backendDispatcher->getInteger(protocol_parameters.get(), "height"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Page.setScreenSizeOverride' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setScreenSizeOverride(protocol_requestId, WTFMove(in_opt_width), WTFMove(in_opt_height));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setScreenSizeOverride(WTFMove(in_opt_width), WTFMove(in_opt_height));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // !(defined(WTF_PLATFORM_COCOA) && WTF_PLATFORM_COCOA)

Ref<RuntimeBackendDispatcher> RuntimeBackendDispatcher::create(BackendDispatcher& backendDispatcher, RuntimeBackendDispatcherHandler* agent)
{
    return adoptRef(*new RuntimeBackendDispatcher(backendDispatcher, agent));
}

RuntimeBackendDispatcher::RuntimeBackendDispatcher(BackendDispatcher& backendDispatcher, RuntimeBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Runtime"_s, this);
}

void RuntimeBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<RuntimeBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (RuntimeBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "parse"_s, &RuntimeBackendDispatcher::parse },
        { "evaluate"_s, &RuntimeBackendDispatcher::evaluate },
        { "awaitPromise"_s, &RuntimeBackendDispatcher::awaitPromise },
        { "callFunctionOn"_s, &RuntimeBackendDispatcher::callFunctionOn },
        { "getPreview"_s, &RuntimeBackendDispatcher::getPreview },
        { "getProperties"_s, &RuntimeBackendDispatcher::getProperties },
        { "getDisplayableProperties"_s, &RuntimeBackendDispatcher::getDisplayableProperties },
        { "getCollectionEntries"_s, &RuntimeBackendDispatcher::getCollectionEntries },
        { "saveResult"_s, &RuntimeBackendDispatcher::saveResult },
        { "setSavedResultAlias"_s, &RuntimeBackendDispatcher::setSavedResultAlias },
        { "releaseObject"_s, &RuntimeBackendDispatcher::releaseObject },
        { "releaseObjectGroup"_s, &RuntimeBackendDispatcher::releaseObjectGroup },
        { "enable"_s, &RuntimeBackendDispatcher::enable },
        { "disable"_s, &RuntimeBackendDispatcher::disable },
        { "getRuntimeTypesForVariablesAtOffsets"_s, &RuntimeBackendDispatcher::getRuntimeTypesForVariablesAtOffsets },
        { "enableTypeProfiler"_s, &RuntimeBackendDispatcher::enableTypeProfiler },
        { "disableTypeProfiler"_s, &RuntimeBackendDispatcher::disableTypeProfiler },
        { "enableControlFlowProfiler"_s, &RuntimeBackendDispatcher::enableControlFlowProfiler },
        { "disableControlFlowProfiler"_s, &RuntimeBackendDispatcher::disableControlFlowProfiler },
        { "getBasicBlocks"_s, &RuntimeBackendDispatcher::getBasicBlocks },
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Runtime."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void RuntimeBackendDispatcher::parse(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_source = m_backendDispatcher->getString(protocol_parameters.get(), "source"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.parse' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->parse(protocol_requestId, in_source);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->parse(in_source);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_result, out_opt_message, out_opt_range] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("result"_s, Protocol::Helpers::getEnumConstantValue(out_result));
    if (!!out_opt_message)
        protocol_jsonMessage->setString("message"_s, out_opt_message);
    if (!!out_opt_range)
        protocol_jsonMessage->setObject("range"_s, out_opt_range.releaseNonNull());
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::evaluate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_expression = m_backendDispatcher->getString(protocol_parameters.get(), "expression"_s, true);
    auto in_opt_objectGroup = m_backendDispatcher->getString(protocol_parameters.get(), "objectGroup"_s, false);
    auto in_opt_includeCommandLineAPI = m_backendDispatcher->getBoolean(protocol_parameters.get(), "includeCommandLineAPI"_s, false);
    auto in_opt_doNotPauseOnExceptionsAndMuteConsole = m_backendDispatcher->getBoolean(protocol_parameters.get(), "doNotPauseOnExceptionsAndMuteConsole"_s, false);
    auto in_opt_contextId = m_backendDispatcher->getInteger(protocol_parameters.get(), "contextId"_s, false);
    auto in_opt_returnByValue = m_backendDispatcher->getBoolean(protocol_parameters.get(), "returnByValue"_s, false);
    auto in_opt_generatePreview = m_backendDispatcher->getBoolean(protocol_parameters.get(), "generatePreview"_s, false);
    auto in_opt_saveResult = m_backendDispatcher->getBoolean(protocol_parameters.get(), "saveResult"_s, false);
    auto in_opt_emulateUserGesture = m_backendDispatcher->getBoolean(protocol_parameters.get(), "emulateUserGesture"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.evaluate' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->evaluate(protocol_requestId, in_expression, in_opt_objectGroup, WTFMove(in_opt_includeCommandLineAPI), WTFMove(in_opt_doNotPauseOnExceptionsAndMuteConsole), WTFMove(in_opt_contextId), WTFMove(in_opt_returnByValue), WTFMove(in_opt_generatePreview), WTFMove(in_opt_saveResult), WTFMove(in_opt_emulateUserGesture));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->evaluate(in_expression, in_opt_objectGroup, WTFMove(in_opt_includeCommandLineAPI), WTFMove(in_opt_doNotPauseOnExceptionsAndMuteConsole), WTFMove(in_opt_contextId), WTFMove(in_opt_returnByValue), WTFMove(in_opt_generatePreview), WTFMove(in_opt_saveResult), WTFMove(in_opt_emulateUserGesture));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_result, out_opt_wasThrown, out_opt_savedResultIndex] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("result"_s, WTFMove(out_result));
    if (!!out_opt_wasThrown)
        protocol_jsonMessage->setBoolean("wasThrown"_s, *out_opt_wasThrown);
    if (!!out_opt_savedResultIndex)
        protocol_jsonMessage->setInteger("savedResultIndex"_s, *out_opt_savedResultIndex);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

RuntimeBackendDispatcherHandler::AwaitPromiseCallback::AwaitPromiseCallback(Ref<BackendDispatcher>&& backendDispatcher, int id) : BackendDispatcher::CallbackBase(WTFMove(backendDispatcher), id) { }

void RuntimeBackendDispatcherHandler::AwaitPromiseCallback::sendSuccess(Ref<Protocol::Runtime::RemoteObject>&& result, std::optional<bool>&& opt_wasThrown, std::optional<int>&& opt_savedResultIndex)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("result"_s, WTFMove(result));
    if (!!opt_wasThrown)
        protocol_jsonMessage->setBoolean("wasThrown"_s, *opt_wasThrown);
    if (!!opt_savedResultIndex)
        protocol_jsonMessage->setInteger("savedResultIndex"_s, *opt_savedResultIndex);
    CallbackBase::sendSuccess(WTFMove(protocol_jsonMessage));
}

void RuntimeBackendDispatcher::awaitPromise(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_promiseObjectId = m_backendDispatcher->getString(protocol_parameters.get(), "promiseObjectId"_s, true);
    auto in_opt_returnByValue = m_backendDispatcher->getBoolean(protocol_parameters.get(), "returnByValue"_s, false);
    auto in_opt_generatePreview = m_backendDispatcher->getBoolean(protocol_parameters.get(), "generatePreview"_s, false);
    auto in_opt_saveResult = m_backendDispatcher->getBoolean(protocol_parameters.get(), "saveResult"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.awaitPromise' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->awaitPromise(protocol_requestId, in_promiseObjectId, WTFMove(in_opt_returnByValue), WTFMove(in_opt_generatePreview), WTFMove(in_opt_saveResult));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    m_agent->awaitPromise(in_promiseObjectId, WTFMove(in_opt_returnByValue), WTFMove(in_opt_generatePreview), WTFMove(in_opt_saveResult), adoptRef(*new RuntimeBackendDispatcherHandler::AwaitPromiseCallback(m_backendDispatcher.copyRef(), protocol_requestId)));
}

RuntimeBackendDispatcherHandler::CallFunctionOnCallback::CallFunctionOnCallback(Ref<BackendDispatcher>&& backendDispatcher, int id) : BackendDispatcher::CallbackBase(WTFMove(backendDispatcher), id) { }

void RuntimeBackendDispatcherHandler::CallFunctionOnCallback::sendSuccess(Ref<Protocol::Runtime::RemoteObject>&& result, std::optional<bool>&& opt_wasThrown)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("result"_s, WTFMove(result));
    if (!!opt_wasThrown)
        protocol_jsonMessage->setBoolean("wasThrown"_s, *opt_wasThrown);
    CallbackBase::sendSuccess(WTFMove(protocol_jsonMessage));
}

void RuntimeBackendDispatcher::callFunctionOn(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_objectId = m_backendDispatcher->getString(protocol_parameters.get(), "objectId"_s, true);
    auto in_functionDeclaration = m_backendDispatcher->getString(protocol_parameters.get(), "functionDeclaration"_s, true);
    auto in_opt_arguments = m_backendDispatcher->getArray(protocol_parameters.get(), "arguments"_s, false);
    auto in_opt_doNotPauseOnExceptionsAndMuteConsole = m_backendDispatcher->getBoolean(protocol_parameters.get(), "doNotPauseOnExceptionsAndMuteConsole"_s, false);
    auto in_opt_returnByValue = m_backendDispatcher->getBoolean(protocol_parameters.get(), "returnByValue"_s, false);
    auto in_opt_generatePreview = m_backendDispatcher->getBoolean(protocol_parameters.get(), "generatePreview"_s, false);
    auto in_opt_emulateUserGesture = m_backendDispatcher->getBoolean(protocol_parameters.get(), "emulateUserGesture"_s, false);
    auto in_opt_awaitPromise = m_backendDispatcher->getBoolean(protocol_parameters.get(), "awaitPromise"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.callFunctionOn' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->callFunctionOn(protocol_requestId, in_objectId, in_functionDeclaration, WTFMove(in_opt_arguments), WTFMove(in_opt_doNotPauseOnExceptionsAndMuteConsole), WTFMove(in_opt_returnByValue), WTFMove(in_opt_generatePreview), WTFMove(in_opt_emulateUserGesture), WTFMove(in_opt_awaitPromise));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    m_agent->callFunctionOn(in_objectId, in_functionDeclaration, WTFMove(in_opt_arguments), WTFMove(in_opt_doNotPauseOnExceptionsAndMuteConsole), WTFMove(in_opt_returnByValue), WTFMove(in_opt_generatePreview), WTFMove(in_opt_emulateUserGesture), WTFMove(in_opt_awaitPromise), adoptRef(*new RuntimeBackendDispatcherHandler::CallFunctionOnCallback(m_backendDispatcher.copyRef(), protocol_requestId)));
}

void RuntimeBackendDispatcher::getPreview(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_objectId = m_backendDispatcher->getString(protocol_parameters.get(), "objectId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.getPreview' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getPreview(protocol_requestId, in_objectId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getPreview(in_objectId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_preview = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("preview"_s, WTFMove(out_preview));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::getProperties(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_objectId = m_backendDispatcher->getString(protocol_parameters.get(), "objectId"_s, true);
    auto in_opt_ownProperties = m_backendDispatcher->getBoolean(protocol_parameters.get(), "ownProperties"_s, false);
    auto in_opt_fetchStart = m_backendDispatcher->getInteger(protocol_parameters.get(), "fetchStart"_s, false);
    auto in_opt_fetchCount = m_backendDispatcher->getInteger(protocol_parameters.get(), "fetchCount"_s, false);
    auto in_opt_generatePreview = m_backendDispatcher->getBoolean(protocol_parameters.get(), "generatePreview"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.getProperties' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getProperties(protocol_requestId, in_objectId, WTFMove(in_opt_ownProperties), WTFMove(in_opt_fetchStart), WTFMove(in_opt_fetchCount), WTFMove(in_opt_generatePreview));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getProperties(in_objectId, WTFMove(in_opt_ownProperties), WTFMove(in_opt_fetchStart), WTFMove(in_opt_fetchCount), WTFMove(in_opt_generatePreview));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_properties, out_opt_internalProperties] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("properties"_s, WTFMove(out_properties));
    if (!!out_opt_internalProperties)
        protocol_jsonMessage->setArray("internalProperties"_s, out_opt_internalProperties.releaseNonNull());
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::getDisplayableProperties(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_objectId = m_backendDispatcher->getString(protocol_parameters.get(), "objectId"_s, true);
    auto in_opt_fetchStart = m_backendDispatcher->getInteger(protocol_parameters.get(), "fetchStart"_s, false);
    auto in_opt_fetchCount = m_backendDispatcher->getInteger(protocol_parameters.get(), "fetchCount"_s, false);
    auto in_opt_generatePreview = m_backendDispatcher->getBoolean(protocol_parameters.get(), "generatePreview"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.getDisplayableProperties' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getDisplayableProperties(protocol_requestId, in_objectId, WTFMove(in_opt_fetchStart), WTFMove(in_opt_fetchCount), WTFMove(in_opt_generatePreview));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getDisplayableProperties(in_objectId, WTFMove(in_opt_fetchStart), WTFMove(in_opt_fetchCount), WTFMove(in_opt_generatePreview));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto [out_properties, out_opt_internalProperties] = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("properties"_s, WTFMove(out_properties));
    if (!!out_opt_internalProperties)
        protocol_jsonMessage->setArray("internalProperties"_s, out_opt_internalProperties.releaseNonNull());
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::getCollectionEntries(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_objectId = m_backendDispatcher->getString(protocol_parameters.get(), "objectId"_s, true);
    auto in_opt_objectGroup = m_backendDispatcher->getString(protocol_parameters.get(), "objectGroup"_s, false);
    auto in_opt_fetchStart = m_backendDispatcher->getInteger(protocol_parameters.get(), "fetchStart"_s, false);
    auto in_opt_fetchCount = m_backendDispatcher->getInteger(protocol_parameters.get(), "fetchCount"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.getCollectionEntries' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getCollectionEntries(protocol_requestId, in_objectId, in_opt_objectGroup, WTFMove(in_opt_fetchStart), WTFMove(in_opt_fetchCount));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getCollectionEntries(in_objectId, in_opt_objectGroup, WTFMove(in_opt_fetchStart), WTFMove(in_opt_fetchCount));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_entries = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("entries"_s, WTFMove(out_entries));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::saveResult(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_value = m_backendDispatcher->getObject(protocol_parameters.get(), "value"_s, true);
    auto in_opt_contextId = m_backendDispatcher->getInteger(protocol_parameters.get(), "contextId"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.saveResult' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->saveResult(protocol_requestId, in_value.releaseNonNull(), WTFMove(in_opt_contextId));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->saveResult(in_value.releaseNonNull(), WTFMove(in_opt_contextId));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_opt_savedResultIndex = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    if (!!out_opt_savedResultIndex)
        protocol_jsonMessage->setInteger("savedResultIndex"_s, *out_opt_savedResultIndex);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::setSavedResultAlias(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_alias = m_backendDispatcher->getString(protocol_parameters.get(), "alias"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.setSavedResultAlias' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setSavedResultAlias(protocol_requestId, in_opt_alias);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setSavedResultAlias(in_opt_alias);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::releaseObject(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_objectId = m_backendDispatcher->getString(protocol_parameters.get(), "objectId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.releaseObject' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->releaseObject(protocol_requestId, in_objectId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->releaseObject(in_objectId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::releaseObjectGroup(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_objectGroup = m_backendDispatcher->getString(protocol_parameters.get(), "objectGroup"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.releaseObjectGroup' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->releaseObjectGroup(protocol_requestId, in_objectGroup);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->releaseObjectGroup(in_objectGroup);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::getRuntimeTypesForVariablesAtOffsets(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_locations = m_backendDispatcher->getArray(protocol_parameters.get(), "locations"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.getRuntimeTypesForVariablesAtOffsets' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getRuntimeTypesForVariablesAtOffsets(protocol_requestId, in_locations.releaseNonNull());
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getRuntimeTypesForVariablesAtOffsets(in_locations.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_types = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("types"_s, WTFMove(out_types));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::enableTypeProfiler(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enableTypeProfiler(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enableTypeProfiler();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::disableTypeProfiler(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disableTypeProfiler(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disableTypeProfiler();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::enableControlFlowProfiler(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enableControlFlowProfiler(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enableControlFlowProfiler();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::disableControlFlowProfiler(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disableControlFlowProfiler(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disableControlFlowProfiler();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void RuntimeBackendDispatcher::getBasicBlocks(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_sourceID = m_backendDispatcher->getString(protocol_parameters.get(), "sourceID"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Runtime.getBasicBlocks' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getBasicBlocks(protocol_requestId, in_sourceID);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getBasicBlocks(in_sourceID);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_basicBlocks = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("basicBlocks"_s, WTFMove(out_basicBlocks));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<ScriptProfilerBackendDispatcher> ScriptProfilerBackendDispatcher::create(BackendDispatcher& backendDispatcher, ScriptProfilerBackendDispatcherHandler* agent)
{
    return adoptRef(*new ScriptProfilerBackendDispatcher(backendDispatcher, agent));
}

ScriptProfilerBackendDispatcher::ScriptProfilerBackendDispatcher(BackendDispatcher& backendDispatcher, ScriptProfilerBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("ScriptProfiler"_s, this);
}

void ScriptProfilerBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<ScriptProfilerBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    if (protocol_method == "startTracking"_s) {
        startTracking(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "stopTracking"_s) {
        stopTracking(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }

    m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'ScriptProfiler."_s, protocol_method, "' was not found"_s));
}

void ScriptProfilerBackendDispatcher::startTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_includeSamples = m_backendDispatcher->getBoolean(protocol_parameters.get(), "includeSamples"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'ScriptProfiler.startTracking' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->startTracking(protocol_requestId, WTFMove(in_opt_includeSamples));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->startTracking(WTFMove(in_opt_includeSamples));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void ScriptProfilerBackendDispatcher::stopTracking(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->stopTracking(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->stopTracking();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<ServiceWorkerBackendDispatcher> ServiceWorkerBackendDispatcher::create(BackendDispatcher& backendDispatcher, ServiceWorkerBackendDispatcherHandler* agent)
{
    return adoptRef(*new ServiceWorkerBackendDispatcher(backendDispatcher, agent));
}

ServiceWorkerBackendDispatcher::ServiceWorkerBackendDispatcher(BackendDispatcher& backendDispatcher, ServiceWorkerBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("ServiceWorker"_s, this);
}

void ServiceWorkerBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<ServiceWorkerBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    if (protocol_method == "getInitializationInfo"_s) {
        getInitializationInfo(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }

    m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'ServiceWorker."_s, protocol_method, "' was not found"_s));
}

void ServiceWorkerBackendDispatcher::getInitializationInfo(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->getInitializationInfo(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->getInitializationInfo();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_info = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setObject("info"_s, WTFMove(out_info));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<TargetBackendDispatcher> TargetBackendDispatcher::create(BackendDispatcher& backendDispatcher, TargetBackendDispatcherHandler* agent)
{
    return adoptRef(*new TargetBackendDispatcher(backendDispatcher, agent));
}

TargetBackendDispatcher::TargetBackendDispatcher(BackendDispatcher& backendDispatcher, TargetBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Target"_s, this);
}

void TargetBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<TargetBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    if (protocol_method == "setPauseOnStart"_s) {
        setPauseOnStart(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "resume"_s) {
        resume(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "sendMessageToTarget"_s) {
        sendMessageToTarget(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }

    m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Target."_s, protocol_method, "' was not found"_s));
}

void TargetBackendDispatcher::setPauseOnStart(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_pauseOnStart = m_backendDispatcher->getBoolean(protocol_parameters.get(), "pauseOnStart"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Target.setPauseOnStart' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setPauseOnStart(protocol_requestId, *in_pauseOnStart);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setPauseOnStart(*in_pauseOnStart);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void TargetBackendDispatcher::resume(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_targetId = m_backendDispatcher->getString(protocol_parameters.get(), "targetId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Target.resume' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->resume(protocol_requestId, in_targetId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->resume(in_targetId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void TargetBackendDispatcher::sendMessageToTarget(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_targetId = m_backendDispatcher->getString(protocol_parameters.get(), "targetId"_s, true);
    auto in_message = m_backendDispatcher->getString(protocol_parameters.get(), "message"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Target.sendMessageToTarget' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->sendMessageToTarget(protocol_requestId, in_targetId, in_message);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->sendMessageToTarget(in_targetId, in_message);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<TimelineBackendDispatcher> TimelineBackendDispatcher::create(BackendDispatcher& backendDispatcher, TimelineBackendDispatcherHandler* agent)
{
    return adoptRef(*new TimelineBackendDispatcher(backendDispatcher, agent));
}

TimelineBackendDispatcher::TimelineBackendDispatcher(BackendDispatcher& backendDispatcher, TimelineBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Timeline"_s, this);
}

void TimelineBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<TimelineBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (TimelineBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "enable"_s, &TimelineBackendDispatcher::enable },
        { "disable"_s, &TimelineBackendDispatcher::disable },
        { "start"_s, &TimelineBackendDispatcher::start },
        { "stop"_s, &TimelineBackendDispatcher::stop },
        { "setAutoCaptureEnabled"_s, &TimelineBackendDispatcher::setAutoCaptureEnabled },
        { "setInstruments"_s, &TimelineBackendDispatcher::setInstruments },
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Timeline."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void TimelineBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void TimelineBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void TimelineBackendDispatcher::start(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_maxCallStackDepth = m_backendDispatcher->getInteger(protocol_parameters.get(), "maxCallStackDepth"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Timeline.start' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->start(protocol_requestId, WTFMove(in_opt_maxCallStackDepth));
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->start(WTFMove(in_opt_maxCallStackDepth));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void TimelineBackendDispatcher::stop(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->stop(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->stop();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void TimelineBackendDispatcher::setAutoCaptureEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_enabled = m_backendDispatcher->getBoolean(protocol_parameters.get(), "enabled"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Timeline.setAutoCaptureEnabled' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setAutoCaptureEnabled(protocol_requestId, *in_enabled);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setAutoCaptureEnabled(*in_enabled);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void TimelineBackendDispatcher::setInstruments(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_instruments = m_backendDispatcher->getArray(protocol_parameters.get(), "instruments"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Timeline.setInstruments' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->setInstruments(protocol_requestId, in_instruments.releaseNonNull());
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->setInstruments(in_instruments.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

Ref<WorkerBackendDispatcher> WorkerBackendDispatcher::create(BackendDispatcher& backendDispatcher, WorkerBackendDispatcherHandler* agent)
{
    return adoptRef(*new WorkerBackendDispatcher(backendDispatcher, agent));
}

WorkerBackendDispatcher::WorkerBackendDispatcher(BackendDispatcher& backendDispatcher, WorkerBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Worker"_s, this);
}

void WorkerBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<WorkerBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    if (protocol_method == "enable"_s) {
        enable(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "disable"_s) {
        disable(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "initialized"_s) {
        initialized(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }
    if (protocol_method == "sendMessageToWorker"_s) {
        sendMessageToWorker(protocol_requestId, WTFMove(protocol_parameters));
        return;
    }

    m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Worker."_s, protocol_method, "' was not found"_s));
}

void WorkerBackendDispatcher::enable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->enable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->enable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void WorkerBackendDispatcher::disable(long protocol_requestId, RefPtr<JSON::Object>&&)
{
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->disable(protocol_requestId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->disable();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void WorkerBackendDispatcher::initialized(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_workerId = m_backendDispatcher->getString(protocol_parameters.get(), "workerId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Worker.initialized' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->initialized(protocol_requestId, in_workerId);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->initialized(in_workerId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void WorkerBackendDispatcher::sendMessageToWorker(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_workerId = m_backendDispatcher->getString(protocol_parameters.get(), "workerId"_s, true);
    auto in_message = m_backendDispatcher->getString(protocol_parameters.get(), "message"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Worker.sendMessageToWorker' can't be processed"_s);
        return;
    }

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
    if (m_alternateDispatcher) {
        m_alternateDispatcher->sendMessageToWorker(protocol_requestId, in_workerId, in_message);
        return;
    }
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

    auto result = m_agent->sendMessageToWorker(in_workerId, in_message);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

} // namespace Inspector
