// java wrapper for vtkRenderer object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkRenderer.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkViewport_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkRenderer_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkRenderer",dType)) { return me; }
  if ((res= vtkViewport_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_AddActor_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddActor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_AddVolume_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddVolume(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_RemoveActor_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveActor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_RemoveVolume_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveVolume(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_AddLight_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLight * temp0;
  temp0 = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddLight(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_RemoveLight_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLight * temp0;
  temp0 = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveLight(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_RemoveAllLights_110(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllLights();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetLights_111(JNIEnv* env, jobject obj)
{
  vtkLightCollection * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLights();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetLightCollection_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLightCollection * temp0;
  temp0 = static_cast<vtkLightCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLightCollection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_CreateLight_113(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateLight();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_MakeLight_114(JNIEnv* env, jobject obj)
{
  vtkLight * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeLight();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetTwoSidedLighting_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTwoSidedLighting();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetTwoSidedLighting_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTwoSidedLighting(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_TwoSidedLightingOn_117(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->TwoSidedLightingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_TwoSidedLightingOff_118(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->TwoSidedLightingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetLightFollowCamera_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLightFollowCamera(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetLightFollowCamera_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLightFollowCamera();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_LightFollowCameraOn_121(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->LightFollowCameraOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_LightFollowCameraOff_122(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->LightFollowCameraOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetAutomaticLightCreation_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutomaticLightCreation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetAutomaticLightCreation_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAutomaticLightCreation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_AutomaticLightCreationOn_125(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutomaticLightCreationOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_AutomaticLightCreationOff_126(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutomaticLightCreationOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_UpdateLightsGeometryToFollowCamera_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateLightsGeometryToFollowCamera();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetVolumes_128(JNIEnv* env, jobject obj)
{
  vtkVolumeCollection * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVolumes();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetActors_129(JNIEnv* env, jobject obj)
{
  vtkActorCollection * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActors();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetActiveCamera_130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCamera * temp0;
  temp0 = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetActiveCamera(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetActiveCamera_131(JNIEnv* env, jobject obj)
{
  vtkCamera * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActiveCamera();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_MakeCamera_132(JNIEnv* env, jobject obj)
{
  vtkCamera * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeCamera();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetErase_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetErase(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetErase_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetErase();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_EraseOn_135(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->EraseOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_EraseOff_136(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->EraseOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetDraw_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDraw(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetDraw_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDraw();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_DrawOn_139(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_DrawOff_140(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_CaptureGL2PSSpecialProp_141(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  int   temp20;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CaptureGL2PSSpecialProp(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetGL2PSSpecialPropCollection_142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGL2PSSpecialPropCollection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_AddCuller_143(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCuller * temp0;
  temp0 = static_cast<vtkCuller*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddCuller(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_RemoveCuller_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCuller * temp0;
  temp0 = static_cast<vtkCuller*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveCuller(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetCullers_145(JNIEnv* env, jobject obj)
{
  vtkCullerCollection * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCullers();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetAmbient_146(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAmbient(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetAmbient_147(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAmbient(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkRenderer_GetAmbient_148(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAmbient();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetAllocatedRenderTime_149(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAllocatedRenderTime(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetAllocatedRenderTime_150(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAllocatedRenderTime();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetTimeFactor_151(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_Render_152(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_DeviceRender_153(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeviceRender();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_DeviceRenderOpaqueGeometry_154(JNIEnv* env, jobject obj,jobject id0)
{
  vtkFrameBufferObjectBase * temp0;
  temp0 = static_cast<vtkFrameBufferObjectBase*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeviceRenderOpaqueGeometry(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_DeviceRenderTranslucentPolygonalGeometry_155(JNIEnv* env, jobject obj,jobject id0)
{
  vtkFrameBufferObjectBase * temp0;
  temp0 = static_cast<vtkFrameBufferObjectBase*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeviceRenderTranslucentPolygonalGeometry(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_ClearLights_156(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearLights();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_Clear_157(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clear();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_VisibleActorCount_158(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->VisibleActorCount();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_VisibleVolumeCount_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->VisibleVolumeCount();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_ComputeVisiblePropBounds_160(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeVisiblePropBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkRenderer_ComputeVisiblePropBounds_161(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeVisiblePropBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_ResetCameraClippingRange_162(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCameraClippingRange();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_ResetCameraClippingRange_163(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCameraClippingRange(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_ResetCameraClippingRange_164(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCameraClippingRange(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetNearClippingPlaneTolerance_165(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNearClippingPlaneTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetNearClippingPlaneToleranceMinValue_166(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNearClippingPlaneToleranceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetNearClippingPlaneToleranceMaxValue_167(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNearClippingPlaneToleranceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetNearClippingPlaneTolerance_168(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNearClippingPlaneTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetClippingRangeExpansion_169(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClippingRangeExpansion(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetClippingRangeExpansionMinValue_170(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClippingRangeExpansionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetClippingRangeExpansionMaxValue_171(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClippingRangeExpansionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetClippingRangeExpansion_172(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClippingRangeExpansion();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_ResetCamera_173(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCamera();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_ResetCamera_174(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCamera(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_ResetCamera_175(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCamera(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_ResetCameraScreenSpace_176(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCameraScreenSpace(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_ResetCameraScreenSpace_177(JNIEnv* env, jobject obj,jdoubleArray id0,jdouble id1)
{
  double temp0[6];
  double   temp1;
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);
  temp1 = id1;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCameraScreenSpace(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_ResetCameraScreenSpace_178(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCameraScreenSpace(temp0,temp1,temp2,temp3,temp4,temp5,temp6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetRenderWindow_179(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderWindow(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetRenderWindow_180(JNIEnv* env, jobject obj)
{
  vtkRenderWindow * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderWindow();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetVTKWindow_181(JNIEnv* env, jobject obj)
{
  vtkWindow * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVTKWindow();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetBackingStore_182(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackingStore(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetBackingStore_183(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackingStore();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_BackingStoreOn_184(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->BackingStoreOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_BackingStoreOff_185(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->BackingStoreOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetInteractive_186(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractive(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetInteractive_187(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractive();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_InteractiveOn_188(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->InteractiveOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_InteractiveOff_189(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->InteractiveOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetLayer_190(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayer(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetLayer_191(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLayer();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetPreserveColorBuffer_192(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPreserveColorBuffer();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetPreserveColorBuffer_193(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPreserveColorBuffer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_PreserveColorBufferOn_194(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->PreserveColorBufferOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_PreserveColorBufferOff_195(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->PreserveColorBufferOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetPreserveDepthBuffer_196(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPreserveDepthBuffer(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetPreserveDepthBuffer_197(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPreserveDepthBuffer();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_PreserveDepthBufferOn_198(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->PreserveDepthBufferOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_PreserveDepthBufferOff_199(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->PreserveDepthBufferOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_Transparent_1100(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Transparent();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_WorldToView_1101(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->WorldToView();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_ViewToWorld_1102(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ViewToWorld();

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetZ_1103(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  double   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZ(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetSafeGetZ_1104(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSafeGetZ(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderer_GetSafeGetZ_1105(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSafeGetZ();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SafeGetZOn_1106(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SafeGetZOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SafeGetZOff_1107(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SafeGetZOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetMTime_1108(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetLastRenderTimeInSeconds_1109(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastRenderTimeInSeconds();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetNumberOfPropsRendered_1110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPropsRendered();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_PickProp_1111(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  vtkAssemblyPath * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PickProp(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_PickProp_1112(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  vtkAssemblyPath * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PickProp(temp0,temp1,temp2,temp3);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_StereoMidpoint_1113(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->StereoMidpoint();

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetTiledAspectRatio_1114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTiledAspectRatio();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_IsActiveCameraCreated_1115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsActiveCameraCreated();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetUseDepthPeeling_1116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseDepthPeeling(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetUseDepthPeeling_1117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseDepthPeeling();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseDepthPeelingOn_1118(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseDepthPeelingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseDepthPeelingOff_1119(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseDepthPeelingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetUseDepthPeelingForVolumes_1120(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseDepthPeelingForVolumes(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderer_GetUseDepthPeelingForVolumes_1121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseDepthPeelingForVolumes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseDepthPeelingForVolumesOn_1122(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseDepthPeelingForVolumesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseDepthPeelingForVolumesOff_1123(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseDepthPeelingForVolumesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetOcclusionRatio_1124(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOcclusionRatio(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetOcclusionRatioMinValue_1125(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOcclusionRatioMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetOcclusionRatioMaxValue_1126(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOcclusionRatioMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetOcclusionRatio_1127(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOcclusionRatio();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetMaximumNumberOfPeels_1128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumNumberOfPeels(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetMaximumNumberOfPeels_1129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumNumberOfPeels();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetLastRenderingUsedDepthPeeling_1130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastRenderingUsedDepthPeeling();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetUseSSAO_1131(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseSSAO(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderer_GetUseSSAO_1132(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseSSAO();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseSSAOOn_1133(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseSSAOOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseSSAOOff_1134(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseSSAOOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetSSAORadius_1135(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSSAORadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetSSAORadius_1136(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSSAORadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetSSAOBias_1137(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSSAOBias(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderer_GetSSAOBias_1138(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSSAOBias();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetSSAOKernelSize_1139(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSSAOKernelSize(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetSSAOKernelSize_1140(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSSAOKernelSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetSSAOBlur_1141(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSSAOBlur(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderer_GetSSAOBlur_1142(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSSAOBlur();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SSAOBlurOn_1143(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SSAOBlurOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SSAOBlurOff_1144(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SSAOBlurOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetDelegate_1145(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRendererDelegate * temp0;
  temp0 = static_cast<vtkRendererDelegate*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDelegate(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetDelegate_1146(JNIEnv* env, jobject obj)
{
  vtkRendererDelegate * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDelegate();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetSelector_1147(JNIEnv* env, jobject obj)
{
  vtkHardwareSelector * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelector();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetLeftBackgroundTexture_1148(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTexture * temp0;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLeftBackgroundTexture(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetLeftBackgroundTexture_1149(JNIEnv* env, jobject obj)
{
  vtkTexture * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftBackgroundTexture();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetBackgroundTexture_1150(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTexture * temp0;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundTexture(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetBackgroundTexture_1151(JNIEnv* env, jobject obj)
{
  vtkTexture * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundTexture();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetRightBackgroundTexture_1152(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTexture * temp0;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRightBackgroundTexture(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetRightBackgroundTexture_1153(JNIEnv* env, jobject obj)
{
  vtkTexture * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRightBackgroundTexture();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetTexturedBackground_1154(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTexturedBackground(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderer_GetTexturedBackground_1155(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTexturedBackground();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_TexturedBackgroundOn_1156(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->TexturedBackgroundOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_TexturedBackgroundOff_1157(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->TexturedBackgroundOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_ReleaseGraphicsResources_1158(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetUseFXAA_1159(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseFXAA(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderer_GetUseFXAA_1160(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseFXAA();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseFXAAOn_1161(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseFXAAOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseFXAAOff_1162(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseFXAAOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetFXAAOptions_1163(JNIEnv* env, jobject obj)
{
  vtkFXAAOptions * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFXAAOptions();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetFXAAOptions_1164(JNIEnv* env, jobject obj,jobject id0)
{
  vtkFXAAOptions * temp0;
  temp0 = static_cast<vtkFXAAOptions*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFXAAOptions(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetUseShadows_1165(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseShadows(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetUseShadows_1166(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseShadows();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseShadowsOn_1167(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseShadowsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseShadowsOff_1168(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseShadowsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetUseHiddenLineRemoval_1169(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseHiddenLineRemoval(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderer_GetUseHiddenLineRemoval_1170(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseHiddenLineRemoval();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseHiddenLineRemovalOn_1171(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseHiddenLineRemovalOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseHiddenLineRemovalOff_1172(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseHiddenLineRemovalOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetPass_1173(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderPass * temp0;
  temp0 = static_cast<vtkRenderPass*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPass(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetPass_1174(JNIEnv* env, jobject obj)
{
  vtkRenderPass * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPass();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetInformation_1175(JNIEnv* env, jobject obj)
{
  vtkInformation * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInformation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetInformation_1176(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInformation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetUseImageBasedLighting_1177(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseImageBasedLighting(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderer_GetUseImageBasedLighting_1178(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseImageBasedLighting();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseImageBasedLightingOn_1179(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseImageBasedLightingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseImageBasedLightingOff_1180(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseImageBasedLightingOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderer_GetEnvironmentTexture_1181(JNIEnv* env, jobject obj)
{
  vtkTexture * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnvironmentTexture();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetEnvironmentTextureProperty_1182(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTexture * temp0;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvironmentTextureProperty(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetEnvironmentTexture_1183(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkTexture * temp0;
  bool   temp1;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvironmentTexture(temp0,temp1);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkRenderer_GetEnvironmentUp_1184(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnvironmentUp();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetEnvironmentUp_1185(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvironmentUp(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetEnvironmentUp_1186(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvironmentUp(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkRenderer_GetEnvironmentRight_1187(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnvironmentRight();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetEnvironmentRight_1188(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvironmentRight(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetEnvironmentRight_1189(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvironmentRight(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_SetUseOIT_1190(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseOIT(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderer_GetUseOIT_1191(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseOIT();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseOITOn_1192(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseOITOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_UseOITOff_1193(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseOITOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderer_DisplayToWorld_1194(JNIEnv* env, jobject obj)
{

  vtkRenderer* op = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisplayToWorld();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkRenderer_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkRenderer::New());
}
