// java wrapper for vtkXYPlotActor object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkXYPlotActor.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkActor2D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkXYPlotActor_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkXYPlotActor",dType)) { return me; }
  if ((res= vtkActor2D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_AddDataSetInput_14(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1,jint id2)
{
  vtkDataSet * temp0;
  char * temp1;
  int   temp2;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddDataSetInput(temp0,temp1,temp2);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_AddDataSetInput_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddDataSetInput(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_AddDataSetInputConnection_16(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1,jint id2)
{
  vtkAlgorithmOutput * temp0;
  char * temp1;
  int   temp2;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddDataSetInputConnection(temp0,temp1,temp2);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_AddDataSetInputConnection_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddDataSetInputConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_RemoveDataSetInput_18(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1,jint id2)
{
  vtkDataSet * temp0;
  char * temp1;
  int   temp2;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveDataSetInput(temp0,temp1,temp2);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_RemoveDataSetInput_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveDataSetInput(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_RemoveDataSetInputConnection_110(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1,jint id2)
{
  vtkAlgorithmOutput * temp0;
  char * temp1;
  int   temp2;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveDataSetInputConnection(temp0,temp1,temp2);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_RemoveDataSetInputConnection_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveDataSetInputConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_RemoveAllDataSetInputConnections_112(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllDataSetInputConnections();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetDataSetInputConnection_113(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  vtkAlgorithmOutput * temp20;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSetInputConnection(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetNumberOfDataSetInputConnections_114(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfDataSetInputConnections();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPointComponent_115(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointComponent(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetPointComponent_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointComponent(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetXValues_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXValues(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetXValuesMinValue_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXValuesMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetXValuesMaxValue_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXValuesMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetXValues_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXValues();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetXValuesToIndex_121(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXValuesToIndex();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetXValuesToArcLength_122(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXValuesToArcLength();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetXValuesToNormalizedArcLength_123(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXValuesToNormalizedArcLength();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetXValuesToValue_124(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXValuesToValue();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXYPlotActor_GetXValuesAsString_125(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXValuesAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_AddDataObjectInput_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddDataObjectInput(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_AddDataObjectInputConnection_127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddDataObjectInputConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_RemoveDataObjectInputConnection_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveDataObjectInputConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_RemoveDataObjectInput_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveDataObjectInput(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_RemoveAllDataObjectInputConnections_130(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllDataObjectInputConnections();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetDataObjectInputConnection_131(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  vtkAlgorithmOutput * temp20;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectInputConnection(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetNumberOfDataObjectInputConnections_132(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfDataObjectInputConnections();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetDataObjectPlotMode_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataObjectPlotMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetDataObjectPlotModeMinValue_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectPlotModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetDataObjectPlotModeMaxValue_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectPlotModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetDataObjectPlotMode_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectPlotMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetDataObjectPlotModeToRows_137(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataObjectPlotModeToRows();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetDataObjectPlotModeToColumns_138(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataObjectPlotModeToColumns();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXYPlotActor_GetDataObjectPlotModeAsString_139(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectPlotModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetDataObjectXComponent_140(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataObjectXComponent(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetDataObjectXComponent_141(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectXComponent(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetDataObjectYComponent_142(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataObjectYComponent(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetDataObjectYComponent_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectYComponent(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotColor_144(JNIEnv* env, jobject obj,jint id0,jdouble id1,jdouble id2,jdouble id3)
{
  int   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotColor(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotColor_145(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotColor(temp0,temp1);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkXYPlotActor_GetPlotColor_146(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double * temp20;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlotColor(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotSymbol_147(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPolyData * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotSymbol(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetPlotSymbol_148(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPolyData * temp20;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlotSymbol(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotLabel_149(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotLabel(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXYPlotActor_GetPlotLabel_150(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlotLabel(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetPlotCurvePoints_151(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlotCurvePoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotCurvePoints_152(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotCurvePoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_PlotCurvePointsOn_153(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlotCurvePointsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_PlotCurvePointsOff_154(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlotCurvePointsOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetPlotCurveLines_155(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlotCurveLines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotCurveLines_156(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotCurveLines(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_PlotCurveLinesOn_157(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlotCurveLinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_PlotCurveLinesOff_158(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlotCurveLinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotLines_159(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotLines(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetPlotLines_160(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlotLines(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotPoints_161(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotPoints(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetPlotPoints_162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlotPoints(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetExchangeAxes_163(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExchangeAxes(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetExchangeAxes_164(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExchangeAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ExchangeAxesOn_165(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExchangeAxesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ExchangeAxesOff_166(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExchangeAxesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetReverseXAxis_167(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReverseXAxis(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetReverseXAxis_168(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReverseXAxis();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ReverseXAxisOn_169(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReverseXAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ReverseXAxisOff_170(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReverseXAxisOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetReverseYAxis_171(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReverseYAxis(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetReverseYAxis_172(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReverseYAxis();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ReverseYAxisOn_173(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReverseYAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ReverseYAxisOff_174(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReverseYAxisOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetLegendActor_175(JNIEnv* env, jobject obj)
{
  vtkLegendBoxActor * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLegendActor();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetGlyphSource_176(JNIEnv* env, jobject obj)
{
  vtkGlyphSource2D * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlyphSource();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetTitle_177(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitle(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXYPlotActor_GetTitle_178(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitle();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetXTitle_179(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXTitle(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXYPlotActor_GetXTitle_180(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXTitle();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetYTitle_181(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYTitle(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXYPlotActor_GetYTitle_182(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYTitle();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetXAxisActor2D_183(JNIEnv* env, jobject obj)
{
  vtkAxisActor2D * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxisActor2D();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetYAxisActor2D_184(JNIEnv* env, jobject obj)
{
  vtkAxisActor2D * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxisActor2D();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetXRange_185(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetXRange_186(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkXYPlotActor_GetXRange_187(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetYRange_188(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetYRange_189(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkXYPlotActor_GetYRange_190(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotRange_191(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotRange(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetNumberOfXLabels_192(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfXLabels(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetNumberOfXLabelsMinValue_193(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfXLabelsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetNumberOfXLabelsMaxValue_194(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfXLabelsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetNumberOfXLabels_195(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfXLabels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetNumberOfYLabels_196(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfYLabels(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetNumberOfYLabelsMinValue_197(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfYLabelsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetNumberOfYLabelsMaxValue_198(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfYLabelsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetNumberOfYLabels_199(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfYLabels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetNumberOfLabels_1100(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfLabels(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAdjustXLabels_1101(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAdjustXLabels(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetAdjustXLabels_1102(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustXLabels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAdjustYLabels_1103(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAdjustYLabels(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetAdjustYLabels_1104(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustYLabels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetNumberOfXMinorTicks_1105(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfXMinorTicks(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetNumberOfXMinorTicks_1106(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfXMinorTicks();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetNumberOfYMinorTicks_1107(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfYMinorTicks(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetNumberOfYMinorTicks_1108(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfYMinorTicks();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetLegend_1109(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLegend(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetLegend_1110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLegend();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_LegendOn_1111(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LegendOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_LegendOff_1112(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LegendOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetTitlePosition_1113(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitlePosition(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetTitlePosition_1114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitlePosition(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkXYPlotActor_GetTitlePosition_1115(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitlePosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAdjustTitlePosition_1116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAdjustTitlePosition(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetAdjustTitlePosition_1117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustTitlePosition();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_AdjustTitlePositionOn_1118(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AdjustTitlePositionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_AdjustTitlePositionOff_1119(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AdjustTitlePositionOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAdjustTitlePositionMode_1120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAdjustTitlePositionMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetAdjustTitlePositionMode_1121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustTitlePositionMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetLegendPosition_1122(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLegendPosition(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetLegendPosition_1123(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLegendPosition(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkXYPlotActor_GetLegendPosition_1124(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLegendPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetLegendPosition2_1125(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLegendPosition2(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetLegendPosition2_1126(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLegendPosition2(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkXYPlotActor_GetLegendPosition2_1127(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLegendPosition2();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetTitleTextProperty_1128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetTitleTextProperty_1129(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisTitleTextProperty_1130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTitleTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetAxisTitleTextProperty_1131(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisTitleTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisLabelTextProperty_1132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabelTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetAxisLabelTextProperty_1133(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisLabelTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetLogx_1134(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLogx(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetLogx_1135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLogx();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_LogxOn_1136(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LogxOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_LogxOff_1137(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LogxOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetLabelFormat_1138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelFormat(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXYPlotActor_GetLabelFormat_1139(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelFormat();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetXLabelFormat_1140(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXLabelFormat(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXYPlotActor_GetXLabelFormat_1141(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXLabelFormat();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetYLabelFormat_1142(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYLabelFormat(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXYPlotActor_GetYLabelFormat_1143(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYLabelFormat();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetBorder_1144(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorder(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetBorderMinValue_1145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorderMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetBorderMaxValue_1146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorderMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetBorder_1147(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorder();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetPlotPoints_1148(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlotPoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotPoints_1149(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotPoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_PlotPointsOn_1150(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlotPointsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_PlotPointsOff_1151(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlotPointsOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetPlotLines_1152(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlotLines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotLines_1153(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotLines(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_PlotLinesOn_1154(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlotLinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_PlotLinesOff_1155(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlotLinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetGlyphSize_1156(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGlyphSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkXYPlotActor_GetGlyphSizeMinValue_1157(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlyphSizeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkXYPlotActor_GetGlyphSizeMaxValue_1158(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlyphSizeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkXYPlotActor_GetGlyphSize_1159(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlyphSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ViewportToPlotCoordinate_1160(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ViewportToPlotCoordinate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotCoordinate_1161(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotCoordinate(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotCoordinate_1162(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotCoordinate(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkXYPlotActor_GetPlotCoordinate_1163(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlotCoordinate();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_PlotToViewportCoordinate_1164(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlotToViewportCoordinate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetViewportCoordinate_1165(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewportCoordinate(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetViewportCoordinate_1166(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewportCoordinate(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkXYPlotActor_GetViewportCoordinate_1167(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewportCoordinate();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_IsInPlot_1168(JNIEnv* env, jobject obj,jobject id0,jdouble id1,jdouble id2)
{
  vtkViewport * temp0;
  double   temp1;
  double   temp2;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsInPlot(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetChartBox_1169(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetChartBox(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetChartBox_1170(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChartBox();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ChartBoxOn_1171(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ChartBoxOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ChartBoxOff_1172(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ChartBoxOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetChartBorder_1173(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetChartBorder(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetChartBorder_1174(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChartBorder();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ChartBorderOn_1175(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ChartBorderOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ChartBorderOff_1176(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ChartBorderOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetChartBoxProperty_1177(JNIEnv* env, jobject obj)
{
  vtkProperty2D * temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChartBoxProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetShowReferenceXLine_1178(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowReferenceXLine(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetShowReferenceXLine_1179(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowReferenceXLine();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ShowReferenceXLineOn_1180(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowReferenceXLineOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ShowReferenceXLineOff_1181(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowReferenceXLineOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetReferenceXValue_1182(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReferenceXValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkXYPlotActor_GetReferenceXValue_1183(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReferenceXValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetShowReferenceYLine_1184(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowReferenceYLine(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetShowReferenceYLine_1185(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowReferenceYLine();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ShowReferenceYLineOn_1186(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowReferenceYLineOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ShowReferenceYLineOff_1187(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowReferenceYLineOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetReferenceYValue_1188(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReferenceYValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkXYPlotActor_GetReferenceYValue_1189(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReferenceYValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXYPlotActor_GetMTime_1190(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_RenderOpaqueGeometry_1191(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_RenderOverlay_1192(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_RenderTranslucentPolygonalGeometry_1193(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_HasTranslucentPolygonalGeometry_1194(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_ReleaseGraphicsResources_1195(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetXTitlePosition_1196(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXTitlePosition(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkXYPlotActor_GetXTitlePosition_1197(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXTitlePosition();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetYTitlePosition_1198(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYTitlePosition(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXYPlotActor_GetYTitlePosition_1199(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYTitlePosition();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetYTitlePositionToTop_1200(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYTitlePositionToTop();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetYTitlePositionToHCenter_1201(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYTitlePositionToHCenter();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetYTitlePositionToVCenter_1202(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYTitlePositionToVCenter();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetPlotGlyphType_1203(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotGlyphType(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetLineWidth_1204(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineWidth(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_AddUserCurvesPoint_1205(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddUserCurvesPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_RemoveAllActiveCurves_1206(JNIEnv* env, jobject obj)
{

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllActiveCurves();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetLegendBorder_1207(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLegendBorder(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetLegendBox_1208(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLegendBox(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetLegendUseBackground_1209(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLegendUseBackground(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetLegendBackgroundColor_1210(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLegendBackgroundColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetTitleColor_1211(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetTitleFontFamily_1212(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleFontFamily(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetTitleBold_1213(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleBold(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetTitleItalic_1214(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleItalic(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetTitleShadow_1215(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleShadow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetTitleFontSize_1216(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleFontSize(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetTitleJustification_1217(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleJustification(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetTitleVerticalJustification_1218(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleVerticalJustification(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetXAxisColor_1219(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxisColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetYAxisColor_1220(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxisColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisTitleColor_1221(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTitleColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisTitleFontFamily_1222(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTitleFontFamily(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisTitleBold_1223(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTitleBold(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisTitleItalic_1224(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTitleItalic(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisTitleShadow_1225(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTitleShadow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisTitleFontSize_1226(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTitleFontSize(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisTitleJustification_1227(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTitleJustification(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisTitleVerticalJustification_1228(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTitleVerticalJustification(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisLabelColor_1229(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabelColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisLabelFontFamily_1230(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabelFontFamily(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisLabelBold_1231(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabelBold(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisLabelItalic_1232(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabelItalic(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisLabelShadow_1233(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabelShadow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisLabelFontSize_1234(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabelFontSize(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisLabelJustification_1235(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabelJustification(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXYPlotActor_SetAxisLabelVerticalJustification_1236(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXYPlotActor* op = static_cast<vtkXYPlotActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabelVerticalJustification(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkXYPlotActor_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkXYPlotActor::New());
}
