// java wrapper for vtkPoints object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPoints.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPoints_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPoints",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPoints_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPoints_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPoints_Allocate_14(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Allocate(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_Initialize_15(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetData_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints_GetData_17(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPoints_GetDataType_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetDataType_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataType(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetDataTypeToBit_110(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToBit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetDataTypeToChar_111(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetDataTypeToUnsignedChar_112(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToUnsignedChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetDataTypeToShort_113(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetDataTypeToUnsignedShort_114(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToUnsignedShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetDataTypeToInt_115(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetDataTypeToUnsignedInt_116(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToUnsignedInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetDataTypeToLong_117(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToLong();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetDataTypeToUnsignedLong_118(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToUnsignedLong();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetDataTypeToFloat_119(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToFloat();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetDataTypeToDouble_120(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToDouble();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_Squeeze_121(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->Squeeze();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_Reset_122(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->Reset();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_DeepCopy_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints * temp0;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_ShallowCopy_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints * temp0;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints_GetActualMemorySize_125(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints_GetNumberOfPoints_126(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPoints_GetPoint_127(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_GetPoint_128(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetPoint_129(JNIEnv* env, jobject obj,jlong id0,jfloatArray id1)
{
  long long   temp0;
  float temp1[3];
  temp0 = id0;
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetPoint_130(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetPoint_131(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_InsertPoint_132(JNIEnv* env, jobject obj,jlong id0,jfloatArray id1)
{
  long long   temp0;
  float temp1[3];
  temp0 = id0;
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertPoint(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_InsertPoint_133(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertPoint(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_InsertPoint_134(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertPoint(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_InsertPoints_135(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkIdList * temp0;
  vtkIdList * temp1;
  vtkPoints * temp2;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id2));

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertPoints(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_InsertPoints_136(JNIEnv* env, jobject obj,jlong id0,jlong id1,jlong id2,jobject id3)
{
  long long   temp0;
  long long   temp1;
  long long   temp2;
  vtkPoints * temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id3));

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertPoints(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints_InsertNextPoint_137(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  long long   temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints_InsertNextPoint_138(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints_InsertNextPoint_139(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextPoint(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_SetNumberOfPoints_140(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfPoints(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPoints_Resize_141(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Resize(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_GetPoints_142(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkIdList * temp0;
  vtkPoints * temp1;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_ComputeBounds_143(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeBounds();

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPoints_GetBounds_144(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_GetBounds_145(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints_GetMTime_146(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints_Modified_147(JNIEnv* env, jobject obj)
{

  vtkPoints* op = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->Modified();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPoints_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPoints::New());
}
