// python wrapper for vtkAnariDevice
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkAnariDevice.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkAnariDevice(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkAnariDevice_ClassNew(); }


static PyObject *
PyvtkAnariDevice_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkAnariDevice::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkAnariDevice::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkAnariDevice *tempr = vtkAnariDevice::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAnariDevice *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkAnariDevice::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkAnariDevice::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkAnariDevice::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SetAnariDebugConfig(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnariDebugConfig");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAnariDebugConfig(temp0, temp1);
    }
    else
    {
      op->vtkAnariDevice::SetAnariDebugConfig(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SetupAnariDeviceFromLibrary(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetupAnariDeviceFromLibrary");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    bool tempr = (ap.IsBound() ?
      op->SetupAnariDeviceFromLibrary(temp0, temp1, temp2) :
      op->vtkAnariDevice::SetupAnariDeviceFromLibrary(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_AnariInitialized(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AnariInitialized");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->AnariInitialized() :
      op->vtkAnariDevice::AnariInitialized());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SetParameterc(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameterc");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  size_t size1 = ap.GetStringSize(1);
  vtkPythonArgs::Array<char> store1(2*size1 + 1);
  char *temp1 = store1.Data();
  char *save1 = temp1 + size1 + 1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->SetParameterc(temp0, temp1);
    }
    else
    {
      op->vtkAnariDevice::SetParameterc(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SetParameterb(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameterb");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetParameterb(temp0, temp1);
    }
    else
    {
      op->vtkAnariDevice::SetParameterb(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SetParameteri(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameteri");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetParameteri(temp0, temp1);
    }
    else
    {
      op->vtkAnariDevice::SetParameteri(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SetParameter2i(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameter2i");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetParameter2i(temp0, temp1, temp2);
    }
    else
    {
      op->vtkAnariDevice::SetParameter2i(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SetParameter3i(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameter3i");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetParameter3i(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkAnariDevice::SetParameter3i(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SetParameter4i(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameter4i");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  int temp2;
  int temp3;
  int temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetParameter4i(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkAnariDevice::SetParameter4i(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SetParameterf(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameterf");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  float temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetParameterf(temp0, temp1);
    }
    else
    {
      op->vtkAnariDevice::SetParameterf(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SetParameter2f(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameter2f");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  float temp1;
  float temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetParameter2f(temp0, temp1, temp2);
    }
    else
    {
      op->vtkAnariDevice::SetParameter2f(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SetParameter3f(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameter3f");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  float temp1;
  float temp2;
  float temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetParameter3f(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkAnariDevice::SetParameter3f(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SetParameter4f(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameter4f");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  float temp1;
  float temp2;
  float temp3;
  float temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetParameter4f(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkAnariDevice::SetParameter4f(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_SetParameterd(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameterd");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  const char *temp0 = nullptr;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetParameterd(temp0, temp1);
    }
    else
    {
      op->vtkAnariDevice::SetParameterd(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_CommitParameters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CommitParameters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CommitParameters();
    }
    else
    {
      op->vtkAnariDevice::CommitParameters();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_GetAnariLibraryName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnariLibraryName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string *tempr = (ap.IsBound() ?
      &op->GetAnariLibraryName() :
      &op->vtkAnariDevice::GetAnariLibraryName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariDevice_GetAnariDeviceName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnariDeviceName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariDevice *op = static_cast<vtkAnariDevice *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string *tempr = (ap.IsBound() ?
      &op->GetAnariDeviceName() :
      &op->vtkAnariDevice::GetAnariDeviceName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkAnariDevice_Methods[] = {
  {"IsTypeOf", PyvtkAnariDevice_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkAnariDevice_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkAnariDevice_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkAnariDevice\nC++: static vtkAnariDevice *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkAnariDevice_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkAnariDevice\nC++: vtkAnariDevice *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkAnariDevice_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkAnariDevice_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetAnariDebugConfig", PyvtkAnariDevice_SetAnariDebugConfig, METH_VARARGS,
   "SetAnariDebugConfig(self, traceDir:str, traceMode:str) -> None\nC++: void SetAnariDebugConfig(const char *traceDir,\n    const char *traceMode)\n\nSetup the trace directory and trace mode strings for the debug\ndevice for when SetupAnariDeviceFromLibrary() is called. Once the\nAnari device is created, this method will have no effect.\n"},
  {"SetupAnariDeviceFromLibrary", PyvtkAnariDevice_SetupAnariDeviceFromLibrary, METH_VARARGS,
   "SetupAnariDeviceFromLibrary(self, libraryName:str, deviceName:str,\n     enableDebugLayer:bool=False) -> bool\nC++: bool SetupAnariDeviceFromLibrary(const char *libraryName,\n    const char *deviceName, bool enableDebugLayer=false)\n\nInitialize this vtkAnariDevice from the name of an anari::Library\nand anari::Device to be loaded. This initialization will use\nwhatever debug configuration set by SetupAnariDebugConfig() prior\nto this function when 'enableDebugLayer' is true. Returns success\nof getting everything setup.\n"},
  {"AnariInitialized", PyvtkAnariDevice_AnariInitialized, METH_VARARGS,
   "AnariInitialized(self) -> bool\nC++: bool AnariInitialized()\n\nCheck if ANARI has been initialized with\nSetupAnariDeviceFromLibrary\n"},
  {"SetParameterc", PyvtkAnariDevice_SetParameterc, METH_VARARGS,
   "SetParameterc(self, param:str, __b:str) -> None\nC++: void SetParameterc(const char *param, char *)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameterb", PyvtkAnariDevice_SetParameterb, METH_VARARGS,
   "SetParameterb(self, param:str, __b:bool) -> None\nC++: void SetParameterb(const char *param, bool)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameteri", PyvtkAnariDevice_SetParameteri, METH_VARARGS,
   "SetParameteri(self, param:str, __b:int) -> None\nC++: void SetParameteri(const char *param, int)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameter2i", PyvtkAnariDevice_SetParameter2i, METH_VARARGS,
   "SetParameter2i(self, param:str, __b:int, __c:int) -> None\nC++: void SetParameter2i(const char *param, int, int)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameter3i", PyvtkAnariDevice_SetParameter3i, METH_VARARGS,
   "SetParameter3i(self, param:str, __b:int, __c:int, __d:int) -> None\nC++: void SetParameter3i(const char *param, int, int, int)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameter4i", PyvtkAnariDevice_SetParameter4i, METH_VARARGS,
   "SetParameter4i(self, param:str, __b:int, __c:int, __d:int,\n    __e:int) -> None\nC++: void SetParameter4i(const char *param, int, int, int, int)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameterf", PyvtkAnariDevice_SetParameterf, METH_VARARGS,
   "SetParameterf(self, param:str, __b:float) -> None\nC++: void SetParameterf(const char *param, float)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameter2f", PyvtkAnariDevice_SetParameter2f, METH_VARARGS,
   "SetParameter2f(self, param:str, __b:float, __c:float) -> None\nC++: void SetParameter2f(const char *param, float, float)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameter3f", PyvtkAnariDevice_SetParameter3f, METH_VARARGS,
   "SetParameter3f(self, param:str, __b:float, __c:float, __d:float)\n    -> None\nC++: void SetParameter3f(const char *param, float, float, float)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameter4f", PyvtkAnariDevice_SetParameter4f, METH_VARARGS,
   "SetParameter4f(self, param:str, __b:float, __c:float, __d:float,\n    __e:float) -> None\nC++: void SetParameter4f(const char *param, float, float, float,\n    float)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameterd", PyvtkAnariDevice_SetParameterd, METH_VARARGS,
   "SetParameterd(self, param:str, __b:float) -> None\nC++: void SetParameterd(const char *param, double)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"CommitParameters", PyvtkAnariDevice_CommitParameters, METH_VARARGS,
   "CommitParameters(self) -> None\nC++: void CommitParameters()\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"GetAnariLibraryName", PyvtkAnariDevice_GetAnariLibraryName, METH_VARARGS,
   "GetAnariLibraryName(self) -> str\nC++: std::string &GetAnariLibraryName()\n\nGet the anari library name\n"},
  {"GetAnariDeviceName", PyvtkAnariDevice_GetAnariDeviceName, METH_VARARGS,
   "GetAnariDeviceName(self) -> str\nC++: std::string &GetAnariDeviceName()\n\nGet the anari device name\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkAnariDevice_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("anari_library_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAnariDevice_GetAnariLibraryName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAnariLibraryName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("anari_device_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAnariDevice_GetAnariDeviceName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAnariDeviceName\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkAnariDevice_Doc =
  "vtkAnariDevice - base class to objects which create + manage a ANARI\nlibrary + device\n\n"
  "Superclass: vtkObject\n\n"
  "Multiple VTK-ANARI objects are potentially responsible for creating\n"
  "and managing ANARI libraries and devices, so this base class\n"
  "consolidates the common functionality between them.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkAnariDevice_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingAnari.vtkAnariDevice", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkAnariDevice_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkAnariDevice_StaticNew()
{
  return vtkAnariDevice::New();
}

PyObject *PyvtkAnariDevice_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkAnariDevice_Type, PyvtkAnariDevice_Methods,
    "vtkAnariDevice",
 &PyvtkAnariDevice_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkAnariDevice_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkAnariDevice(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkAnariDevice_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkAnariDevice", o) != 0)
  {
    Py_DECREF(o);
  }

}

