#include "soapH.h"

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	a = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return a;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_new_byte(struct soap *soap, int n)
{
	char *a = static_cast<char *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(char)));
	for (char *p = a; p && n--; ++p)
		soap_default_byte(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	if (soap_out_byte(soap, tag ? tag : "byte", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_short(struct soap *soap, const char *tag, int id, const short *a, const char *type)
{
	return soap_outshort(soap, tag, id, a, type, SOAP_TYPE_short);
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_in_short(struct soap *soap, const char *tag, short *a, const char *type)
{
	a = soap_inshort(soap, tag, a, type, SOAP_TYPE_short);
	return a;
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_new_short(struct soap *soap, int n)
{
	short *a = static_cast<short *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(short)));
	for (short *p = a; p && n--; ++p)
		soap_default_short(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_short(struct soap *soap, const short *a, const char *tag, const char *type)
{
	if (soap_out_short(soap, tag ? tag : "short", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_get_short(struct soap *soap, short *p, const char *tag, const char *type)
{
	if ((p = soap_in_short(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	a = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return a;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_new_int(struct soap *soap, int n)
{
	int *a = static_cast<int *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(int)));
	for (int *p = a; p && n--; ++p)
		soap_default_int(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	if (soap_out_int(soap, tag ? tag : "int", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_LONG64(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_in_LONG64(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{
	a = soap_inLONG64(soap, tag, a, type, SOAP_TYPE_LONG64);
	return a;
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_new_LONG64(struct soap *soap, int n)
{
	LONG64 *a = static_cast<LONG64 *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(LONG64)));
	for (LONG64 *p = a; p && n--; ++p)
		soap_default_LONG64(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_LONG64(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
	if (soap_out_LONG64(soap, tag ? tag : "long", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_LONG64(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_LONG64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedShort(struct soap *soap, const char *tag, int id, const unsigned short *a, const char *type)
{
	return soap_outunsignedShort(soap, tag, id, a, type, SOAP_TYPE_unsignedShort);
}

SOAP_FMAC3 unsigned short * SOAP_FMAC4 soap_in_unsignedShort(struct soap *soap, const char *tag, unsigned short *a, const char *type)
{
	a = soap_inunsignedShort(soap, tag, a, type, SOAP_TYPE_unsignedShort);
	return a;
}

SOAP_FMAC3 unsigned short * SOAP_FMAC4 soap_new_unsignedShort(struct soap *soap, int n)
{
	unsigned short *a = static_cast<unsigned short *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(unsigned short)));
	for (unsigned short *p = a; p && n--; ++p)
		soap_default_unsignedShort(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedShort(struct soap *soap, const unsigned short *a, const char *tag, const char *type)
{
	if (soap_out_unsignedShort(soap, tag ? tag : "unsignedShort", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned short * SOAP_FMAC4 soap_get_unsignedShort(struct soap *soap, unsigned short *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedShort(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	a = soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
	return a;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_new_unsignedInt(struct soap *soap, int n)
{
	unsigned int *a = static_cast<unsigned int *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(unsigned int)));
	for (unsigned int *p = a; p && n--; ++p)
		soap_default_unsignedInt(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	if (soap_out_unsignedInt(soap, tag ? tag : "unsignedInt", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (LONG64)false, "false" },
	{ (LONG64)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{
	(void)soap; /* appease -Wall -Werror */
	return soap_code_str(soap_codes_bool, n != 0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type) || soap_send(soap, soap_bool2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2bool(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_bool, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_new_bool(struct soap *soap, int n)
{
	bool *a = static_cast<bool *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(bool)));
	for (bool *p = a; p && n--; ++p)
		soap_default_bool(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	if (soap_out_bool(soap, tag ? tag : "boolean", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__SymlinkPolicy[] =
{	{ (LONG64)vbox__SymlinkPolicy__None, "None" },
	{ (LONG64)vbox__SymlinkPolicy__Forbidden, "Forbidden" },
	{ (LONG64)vbox__SymlinkPolicy__AllowedInShareSubtree, "AllowedInShareSubtree" },
	{ (LONG64)vbox__SymlinkPolicy__AllowedToRelativeTargets, "AllowedToRelativeTargets" },
	{ (LONG64)vbox__SymlinkPolicy__AllowedToAnyTarget, "AllowedToAnyTarget" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__SymlinkPolicy2s(struct soap *soap, enum vbox__SymlinkPolicy n)
{
	const char *s = soap_code_str(soap_codes_vbox__SymlinkPolicy, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__SymlinkPolicy(struct soap *soap, const char *tag, int id, const enum vbox__SymlinkPolicy *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__SymlinkPolicy), type) || soap_send(soap, soap_vbox__SymlinkPolicy2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__SymlinkPolicy(struct soap *soap, const char *s, enum vbox__SymlinkPolicy *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__SymlinkPolicy, s);
	if (map)
		*a = (enum vbox__SymlinkPolicy)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__SymlinkPolicy)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__SymlinkPolicy * SOAP_FMAC4 soap_in_vbox__SymlinkPolicy(struct soap *soap, const char *tag, enum vbox__SymlinkPolicy *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__SymlinkPolicy*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__SymlinkPolicy, sizeof(enum vbox__SymlinkPolicy), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__SymlinkPolicy(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__SymlinkPolicy *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__SymlinkPolicy, SOAP_TYPE_vbox__SymlinkPolicy, sizeof(enum vbox__SymlinkPolicy), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__SymlinkPolicy * SOAP_FMAC4 soap_new_vbox__SymlinkPolicy(struct soap *soap, int n)
{
	enum vbox__SymlinkPolicy *a = static_cast<enum vbox__SymlinkPolicy *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__SymlinkPolicy)));
	for (enum vbox__SymlinkPolicy *p = a; p && n--; ++p)
		soap_default_vbox__SymlinkPolicy(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__SymlinkPolicy(struct soap *soap, const enum vbox__SymlinkPolicy *a, const char *tag, const char *type)
{
	if (soap_out_vbox__SymlinkPolicy(soap, tag ? tag : "vbox:SymlinkPolicy", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__SymlinkPolicy * SOAP_FMAC4 soap_get_vbox__SymlinkPolicy(struct soap *soap, enum vbox__SymlinkPolicy *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__SymlinkPolicy(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__MetricType[] =
{	{ (LONG64)vbox__MetricType__Invalid, "Invalid" },
	{ (LONG64)vbox__MetricType__CpuUtilization, "CpuUtilization" },
	{ (LONG64)vbox__MetricType__MemoryUtilization, "MemoryUtilization" },
	{ (LONG64)vbox__MetricType__DiskBytesRead, "DiskBytesRead" },
	{ (LONG64)vbox__MetricType__DiskBytesWritten, "DiskBytesWritten" },
	{ (LONG64)vbox__MetricType__NetworksBytesIn, "NetworksBytesIn" },
	{ (LONG64)vbox__MetricType__NetworksBytesOut, "NetworksBytesOut" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__MetricType2s(struct soap *soap, enum vbox__MetricType n)
{
	const char *s = soap_code_str(soap_codes_vbox__MetricType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__MetricType(struct soap *soap, const char *tag, int id, const enum vbox__MetricType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__MetricType), type) || soap_send(soap, soap_vbox__MetricType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__MetricType(struct soap *soap, const char *s, enum vbox__MetricType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__MetricType, s);
	if (map)
		*a = (enum vbox__MetricType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 6)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__MetricType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__MetricType * SOAP_FMAC4 soap_in_vbox__MetricType(struct soap *soap, const char *tag, enum vbox__MetricType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__MetricType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__MetricType, sizeof(enum vbox__MetricType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__MetricType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__MetricType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__MetricType, SOAP_TYPE_vbox__MetricType, sizeof(enum vbox__MetricType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__MetricType * SOAP_FMAC4 soap_new_vbox__MetricType(struct soap *soap, int n)
{
	enum vbox__MetricType *a = static_cast<enum vbox__MetricType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__MetricType)));
	for (enum vbox__MetricType *p = a; p && n--; ++p)
		soap_default_vbox__MetricType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__MetricType(struct soap *soap, const enum vbox__MetricType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__MetricType(soap, tag ? tag : "vbox:MetricType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__MetricType * SOAP_FMAC4 soap_get_vbox__MetricType(struct soap *soap, enum vbox__MetricType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__MetricType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__CloudImageState[] =
{	{ (LONG64)vbox__CloudImageState__Invalid, "Invalid" },
	{ (LONG64)vbox__CloudImageState__Provisioning, "Provisioning" },
	{ (LONG64)vbox__CloudImageState__Importing, "Importing" },
	{ (LONG64)vbox__CloudImageState__Available, "Available" },
	{ (LONG64)vbox__CloudImageState__Exporting, "Exporting" },
	{ (LONG64)vbox__CloudImageState__Disabled, "Disabled" },
	{ (LONG64)vbox__CloudImageState__Deleted, "Deleted" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__CloudImageState2s(struct soap *soap, enum vbox__CloudImageState n)
{
	const char *s = soap_code_str(soap_codes_vbox__CloudImageState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__CloudImageState(struct soap *soap, const char *tag, int id, const enum vbox__CloudImageState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__CloudImageState), type) || soap_send(soap, soap_vbox__CloudImageState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__CloudImageState(struct soap *soap, const char *s, enum vbox__CloudImageState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__CloudImageState, s);
	if (map)
		*a = (enum vbox__CloudImageState)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 6)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__CloudImageState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__CloudImageState * SOAP_FMAC4 soap_in_vbox__CloudImageState(struct soap *soap, const char *tag, enum vbox__CloudImageState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__CloudImageState*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__CloudImageState, sizeof(enum vbox__CloudImageState), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__CloudImageState(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__CloudImageState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__CloudImageState, SOAP_TYPE_vbox__CloudImageState, sizeof(enum vbox__CloudImageState), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__CloudImageState * SOAP_FMAC4 soap_new_vbox__CloudImageState(struct soap *soap, int n)
{
	enum vbox__CloudImageState *a = static_cast<enum vbox__CloudImageState *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__CloudImageState)));
	for (enum vbox__CloudImageState *p = a; p && n--; ++p)
		soap_default_vbox__CloudImageState(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__CloudImageState(struct soap *soap, const enum vbox__CloudImageState *a, const char *tag, const char *type)
{
	if (soap_out_vbox__CloudImageState(soap, tag ? tag : "vbox:CloudImageState", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__CloudImageState * SOAP_FMAC4 soap_get_vbox__CloudImageState(struct soap *soap, enum vbox__CloudImageState *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__CloudImageState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__CloudMachineState[] =
{	{ (LONG64)vbox__CloudMachineState__Invalid, "Invalid" },
	{ (LONG64)vbox__CloudMachineState__Provisioning, "Provisioning" },
	{ (LONG64)vbox__CloudMachineState__Running, "Running" },
	{ (LONG64)vbox__CloudMachineState__Starting, "Starting" },
	{ (LONG64)vbox__CloudMachineState__Stopping, "Stopping" },
	{ (LONG64)vbox__CloudMachineState__Stopped, "Stopped" },
	{ (LONG64)vbox__CloudMachineState__CreatingImage, "CreatingImage" },
	{ (LONG64)vbox__CloudMachineState__Terminating, "Terminating" },
	{ (LONG64)vbox__CloudMachineState__Terminated, "Terminated" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__CloudMachineState2s(struct soap *soap, enum vbox__CloudMachineState n)
{
	const char *s = soap_code_str(soap_codes_vbox__CloudMachineState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__CloudMachineState(struct soap *soap, const char *tag, int id, const enum vbox__CloudMachineState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__CloudMachineState), type) || soap_send(soap, soap_vbox__CloudMachineState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__CloudMachineState(struct soap *soap, const char *s, enum vbox__CloudMachineState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__CloudMachineState, s);
	if (map)
		*a = (enum vbox__CloudMachineState)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 8)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__CloudMachineState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__CloudMachineState * SOAP_FMAC4 soap_in_vbox__CloudMachineState(struct soap *soap, const char *tag, enum vbox__CloudMachineState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__CloudMachineState*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__CloudMachineState, sizeof(enum vbox__CloudMachineState), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__CloudMachineState(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__CloudMachineState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__CloudMachineState, SOAP_TYPE_vbox__CloudMachineState, sizeof(enum vbox__CloudMachineState), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__CloudMachineState * SOAP_FMAC4 soap_new_vbox__CloudMachineState(struct soap *soap, int n)
{
	enum vbox__CloudMachineState *a = static_cast<enum vbox__CloudMachineState *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__CloudMachineState)));
	for (enum vbox__CloudMachineState *p = a; p && n--; ++p)
		soap_default_vbox__CloudMachineState(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__CloudMachineState(struct soap *soap, const enum vbox__CloudMachineState *a, const char *tag, const char *type)
{
	if (soap_out_vbox__CloudMachineState(soap, tag ? tag : "vbox:CloudMachineState", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__CloudMachineState * SOAP_FMAC4 soap_get_vbox__CloudMachineState(struct soap *soap, enum vbox__CloudMachineState *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__CloudMachineState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FormValueType[] =
{	{ (LONG64)vbox__FormValueType__Boolean, "Boolean" },
	{ (LONG64)vbox__FormValueType__String, "String" },
	{ (LONG64)vbox__FormValueType__Choice, "Choice" },
	{ (LONG64)vbox__FormValueType__RangedInteger, "RangedInteger" },
	{ (LONG64)vbox__FormValueType__RangedInteger64, "RangedInteger64" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FormValueType2s(struct soap *soap, enum vbox__FormValueType n)
{
	const char *s = soap_code_str(soap_codes_vbox__FormValueType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FormValueType(struct soap *soap, const char *tag, int id, const enum vbox__FormValueType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FormValueType), type) || soap_send(soap, soap_vbox__FormValueType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FormValueType(struct soap *soap, const char *s, enum vbox__FormValueType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FormValueType, s);
	if (map)
		*a = (enum vbox__FormValueType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FormValueType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FormValueType * SOAP_FMAC4 soap_in_vbox__FormValueType(struct soap *soap, const char *tag, enum vbox__FormValueType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FormValueType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FormValueType, sizeof(enum vbox__FormValueType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FormValueType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FormValueType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FormValueType, SOAP_TYPE_vbox__FormValueType, sizeof(enum vbox__FormValueType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FormValueType * SOAP_FMAC4 soap_new_vbox__FormValueType(struct soap *soap, int n)
{
	enum vbox__FormValueType *a = static_cast<enum vbox__FormValueType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FormValueType)));
	for (enum vbox__FormValueType *p = a; p && n--; ++p)
		soap_default_vbox__FormValueType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FormValueType(struct soap *soap, const enum vbox__FormValueType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FormValueType(soap, tag ? tag : "vbox:FormValueType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FormValueType * SOAP_FMAC4 soap_get_vbox__FormValueType(struct soap *soap, enum vbox__FormValueType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FormValueType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__GuestMonitorChangedEventType[] =
{	{ (LONG64)vbox__GuestMonitorChangedEventType__Enabled, "Enabled" },
	{ (LONG64)vbox__GuestMonitorChangedEventType__Disabled, "Disabled" },
	{ (LONG64)vbox__GuestMonitorChangedEventType__NewOrigin, "NewOrigin" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__GuestMonitorChangedEventType2s(struct soap *soap, enum vbox__GuestMonitorChangedEventType n)
{
	const char *s = soap_code_str(soap_codes_vbox__GuestMonitorChangedEventType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__GuestMonitorChangedEventType(struct soap *soap, const char *tag, int id, const enum vbox__GuestMonitorChangedEventType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__GuestMonitorChangedEventType), type) || soap_send(soap, soap_vbox__GuestMonitorChangedEventType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__GuestMonitorChangedEventType(struct soap *soap, const char *s, enum vbox__GuestMonitorChangedEventType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__GuestMonitorChangedEventType, s);
	if (map)
		*a = (enum vbox__GuestMonitorChangedEventType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__GuestMonitorChangedEventType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__GuestMonitorChangedEventType * SOAP_FMAC4 soap_in_vbox__GuestMonitorChangedEventType(struct soap *soap, const char *tag, enum vbox__GuestMonitorChangedEventType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__GuestMonitorChangedEventType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__GuestMonitorChangedEventType, sizeof(enum vbox__GuestMonitorChangedEventType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__GuestMonitorChangedEventType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__GuestMonitorChangedEventType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__GuestMonitorChangedEventType, SOAP_TYPE_vbox__GuestMonitorChangedEventType, sizeof(enum vbox__GuestMonitorChangedEventType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__GuestMonitorChangedEventType * SOAP_FMAC4 soap_new_vbox__GuestMonitorChangedEventType(struct soap *soap, int n)
{
	enum vbox__GuestMonitorChangedEventType *a = static_cast<enum vbox__GuestMonitorChangedEventType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__GuestMonitorChangedEventType)));
	for (enum vbox__GuestMonitorChangedEventType *p = a; p && n--; ++p)
		soap_default_vbox__GuestMonitorChangedEventType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__GuestMonitorChangedEventType(struct soap *soap, const enum vbox__GuestMonitorChangedEventType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__GuestMonitorChangedEventType(soap, tag ? tag : "vbox:GuestMonitorChangedEventType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__GuestMonitorChangedEventType * SOAP_FMAC4 soap_get_vbox__GuestMonitorChangedEventType(struct soap *soap, enum vbox__GuestMonitorChangedEventType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__GuestMonitorChangedEventType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__GuestMouseEventMode[] =
{	{ (LONG64)vbox__GuestMouseEventMode__Relative, "Relative" },
	{ (LONG64)vbox__GuestMouseEventMode__Absolute, "Absolute" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__GuestMouseEventMode2s(struct soap *soap, enum vbox__GuestMouseEventMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__GuestMouseEventMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__GuestMouseEventMode(struct soap *soap, const char *tag, int id, const enum vbox__GuestMouseEventMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__GuestMouseEventMode), type) || soap_send(soap, soap_vbox__GuestMouseEventMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__GuestMouseEventMode(struct soap *soap, const char *s, enum vbox__GuestMouseEventMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__GuestMouseEventMode, s);
	if (map)
		*a = (enum vbox__GuestMouseEventMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__GuestMouseEventMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__GuestMouseEventMode * SOAP_FMAC4 soap_in_vbox__GuestMouseEventMode(struct soap *soap, const char *tag, enum vbox__GuestMouseEventMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__GuestMouseEventMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__GuestMouseEventMode, sizeof(enum vbox__GuestMouseEventMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__GuestMouseEventMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__GuestMouseEventMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__GuestMouseEventMode, SOAP_TYPE_vbox__GuestMouseEventMode, sizeof(enum vbox__GuestMouseEventMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__GuestMouseEventMode * SOAP_FMAC4 soap_new_vbox__GuestMouseEventMode(struct soap *soap, int n)
{
	enum vbox__GuestMouseEventMode *a = static_cast<enum vbox__GuestMouseEventMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__GuestMouseEventMode)));
	for (enum vbox__GuestMouseEventMode *p = a; p && n--; ++p)
		soap_default_vbox__GuestMouseEventMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__GuestMouseEventMode(struct soap *soap, const enum vbox__GuestMouseEventMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__GuestMouseEventMode(soap, tag ? tag : "vbox:GuestMouseEventMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__GuestMouseEventMode * SOAP_FMAC4 soap_get_vbox__GuestMouseEventMode(struct soap *soap, enum vbox__GuestMouseEventMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__GuestMouseEventMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__VBoxEventType[] =
{	{ (LONG64)vbox__VBoxEventType__Invalid, "Invalid" },
	{ (LONG64)vbox__VBoxEventType__Any, "Any" },
	{ (LONG64)vbox__VBoxEventType__Vetoable, "Vetoable" },
	{ (LONG64)vbox__VBoxEventType__MachineEvent, "MachineEvent" },
	{ (LONG64)vbox__VBoxEventType__SnapshotEvent, "SnapshotEvent" },
	{ (LONG64)vbox__VBoxEventType__InputEvent, "InputEvent" },
	{ (LONG64)vbox__VBoxEventType__LastWildcard, "LastWildcard" },
	{ (LONG64)vbox__VBoxEventType__OnMachineStateChanged, "OnMachineStateChanged" },
	{ (LONG64)vbox__VBoxEventType__OnMachineDataChanged, "OnMachineDataChanged" },
	{ (LONG64)vbox__VBoxEventType__OnExtraDataChanged, "OnExtraDataChanged" },
	{ (LONG64)vbox__VBoxEventType__OnExtraDataCanChange, "OnExtraDataCanChange" },
	{ (LONG64)vbox__VBoxEventType__OnMediumRegistered, "OnMediumRegistered" },
	{ (LONG64)vbox__VBoxEventType__OnMachineRegistered, "OnMachineRegistered" },
	{ (LONG64)vbox__VBoxEventType__OnSessionStateChanged, "OnSessionStateChanged" },
	{ (LONG64)vbox__VBoxEventType__OnSnapshotTaken, "OnSnapshotTaken" },
	{ (LONG64)vbox__VBoxEventType__OnSnapshotDeleted, "OnSnapshotDeleted" },
	{ (LONG64)vbox__VBoxEventType__OnSnapshotChanged, "OnSnapshotChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestPropertyChanged, "OnGuestPropertyChanged" },
	{ (LONG64)vbox__VBoxEventType__OnMousePointerShapeChanged, "OnMousePointerShapeChanged" },
	{ (LONG64)vbox__VBoxEventType__OnMouseCapabilityChanged, "OnMouseCapabilityChanged" },
	{ (LONG64)vbox__VBoxEventType__OnKeyboardLedsChanged, "OnKeyboardLedsChanged" },
	{ (LONG64)vbox__VBoxEventType__OnStateChanged, "OnStateChanged" },
	{ (LONG64)vbox__VBoxEventType__OnAdditionsStateChanged, "OnAdditionsStateChanged" },
	{ (LONG64)vbox__VBoxEventType__OnNetworkAdapterChanged, "OnNetworkAdapterChanged" },
	{ (LONG64)vbox__VBoxEventType__OnSerialPortChanged, "OnSerialPortChanged" },
	{ (LONG64)vbox__VBoxEventType__OnParallelPortChanged, "OnParallelPortChanged" },
	{ (LONG64)vbox__VBoxEventType__OnStorageControllerChanged, "OnStorageControllerChanged" },
	{ (LONG64)vbox__VBoxEventType__OnMediumChanged, "OnMediumChanged" },
	{ (LONG64)vbox__VBoxEventType__OnVRDEServerChanged, "OnVRDEServerChanged" },
	{ (LONG64)vbox__VBoxEventType__OnUSBControllerChanged, "OnUSBControllerChanged" },
	{ (LONG64)vbox__VBoxEventType__OnUSBDeviceStateChanged, "OnUSBDeviceStateChanged" },
	{ (LONG64)vbox__VBoxEventType__OnSharedFolderChanged, "OnSharedFolderChanged" },
	{ (LONG64)vbox__VBoxEventType__OnRuntimeError, "OnRuntimeError" },
	{ (LONG64)vbox__VBoxEventType__OnCanShowWindow, "OnCanShowWindow" },
	{ (LONG64)vbox__VBoxEventType__OnShowWindow, "OnShowWindow" },
	{ (LONG64)vbox__VBoxEventType__OnCPUChanged, "OnCPUChanged" },
	{ (LONG64)vbox__VBoxEventType__OnVRDEServerInfoChanged, "OnVRDEServerInfoChanged" },
	{ (LONG64)vbox__VBoxEventType__OnEventSourceChanged, "OnEventSourceChanged" },
	{ (LONG64)vbox__VBoxEventType__OnCPUExecutionCapChanged, "OnCPUExecutionCapChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestKeyboard, "OnGuestKeyboard" },
	{ (LONG64)vbox__VBoxEventType__OnGuestMouse, "OnGuestMouse" },
	{ (LONG64)vbox__VBoxEventType__OnNATRedirect, "OnNATRedirect" },
	{ (LONG64)vbox__VBoxEventType__OnHostPCIDevicePlug, "OnHostPCIDevicePlug" },
	{ (LONG64)vbox__VBoxEventType__OnVBoxSVCAvailabilityChanged, "OnVBoxSVCAvailabilityChanged" },
	{ (LONG64)vbox__VBoxEventType__OnBandwidthGroupChanged, "OnBandwidthGroupChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestMonitorChanged, "OnGuestMonitorChanged" },
	{ (LONG64)vbox__VBoxEventType__OnStorageDeviceChanged, "OnStorageDeviceChanged" },
	{ (LONG64)vbox__VBoxEventType__OnClipboardModeChanged, "OnClipboardModeChanged" },
	{ (LONG64)vbox__VBoxEventType__OnDnDModeChanged, "OnDnDModeChanged" },
	{ (LONG64)vbox__VBoxEventType__OnNATNetworkChanged, "OnNATNetworkChanged" },
	{ (LONG64)vbox__VBoxEventType__OnNATNetworkStartStop, "OnNATNetworkStartStop" },
	{ (LONG64)vbox__VBoxEventType__OnNATNetworkAlter, "OnNATNetworkAlter" },
	{ (LONG64)vbox__VBoxEventType__OnNATNetworkCreationDeletion, "OnNATNetworkCreationDeletion" },
	{ (LONG64)vbox__VBoxEventType__OnNATNetworkSetting, "OnNATNetworkSetting" },
	{ (LONG64)vbox__VBoxEventType__OnNATNetworkPortForward, "OnNATNetworkPortForward" },
	{ (LONG64)vbox__VBoxEventType__OnGuestSessionStateChanged, "OnGuestSessionStateChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestSessionRegistered, "OnGuestSessionRegistered" },
	{ (LONG64)vbox__VBoxEventType__OnGuestProcessRegistered, "OnGuestProcessRegistered" },
	{ (LONG64)vbox__VBoxEventType__OnGuestProcessStateChanged, "OnGuestProcessStateChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestProcessInputNotify, "OnGuestProcessInputNotify" },
	{ (LONG64)vbox__VBoxEventType__OnGuestProcessOutput, "OnGuestProcessOutput" },
	{ (LONG64)vbox__VBoxEventType__OnGuestFileRegistered, "OnGuestFileRegistered" },
	{ (LONG64)vbox__VBoxEventType__OnGuestFileStateChanged, "OnGuestFileStateChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestFileOffsetChanged, "OnGuestFileOffsetChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestFileRead, "OnGuestFileRead" },
	{ (LONG64)vbox__VBoxEventType__OnGuestFileWrite, "OnGuestFileWrite" },
	{ (LONG64)vbox__VBoxEventType__OnRecordingStateChanged, "OnRecordingStateChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestUserStateChanged, "OnGuestUserStateChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestMultiTouch, "OnGuestMultiTouch" },
	{ (LONG64)vbox__VBoxEventType__OnHostNameResolutionConfigurationChange, "OnHostNameResolutionConfigurationChange" },
	{ (LONG64)vbox__VBoxEventType__OnSnapshotRestored, "OnSnapshotRestored" },
	{ (LONG64)vbox__VBoxEventType__OnMediumConfigChanged, "OnMediumConfigChanged" },
	{ (LONG64)vbox__VBoxEventType__OnAudioAdapterChanged, "OnAudioAdapterChanged" },
	{ (LONG64)vbox__VBoxEventType__OnProgressPercentageChanged, "OnProgressPercentageChanged" },
	{ (LONG64)vbox__VBoxEventType__OnProgressTaskCompleted, "OnProgressTaskCompleted" },
	{ (LONG64)vbox__VBoxEventType__OnCursorPositionChanged, "OnCursorPositionChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestAdditionsStatusChanged, "OnGuestAdditionsStatusChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestMonitorInfoChanged, "OnGuestMonitorInfoChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestFileSizeChanged, "OnGuestFileSizeChanged" },
	{ (LONG64)vbox__VBoxEventType__OnClipboardFileTransferModeChanged, "OnClipboardFileTransferModeChanged" },
	{ (LONG64)vbox__VBoxEventType__OnCloudProviderListChanged, "OnCloudProviderListChanged" },
	{ (LONG64)vbox__VBoxEventType__OnCloudProviderRegistered, "OnCloudProviderRegistered" },
	{ (LONG64)vbox__VBoxEventType__OnCloudProviderUninstall, "OnCloudProviderUninstall" },
	{ (LONG64)vbox__VBoxEventType__OnCloudProfileRegistered, "OnCloudProfileRegistered" },
	{ (LONG64)vbox__VBoxEventType__OnCloudProfileChanged, "OnCloudProfileChanged" },
	{ (LONG64)vbox__VBoxEventType__OnProgressCreated, "OnProgressCreated" },
	{ (LONG64)vbox__VBoxEventType__OnLanguageChanged, "OnLanguageChanged" },
	{ (LONG64)vbox__VBoxEventType__OnUpdateAgentAvailable, "OnUpdateAgentAvailable" },
	{ (LONG64)vbox__VBoxEventType__OnUpdateAgentError, "OnUpdateAgentError" },
	{ (LONG64)vbox__VBoxEventType__OnUpdateAgentSettingsChanged, "OnUpdateAgentSettingsChanged" },
	{ (LONG64)vbox__VBoxEventType__OnUpdateAgentStateChanged, "OnUpdateAgentStateChanged" },
	{ (LONG64)vbox__VBoxEventType__OnHostAudioDeviceChanged, "OnHostAudioDeviceChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestDebugControlChanged, "OnGuestDebugControlChanged" },
	{ (LONG64)vbox__VBoxEventType__OnMachineGroupsChanged, "OnMachineGroupsChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestDirectoryRegistered, "OnGuestDirectoryRegistered" },
	{ (LONG64)vbox__VBoxEventType__OnGuestDirectoryStateChanged, "OnGuestDirectoryStateChanged" },
	{ (LONG64)vbox__VBoxEventType__OnGuestDirectoryRead, "OnGuestDirectoryRead" },
	{ (LONG64)vbox__VBoxEventType__OnClipboardError, "OnClipboardError" },
	{ (LONG64)vbox__VBoxEventType__OnExtPackInstalled, "OnExtPackInstalled" },
	{ (LONG64)vbox__VBoxEventType__OnExtPackUninstalled, "OnExtPackUninstalled" },
	{ (LONG64)vbox__VBoxEventType__OnRecordingScreenStateChanged, "OnRecordingScreenStateChanged" },
	{ (LONG64)vbox__VBoxEventType__End, "End" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__VBoxEventType2s(struct soap *soap, enum vbox__VBoxEventType n)
{
	const char *s = soap_code_str(soap_codes_vbox__VBoxEventType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__VBoxEventType(struct soap *soap, const char *tag, int id, const enum vbox__VBoxEventType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__VBoxEventType), type) || soap_send(soap, soap_vbox__VBoxEventType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__VBoxEventType(struct soap *soap, const char *s, enum vbox__VBoxEventType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__VBoxEventType, s);
	if (map)
		*a = (enum vbox__VBoxEventType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 101)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__VBoxEventType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__VBoxEventType * SOAP_FMAC4 soap_in_vbox__VBoxEventType(struct soap *soap, const char *tag, enum vbox__VBoxEventType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__VBoxEventType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__VBoxEventType, sizeof(enum vbox__VBoxEventType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__VBoxEventType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__VBoxEventType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__VBoxEventType, SOAP_TYPE_vbox__VBoxEventType, sizeof(enum vbox__VBoxEventType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__VBoxEventType * SOAP_FMAC4 soap_new_vbox__VBoxEventType(struct soap *soap, int n)
{
	enum vbox__VBoxEventType *a = static_cast<enum vbox__VBoxEventType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__VBoxEventType)));
	for (enum vbox__VBoxEventType *p = a; p && n--; ++p)
		soap_default_vbox__VBoxEventType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__VBoxEventType(struct soap *soap, const enum vbox__VBoxEventType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__VBoxEventType(soap, tag ? tag : "vbox:VBoxEventType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__VBoxEventType * SOAP_FMAC4 soap_get_vbox__VBoxEventType(struct soap *soap, enum vbox__VBoxEventType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__VBoxEventType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__GuestDebugIoProvider[] =
{	{ (LONG64)vbox__GuestDebugIoProvider__None, "None" },
	{ (LONG64)vbox__GuestDebugIoProvider__TCP, "TCP" },
	{ (LONG64)vbox__GuestDebugIoProvider__UDP, "UDP" },
	{ (LONG64)vbox__GuestDebugIoProvider__IPC, "IPC" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__GuestDebugIoProvider2s(struct soap *soap, enum vbox__GuestDebugIoProvider n)
{
	const char *s = soap_code_str(soap_codes_vbox__GuestDebugIoProvider, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__GuestDebugIoProvider(struct soap *soap, const char *tag, int id, const enum vbox__GuestDebugIoProvider *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__GuestDebugIoProvider), type) || soap_send(soap, soap_vbox__GuestDebugIoProvider2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__GuestDebugIoProvider(struct soap *soap, const char *s, enum vbox__GuestDebugIoProvider *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__GuestDebugIoProvider, s);
	if (map)
		*a = (enum vbox__GuestDebugIoProvider)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__GuestDebugIoProvider)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__GuestDebugIoProvider * SOAP_FMAC4 soap_in_vbox__GuestDebugIoProvider(struct soap *soap, const char *tag, enum vbox__GuestDebugIoProvider *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__GuestDebugIoProvider*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__GuestDebugIoProvider, sizeof(enum vbox__GuestDebugIoProvider), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__GuestDebugIoProvider(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__GuestDebugIoProvider *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__GuestDebugIoProvider, SOAP_TYPE_vbox__GuestDebugIoProvider, sizeof(enum vbox__GuestDebugIoProvider), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__GuestDebugIoProvider * SOAP_FMAC4 soap_new_vbox__GuestDebugIoProvider(struct soap *soap, int n)
{
	enum vbox__GuestDebugIoProvider *a = static_cast<enum vbox__GuestDebugIoProvider *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__GuestDebugIoProvider)));
	for (enum vbox__GuestDebugIoProvider *p = a; p && n--; ++p)
		soap_default_vbox__GuestDebugIoProvider(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__GuestDebugIoProvider(struct soap *soap, const enum vbox__GuestDebugIoProvider *a, const char *tag, const char *type)
{
	if (soap_out_vbox__GuestDebugIoProvider(soap, tag ? tag : "vbox:GuestDebugIoProvider", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__GuestDebugIoProvider * SOAP_FMAC4 soap_get_vbox__GuestDebugIoProvider(struct soap *soap, enum vbox__GuestDebugIoProvider *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__GuestDebugIoProvider(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__GuestDebugProvider[] =
{	{ (LONG64)vbox__GuestDebugProvider__None, "None" },
	{ (LONG64)vbox__GuestDebugProvider__Native, "Native" },
	{ (LONG64)vbox__GuestDebugProvider__GDB, "GDB" },
	{ (LONG64)vbox__GuestDebugProvider__KD, "KD" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__GuestDebugProvider2s(struct soap *soap, enum vbox__GuestDebugProvider n)
{
	const char *s = soap_code_str(soap_codes_vbox__GuestDebugProvider, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__GuestDebugProvider(struct soap *soap, const char *tag, int id, const enum vbox__GuestDebugProvider *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__GuestDebugProvider), type) || soap_send(soap, soap_vbox__GuestDebugProvider2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__GuestDebugProvider(struct soap *soap, const char *s, enum vbox__GuestDebugProvider *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__GuestDebugProvider, s);
	if (map)
		*a = (enum vbox__GuestDebugProvider)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__GuestDebugProvider)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__GuestDebugProvider * SOAP_FMAC4 soap_in_vbox__GuestDebugProvider(struct soap *soap, const char *tag, enum vbox__GuestDebugProvider *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__GuestDebugProvider*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__GuestDebugProvider, sizeof(enum vbox__GuestDebugProvider), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__GuestDebugProvider(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__GuestDebugProvider *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__GuestDebugProvider, SOAP_TYPE_vbox__GuestDebugProvider, sizeof(enum vbox__GuestDebugProvider), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__GuestDebugProvider * SOAP_FMAC4 soap_new_vbox__GuestDebugProvider(struct soap *soap, int n)
{
	enum vbox__GuestDebugProvider *a = static_cast<enum vbox__GuestDebugProvider *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__GuestDebugProvider)));
	for (enum vbox__GuestDebugProvider *p = a; p && n--; ++p)
		soap_default_vbox__GuestDebugProvider(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__GuestDebugProvider(struct soap *soap, const enum vbox__GuestDebugProvider *a, const char *tag, const char *type)
{
	if (soap_out_vbox__GuestDebugProvider(soap, tag ? tag : "vbox:GuestDebugProvider", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__GuestDebugProvider * SOAP_FMAC4 soap_get_vbox__GuestDebugProvider(struct soap *soap, enum vbox__GuestDebugProvider *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__GuestDebugProvider(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__BandwidthGroupType[] =
{	{ (LONG64)vbox__BandwidthGroupType__Null, "Null" },
	{ (LONG64)vbox__BandwidthGroupType__Disk, "Disk" },
	{ (LONG64)vbox__BandwidthGroupType__Network, "Network" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__BandwidthGroupType2s(struct soap *soap, enum vbox__BandwidthGroupType n)
{
	const char *s = soap_code_str(soap_codes_vbox__BandwidthGroupType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__BandwidthGroupType(struct soap *soap, const char *tag, int id, const enum vbox__BandwidthGroupType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__BandwidthGroupType), type) || soap_send(soap, soap_vbox__BandwidthGroupType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__BandwidthGroupType(struct soap *soap, const char *s, enum vbox__BandwidthGroupType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__BandwidthGroupType, s);
	if (map)
		*a = (enum vbox__BandwidthGroupType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__BandwidthGroupType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__BandwidthGroupType * SOAP_FMAC4 soap_in_vbox__BandwidthGroupType(struct soap *soap, const char *tag, enum vbox__BandwidthGroupType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__BandwidthGroupType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__BandwidthGroupType, sizeof(enum vbox__BandwidthGroupType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__BandwidthGroupType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__BandwidthGroupType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__BandwidthGroupType, SOAP_TYPE_vbox__BandwidthGroupType, sizeof(enum vbox__BandwidthGroupType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__BandwidthGroupType * SOAP_FMAC4 soap_new_vbox__BandwidthGroupType(struct soap *soap, int n)
{
	enum vbox__BandwidthGroupType *a = static_cast<enum vbox__BandwidthGroupType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__BandwidthGroupType)));
	for (enum vbox__BandwidthGroupType *p = a; p && n--; ++p)
		soap_default_vbox__BandwidthGroupType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__BandwidthGroupType(struct soap *soap, const enum vbox__BandwidthGroupType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__BandwidthGroupType(soap, tag ? tag : "vbox:BandwidthGroupType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__BandwidthGroupType * SOAP_FMAC4 soap_get_vbox__BandwidthGroupType(struct soap *soap, enum vbox__BandwidthGroupType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__BandwidthGroupType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__NATProtocol[] =
{	{ (LONG64)vbox__NATProtocol__UDP, "UDP" },
	{ (LONG64)vbox__NATProtocol__TCP, "TCP" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__NATProtocol2s(struct soap *soap, enum vbox__NATProtocol n)
{
	const char *s = soap_code_str(soap_codes_vbox__NATProtocol, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__NATProtocol(struct soap *soap, const char *tag, int id, const enum vbox__NATProtocol *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__NATProtocol), type) || soap_send(soap, soap_vbox__NATProtocol2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__NATProtocol(struct soap *soap, const char *s, enum vbox__NATProtocol *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__NATProtocol, s);
	if (map)
		*a = (enum vbox__NATProtocol)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__NATProtocol)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__NATProtocol * SOAP_FMAC4 soap_in_vbox__NATProtocol(struct soap *soap, const char *tag, enum vbox__NATProtocol *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__NATProtocol*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__NATProtocol, sizeof(enum vbox__NATProtocol), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__NATProtocol(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__NATProtocol *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__NATProtocol, SOAP_TYPE_vbox__NATProtocol, sizeof(enum vbox__NATProtocol), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__NATProtocol * SOAP_FMAC4 soap_new_vbox__NATProtocol(struct soap *soap, int n)
{
	enum vbox__NATProtocol *a = static_cast<enum vbox__NATProtocol *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__NATProtocol)));
	for (enum vbox__NATProtocol *p = a; p && n--; ++p)
		soap_default_vbox__NATProtocol(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__NATProtocol(struct soap *soap, const enum vbox__NATProtocol *a, const char *tag, const char *type)
{
	if (soap_out_vbox__NATProtocol(soap, tag ? tag : "vbox:NATProtocol", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__NATProtocol * SOAP_FMAC4 soap_get_vbox__NATProtocol(struct soap *soap, enum vbox__NATProtocol *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__NATProtocol(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__NATAliasMode[] =
{	{ (LONG64)vbox__NATAliasMode__AliasLog, "AliasLog" },
	{ (LONG64)vbox__NATAliasMode__AliasProxyOnly, "AliasProxyOnly" },
	{ (LONG64)vbox__NATAliasMode__AliasUseSamePorts, "AliasUseSamePorts" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__NATAliasMode2s(struct soap *soap, enum vbox__NATAliasMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__NATAliasMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__NATAliasMode(struct soap *soap, const char *tag, int id, const enum vbox__NATAliasMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__NATAliasMode), type) || soap_send(soap, soap_vbox__NATAliasMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__NATAliasMode(struct soap *soap, const char *s, enum vbox__NATAliasMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__NATAliasMode, s);
	if (map)
		*a = (enum vbox__NATAliasMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__NATAliasMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__NATAliasMode * SOAP_FMAC4 soap_in_vbox__NATAliasMode(struct soap *soap, const char *tag, enum vbox__NATAliasMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__NATAliasMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__NATAliasMode, sizeof(enum vbox__NATAliasMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__NATAliasMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__NATAliasMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__NATAliasMode, SOAP_TYPE_vbox__NATAliasMode, sizeof(enum vbox__NATAliasMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__NATAliasMode * SOAP_FMAC4 soap_new_vbox__NATAliasMode(struct soap *soap, int n)
{
	enum vbox__NATAliasMode *a = static_cast<enum vbox__NATAliasMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__NATAliasMode)));
	for (enum vbox__NATAliasMode *p = a; p && n--; ++p)
		soap_default_vbox__NATAliasMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__NATAliasMode(struct soap *soap, const enum vbox__NATAliasMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__NATAliasMode(soap, tag ? tag : "vbox:NATAliasMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__NATAliasMode * SOAP_FMAC4 soap_get_vbox__NATAliasMode(struct soap *soap, enum vbox__NATAliasMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__NATAliasMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ChipsetType[] =
{	{ (LONG64)vbox__ChipsetType__Null, "Null" },
	{ (LONG64)vbox__ChipsetType__PIIX3, "PIIX3" },
	{ (LONG64)vbox__ChipsetType__ICH9, "ICH9" },
	{ (LONG64)vbox__ChipsetType__ARMv8Virtual, "ARMv8Virtual" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ChipsetType2s(struct soap *soap, enum vbox__ChipsetType n)
{
	const char *s = soap_code_str(soap_codes_vbox__ChipsetType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ChipsetType(struct soap *soap, const char *tag, int id, const enum vbox__ChipsetType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ChipsetType), type) || soap_send(soap, soap_vbox__ChipsetType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ChipsetType(struct soap *soap, const char *s, enum vbox__ChipsetType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ChipsetType, s);
	if (map)
		*a = (enum vbox__ChipsetType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ChipsetType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ChipsetType * SOAP_FMAC4 soap_in_vbox__ChipsetType(struct soap *soap, const char *tag, enum vbox__ChipsetType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ChipsetType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ChipsetType, sizeof(enum vbox__ChipsetType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ChipsetType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ChipsetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ChipsetType, SOAP_TYPE_vbox__ChipsetType, sizeof(enum vbox__ChipsetType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ChipsetType * SOAP_FMAC4 soap_new_vbox__ChipsetType(struct soap *soap, int n)
{
	enum vbox__ChipsetType *a = static_cast<enum vbox__ChipsetType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ChipsetType)));
	for (enum vbox__ChipsetType *p = a; p && n--; ++p)
		soap_default_vbox__ChipsetType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ChipsetType(struct soap *soap, const enum vbox__ChipsetType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ChipsetType(soap, tag ? tag : "vbox:ChipsetType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ChipsetType * SOAP_FMAC4 soap_get_vbox__ChipsetType(struct soap *soap, enum vbox__ChipsetType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ChipsetType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__StorageControllerType[] =
{	{ (LONG64)vbox__StorageControllerType__Null, "Null" },
	{ (LONG64)vbox__StorageControllerType__LsiLogic, "LsiLogic" },
	{ (LONG64)vbox__StorageControllerType__BusLogic, "BusLogic" },
	{ (LONG64)vbox__StorageControllerType__IntelAhci, "IntelAhci" },
	{ (LONG64)vbox__StorageControllerType__PIIX3, "PIIX3" },
	{ (LONG64)vbox__StorageControllerType__PIIX4, "PIIX4" },
	{ (LONG64)vbox__StorageControllerType__ICH6, "ICH6" },
	{ (LONG64)vbox__StorageControllerType__I82078, "I82078" },
	{ (LONG64)vbox__StorageControllerType__LsiLogicSas, "LsiLogicSas" },
	{ (LONG64)vbox__StorageControllerType__USB, "USB" },
	{ (LONG64)vbox__StorageControllerType__NVMe, "NVMe" },
	{ (LONG64)vbox__StorageControllerType__VirtioSCSI, "VirtioSCSI" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__StorageControllerType2s(struct soap *soap, enum vbox__StorageControllerType n)
{
	const char *s = soap_code_str(soap_codes_vbox__StorageControllerType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__StorageControllerType(struct soap *soap, const char *tag, int id, const enum vbox__StorageControllerType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__StorageControllerType), type) || soap_send(soap, soap_vbox__StorageControllerType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__StorageControllerType(struct soap *soap, const char *s, enum vbox__StorageControllerType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__StorageControllerType, s);
	if (map)
		*a = (enum vbox__StorageControllerType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 11)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__StorageControllerType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__StorageControllerType * SOAP_FMAC4 soap_in_vbox__StorageControllerType(struct soap *soap, const char *tag, enum vbox__StorageControllerType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__StorageControllerType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__StorageControllerType, sizeof(enum vbox__StorageControllerType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__StorageControllerType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__StorageControllerType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__StorageControllerType, SOAP_TYPE_vbox__StorageControllerType, sizeof(enum vbox__StorageControllerType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__StorageControllerType * SOAP_FMAC4 soap_new_vbox__StorageControllerType(struct soap *soap, int n)
{
	enum vbox__StorageControllerType *a = static_cast<enum vbox__StorageControllerType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__StorageControllerType)));
	for (enum vbox__StorageControllerType *p = a; p && n--; ++p)
		soap_default_vbox__StorageControllerType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__StorageControllerType(struct soap *soap, const enum vbox__StorageControllerType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__StorageControllerType(soap, tag ? tag : "vbox:StorageControllerType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__StorageControllerType * SOAP_FMAC4 soap_get_vbox__StorageControllerType(struct soap *soap, enum vbox__StorageControllerType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__StorageControllerType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__StorageBus[] =
{	{ (LONG64)vbox__StorageBus__Null, "Null" },
	{ (LONG64)vbox__StorageBus__IDE, "IDE" },
	{ (LONG64)vbox__StorageBus__SATA, "SATA" },
	{ (LONG64)vbox__StorageBus__SCSI, "SCSI" },
	{ (LONG64)vbox__StorageBus__Floppy, "Floppy" },
	{ (LONG64)vbox__StorageBus__SAS, "SAS" },
	{ (LONG64)vbox__StorageBus__USB, "USB" },
	{ (LONG64)vbox__StorageBus__PCIe, "PCIe" },
	{ (LONG64)vbox__StorageBus__VirtioSCSI, "VirtioSCSI" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__StorageBus2s(struct soap *soap, enum vbox__StorageBus n)
{
	const char *s = soap_code_str(soap_codes_vbox__StorageBus, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__StorageBus(struct soap *soap, const char *tag, int id, const enum vbox__StorageBus *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__StorageBus), type) || soap_send(soap, soap_vbox__StorageBus2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__StorageBus(struct soap *soap, const char *s, enum vbox__StorageBus *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__StorageBus, s);
	if (map)
		*a = (enum vbox__StorageBus)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 8)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__StorageBus)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__StorageBus * SOAP_FMAC4 soap_in_vbox__StorageBus(struct soap *soap, const char *tag, enum vbox__StorageBus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__StorageBus*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__StorageBus, sizeof(enum vbox__StorageBus), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__StorageBus(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__StorageBus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__StorageBus, SOAP_TYPE_vbox__StorageBus, sizeof(enum vbox__StorageBus), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__StorageBus * SOAP_FMAC4 soap_new_vbox__StorageBus(struct soap *soap, int n)
{
	enum vbox__StorageBus *a = static_cast<enum vbox__StorageBus *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__StorageBus)));
	for (enum vbox__StorageBus *p = a; p && n--; ++p)
		soap_default_vbox__StorageBus(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__StorageBus(struct soap *soap, const enum vbox__StorageBus *a, const char *tag, const char *type)
{
	if (soap_out_vbox__StorageBus(soap, tag ? tag : "vbox:StorageBus", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__StorageBus * SOAP_FMAC4 soap_get_vbox__StorageBus(struct soap *soap, enum vbox__StorageBus *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__StorageBus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__Reason[] =
{	{ (LONG64)vbox__Reason__Unspecified, "Unspecified" },
	{ (LONG64)vbox__Reason__HostSuspend, "HostSuspend" },
	{ (LONG64)vbox__Reason__HostResume, "HostResume" },
	{ (LONG64)vbox__Reason__HostBatteryLow, "HostBatteryLow" },
	{ (LONG64)vbox__Reason__Snapshot, "Snapshot" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__Reason2s(struct soap *soap, enum vbox__Reason n)
{
	const char *s = soap_code_str(soap_codes_vbox__Reason, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__Reason(struct soap *soap, const char *tag, int id, const enum vbox__Reason *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__Reason), type) || soap_send(soap, soap_vbox__Reason2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__Reason(struct soap *soap, const char *s, enum vbox__Reason *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__Reason, s);
	if (map)
		*a = (enum vbox__Reason)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__Reason)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__Reason * SOAP_FMAC4 soap_in_vbox__Reason(struct soap *soap, const char *tag, enum vbox__Reason *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__Reason*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__Reason, sizeof(enum vbox__Reason), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__Reason(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__Reason, SOAP_TYPE_vbox__Reason, sizeof(enum vbox__Reason), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__Reason * SOAP_FMAC4 soap_new_vbox__Reason(struct soap *soap, int n)
{
	enum vbox__Reason *a = static_cast<enum vbox__Reason *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__Reason)));
	for (enum vbox__Reason *p = a; p && n--; ++p)
		soap_default_vbox__Reason(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__Reason(struct soap *soap, const enum vbox__Reason *a, const char *tag, const char *type)
{
	if (soap_out_vbox__Reason(soap, tag ? tag : "vbox:Reason", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__Reason * SOAP_FMAC4 soap_get_vbox__Reason(struct soap *soap, enum vbox__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AuthType[] =
{	{ (LONG64)vbox__AuthType__Null, "Null" },
	{ (LONG64)vbox__AuthType__External, "External" },
	{ (LONG64)vbox__AuthType__Guest, "Guest" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AuthType2s(struct soap *soap, enum vbox__AuthType n)
{
	const char *s = soap_code_str(soap_codes_vbox__AuthType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AuthType(struct soap *soap, const char *tag, int id, const enum vbox__AuthType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AuthType), type) || soap_send(soap, soap_vbox__AuthType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AuthType(struct soap *soap, const char *s, enum vbox__AuthType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AuthType, s);
	if (map)
		*a = (enum vbox__AuthType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AuthType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AuthType * SOAP_FMAC4 soap_in_vbox__AuthType(struct soap *soap, const char *tag, enum vbox__AuthType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AuthType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AuthType, sizeof(enum vbox__AuthType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AuthType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AuthType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AuthType, SOAP_TYPE_vbox__AuthType, sizeof(enum vbox__AuthType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AuthType * SOAP_FMAC4 soap_new_vbox__AuthType(struct soap *soap, int n)
{
	enum vbox__AuthType *a = static_cast<enum vbox__AuthType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AuthType)));
	for (enum vbox__AuthType *p = a; p && n--; ++p)
		soap_default_vbox__AuthType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AuthType(struct soap *soap, const enum vbox__AuthType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AuthType(soap, tag ? tag : "vbox:AuthType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AuthType * SOAP_FMAC4 soap_get_vbox__AuthType(struct soap *soap, enum vbox__AuthType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AuthType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AudioDeviceState[] =
{	{ (LONG64)vbox__AudioDeviceState__Unknown, "Unknown" },
	{ (LONG64)vbox__AudioDeviceState__Active, "Active" },
	{ (LONG64)vbox__AudioDeviceState__Disabled, "Disabled" },
	{ (LONG64)vbox__AudioDeviceState__NotPresent, "NotPresent" },
	{ (LONG64)vbox__AudioDeviceState__Unplugged, "Unplugged" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AudioDeviceState2s(struct soap *soap, enum vbox__AudioDeviceState n)
{
	const char *s = soap_code_str(soap_codes_vbox__AudioDeviceState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AudioDeviceState(struct soap *soap, const char *tag, int id, const enum vbox__AudioDeviceState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AudioDeviceState), type) || soap_send(soap, soap_vbox__AudioDeviceState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AudioDeviceState(struct soap *soap, const char *s, enum vbox__AudioDeviceState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AudioDeviceState, s);
	if (map)
		*a = (enum vbox__AudioDeviceState)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AudioDeviceState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AudioDeviceState * SOAP_FMAC4 soap_in_vbox__AudioDeviceState(struct soap *soap, const char *tag, enum vbox__AudioDeviceState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AudioDeviceState*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AudioDeviceState, sizeof(enum vbox__AudioDeviceState), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AudioDeviceState(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AudioDeviceState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AudioDeviceState, SOAP_TYPE_vbox__AudioDeviceState, sizeof(enum vbox__AudioDeviceState), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AudioDeviceState * SOAP_FMAC4 soap_new_vbox__AudioDeviceState(struct soap *soap, int n)
{
	enum vbox__AudioDeviceState *a = static_cast<enum vbox__AudioDeviceState *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AudioDeviceState)));
	for (enum vbox__AudioDeviceState *p = a; p && n--; ++p)
		soap_default_vbox__AudioDeviceState(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AudioDeviceState(struct soap *soap, const enum vbox__AudioDeviceState *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AudioDeviceState(soap, tag ? tag : "vbox:AudioDeviceState", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AudioDeviceState * SOAP_FMAC4 soap_get_vbox__AudioDeviceState(struct soap *soap, enum vbox__AudioDeviceState *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AudioDeviceState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AudioDeviceType[] =
{	{ (LONG64)vbox__AudioDeviceType__Unknown, "Unknown" },
	{ (LONG64)vbox__AudioDeviceType__BuiltLin, "BuiltLin" },
	{ (LONG64)vbox__AudioDeviceType__ExternalUSB, "ExternalUSB" },
	{ (LONG64)vbox__AudioDeviceType__ExternalOther, "ExternalOther" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AudioDeviceType2s(struct soap *soap, enum vbox__AudioDeviceType n)
{
	const char *s = soap_code_str(soap_codes_vbox__AudioDeviceType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AudioDeviceType(struct soap *soap, const char *tag, int id, const enum vbox__AudioDeviceType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AudioDeviceType), type) || soap_send(soap, soap_vbox__AudioDeviceType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AudioDeviceType(struct soap *soap, const char *s, enum vbox__AudioDeviceType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AudioDeviceType, s);
	if (map)
		*a = (enum vbox__AudioDeviceType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AudioDeviceType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AudioDeviceType * SOAP_FMAC4 soap_in_vbox__AudioDeviceType(struct soap *soap, const char *tag, enum vbox__AudioDeviceType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AudioDeviceType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AudioDeviceType, sizeof(enum vbox__AudioDeviceType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AudioDeviceType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AudioDeviceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AudioDeviceType, SOAP_TYPE_vbox__AudioDeviceType, sizeof(enum vbox__AudioDeviceType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AudioDeviceType * SOAP_FMAC4 soap_new_vbox__AudioDeviceType(struct soap *soap, int n)
{
	enum vbox__AudioDeviceType *a = static_cast<enum vbox__AudioDeviceType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AudioDeviceType)));
	for (enum vbox__AudioDeviceType *p = a; p && n--; ++p)
		soap_default_vbox__AudioDeviceType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AudioDeviceType(struct soap *soap, const enum vbox__AudioDeviceType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AudioDeviceType(soap, tag ? tag : "vbox:AudioDeviceType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AudioDeviceType * SOAP_FMAC4 soap_get_vbox__AudioDeviceType(struct soap *soap, enum vbox__AudioDeviceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AudioDeviceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AudioDirection[] =
{	{ (LONG64)vbox__AudioDirection__Unknown, "Unknown" },
	{ (LONG64)vbox__AudioDirection__In, "In" },
	{ (LONG64)vbox__AudioDirection__Out, "Out" },
	{ (LONG64)vbox__AudioDirection__Duplex, "Duplex" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AudioDirection2s(struct soap *soap, enum vbox__AudioDirection n)
{
	const char *s = soap_code_str(soap_codes_vbox__AudioDirection, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AudioDirection(struct soap *soap, const char *tag, int id, const enum vbox__AudioDirection *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AudioDirection), type) || soap_send(soap, soap_vbox__AudioDirection2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AudioDirection(struct soap *soap, const char *s, enum vbox__AudioDirection *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AudioDirection, s);
	if (map)
		*a = (enum vbox__AudioDirection)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AudioDirection)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AudioDirection * SOAP_FMAC4 soap_in_vbox__AudioDirection(struct soap *soap, const char *tag, enum vbox__AudioDirection *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AudioDirection*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AudioDirection, sizeof(enum vbox__AudioDirection), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AudioDirection(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AudioDirection *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AudioDirection, SOAP_TYPE_vbox__AudioDirection, sizeof(enum vbox__AudioDirection), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AudioDirection * SOAP_FMAC4 soap_new_vbox__AudioDirection(struct soap *soap, int n)
{
	enum vbox__AudioDirection *a = static_cast<enum vbox__AudioDirection *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AudioDirection)));
	for (enum vbox__AudioDirection *p = a; p && n--; ++p)
		soap_default_vbox__AudioDirection(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AudioDirection(struct soap *soap, const enum vbox__AudioDirection *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AudioDirection(soap, tag ? tag : "vbox:AudioDirection", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AudioDirection * SOAP_FMAC4 soap_get_vbox__AudioDirection(struct soap *soap, enum vbox__AudioDirection *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AudioDirection(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AudioCodecType[] =
{	{ (LONG64)vbox__AudioCodecType__Null, "Null" },
	{ (LONG64)vbox__AudioCodecType__SB16, "SB16" },
	{ (LONG64)vbox__AudioCodecType__STAC9700, "STAC9700" },
	{ (LONG64)vbox__AudioCodecType__AD1980, "AD1980" },
	{ (LONG64)vbox__AudioCodecType__STAC9221, "STAC9221" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AudioCodecType2s(struct soap *soap, enum vbox__AudioCodecType n)
{
	const char *s = soap_code_str(soap_codes_vbox__AudioCodecType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AudioCodecType(struct soap *soap, const char *tag, int id, const enum vbox__AudioCodecType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AudioCodecType), type) || soap_send(soap, soap_vbox__AudioCodecType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AudioCodecType(struct soap *soap, const char *s, enum vbox__AudioCodecType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AudioCodecType, s);
	if (map)
		*a = (enum vbox__AudioCodecType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AudioCodecType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AudioCodecType * SOAP_FMAC4 soap_in_vbox__AudioCodecType(struct soap *soap, const char *tag, enum vbox__AudioCodecType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AudioCodecType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AudioCodecType, sizeof(enum vbox__AudioCodecType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AudioCodecType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AudioCodecType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AudioCodecType, SOAP_TYPE_vbox__AudioCodecType, sizeof(enum vbox__AudioCodecType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AudioCodecType * SOAP_FMAC4 soap_new_vbox__AudioCodecType(struct soap *soap, int n)
{
	enum vbox__AudioCodecType *a = static_cast<enum vbox__AudioCodecType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AudioCodecType)));
	for (enum vbox__AudioCodecType *p = a; p && n--; ++p)
		soap_default_vbox__AudioCodecType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AudioCodecType(struct soap *soap, const enum vbox__AudioCodecType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AudioCodecType(soap, tag ? tag : "vbox:AudioCodecType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AudioCodecType * SOAP_FMAC4 soap_get_vbox__AudioCodecType(struct soap *soap, enum vbox__AudioCodecType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AudioCodecType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AudioControllerType[] =
{	{ (LONG64)vbox__AudioControllerType__AC97, "AC97" },
	{ (LONG64)vbox__AudioControllerType__SB16, "SB16" },
	{ (LONG64)vbox__AudioControllerType__HDA, "HDA" },
	{ (LONG64)vbox__AudioControllerType__VirtioSound, "VirtioSound" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AudioControllerType2s(struct soap *soap, enum vbox__AudioControllerType n)
{
	const char *s = soap_code_str(soap_codes_vbox__AudioControllerType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AudioControllerType(struct soap *soap, const char *tag, int id, const enum vbox__AudioControllerType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AudioControllerType), type) || soap_send(soap, soap_vbox__AudioControllerType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AudioControllerType(struct soap *soap, const char *s, enum vbox__AudioControllerType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AudioControllerType, s);
	if (map)
		*a = (enum vbox__AudioControllerType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AudioControllerType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AudioControllerType * SOAP_FMAC4 soap_in_vbox__AudioControllerType(struct soap *soap, const char *tag, enum vbox__AudioControllerType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AudioControllerType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AudioControllerType, sizeof(enum vbox__AudioControllerType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AudioControllerType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AudioControllerType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AudioControllerType, SOAP_TYPE_vbox__AudioControllerType, sizeof(enum vbox__AudioControllerType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AudioControllerType * SOAP_FMAC4 soap_new_vbox__AudioControllerType(struct soap *soap, int n)
{
	enum vbox__AudioControllerType *a = static_cast<enum vbox__AudioControllerType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AudioControllerType)));
	for (enum vbox__AudioControllerType *p = a; p && n--; ++p)
		soap_default_vbox__AudioControllerType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AudioControllerType(struct soap *soap, const enum vbox__AudioControllerType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AudioControllerType(soap, tag ? tag : "vbox:AudioControllerType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AudioControllerType * SOAP_FMAC4 soap_get_vbox__AudioControllerType(struct soap *soap, enum vbox__AudioControllerType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AudioControllerType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AudioDriverType[] =
{	{ (LONG64)vbox__AudioDriverType__Default, "Default" },
	{ (LONG64)vbox__AudioDriverType__Null, "Null" },
	{ (LONG64)vbox__AudioDriverType__OSS, "OSS" },
	{ (LONG64)vbox__AudioDriverType__ALSA, "ALSA" },
	{ (LONG64)vbox__AudioDriverType__Pulse, "Pulse" },
	{ (LONG64)vbox__AudioDriverType__WinMM, "WinMM" },
	{ (LONG64)vbox__AudioDriverType__DirectSound, "DirectSound" },
	{ (LONG64)vbox__AudioDriverType__WAS, "WAS" },
	{ (LONG64)vbox__AudioDriverType__CoreAudio, "CoreAudio" },
	{ (LONG64)vbox__AudioDriverType__MMPM, "MMPM" },
	{ (LONG64)vbox__AudioDriverType__SolAudio, "SolAudio" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AudioDriverType2s(struct soap *soap, enum vbox__AudioDriverType n)
{
	const char *s = soap_code_str(soap_codes_vbox__AudioDriverType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AudioDriverType(struct soap *soap, const char *tag, int id, const enum vbox__AudioDriverType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AudioDriverType), type) || soap_send(soap, soap_vbox__AudioDriverType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AudioDriverType(struct soap *soap, const char *s, enum vbox__AudioDriverType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AudioDriverType, s);
	if (map)
		*a = (enum vbox__AudioDriverType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 10)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AudioDriverType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AudioDriverType * SOAP_FMAC4 soap_in_vbox__AudioDriverType(struct soap *soap, const char *tag, enum vbox__AudioDriverType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AudioDriverType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AudioDriverType, sizeof(enum vbox__AudioDriverType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AudioDriverType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AudioDriverType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AudioDriverType, SOAP_TYPE_vbox__AudioDriverType, sizeof(enum vbox__AudioDriverType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AudioDriverType * SOAP_FMAC4 soap_new_vbox__AudioDriverType(struct soap *soap, int n)
{
	enum vbox__AudioDriverType *a = static_cast<enum vbox__AudioDriverType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AudioDriverType)));
	for (enum vbox__AudioDriverType *p = a; p && n--; ++p)
		soap_default_vbox__AudioDriverType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AudioDriverType(struct soap *soap, const enum vbox__AudioDriverType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AudioDriverType(soap, tag ? tag : "vbox:AudioDriverType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AudioDriverType * SOAP_FMAC4 soap_get_vbox__AudioDriverType(struct soap *soap, enum vbox__AudioDriverType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AudioDriverType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__USBDeviceFilterAction[] =
{	{ (LONG64)vbox__USBDeviceFilterAction__Null, "Null" },
	{ (LONG64)vbox__USBDeviceFilterAction__Ignore, "Ignore" },
	{ (LONG64)vbox__USBDeviceFilterAction__Hold, "Hold" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__USBDeviceFilterAction2s(struct soap *soap, enum vbox__USBDeviceFilterAction n)
{
	const char *s = soap_code_str(soap_codes_vbox__USBDeviceFilterAction, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__USBDeviceFilterAction(struct soap *soap, const char *tag, int id, const enum vbox__USBDeviceFilterAction *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__USBDeviceFilterAction), type) || soap_send(soap, soap_vbox__USBDeviceFilterAction2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__USBDeviceFilterAction(struct soap *soap, const char *s, enum vbox__USBDeviceFilterAction *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__USBDeviceFilterAction, s);
	if (map)
		*a = (enum vbox__USBDeviceFilterAction)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__USBDeviceFilterAction)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__USBDeviceFilterAction * SOAP_FMAC4 soap_in_vbox__USBDeviceFilterAction(struct soap *soap, const char *tag, enum vbox__USBDeviceFilterAction *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__USBDeviceFilterAction*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__USBDeviceFilterAction, sizeof(enum vbox__USBDeviceFilterAction), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__USBDeviceFilterAction(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__USBDeviceFilterAction *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__USBDeviceFilterAction, SOAP_TYPE_vbox__USBDeviceFilterAction, sizeof(enum vbox__USBDeviceFilterAction), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__USBDeviceFilterAction * SOAP_FMAC4 soap_new_vbox__USBDeviceFilterAction(struct soap *soap, int n)
{
	enum vbox__USBDeviceFilterAction *a = static_cast<enum vbox__USBDeviceFilterAction *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__USBDeviceFilterAction)));
	for (enum vbox__USBDeviceFilterAction *p = a; p && n--; ++p)
		soap_default_vbox__USBDeviceFilterAction(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__USBDeviceFilterAction(struct soap *soap, const enum vbox__USBDeviceFilterAction *a, const char *tag, const char *type)
{
	if (soap_out_vbox__USBDeviceFilterAction(soap, tag ? tag : "vbox:USBDeviceFilterAction", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__USBDeviceFilterAction * SOAP_FMAC4 soap_get_vbox__USBDeviceFilterAction(struct soap *soap, enum vbox__USBDeviceFilterAction *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__USBDeviceFilterAction(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__USBDeviceState[] =
{	{ (LONG64)vbox__USBDeviceState__NotSupported, "NotSupported" },
	{ (LONG64)vbox__USBDeviceState__Unavailable, "Unavailable" },
	{ (LONG64)vbox__USBDeviceState__Busy, "Busy" },
	{ (LONG64)vbox__USBDeviceState__Available, "Available" },
	{ (LONG64)vbox__USBDeviceState__Held, "Held" },
	{ (LONG64)vbox__USBDeviceState__Captured, "Captured" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__USBDeviceState2s(struct soap *soap, enum vbox__USBDeviceState n)
{
	const char *s = soap_code_str(soap_codes_vbox__USBDeviceState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__USBDeviceState(struct soap *soap, const char *tag, int id, const enum vbox__USBDeviceState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__USBDeviceState), type) || soap_send(soap, soap_vbox__USBDeviceState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__USBDeviceState(struct soap *soap, const char *s, enum vbox__USBDeviceState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__USBDeviceState, s);
	if (map)
		*a = (enum vbox__USBDeviceState)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 5)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__USBDeviceState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__USBDeviceState * SOAP_FMAC4 soap_in_vbox__USBDeviceState(struct soap *soap, const char *tag, enum vbox__USBDeviceState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__USBDeviceState*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__USBDeviceState, sizeof(enum vbox__USBDeviceState), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__USBDeviceState(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__USBDeviceState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__USBDeviceState, SOAP_TYPE_vbox__USBDeviceState, sizeof(enum vbox__USBDeviceState), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__USBDeviceState * SOAP_FMAC4 soap_new_vbox__USBDeviceState(struct soap *soap, int n)
{
	enum vbox__USBDeviceState *a = static_cast<enum vbox__USBDeviceState *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__USBDeviceState)));
	for (enum vbox__USBDeviceState *p = a; p && n--; ++p)
		soap_default_vbox__USBDeviceState(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__USBDeviceState(struct soap *soap, const enum vbox__USBDeviceState *a, const char *tag, const char *type)
{
	if (soap_out_vbox__USBDeviceState(soap, tag ? tag : "vbox:USBDeviceState", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__USBDeviceState * SOAP_FMAC4 soap_get_vbox__USBDeviceState(struct soap *soap, enum vbox__USBDeviceState *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__USBDeviceState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__USBConnectionSpeed[] =
{	{ (LONG64)vbox__USBConnectionSpeed__Null, "Null" },
	{ (LONG64)vbox__USBConnectionSpeed__Low, "Low" },
	{ (LONG64)vbox__USBConnectionSpeed__Full, "Full" },
	{ (LONG64)vbox__USBConnectionSpeed__High, "High" },
	{ (LONG64)vbox__USBConnectionSpeed__Super, "Super" },
	{ (LONG64)vbox__USBConnectionSpeed__SuperPlus, "SuperPlus" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__USBConnectionSpeed2s(struct soap *soap, enum vbox__USBConnectionSpeed n)
{
	const char *s = soap_code_str(soap_codes_vbox__USBConnectionSpeed, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__USBConnectionSpeed(struct soap *soap, const char *tag, int id, const enum vbox__USBConnectionSpeed *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__USBConnectionSpeed), type) || soap_send(soap, soap_vbox__USBConnectionSpeed2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__USBConnectionSpeed(struct soap *soap, const char *s, enum vbox__USBConnectionSpeed *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__USBConnectionSpeed, s);
	if (map)
		*a = (enum vbox__USBConnectionSpeed)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 5)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__USBConnectionSpeed)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__USBConnectionSpeed * SOAP_FMAC4 soap_in_vbox__USBConnectionSpeed(struct soap *soap, const char *tag, enum vbox__USBConnectionSpeed *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__USBConnectionSpeed*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__USBConnectionSpeed, sizeof(enum vbox__USBConnectionSpeed), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__USBConnectionSpeed(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__USBConnectionSpeed *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__USBConnectionSpeed, SOAP_TYPE_vbox__USBConnectionSpeed, sizeof(enum vbox__USBConnectionSpeed), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__USBConnectionSpeed * SOAP_FMAC4 soap_new_vbox__USBConnectionSpeed(struct soap *soap, int n)
{
	enum vbox__USBConnectionSpeed *a = static_cast<enum vbox__USBConnectionSpeed *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__USBConnectionSpeed)));
	for (enum vbox__USBConnectionSpeed *p = a; p && n--; ++p)
		soap_default_vbox__USBConnectionSpeed(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__USBConnectionSpeed(struct soap *soap, const enum vbox__USBConnectionSpeed *a, const char *tag, const char *type)
{
	if (soap_out_vbox__USBConnectionSpeed(soap, tag ? tag : "vbox:USBConnectionSpeed", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__USBConnectionSpeed * SOAP_FMAC4 soap_get_vbox__USBConnectionSpeed(struct soap *soap, enum vbox__USBConnectionSpeed *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__USBConnectionSpeed(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__USBControllerType[] =
{	{ (LONG64)vbox__USBControllerType__Null, "Null" },
	{ (LONG64)vbox__USBControllerType__OHCI, "OHCI" },
	{ (LONG64)vbox__USBControllerType__EHCI, "EHCI" },
	{ (LONG64)vbox__USBControllerType__XHCI, "XHCI" },
	{ (LONG64)vbox__USBControllerType__Last, "Last" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__USBControllerType2s(struct soap *soap, enum vbox__USBControllerType n)
{
	const char *s = soap_code_str(soap_codes_vbox__USBControllerType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__USBControllerType(struct soap *soap, const char *tag, int id, const enum vbox__USBControllerType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__USBControllerType), type) || soap_send(soap, soap_vbox__USBControllerType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__USBControllerType(struct soap *soap, const char *s, enum vbox__USBControllerType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__USBControllerType, s);
	if (map)
		*a = (enum vbox__USBControllerType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__USBControllerType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__USBControllerType * SOAP_FMAC4 soap_in_vbox__USBControllerType(struct soap *soap, const char *tag, enum vbox__USBControllerType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__USBControllerType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__USBControllerType, sizeof(enum vbox__USBControllerType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__USBControllerType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__USBControllerType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__USBControllerType, SOAP_TYPE_vbox__USBControllerType, sizeof(enum vbox__USBControllerType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__USBControllerType * SOAP_FMAC4 soap_new_vbox__USBControllerType(struct soap *soap, int n)
{
	enum vbox__USBControllerType *a = static_cast<enum vbox__USBControllerType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__USBControllerType)));
	for (enum vbox__USBControllerType *p = a; p && n--; ++p)
		soap_default_vbox__USBControllerType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__USBControllerType(struct soap *soap, const enum vbox__USBControllerType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__USBControllerType(soap, tag ? tag : "vbox:USBControllerType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__USBControllerType * SOAP_FMAC4 soap_get_vbox__USBControllerType(struct soap *soap, enum vbox__USBControllerType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__USBControllerType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__UartType[] =
{	{ (LONG64)vbox__UartType__U16450, "U16450" },
	{ (LONG64)vbox__UartType__U16550A, "U16550A" },
	{ (LONG64)vbox__UartType__U16750, "U16750" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__UartType2s(struct soap *soap, enum vbox__UartType n)
{
	const char *s = soap_code_str(soap_codes_vbox__UartType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__UartType(struct soap *soap, const char *tag, int id, const enum vbox__UartType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__UartType), type) || soap_send(soap, soap_vbox__UartType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__UartType(struct soap *soap, const char *s, enum vbox__UartType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__UartType, s);
	if (map)
		*a = (enum vbox__UartType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__UartType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__UartType * SOAP_FMAC4 soap_in_vbox__UartType(struct soap *soap, const char *tag, enum vbox__UartType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__UartType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__UartType, sizeof(enum vbox__UartType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__UartType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__UartType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__UartType, SOAP_TYPE_vbox__UartType, sizeof(enum vbox__UartType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__UartType * SOAP_FMAC4 soap_new_vbox__UartType(struct soap *soap, int n)
{
	enum vbox__UartType *a = static_cast<enum vbox__UartType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__UartType)));
	for (enum vbox__UartType *p = a; p && n--; ++p)
		soap_default_vbox__UartType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__UartType(struct soap *soap, const enum vbox__UartType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__UartType(soap, tag ? tag : "vbox:UartType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__UartType * SOAP_FMAC4 soap_get_vbox__UartType(struct soap *soap, enum vbox__UartType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__UartType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__PortMode[] =
{	{ (LONG64)vbox__PortMode__Disconnected, "Disconnected" },
	{ (LONG64)vbox__PortMode__HostPipe, "HostPipe" },
	{ (LONG64)vbox__PortMode__HostDevice, "HostDevice" },
	{ (LONG64)vbox__PortMode__RawFile, "RawFile" },
	{ (LONG64)vbox__PortMode__TCP, "TCP" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__PortMode2s(struct soap *soap, enum vbox__PortMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__PortMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__PortMode(struct soap *soap, const char *tag, int id, const enum vbox__PortMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__PortMode), type) || soap_send(soap, soap_vbox__PortMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__PortMode(struct soap *soap, const char *s, enum vbox__PortMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__PortMode, s);
	if (map)
		*a = (enum vbox__PortMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__PortMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__PortMode * SOAP_FMAC4 soap_in_vbox__PortMode(struct soap *soap, const char *tag, enum vbox__PortMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__PortMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__PortMode, sizeof(enum vbox__PortMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__PortMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__PortMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__PortMode, SOAP_TYPE_vbox__PortMode, sizeof(enum vbox__PortMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__PortMode * SOAP_FMAC4 soap_new_vbox__PortMode(struct soap *soap, int n)
{
	enum vbox__PortMode *a = static_cast<enum vbox__PortMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__PortMode)));
	for (enum vbox__PortMode *p = a; p && n--; ++p)
		soap_default_vbox__PortMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__PortMode(struct soap *soap, const enum vbox__PortMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__PortMode(soap, tag ? tag : "vbox:PortMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__PortMode * SOAP_FMAC4 soap_get_vbox__PortMode(struct soap *soap, enum vbox__PortMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__PortMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__NetworkAdapterPromiscModePolicy[] =
{	{ (LONG64)vbox__NetworkAdapterPromiscModePolicy__Deny, "Deny" },
	{ (LONG64)vbox__NetworkAdapterPromiscModePolicy__AllowNetwork, "AllowNetwork" },
	{ (LONG64)vbox__NetworkAdapterPromiscModePolicy__AllowAll, "AllowAll" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__NetworkAdapterPromiscModePolicy2s(struct soap *soap, enum vbox__NetworkAdapterPromiscModePolicy n)
{
	const char *s = soap_code_str(soap_codes_vbox__NetworkAdapterPromiscModePolicy, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__NetworkAdapterPromiscModePolicy(struct soap *soap, const char *tag, int id, const enum vbox__NetworkAdapterPromiscModePolicy *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__NetworkAdapterPromiscModePolicy), type) || soap_send(soap, soap_vbox__NetworkAdapterPromiscModePolicy2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__NetworkAdapterPromiscModePolicy(struct soap *soap, const char *s, enum vbox__NetworkAdapterPromiscModePolicy *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__NetworkAdapterPromiscModePolicy, s);
	if (map)
		*a = (enum vbox__NetworkAdapterPromiscModePolicy)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__NetworkAdapterPromiscModePolicy)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__NetworkAdapterPromiscModePolicy * SOAP_FMAC4 soap_in_vbox__NetworkAdapterPromiscModePolicy(struct soap *soap, const char *tag, enum vbox__NetworkAdapterPromiscModePolicy *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__NetworkAdapterPromiscModePolicy*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__NetworkAdapterPromiscModePolicy, sizeof(enum vbox__NetworkAdapterPromiscModePolicy), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__NetworkAdapterPromiscModePolicy(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__NetworkAdapterPromiscModePolicy *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__NetworkAdapterPromiscModePolicy, SOAP_TYPE_vbox__NetworkAdapterPromiscModePolicy, sizeof(enum vbox__NetworkAdapterPromiscModePolicy), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__NetworkAdapterPromiscModePolicy * SOAP_FMAC4 soap_new_vbox__NetworkAdapterPromiscModePolicy(struct soap *soap, int n)
{
	enum vbox__NetworkAdapterPromiscModePolicy *a = static_cast<enum vbox__NetworkAdapterPromiscModePolicy *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__NetworkAdapterPromiscModePolicy)));
	for (enum vbox__NetworkAdapterPromiscModePolicy *p = a; p && n--; ++p)
		soap_default_vbox__NetworkAdapterPromiscModePolicy(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__NetworkAdapterPromiscModePolicy(struct soap *soap, const enum vbox__NetworkAdapterPromiscModePolicy *a, const char *tag, const char *type)
{
	if (soap_out_vbox__NetworkAdapterPromiscModePolicy(soap, tag ? tag : "vbox:NetworkAdapterPromiscModePolicy", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__NetworkAdapterPromiscModePolicy * SOAP_FMAC4 soap_get_vbox__NetworkAdapterPromiscModePolicy(struct soap *soap, enum vbox__NetworkAdapterPromiscModePolicy *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__NetworkAdapterPromiscModePolicy(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__NetworkAdapterType[] =
{	{ (LONG64)vbox__NetworkAdapterType__Null, "Null" },
	{ (LONG64)vbox__NetworkAdapterType__Am79C970A, "Am79C970A" },
	{ (LONG64)vbox__NetworkAdapterType__Am79C973, "Am79C973" },
	{ (LONG64)vbox__NetworkAdapterType__I82540EM, "I82540EM" },
	{ (LONG64)vbox__NetworkAdapterType__I82543GC, "I82543GC" },
	{ (LONG64)vbox__NetworkAdapterType__I82545EM, "I82545EM" },
	{ (LONG64)vbox__NetworkAdapterType__Virtio, "Virtio" },
	{ (LONG64)vbox__NetworkAdapterType__Am79C960, "Am79C960" },
	{ (LONG64)vbox__NetworkAdapterType__NE2000, "NE2000" },
	{ (LONG64)vbox__NetworkAdapterType__NE1000, "NE1000" },
	{ (LONG64)vbox__NetworkAdapterType__WD8013, "WD8013" },
	{ (LONG64)vbox__NetworkAdapterType__WD8003, "WD8003" },
	{ (LONG64)vbox__NetworkAdapterType__ELNK2, "ELNK2" },
	{ (LONG64)vbox__NetworkAdapterType__ELNK1, "ELNK1" },
	{ (LONG64)vbox__NetworkAdapterType__UsbNet, "UsbNet" },
	{ (LONG64)vbox__NetworkAdapterType__I82583V, "I82583V" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__NetworkAdapterType2s(struct soap *soap, enum vbox__NetworkAdapterType n)
{
	const char *s = soap_code_str(soap_codes_vbox__NetworkAdapterType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__NetworkAdapterType(struct soap *soap, const char *tag, int id, const enum vbox__NetworkAdapterType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__NetworkAdapterType), type) || soap_send(soap, soap_vbox__NetworkAdapterType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__NetworkAdapterType(struct soap *soap, const char *s, enum vbox__NetworkAdapterType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__NetworkAdapterType, s);
	if (map)
		*a = (enum vbox__NetworkAdapterType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 15)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__NetworkAdapterType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__NetworkAdapterType * SOAP_FMAC4 soap_in_vbox__NetworkAdapterType(struct soap *soap, const char *tag, enum vbox__NetworkAdapterType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__NetworkAdapterType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__NetworkAdapterType, sizeof(enum vbox__NetworkAdapterType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__NetworkAdapterType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__NetworkAdapterType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__NetworkAdapterType, SOAP_TYPE_vbox__NetworkAdapterType, sizeof(enum vbox__NetworkAdapterType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__NetworkAdapterType * SOAP_FMAC4 soap_new_vbox__NetworkAdapterType(struct soap *soap, int n)
{
	enum vbox__NetworkAdapterType *a = static_cast<enum vbox__NetworkAdapterType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__NetworkAdapterType)));
	for (enum vbox__NetworkAdapterType *p = a; p && n--; ++p)
		soap_default_vbox__NetworkAdapterType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__NetworkAdapterType(struct soap *soap, const enum vbox__NetworkAdapterType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__NetworkAdapterType(soap, tag ? tag : "vbox:NetworkAdapterType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__NetworkAdapterType * SOAP_FMAC4 soap_get_vbox__NetworkAdapterType(struct soap *soap, enum vbox__NetworkAdapterType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__NetworkAdapterType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__NetworkAttachmentType[] =
{	{ (LONG64)vbox__NetworkAttachmentType__Null, "Null" },
	{ (LONG64)vbox__NetworkAttachmentType__NAT, "NAT" },
	{ (LONG64)vbox__NetworkAttachmentType__Bridged, "Bridged" },
	{ (LONG64)vbox__NetworkAttachmentType__Internal, "Internal" },
	{ (LONG64)vbox__NetworkAttachmentType__HostOnly, "HostOnly" },
	{ (LONG64)vbox__NetworkAttachmentType__Generic, "Generic" },
	{ (LONG64)vbox__NetworkAttachmentType__NATNetwork, "NATNetwork" },
	{ (LONG64)vbox__NetworkAttachmentType__Cloud, "Cloud" },
	{ (LONG64)vbox__NetworkAttachmentType__HostOnlyNetwork, "HostOnlyNetwork" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__NetworkAttachmentType2s(struct soap *soap, enum vbox__NetworkAttachmentType n)
{
	const char *s = soap_code_str(soap_codes_vbox__NetworkAttachmentType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__NetworkAttachmentType(struct soap *soap, const char *tag, int id, const enum vbox__NetworkAttachmentType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__NetworkAttachmentType), type) || soap_send(soap, soap_vbox__NetworkAttachmentType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__NetworkAttachmentType(struct soap *soap, const char *s, enum vbox__NetworkAttachmentType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__NetworkAttachmentType, s);
	if (map)
		*a = (enum vbox__NetworkAttachmentType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 8)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__NetworkAttachmentType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__NetworkAttachmentType * SOAP_FMAC4 soap_in_vbox__NetworkAttachmentType(struct soap *soap, const char *tag, enum vbox__NetworkAttachmentType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__NetworkAttachmentType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__NetworkAttachmentType, sizeof(enum vbox__NetworkAttachmentType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__NetworkAttachmentType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__NetworkAttachmentType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__NetworkAttachmentType, SOAP_TYPE_vbox__NetworkAttachmentType, sizeof(enum vbox__NetworkAttachmentType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__NetworkAttachmentType * SOAP_FMAC4 soap_new_vbox__NetworkAttachmentType(struct soap *soap, int n)
{
	enum vbox__NetworkAttachmentType *a = static_cast<enum vbox__NetworkAttachmentType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__NetworkAttachmentType)));
	for (enum vbox__NetworkAttachmentType *p = a; p && n--; ++p)
		soap_default_vbox__NetworkAttachmentType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__NetworkAttachmentType(struct soap *soap, const enum vbox__NetworkAttachmentType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__NetworkAttachmentType(soap, tag ? tag : "vbox:NetworkAttachmentType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__NetworkAttachmentType * SOAP_FMAC4 soap_get_vbox__NetworkAttachmentType(struct soap *soap, enum vbox__NetworkAttachmentType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__NetworkAttachmentType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ScreenLayoutMode[] =
{	{ (LONG64)vbox__ScreenLayoutMode__Apply, "Apply" },
	{ (LONG64)vbox__ScreenLayoutMode__Reset, "Reset" },
	{ (LONG64)vbox__ScreenLayoutMode__Attach, "Attach" },
	{ (LONG64)vbox__ScreenLayoutMode__Silent, "Silent" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ScreenLayoutMode2s(struct soap *soap, enum vbox__ScreenLayoutMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__ScreenLayoutMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ScreenLayoutMode(struct soap *soap, const char *tag, int id, const enum vbox__ScreenLayoutMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ScreenLayoutMode), type) || soap_send(soap, soap_vbox__ScreenLayoutMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ScreenLayoutMode(struct soap *soap, const char *s, enum vbox__ScreenLayoutMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ScreenLayoutMode, s);
	if (map)
		*a = (enum vbox__ScreenLayoutMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ScreenLayoutMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ScreenLayoutMode * SOAP_FMAC4 soap_in_vbox__ScreenLayoutMode(struct soap *soap, const char *tag, enum vbox__ScreenLayoutMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ScreenLayoutMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ScreenLayoutMode, sizeof(enum vbox__ScreenLayoutMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ScreenLayoutMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ScreenLayoutMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ScreenLayoutMode, SOAP_TYPE_vbox__ScreenLayoutMode, sizeof(enum vbox__ScreenLayoutMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ScreenLayoutMode * SOAP_FMAC4 soap_new_vbox__ScreenLayoutMode(struct soap *soap, int n)
{
	enum vbox__ScreenLayoutMode *a = static_cast<enum vbox__ScreenLayoutMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ScreenLayoutMode)));
	for (enum vbox__ScreenLayoutMode *p = a; p && n--; ++p)
		soap_default_vbox__ScreenLayoutMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ScreenLayoutMode(struct soap *soap, const enum vbox__ScreenLayoutMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ScreenLayoutMode(soap, tag ? tag : "vbox:ScreenLayoutMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ScreenLayoutMode * SOAP_FMAC4 soap_get_vbox__ScreenLayoutMode(struct soap *soap, enum vbox__ScreenLayoutMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ScreenLayoutMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__GuestMonitorStatus[] =
{	{ (LONG64)vbox__GuestMonitorStatus__Disabled, "Disabled" },
	{ (LONG64)vbox__GuestMonitorStatus__Enabled, "Enabled" },
	{ (LONG64)vbox__GuestMonitorStatus__Blank, "Blank" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__GuestMonitorStatus2s(struct soap *soap, enum vbox__GuestMonitorStatus n)
{
	const char *s = soap_code_str(soap_codes_vbox__GuestMonitorStatus, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__GuestMonitorStatus(struct soap *soap, const char *tag, int id, const enum vbox__GuestMonitorStatus *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__GuestMonitorStatus), type) || soap_send(soap, soap_vbox__GuestMonitorStatus2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__GuestMonitorStatus(struct soap *soap, const char *s, enum vbox__GuestMonitorStatus *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__GuestMonitorStatus, s);
	if (map)
		*a = (enum vbox__GuestMonitorStatus)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__GuestMonitorStatus)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__GuestMonitorStatus * SOAP_FMAC4 soap_in_vbox__GuestMonitorStatus(struct soap *soap, const char *tag, enum vbox__GuestMonitorStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__GuestMonitorStatus*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__GuestMonitorStatus, sizeof(enum vbox__GuestMonitorStatus), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__GuestMonitorStatus(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__GuestMonitorStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__GuestMonitorStatus, SOAP_TYPE_vbox__GuestMonitorStatus, sizeof(enum vbox__GuestMonitorStatus), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__GuestMonitorStatus * SOAP_FMAC4 soap_new_vbox__GuestMonitorStatus(struct soap *soap, int n)
{
	enum vbox__GuestMonitorStatus *a = static_cast<enum vbox__GuestMonitorStatus *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__GuestMonitorStatus)));
	for (enum vbox__GuestMonitorStatus *p = a; p && n--; ++p)
		soap_default_vbox__GuestMonitorStatus(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__GuestMonitorStatus(struct soap *soap, const enum vbox__GuestMonitorStatus *a, const char *tag, const char *type)
{
	if (soap_out_vbox__GuestMonitorStatus(soap, tag ? tag : "vbox:GuestMonitorStatus", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__GuestMonitorStatus * SOAP_FMAC4 soap_get_vbox__GuestMonitorStatus(struct soap *soap, enum vbox__GuestMonitorStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__GuestMonitorStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FramebufferCapabilities[] =
{	{ (LONG64)vbox__FramebufferCapabilities__UpdateImage, "UpdateImage" },
	{ (LONG64)vbox__FramebufferCapabilities__VHWA, "VHWA" },
	{ (LONG64)vbox__FramebufferCapabilities__VisibleRegion, "VisibleRegion" },
	{ (LONG64)vbox__FramebufferCapabilities__RenderCursor, "RenderCursor" },
	{ (LONG64)vbox__FramebufferCapabilities__MoveCursor, "MoveCursor" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FramebufferCapabilities2s(struct soap *soap, enum vbox__FramebufferCapabilities n)
{
	const char *s = soap_code_str(soap_codes_vbox__FramebufferCapabilities, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FramebufferCapabilities(struct soap *soap, const char *tag, int id, const enum vbox__FramebufferCapabilities *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FramebufferCapabilities), type) || soap_send(soap, soap_vbox__FramebufferCapabilities2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FramebufferCapabilities(struct soap *soap, const char *s, enum vbox__FramebufferCapabilities *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FramebufferCapabilities, s);
	if (map)
		*a = (enum vbox__FramebufferCapabilities)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FramebufferCapabilities)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FramebufferCapabilities * SOAP_FMAC4 soap_in_vbox__FramebufferCapabilities(struct soap *soap, const char *tag, enum vbox__FramebufferCapabilities *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FramebufferCapabilities*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FramebufferCapabilities, sizeof(enum vbox__FramebufferCapabilities), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FramebufferCapabilities(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FramebufferCapabilities *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FramebufferCapabilities, SOAP_TYPE_vbox__FramebufferCapabilities, sizeof(enum vbox__FramebufferCapabilities), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FramebufferCapabilities * SOAP_FMAC4 soap_new_vbox__FramebufferCapabilities(struct soap *soap, int n)
{
	enum vbox__FramebufferCapabilities *a = static_cast<enum vbox__FramebufferCapabilities *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FramebufferCapabilities)));
	for (enum vbox__FramebufferCapabilities *p = a; p && n--; ++p)
		soap_default_vbox__FramebufferCapabilities(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FramebufferCapabilities(struct soap *soap, const enum vbox__FramebufferCapabilities *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FramebufferCapabilities(soap, tag ? tag : "vbox:FramebufferCapabilities", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FramebufferCapabilities * SOAP_FMAC4 soap_get_vbox__FramebufferCapabilities(struct soap *soap, enum vbox__FramebufferCapabilities *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FramebufferCapabilities(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__TouchContactState[] =
{	{ (LONG64)vbox__TouchContactState__None, "None" },
	{ (LONG64)vbox__TouchContactState__InContact, "InContact" },
	{ (LONG64)vbox__TouchContactState__InRange, "InRange" },
	{ (LONG64)vbox__TouchContactState__ContactStateMask, "ContactStateMask" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__TouchContactState2s(struct soap *soap, enum vbox__TouchContactState n)
{
	const char *s = soap_code_str(soap_codes_vbox__TouchContactState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__TouchContactState(struct soap *soap, const char *tag, int id, const enum vbox__TouchContactState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__TouchContactState), type) || soap_send(soap, soap_vbox__TouchContactState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__TouchContactState(struct soap *soap, const char *s, enum vbox__TouchContactState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__TouchContactState, s);
	if (map)
		*a = (enum vbox__TouchContactState)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__TouchContactState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__TouchContactState * SOAP_FMAC4 soap_in_vbox__TouchContactState(struct soap *soap, const char *tag, enum vbox__TouchContactState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__TouchContactState*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__TouchContactState, sizeof(enum vbox__TouchContactState), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__TouchContactState(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__TouchContactState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__TouchContactState, SOAP_TYPE_vbox__TouchContactState, sizeof(enum vbox__TouchContactState), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__TouchContactState * SOAP_FMAC4 soap_new_vbox__TouchContactState(struct soap *soap, int n)
{
	enum vbox__TouchContactState *a = static_cast<enum vbox__TouchContactState *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__TouchContactState)));
	for (enum vbox__TouchContactState *p = a; p && n--; ++p)
		soap_default_vbox__TouchContactState(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__TouchContactState(struct soap *soap, const enum vbox__TouchContactState *a, const char *tag, const char *type)
{
	if (soap_out_vbox__TouchContactState(soap, tag ? tag : "vbox:TouchContactState", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__TouchContactState * SOAP_FMAC4 soap_get_vbox__TouchContactState(struct soap *soap, enum vbox__TouchContactState *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__TouchContactState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__MouseButtonState[] =
{	{ (LONG64)vbox__MouseButtonState__LeftButton, "LeftButton" },
	{ (LONG64)vbox__MouseButtonState__RightButton, "RightButton" },
	{ (LONG64)vbox__MouseButtonState__MiddleButton, "MiddleButton" },
	{ (LONG64)vbox__MouseButtonState__WheelUp, "WheelUp" },
	{ (LONG64)vbox__MouseButtonState__WheelDown, "WheelDown" },
	{ (LONG64)vbox__MouseButtonState__XButton1, "XButton1" },
	{ (LONG64)vbox__MouseButtonState__XButton2, "XButton2" },
	{ (LONG64)vbox__MouseButtonState__MouseStateMask, "MouseStateMask" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__MouseButtonState2s(struct soap *soap, enum vbox__MouseButtonState n)
{
	const char *s = soap_code_str(soap_codes_vbox__MouseButtonState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__MouseButtonState(struct soap *soap, const char *tag, int id, const enum vbox__MouseButtonState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__MouseButtonState), type) || soap_send(soap, soap_vbox__MouseButtonState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__MouseButtonState(struct soap *soap, const char *s, enum vbox__MouseButtonState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__MouseButtonState, s);
	if (map)
		*a = (enum vbox__MouseButtonState)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 7)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__MouseButtonState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__MouseButtonState * SOAP_FMAC4 soap_in_vbox__MouseButtonState(struct soap *soap, const char *tag, enum vbox__MouseButtonState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__MouseButtonState*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__MouseButtonState, sizeof(enum vbox__MouseButtonState), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__MouseButtonState(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__MouseButtonState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__MouseButtonState, SOAP_TYPE_vbox__MouseButtonState, sizeof(enum vbox__MouseButtonState), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__MouseButtonState * SOAP_FMAC4 soap_new_vbox__MouseButtonState(struct soap *soap, int n)
{
	enum vbox__MouseButtonState *a = static_cast<enum vbox__MouseButtonState *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__MouseButtonState)));
	for (enum vbox__MouseButtonState *p = a; p && n--; ++p)
		soap_default_vbox__MouseButtonState(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__MouseButtonState(struct soap *soap, const enum vbox__MouseButtonState *a, const char *tag, const char *type)
{
	if (soap_out_vbox__MouseButtonState(soap, tag ? tag : "vbox:MouseButtonState", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__MouseButtonState * SOAP_FMAC4 soap_get_vbox__MouseButtonState(struct soap *soap, enum vbox__MouseButtonState *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__MouseButtonState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__KeyboardLED[] =
{	{ (LONG64)vbox__KeyboardLED__NumLock, "NumLock" },
	{ (LONG64)vbox__KeyboardLED__CapsLock, "CapsLock" },
	{ (LONG64)vbox__KeyboardLED__ScrollLock, "ScrollLock" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__KeyboardLED2s(struct soap *soap, enum vbox__KeyboardLED n)
{
	const char *s = soap_code_str(soap_codes_vbox__KeyboardLED, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__KeyboardLED(struct soap *soap, const char *tag, int id, const enum vbox__KeyboardLED *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__KeyboardLED), type) || soap_send(soap, soap_vbox__KeyboardLED2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__KeyboardLED(struct soap *soap, const char *s, enum vbox__KeyboardLED *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__KeyboardLED, s);
	if (map)
		*a = (enum vbox__KeyboardLED)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__KeyboardLED)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__KeyboardLED * SOAP_FMAC4 soap_in_vbox__KeyboardLED(struct soap *soap, const char *tag, enum vbox__KeyboardLED *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__KeyboardLED*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__KeyboardLED, sizeof(enum vbox__KeyboardLED), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__KeyboardLED(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__KeyboardLED *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__KeyboardLED, SOAP_TYPE_vbox__KeyboardLED, sizeof(enum vbox__KeyboardLED), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__KeyboardLED * SOAP_FMAC4 soap_new_vbox__KeyboardLED(struct soap *soap, int n)
{
	enum vbox__KeyboardLED *a = static_cast<enum vbox__KeyboardLED *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__KeyboardLED)));
	for (enum vbox__KeyboardLED *p = a; p && n--; ++p)
		soap_default_vbox__KeyboardLED(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__KeyboardLED(struct soap *soap, const enum vbox__KeyboardLED *a, const char *tag, const char *type)
{
	if (soap_out_vbox__KeyboardLED(soap, tag ? tag : "vbox:KeyboardLED", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__KeyboardLED * SOAP_FMAC4 soap_get_vbox__KeyboardLED(struct soap *soap, enum vbox__KeyboardLED *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__KeyboardLED(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__PartitionTableType[] =
{	{ (LONG64)vbox__PartitionTableType__MBR, "MBR" },
	{ (LONG64)vbox__PartitionTableType__GPT, "GPT" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__PartitionTableType2s(struct soap *soap, enum vbox__PartitionTableType n)
{
	const char *s = soap_code_str(soap_codes_vbox__PartitionTableType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__PartitionTableType(struct soap *soap, const char *tag, int id, const enum vbox__PartitionTableType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__PartitionTableType), type) || soap_send(soap, soap_vbox__PartitionTableType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__PartitionTableType(struct soap *soap, const char *s, enum vbox__PartitionTableType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__PartitionTableType, s);
	if (map)
		*a = (enum vbox__PartitionTableType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__PartitionTableType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__PartitionTableType * SOAP_FMAC4 soap_in_vbox__PartitionTableType(struct soap *soap, const char *tag, enum vbox__PartitionTableType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__PartitionTableType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__PartitionTableType, sizeof(enum vbox__PartitionTableType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__PartitionTableType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__PartitionTableType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__PartitionTableType, SOAP_TYPE_vbox__PartitionTableType, sizeof(enum vbox__PartitionTableType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__PartitionTableType * SOAP_FMAC4 soap_new_vbox__PartitionTableType(struct soap *soap, int n)
{
	enum vbox__PartitionTableType *a = static_cast<enum vbox__PartitionTableType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__PartitionTableType)));
	for (enum vbox__PartitionTableType *p = a; p && n--; ++p)
		soap_default_vbox__PartitionTableType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__PartitionTableType(struct soap *soap, const enum vbox__PartitionTableType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__PartitionTableType(soap, tag ? tag : "vbox:PartitionTableType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__PartitionTableType * SOAP_FMAC4 soap_get_vbox__PartitionTableType(struct soap *soap, enum vbox__PartitionTableType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__PartitionTableType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__MediumFormatCapabilities[] =
{	{ (LONG64)vbox__MediumFormatCapabilities__Uuid, "Uuid" },
	{ (LONG64)vbox__MediumFormatCapabilities__CreateFixed, "CreateFixed" },
	{ (LONG64)vbox__MediumFormatCapabilities__CreateDynamic, "CreateDynamic" },
	{ (LONG64)vbox__MediumFormatCapabilities__CreateSplit2G, "CreateSplit2G" },
	{ (LONG64)vbox__MediumFormatCapabilities__Differencing, "Differencing" },
	{ (LONG64)vbox__MediumFormatCapabilities__Asynchronous, "Asynchronous" },
	{ (LONG64)vbox__MediumFormatCapabilities__File, "File" },
	{ (LONG64)vbox__MediumFormatCapabilities__Properties, "Properties" },
	{ (LONG64)vbox__MediumFormatCapabilities__TcpNetworking, "TcpNetworking" },
	{ (LONG64)vbox__MediumFormatCapabilities__VFS, "VFS" },
	{ (LONG64)vbox__MediumFormatCapabilities__Discard, "Discard" },
	{ (LONG64)vbox__MediumFormatCapabilities__Preferred, "Preferred" },
	{ (LONG64)vbox__MediumFormatCapabilities__CapabilityMask, "CapabilityMask" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__MediumFormatCapabilities2s(struct soap *soap, enum vbox__MediumFormatCapabilities n)
{
	const char *s = soap_code_str(soap_codes_vbox__MediumFormatCapabilities, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__MediumFormatCapabilities(struct soap *soap, const char *tag, int id, const enum vbox__MediumFormatCapabilities *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__MediumFormatCapabilities), type) || soap_send(soap, soap_vbox__MediumFormatCapabilities2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__MediumFormatCapabilities(struct soap *soap, const char *s, enum vbox__MediumFormatCapabilities *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__MediumFormatCapabilities, s);
	if (map)
		*a = (enum vbox__MediumFormatCapabilities)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 12)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__MediumFormatCapabilities)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__MediumFormatCapabilities * SOAP_FMAC4 soap_in_vbox__MediumFormatCapabilities(struct soap *soap, const char *tag, enum vbox__MediumFormatCapabilities *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__MediumFormatCapabilities*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__MediumFormatCapabilities, sizeof(enum vbox__MediumFormatCapabilities), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__MediumFormatCapabilities(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__MediumFormatCapabilities *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__MediumFormatCapabilities, SOAP_TYPE_vbox__MediumFormatCapabilities, sizeof(enum vbox__MediumFormatCapabilities), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__MediumFormatCapabilities * SOAP_FMAC4 soap_new_vbox__MediumFormatCapabilities(struct soap *soap, int n)
{
	enum vbox__MediumFormatCapabilities *a = static_cast<enum vbox__MediumFormatCapabilities *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__MediumFormatCapabilities)));
	for (enum vbox__MediumFormatCapabilities *p = a; p && n--; ++p)
		soap_default_vbox__MediumFormatCapabilities(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__MediumFormatCapabilities(struct soap *soap, const enum vbox__MediumFormatCapabilities *a, const char *tag, const char *type)
{
	if (soap_out_vbox__MediumFormatCapabilities(soap, tag ? tag : "vbox:MediumFormatCapabilities", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__MediumFormatCapabilities * SOAP_FMAC4 soap_get_vbox__MediumFormatCapabilities(struct soap *soap, enum vbox__MediumFormatCapabilities *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__MediumFormatCapabilities(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DataFlags[] =
{	{ (LONG64)vbox__DataFlags__None, "None" },
	{ (LONG64)vbox__DataFlags__Mandatory, "Mandatory" },
	{ (LONG64)vbox__DataFlags__Expert, "Expert" },
	{ (LONG64)vbox__DataFlags__Array, "Array" },
	{ (LONG64)vbox__DataFlags__FlagMask, "FlagMask" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DataFlags2s(struct soap *soap, enum vbox__DataFlags n)
{
	const char *s = soap_code_str(soap_codes_vbox__DataFlags, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DataFlags(struct soap *soap, const char *tag, int id, const enum vbox__DataFlags *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DataFlags), type) || soap_send(soap, soap_vbox__DataFlags2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DataFlags(struct soap *soap, const char *s, enum vbox__DataFlags *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DataFlags, s);
	if (map)
		*a = (enum vbox__DataFlags)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DataFlags)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DataFlags * SOAP_FMAC4 soap_in_vbox__DataFlags(struct soap *soap, const char *tag, enum vbox__DataFlags *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DataFlags*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DataFlags, sizeof(enum vbox__DataFlags), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DataFlags(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DataFlags *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DataFlags, SOAP_TYPE_vbox__DataFlags, sizeof(enum vbox__DataFlags), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DataFlags * SOAP_FMAC4 soap_new_vbox__DataFlags(struct soap *soap, int n)
{
	enum vbox__DataFlags *a = static_cast<enum vbox__DataFlags *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DataFlags)));
	for (enum vbox__DataFlags *p = a; p && n--; ++p)
		soap_default_vbox__DataFlags(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DataFlags(struct soap *soap, const enum vbox__DataFlags *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DataFlags(soap, tag ? tag : "vbox:DataFlags", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DataFlags * SOAP_FMAC4 soap_get_vbox__DataFlags(struct soap *soap, enum vbox__DataFlags *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DataFlags(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DataType[] =
{	{ (LONG64)vbox__DataType__Int32, "Int32" },
	{ (LONG64)vbox__DataType__Int8, "Int8" },
	{ (LONG64)vbox__DataType__String, "String" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DataType2s(struct soap *soap, enum vbox__DataType n)
{
	const char *s = soap_code_str(soap_codes_vbox__DataType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DataType(struct soap *soap, const char *tag, int id, const enum vbox__DataType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DataType), type) || soap_send(soap, soap_vbox__DataType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DataType(struct soap *soap, const char *s, enum vbox__DataType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DataType, s);
	if (map)
		*a = (enum vbox__DataType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DataType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DataType * SOAP_FMAC4 soap_in_vbox__DataType(struct soap *soap, const char *tag, enum vbox__DataType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DataType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DataType, sizeof(enum vbox__DataType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DataType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DataType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DataType, SOAP_TYPE_vbox__DataType, sizeof(enum vbox__DataType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DataType * SOAP_FMAC4 soap_new_vbox__DataType(struct soap *soap, int n)
{
	enum vbox__DataType *a = static_cast<enum vbox__DataType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DataType)));
	for (enum vbox__DataType *p = a; p && n--; ++p)
		soap_default_vbox__DataType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DataType(struct soap *soap, const enum vbox__DataType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DataType(soap, tag ? tag : "vbox:DataType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DataType * SOAP_FMAC4 soap_get_vbox__DataType(struct soap *soap, enum vbox__DataType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DataType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__MediumVariant[] =
{	{ (LONG64)vbox__MediumVariant__Standard, "Standard" },
	{ (LONG64)vbox__MediumVariant__VmdkSplit2G, "VmdkSplit2G" },
	{ (LONG64)vbox__MediumVariant__VmdkRawDisk, "VmdkRawDisk" },
	{ (LONG64)vbox__MediumVariant__VmdkStreamOptimized, "VmdkStreamOptimized" },
	{ (LONG64)vbox__MediumVariant__VmdkESX, "VmdkESX" },
	{ (LONG64)vbox__MediumVariant__VdiZeroExpand, "VdiZeroExpand" },
	{ (LONG64)vbox__MediumVariant__Fixed, "Fixed" },
	{ (LONG64)vbox__MediumVariant__Diff, "Diff" },
	{ (LONG64)vbox__MediumVariant__Formatted, "Formatted" },
	{ (LONG64)vbox__MediumVariant__NoCreateDir, "NoCreateDir" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__MediumVariant2s(struct soap *soap, enum vbox__MediumVariant n)
{
	const char *s = soap_code_str(soap_codes_vbox__MediumVariant, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__MediumVariant(struct soap *soap, const char *tag, int id, const enum vbox__MediumVariant *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__MediumVariant), type) || soap_send(soap, soap_vbox__MediumVariant2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__MediumVariant(struct soap *soap, const char *s, enum vbox__MediumVariant *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__MediumVariant, s);
	if (map)
		*a = (enum vbox__MediumVariant)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 9)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__MediumVariant)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__MediumVariant * SOAP_FMAC4 soap_in_vbox__MediumVariant(struct soap *soap, const char *tag, enum vbox__MediumVariant *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__MediumVariant*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__MediumVariant, sizeof(enum vbox__MediumVariant), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__MediumVariant(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__MediumVariant *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__MediumVariant, SOAP_TYPE_vbox__MediumVariant, sizeof(enum vbox__MediumVariant), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__MediumVariant * SOAP_FMAC4 soap_new_vbox__MediumVariant(struct soap *soap, int n)
{
	enum vbox__MediumVariant *a = static_cast<enum vbox__MediumVariant *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__MediumVariant)));
	for (enum vbox__MediumVariant *p = a; p && n--; ++p)
		soap_default_vbox__MediumVariant(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__MediumVariant(struct soap *soap, const enum vbox__MediumVariant *a, const char *tag, const char *type)
{
	if (soap_out_vbox__MediumVariant(soap, tag ? tag : "vbox:MediumVariant", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__MediumVariant * SOAP_FMAC4 soap_get_vbox__MediumVariant(struct soap *soap, enum vbox__MediumVariant *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__MediumVariant(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__MediumType[] =
{	{ (LONG64)vbox__MediumType__Normal, "Normal" },
	{ (LONG64)vbox__MediumType__Immutable, "Immutable" },
	{ (LONG64)vbox__MediumType__Writethrough, "Writethrough" },
	{ (LONG64)vbox__MediumType__Shareable, "Shareable" },
	{ (LONG64)vbox__MediumType__Readonly, "Readonly" },
	{ (LONG64)vbox__MediumType__MultiAttach, "MultiAttach" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__MediumType2s(struct soap *soap, enum vbox__MediumType n)
{
	const char *s = soap_code_str(soap_codes_vbox__MediumType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__MediumType(struct soap *soap, const char *tag, int id, const enum vbox__MediumType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__MediumType), type) || soap_send(soap, soap_vbox__MediumType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__MediumType(struct soap *soap, const char *s, enum vbox__MediumType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__MediumType, s);
	if (map)
		*a = (enum vbox__MediumType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 5)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__MediumType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__MediumType * SOAP_FMAC4 soap_in_vbox__MediumType(struct soap *soap, const char *tag, enum vbox__MediumType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__MediumType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__MediumType, sizeof(enum vbox__MediumType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__MediumType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__MediumType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__MediumType, SOAP_TYPE_vbox__MediumType, sizeof(enum vbox__MediumType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__MediumType * SOAP_FMAC4 soap_new_vbox__MediumType(struct soap *soap, int n)
{
	enum vbox__MediumType *a = static_cast<enum vbox__MediumType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__MediumType)));
	for (enum vbox__MediumType *p = a; p && n--; ++p)
		soap_default_vbox__MediumType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__MediumType(struct soap *soap, const enum vbox__MediumType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__MediumType(soap, tag ? tag : "vbox:MediumType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__MediumType * SOAP_FMAC4 soap_get_vbox__MediumType(struct soap *soap, enum vbox__MediumType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__MediumType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__MediumState[] =
{	{ (LONG64)vbox__MediumState__NotCreated, "NotCreated" },
	{ (LONG64)vbox__MediumState__Created, "Created" },
	{ (LONG64)vbox__MediumState__LockedRead, "LockedRead" },
	{ (LONG64)vbox__MediumState__LockedWrite, "LockedWrite" },
	{ (LONG64)vbox__MediumState__Inaccessible, "Inaccessible" },
	{ (LONG64)vbox__MediumState__Creating, "Creating" },
	{ (LONG64)vbox__MediumState__Deleting, "Deleting" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__MediumState2s(struct soap *soap, enum vbox__MediumState n)
{
	const char *s = soap_code_str(soap_codes_vbox__MediumState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__MediumState(struct soap *soap, const char *tag, int id, const enum vbox__MediumState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__MediumState), type) || soap_send(soap, soap_vbox__MediumState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__MediumState(struct soap *soap, const char *s, enum vbox__MediumState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__MediumState, s);
	if (map)
		*a = (enum vbox__MediumState)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 6)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__MediumState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__MediumState * SOAP_FMAC4 soap_in_vbox__MediumState(struct soap *soap, const char *tag, enum vbox__MediumState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__MediumState*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__MediumState, sizeof(enum vbox__MediumState), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__MediumState(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__MediumState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__MediumState, SOAP_TYPE_vbox__MediumState, sizeof(enum vbox__MediumState), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__MediumState * SOAP_FMAC4 soap_new_vbox__MediumState(struct soap *soap, int n)
{
	enum vbox__MediumState *a = static_cast<enum vbox__MediumState *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__MediumState)));
	for (enum vbox__MediumState *p = a; p && n--; ++p)
		soap_default_vbox__MediumState(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__MediumState(struct soap *soap, const enum vbox__MediumState *a, const char *tag, const char *type)
{
	if (soap_out_vbox__MediumState(soap, tag ? tag : "vbox:MediumState", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__MediumState * SOAP_FMAC4 soap_get_vbox__MediumState(struct soap *soap, enum vbox__MediumState *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__MediumState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DirectoryOpenFlag[] =
{	{ (LONG64)vbox__DirectoryOpenFlag__None, "None" },
	{ (LONG64)vbox__DirectoryOpenFlag__NoSymlinks, "NoSymlinks" },
	{ (LONG64)vbox__DirectoryOpenFlag__DenyAscent, "DenyAscent" },
	{ (LONG64)vbox__DirectoryOpenFlag__NoFollowSymlinks, "NoFollowSymlinks" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DirectoryOpenFlag2s(struct soap *soap, enum vbox__DirectoryOpenFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__DirectoryOpenFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DirectoryOpenFlag(struct soap *soap, const char *tag, int id, const enum vbox__DirectoryOpenFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DirectoryOpenFlag), type) || soap_send(soap, soap_vbox__DirectoryOpenFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DirectoryOpenFlag(struct soap *soap, const char *s, enum vbox__DirectoryOpenFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DirectoryOpenFlag, s);
	if (map)
		*a = (enum vbox__DirectoryOpenFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DirectoryOpenFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DirectoryOpenFlag * SOAP_FMAC4 soap_in_vbox__DirectoryOpenFlag(struct soap *soap, const char *tag, enum vbox__DirectoryOpenFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DirectoryOpenFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DirectoryOpenFlag, sizeof(enum vbox__DirectoryOpenFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DirectoryOpenFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DirectoryOpenFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DirectoryOpenFlag, SOAP_TYPE_vbox__DirectoryOpenFlag, sizeof(enum vbox__DirectoryOpenFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DirectoryOpenFlag * SOAP_FMAC4 soap_new_vbox__DirectoryOpenFlag(struct soap *soap, int n)
{
	enum vbox__DirectoryOpenFlag *a = static_cast<enum vbox__DirectoryOpenFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DirectoryOpenFlag)));
	for (enum vbox__DirectoryOpenFlag *p = a; p && n--; ++p)
		soap_default_vbox__DirectoryOpenFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DirectoryOpenFlag(struct soap *soap, const enum vbox__DirectoryOpenFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DirectoryOpenFlag(soap, tag ? tag : "vbox:DirectoryOpenFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DirectoryOpenFlag * SOAP_FMAC4 soap_get_vbox__DirectoryOpenFlag(struct soap *soap, enum vbox__DirectoryOpenFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DirectoryOpenFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DnDAction[] =
{	{ (LONG64)vbox__DnDAction__Ignore, "Ignore" },
	{ (LONG64)vbox__DnDAction__Copy, "Copy" },
	{ (LONG64)vbox__DnDAction__Move, "Move" },
	{ (LONG64)vbox__DnDAction__Link, "Link" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DnDAction2s(struct soap *soap, enum vbox__DnDAction n)
{
	const char *s = soap_code_str(soap_codes_vbox__DnDAction, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DnDAction(struct soap *soap, const char *tag, int id, const enum vbox__DnDAction *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DnDAction), type) || soap_send(soap, soap_vbox__DnDAction2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DnDAction(struct soap *soap, const char *s, enum vbox__DnDAction *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DnDAction, s);
	if (map)
		*a = (enum vbox__DnDAction)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DnDAction)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DnDAction * SOAP_FMAC4 soap_in_vbox__DnDAction(struct soap *soap, const char *tag, enum vbox__DnDAction *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DnDAction*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DnDAction, sizeof(enum vbox__DnDAction), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DnDAction(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DnDAction *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DnDAction, SOAP_TYPE_vbox__DnDAction, sizeof(enum vbox__DnDAction), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DnDAction * SOAP_FMAC4 soap_new_vbox__DnDAction(struct soap *soap, int n)
{
	enum vbox__DnDAction *a = static_cast<enum vbox__DnDAction *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DnDAction)));
	for (enum vbox__DnDAction *p = a; p && n--; ++p)
		soap_default_vbox__DnDAction(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DnDAction(struct soap *soap, const enum vbox__DnDAction *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DnDAction(soap, tag ? tag : "vbox:DnDAction", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DnDAction * SOAP_FMAC4 soap_get_vbox__DnDAction(struct soap *soap, enum vbox__DnDAction *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DnDAction(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FsObjType[] =
{	{ (LONG64)vbox__FsObjType__Unknown, "Unknown" },
	{ (LONG64)vbox__FsObjType__Fifo, "Fifo" },
	{ (LONG64)vbox__FsObjType__DevChar, "DevChar" },
	{ (LONG64)vbox__FsObjType__Directory, "Directory" },
	{ (LONG64)vbox__FsObjType__DevBlock, "DevBlock" },
	{ (LONG64)vbox__FsObjType__File, "File" },
	{ (LONG64)vbox__FsObjType__Symlink, "Symlink" },
	{ (LONG64)vbox__FsObjType__Socket, "Socket" },
	{ (LONG64)vbox__FsObjType__WhiteOut, "WhiteOut" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FsObjType2s(struct soap *soap, enum vbox__FsObjType n)
{
	const char *s = soap_code_str(soap_codes_vbox__FsObjType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FsObjType(struct soap *soap, const char *tag, int id, const enum vbox__FsObjType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FsObjType), type) || soap_send(soap, soap_vbox__FsObjType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FsObjType(struct soap *soap, const char *s, enum vbox__FsObjType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FsObjType, s);
	if (map)
		*a = (enum vbox__FsObjType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 8)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FsObjType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FsObjType * SOAP_FMAC4 soap_in_vbox__FsObjType(struct soap *soap, const char *tag, enum vbox__FsObjType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FsObjType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FsObjType, sizeof(enum vbox__FsObjType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FsObjType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FsObjType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FsObjType, SOAP_TYPE_vbox__FsObjType, sizeof(enum vbox__FsObjType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FsObjType * SOAP_FMAC4 soap_new_vbox__FsObjType(struct soap *soap, int n)
{
	enum vbox__FsObjType *a = static_cast<enum vbox__FsObjType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FsObjType)));
	for (enum vbox__FsObjType *p = a; p && n--; ++p)
		soap_default_vbox__FsObjType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FsObjType(struct soap *soap, const enum vbox__FsObjType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FsObjType(soap, tag ? tag : "vbox:FsObjType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FsObjType * SOAP_FMAC4 soap_get_vbox__FsObjType(struct soap *soap, enum vbox__FsObjType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FsObjType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FileStatus[] =
{	{ (LONG64)vbox__FileStatus__Undefined, "Undefined" },
	{ (LONG64)vbox__FileStatus__Opening, "Opening" },
	{ (LONG64)vbox__FileStatus__Open, "Open" },
	{ (LONG64)vbox__FileStatus__Closing, "Closing" },
	{ (LONG64)vbox__FileStatus__Closed, "Closed" },
	{ (LONG64)vbox__FileStatus__Down, "Down" },
	{ (LONG64)vbox__FileStatus__Error, "Error" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FileStatus2s(struct soap *soap, enum vbox__FileStatus n)
{
	const char *s = soap_code_str(soap_codes_vbox__FileStatus, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FileStatus(struct soap *soap, const char *tag, int id, const enum vbox__FileStatus *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FileStatus), type) || soap_send(soap, soap_vbox__FileStatus2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FileStatus(struct soap *soap, const char *s, enum vbox__FileStatus *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FileStatus, s);
	if (map)
		*a = (enum vbox__FileStatus)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 6)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FileStatus)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FileStatus * SOAP_FMAC4 soap_in_vbox__FileStatus(struct soap *soap, const char *tag, enum vbox__FileStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FileStatus*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FileStatus, sizeof(enum vbox__FileStatus), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FileStatus(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FileStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FileStatus, SOAP_TYPE_vbox__FileStatus, sizeof(enum vbox__FileStatus), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FileStatus * SOAP_FMAC4 soap_new_vbox__FileStatus(struct soap *soap, int n)
{
	enum vbox__FileStatus *a = static_cast<enum vbox__FileStatus *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FileStatus)));
	for (enum vbox__FileStatus *p = a; p && n--; ++p)
		soap_default_vbox__FileStatus(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FileStatus(struct soap *soap, const enum vbox__FileStatus *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FileStatus(soap, tag ? tag : "vbox:FileStatus", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FileStatus * SOAP_FMAC4 soap_get_vbox__FileStatus(struct soap *soap, enum vbox__FileStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FileStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FileOpenExFlag[] =
{	{ (LONG64)vbox__FileOpenExFlag__None, "None" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FileOpenExFlag2s(struct soap *soap, enum vbox__FileOpenExFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__FileOpenExFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FileOpenExFlag(struct soap *soap, const char *tag, int id, const enum vbox__FileOpenExFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FileOpenExFlag), type) || soap_send(soap, soap_vbox__FileOpenExFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FileOpenExFlag(struct soap *soap, const char *s, enum vbox__FileOpenExFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FileOpenExFlag, s);
	if (map)
		*a = (enum vbox__FileOpenExFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 0)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FileOpenExFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FileOpenExFlag * SOAP_FMAC4 soap_in_vbox__FileOpenExFlag(struct soap *soap, const char *tag, enum vbox__FileOpenExFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FileOpenExFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FileOpenExFlag, sizeof(enum vbox__FileOpenExFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FileOpenExFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FileOpenExFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FileOpenExFlag, SOAP_TYPE_vbox__FileOpenExFlag, sizeof(enum vbox__FileOpenExFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FileOpenExFlag * SOAP_FMAC4 soap_new_vbox__FileOpenExFlag(struct soap *soap, int n)
{
	enum vbox__FileOpenExFlag *a = static_cast<enum vbox__FileOpenExFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FileOpenExFlag)));
	for (enum vbox__FileOpenExFlag *p = a; p && n--; ++p)
		soap_default_vbox__FileOpenExFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FileOpenExFlag(struct soap *soap, const enum vbox__FileOpenExFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FileOpenExFlag(soap, tag ? tag : "vbox:FileOpenExFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FileOpenExFlag * SOAP_FMAC4 soap_get_vbox__FileOpenExFlag(struct soap *soap, enum vbox__FileOpenExFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FileOpenExFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FileSharingMode[] =
{	{ (LONG64)vbox__FileSharingMode__Read, "Read" },
	{ (LONG64)vbox__FileSharingMode__Write, "Write" },
	{ (LONG64)vbox__FileSharingMode__ReadWrite, "ReadWrite" },
	{ (LONG64)vbox__FileSharingMode__Delete, "Delete" },
	{ (LONG64)vbox__FileSharingMode__ReadDelete, "ReadDelete" },
	{ (LONG64)vbox__FileSharingMode__WriteDelete, "WriteDelete" },
	{ (LONG64)vbox__FileSharingMode__All, "All" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FileSharingMode2s(struct soap *soap, enum vbox__FileSharingMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__FileSharingMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FileSharingMode(struct soap *soap, const char *tag, int id, const enum vbox__FileSharingMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FileSharingMode), type) || soap_send(soap, soap_vbox__FileSharingMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FileSharingMode(struct soap *soap, const char *s, enum vbox__FileSharingMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FileSharingMode, s);
	if (map)
		*a = (enum vbox__FileSharingMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 6)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FileSharingMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FileSharingMode * SOAP_FMAC4 soap_in_vbox__FileSharingMode(struct soap *soap, const char *tag, enum vbox__FileSharingMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FileSharingMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FileSharingMode, sizeof(enum vbox__FileSharingMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FileSharingMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FileSharingMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FileSharingMode, SOAP_TYPE_vbox__FileSharingMode, sizeof(enum vbox__FileSharingMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FileSharingMode * SOAP_FMAC4 soap_new_vbox__FileSharingMode(struct soap *soap, int n)
{
	enum vbox__FileSharingMode *a = static_cast<enum vbox__FileSharingMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FileSharingMode)));
	for (enum vbox__FileSharingMode *p = a; p && n--; ++p)
		soap_default_vbox__FileSharingMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FileSharingMode(struct soap *soap, const enum vbox__FileSharingMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FileSharingMode(soap, tag ? tag : "vbox:FileSharingMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FileSharingMode * SOAP_FMAC4 soap_get_vbox__FileSharingMode(struct soap *soap, enum vbox__FileSharingMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FileSharingMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FileOpenAction[] =
{	{ (LONG64)vbox__FileOpenAction__OpenExisting, "OpenExisting" },
	{ (LONG64)vbox__FileOpenAction__OpenOrCreate, "OpenOrCreate" },
	{ (LONG64)vbox__FileOpenAction__CreateNew, "CreateNew" },
	{ (LONG64)vbox__FileOpenAction__CreateOrReplace, "CreateOrReplace" },
	{ (LONG64)vbox__FileOpenAction__OpenExistingTruncated, "OpenExistingTruncated" },
	{ (LONG64)vbox__FileOpenAction__AppendOrCreate, "AppendOrCreate" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FileOpenAction2s(struct soap *soap, enum vbox__FileOpenAction n)
{
	const char *s = soap_code_str(soap_codes_vbox__FileOpenAction, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FileOpenAction(struct soap *soap, const char *tag, int id, const enum vbox__FileOpenAction *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FileOpenAction), type) || soap_send(soap, soap_vbox__FileOpenAction2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FileOpenAction(struct soap *soap, const char *s, enum vbox__FileOpenAction *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FileOpenAction, s);
	if (map)
		*a = (enum vbox__FileOpenAction)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 5)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FileOpenAction)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FileOpenAction * SOAP_FMAC4 soap_in_vbox__FileOpenAction(struct soap *soap, const char *tag, enum vbox__FileOpenAction *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FileOpenAction*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FileOpenAction, sizeof(enum vbox__FileOpenAction), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FileOpenAction(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FileOpenAction *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FileOpenAction, SOAP_TYPE_vbox__FileOpenAction, sizeof(enum vbox__FileOpenAction), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FileOpenAction * SOAP_FMAC4 soap_new_vbox__FileOpenAction(struct soap *soap, int n)
{
	enum vbox__FileOpenAction *a = static_cast<enum vbox__FileOpenAction *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FileOpenAction)));
	for (enum vbox__FileOpenAction *p = a; p && n--; ++p)
		soap_default_vbox__FileOpenAction(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FileOpenAction(struct soap *soap, const enum vbox__FileOpenAction *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FileOpenAction(soap, tag ? tag : "vbox:FileOpenAction", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FileOpenAction * SOAP_FMAC4 soap_get_vbox__FileOpenAction(struct soap *soap, enum vbox__FileOpenAction *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FileOpenAction(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FileAccessMode[] =
{	{ (LONG64)vbox__FileAccessMode__ReadOnly, "ReadOnly" },
	{ (LONG64)vbox__FileAccessMode__WriteOnly, "WriteOnly" },
	{ (LONG64)vbox__FileAccessMode__ReadWrite, "ReadWrite" },
	{ (LONG64)vbox__FileAccessMode__AppendOnly, "AppendOnly" },
	{ (LONG64)vbox__FileAccessMode__AppendRead, "AppendRead" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FileAccessMode2s(struct soap *soap, enum vbox__FileAccessMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__FileAccessMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FileAccessMode(struct soap *soap, const char *tag, int id, const enum vbox__FileAccessMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FileAccessMode), type) || soap_send(soap, soap_vbox__FileAccessMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FileAccessMode(struct soap *soap, const char *s, enum vbox__FileAccessMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FileAccessMode, s);
	if (map)
		*a = (enum vbox__FileAccessMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FileAccessMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FileAccessMode * SOAP_FMAC4 soap_in_vbox__FileAccessMode(struct soap *soap, const char *tag, enum vbox__FileAccessMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FileAccessMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FileAccessMode, sizeof(enum vbox__FileAccessMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FileAccessMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FileAccessMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FileAccessMode, SOAP_TYPE_vbox__FileAccessMode, sizeof(enum vbox__FileAccessMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FileAccessMode * SOAP_FMAC4 soap_new_vbox__FileAccessMode(struct soap *soap, int n)
{
	enum vbox__FileAccessMode *a = static_cast<enum vbox__FileAccessMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FileAccessMode)));
	for (enum vbox__FileAccessMode *p = a; p && n--; ++p)
		soap_default_vbox__FileAccessMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FileAccessMode(struct soap *soap, const enum vbox__FileAccessMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FileAccessMode(soap, tag ? tag : "vbox:FileAccessMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FileAccessMode * SOAP_FMAC4 soap_get_vbox__FileAccessMode(struct soap *soap, enum vbox__FileAccessMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FileAccessMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DirectoryStatus[] =
{	{ (LONG64)vbox__DirectoryStatus__Undefined, "Undefined" },
	{ (LONG64)vbox__DirectoryStatus__Open, "Open" },
	{ (LONG64)vbox__DirectoryStatus__Close, "Close" },
	{ (LONG64)vbox__DirectoryStatus__Rewind, "Rewind" },
	{ (LONG64)vbox__DirectoryStatus__Down, "Down" },
	{ (LONG64)vbox__DirectoryStatus__Error, "Error" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DirectoryStatus2s(struct soap *soap, enum vbox__DirectoryStatus n)
{
	const char *s = soap_code_str(soap_codes_vbox__DirectoryStatus, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DirectoryStatus(struct soap *soap, const char *tag, int id, const enum vbox__DirectoryStatus *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DirectoryStatus), type) || soap_send(soap, soap_vbox__DirectoryStatus2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DirectoryStatus(struct soap *soap, const char *s, enum vbox__DirectoryStatus *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DirectoryStatus, s);
	if (map)
		*a = (enum vbox__DirectoryStatus)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 5)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DirectoryStatus)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DirectoryStatus * SOAP_FMAC4 soap_in_vbox__DirectoryStatus(struct soap *soap, const char *tag, enum vbox__DirectoryStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DirectoryStatus*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DirectoryStatus, sizeof(enum vbox__DirectoryStatus), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DirectoryStatus(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DirectoryStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DirectoryStatus, SOAP_TYPE_vbox__DirectoryStatus, sizeof(enum vbox__DirectoryStatus), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DirectoryStatus * SOAP_FMAC4 soap_new_vbox__DirectoryStatus(struct soap *soap, int n)
{
	enum vbox__DirectoryStatus *a = static_cast<enum vbox__DirectoryStatus *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DirectoryStatus)));
	for (enum vbox__DirectoryStatus *p = a; p && n--; ++p)
		soap_default_vbox__DirectoryStatus(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DirectoryStatus(struct soap *soap, const enum vbox__DirectoryStatus *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DirectoryStatus(soap, tag ? tag : "vbox:DirectoryStatus", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DirectoryStatus * SOAP_FMAC4 soap_get_vbox__DirectoryStatus(struct soap *soap, enum vbox__DirectoryStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DirectoryStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__PathStyle[] =
{	{ (LONG64)vbox__PathStyle__DOS, "DOS" },
	{ (LONG64)vbox__PathStyle__UNIX, "UNIX" },
	{ (LONG64)vbox__PathStyle__Unknown, "Unknown" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__PathStyle2s(struct soap *soap, enum vbox__PathStyle n)
{
	const char *s = soap_code_str(soap_codes_vbox__PathStyle, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__PathStyle(struct soap *soap, const char *tag, int id, const enum vbox__PathStyle *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__PathStyle), type) || soap_send(soap, soap_vbox__PathStyle2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__PathStyle(struct soap *soap, const char *s, enum vbox__PathStyle *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__PathStyle, s);
	if (map)
		*a = (enum vbox__PathStyle)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__PathStyle)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__PathStyle * SOAP_FMAC4 soap_in_vbox__PathStyle(struct soap *soap, const char *tag, enum vbox__PathStyle *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__PathStyle*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__PathStyle, sizeof(enum vbox__PathStyle), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__PathStyle(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__PathStyle *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__PathStyle, SOAP_TYPE_vbox__PathStyle, sizeof(enum vbox__PathStyle), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__PathStyle * SOAP_FMAC4 soap_new_vbox__PathStyle(struct soap *soap, int n)
{
	enum vbox__PathStyle *a = static_cast<enum vbox__PathStyle *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__PathStyle)));
	for (enum vbox__PathStyle *p = a; p && n--; ++p)
		soap_default_vbox__PathStyle(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__PathStyle(struct soap *soap, const enum vbox__PathStyle *a, const char *tag, const char *type)
{
	if (soap_out_vbox__PathStyle(soap, tag ? tag : "vbox:PathStyle", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__PathStyle * SOAP_FMAC4 soap_get_vbox__PathStyle(struct soap *soap, enum vbox__PathStyle *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__PathStyle(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ProcessInputStatus[] =
{	{ (LONG64)vbox__ProcessInputStatus__Undefined, "Undefined" },
	{ (LONG64)vbox__ProcessInputStatus__Broken, "Broken" },
	{ (LONG64)vbox__ProcessInputStatus__Available, "Available" },
	{ (LONG64)vbox__ProcessInputStatus__Written, "Written" },
	{ (LONG64)vbox__ProcessInputStatus__Overflow, "Overflow" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ProcessInputStatus2s(struct soap *soap, enum vbox__ProcessInputStatus n)
{
	const char *s = soap_code_str(soap_codes_vbox__ProcessInputStatus, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ProcessInputStatus(struct soap *soap, const char *tag, int id, const enum vbox__ProcessInputStatus *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ProcessInputStatus), type) || soap_send(soap, soap_vbox__ProcessInputStatus2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ProcessInputStatus(struct soap *soap, const char *s, enum vbox__ProcessInputStatus *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ProcessInputStatus, s);
	if (map)
		*a = (enum vbox__ProcessInputStatus)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ProcessInputStatus)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ProcessInputStatus * SOAP_FMAC4 soap_in_vbox__ProcessInputStatus(struct soap *soap, const char *tag, enum vbox__ProcessInputStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ProcessInputStatus*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ProcessInputStatus, sizeof(enum vbox__ProcessInputStatus), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ProcessInputStatus(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ProcessInputStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ProcessInputStatus, SOAP_TYPE_vbox__ProcessInputStatus, sizeof(enum vbox__ProcessInputStatus), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ProcessInputStatus * SOAP_FMAC4 soap_new_vbox__ProcessInputStatus(struct soap *soap, int n)
{
	enum vbox__ProcessInputStatus *a = static_cast<enum vbox__ProcessInputStatus *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ProcessInputStatus)));
	for (enum vbox__ProcessInputStatus *p = a; p && n--; ++p)
		soap_default_vbox__ProcessInputStatus(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ProcessInputStatus(struct soap *soap, const enum vbox__ProcessInputStatus *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ProcessInputStatus(soap, tag ? tag : "vbox:ProcessInputStatus", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ProcessInputStatus * SOAP_FMAC4 soap_get_vbox__ProcessInputStatus(struct soap *soap, enum vbox__ProcessInputStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ProcessInputStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ProcessStatus[] =
{	{ (LONG64)vbox__ProcessStatus__Undefined, "Undefined" },
	{ (LONG64)vbox__ProcessStatus__Starting, "Starting" },
	{ (LONG64)vbox__ProcessStatus__Started, "Started" },
	{ (LONG64)vbox__ProcessStatus__Paused, "Paused" },
	{ (LONG64)vbox__ProcessStatus__Terminating, "Terminating" },
	{ (LONG64)vbox__ProcessStatus__TerminatedNormally, "TerminatedNormally" },
	{ (LONG64)vbox__ProcessStatus__TerminatedSignal, "TerminatedSignal" },
	{ (LONG64)vbox__ProcessStatus__TerminatedAbnormally, "TerminatedAbnormally" },
	{ (LONG64)vbox__ProcessStatus__TimedOutKilled, "TimedOutKilled" },
	{ (LONG64)vbox__ProcessStatus__TimedOutAbnormally, "TimedOutAbnormally" },
	{ (LONG64)vbox__ProcessStatus__Down, "Down" },
	{ (LONG64)vbox__ProcessStatus__Error, "Error" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ProcessStatus2s(struct soap *soap, enum vbox__ProcessStatus n)
{
	const char *s = soap_code_str(soap_codes_vbox__ProcessStatus, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ProcessStatus(struct soap *soap, const char *tag, int id, const enum vbox__ProcessStatus *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ProcessStatus), type) || soap_send(soap, soap_vbox__ProcessStatus2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ProcessStatus(struct soap *soap, const char *s, enum vbox__ProcessStatus *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ProcessStatus, s);
	if (map)
		*a = (enum vbox__ProcessStatus)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 11)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ProcessStatus)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ProcessStatus * SOAP_FMAC4 soap_in_vbox__ProcessStatus(struct soap *soap, const char *tag, enum vbox__ProcessStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ProcessStatus*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ProcessStatus, sizeof(enum vbox__ProcessStatus), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ProcessStatus(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ProcessStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ProcessStatus, SOAP_TYPE_vbox__ProcessStatus, sizeof(enum vbox__ProcessStatus), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ProcessStatus * SOAP_FMAC4 soap_new_vbox__ProcessStatus(struct soap *soap, int n)
{
	enum vbox__ProcessStatus *a = static_cast<enum vbox__ProcessStatus *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ProcessStatus)));
	for (enum vbox__ProcessStatus *p = a; p && n--; ++p)
		soap_default_vbox__ProcessStatus(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ProcessStatus(struct soap *soap, const enum vbox__ProcessStatus *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ProcessStatus(soap, tag ? tag : "vbox:ProcessStatus", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ProcessStatus * SOAP_FMAC4 soap_get_vbox__ProcessStatus(struct soap *soap, enum vbox__ProcessStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ProcessStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__SymlinkReadFlag[] =
{	{ (LONG64)vbox__SymlinkReadFlag__None, "None" },
	{ (LONG64)vbox__SymlinkReadFlag__NoSymlinks, "NoSymlinks" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__SymlinkReadFlag2s(struct soap *soap, enum vbox__SymlinkReadFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__SymlinkReadFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__SymlinkReadFlag(struct soap *soap, const char *tag, int id, const enum vbox__SymlinkReadFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__SymlinkReadFlag), type) || soap_send(soap, soap_vbox__SymlinkReadFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__SymlinkReadFlag(struct soap *soap, const char *s, enum vbox__SymlinkReadFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__SymlinkReadFlag, s);
	if (map)
		*a = (enum vbox__SymlinkReadFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__SymlinkReadFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__SymlinkReadFlag * SOAP_FMAC4 soap_in_vbox__SymlinkReadFlag(struct soap *soap, const char *tag, enum vbox__SymlinkReadFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__SymlinkReadFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__SymlinkReadFlag, sizeof(enum vbox__SymlinkReadFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__SymlinkReadFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__SymlinkReadFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__SymlinkReadFlag, SOAP_TYPE_vbox__SymlinkReadFlag, sizeof(enum vbox__SymlinkReadFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__SymlinkReadFlag * SOAP_FMAC4 soap_new_vbox__SymlinkReadFlag(struct soap *soap, int n)
{
	enum vbox__SymlinkReadFlag *a = static_cast<enum vbox__SymlinkReadFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__SymlinkReadFlag)));
	for (enum vbox__SymlinkReadFlag *p = a; p && n--; ++p)
		soap_default_vbox__SymlinkReadFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__SymlinkReadFlag(struct soap *soap, const enum vbox__SymlinkReadFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__SymlinkReadFlag(soap, tag ? tag : "vbox:SymlinkReadFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__SymlinkReadFlag * SOAP_FMAC4 soap_get_vbox__SymlinkReadFlag(struct soap *soap, enum vbox__SymlinkReadFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__SymlinkReadFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__SymlinkType[] =
{	{ (LONG64)vbox__SymlinkType__Unknown, "Unknown" },
	{ (LONG64)vbox__SymlinkType__Directory, "Directory" },
	{ (LONG64)vbox__SymlinkType__File, "File" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__SymlinkType2s(struct soap *soap, enum vbox__SymlinkType n)
{
	const char *s = soap_code_str(soap_codes_vbox__SymlinkType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__SymlinkType(struct soap *soap, const char *tag, int id, const enum vbox__SymlinkType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__SymlinkType), type) || soap_send(soap, soap_vbox__SymlinkType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__SymlinkType(struct soap *soap, const char *s, enum vbox__SymlinkType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__SymlinkType, s);
	if (map)
		*a = (enum vbox__SymlinkType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__SymlinkType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__SymlinkType * SOAP_FMAC4 soap_in_vbox__SymlinkType(struct soap *soap, const char *tag, enum vbox__SymlinkType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__SymlinkType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__SymlinkType, sizeof(enum vbox__SymlinkType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__SymlinkType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__SymlinkType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__SymlinkType, SOAP_TYPE_vbox__SymlinkType, sizeof(enum vbox__SymlinkType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__SymlinkType * SOAP_FMAC4 soap_new_vbox__SymlinkType(struct soap *soap, int n)
{
	enum vbox__SymlinkType *a = static_cast<enum vbox__SymlinkType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__SymlinkType)));
	for (enum vbox__SymlinkType *p = a; p && n--; ++p)
		soap_default_vbox__SymlinkType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__SymlinkType(struct soap *soap, const enum vbox__SymlinkType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__SymlinkType(soap, tag ? tag : "vbox:SymlinkType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__SymlinkType * SOAP_FMAC4 soap_get_vbox__SymlinkType(struct soap *soap, enum vbox__SymlinkType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__SymlinkType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ProcessPriority[] =
{	{ (LONG64)vbox__ProcessPriority__Invalid, "Invalid" },
	{ (LONG64)vbox__ProcessPriority__Default, "Default" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ProcessPriority2s(struct soap *soap, enum vbox__ProcessPriority n)
{
	const char *s = soap_code_str(soap_codes_vbox__ProcessPriority, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ProcessPriority(struct soap *soap, const char *tag, int id, const enum vbox__ProcessPriority *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ProcessPriority), type) || soap_send(soap, soap_vbox__ProcessPriority2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ProcessPriority(struct soap *soap, const char *s, enum vbox__ProcessPriority *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ProcessPriority, s);
	if (map)
		*a = (enum vbox__ProcessPriority)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ProcessPriority)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ProcessPriority * SOAP_FMAC4 soap_in_vbox__ProcessPriority(struct soap *soap, const char *tag, enum vbox__ProcessPriority *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ProcessPriority*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ProcessPriority, sizeof(enum vbox__ProcessPriority), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ProcessPriority(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ProcessPriority *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ProcessPriority, SOAP_TYPE_vbox__ProcessPriority, sizeof(enum vbox__ProcessPriority), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ProcessPriority * SOAP_FMAC4 soap_new_vbox__ProcessPriority(struct soap *soap, int n)
{
	enum vbox__ProcessPriority *a = static_cast<enum vbox__ProcessPriority *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ProcessPriority)));
	for (enum vbox__ProcessPriority *p = a; p && n--; ++p)
		soap_default_vbox__ProcessPriority(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ProcessPriority(struct soap *soap, const enum vbox__ProcessPriority *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ProcessPriority(soap, tag ? tag : "vbox:ProcessPriority", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ProcessPriority * SOAP_FMAC4 soap_get_vbox__ProcessPriority(struct soap *soap, enum vbox__ProcessPriority *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ProcessPriority(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ProcessCreateFlag[] =
{	{ (LONG64)vbox__ProcessCreateFlag__None, "None" },
	{ (LONG64)vbox__ProcessCreateFlag__WaitForProcessStartOnly, "WaitForProcessStartOnly" },
	{ (LONG64)vbox__ProcessCreateFlag__IgnoreOrphanedProcesses, "IgnoreOrphanedProcesses" },
	{ (LONG64)vbox__ProcessCreateFlag__Hidden, "Hidden" },
	{ (LONG64)vbox__ProcessCreateFlag__Profile, "Profile" },
	{ (LONG64)vbox__ProcessCreateFlag__WaitForStdOut, "WaitForStdOut" },
	{ (LONG64)vbox__ProcessCreateFlag__WaitForStdErr, "WaitForStdErr" },
	{ (LONG64)vbox__ProcessCreateFlag__ExpandArguments, "ExpandArguments" },
	{ (LONG64)vbox__ProcessCreateFlag__UnquotedArguments, "UnquotedArguments" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ProcessCreateFlag2s(struct soap *soap, enum vbox__ProcessCreateFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__ProcessCreateFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ProcessCreateFlag(struct soap *soap, const char *tag, int id, const enum vbox__ProcessCreateFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ProcessCreateFlag), type) || soap_send(soap, soap_vbox__ProcessCreateFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ProcessCreateFlag(struct soap *soap, const char *s, enum vbox__ProcessCreateFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ProcessCreateFlag, s);
	if (map)
		*a = (enum vbox__ProcessCreateFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 8)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ProcessCreateFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ProcessCreateFlag * SOAP_FMAC4 soap_in_vbox__ProcessCreateFlag(struct soap *soap, const char *tag, enum vbox__ProcessCreateFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ProcessCreateFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ProcessCreateFlag, sizeof(enum vbox__ProcessCreateFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ProcessCreateFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ProcessCreateFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ProcessCreateFlag, SOAP_TYPE_vbox__ProcessCreateFlag, sizeof(enum vbox__ProcessCreateFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ProcessCreateFlag * SOAP_FMAC4 soap_new_vbox__ProcessCreateFlag(struct soap *soap, int n)
{
	enum vbox__ProcessCreateFlag *a = static_cast<enum vbox__ProcessCreateFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ProcessCreateFlag)));
	for (enum vbox__ProcessCreateFlag *p = a; p && n--; ++p)
		soap_default_vbox__ProcessCreateFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ProcessCreateFlag(struct soap *soap, const enum vbox__ProcessCreateFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ProcessCreateFlag(soap, tag ? tag : "vbox:ProcessCreateFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ProcessCreateFlag * SOAP_FMAC4 soap_get_vbox__ProcessCreateFlag(struct soap *soap, enum vbox__ProcessCreateFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ProcessCreateFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FsObjRenameFlag[] =
{	{ (LONG64)vbox__FsObjRenameFlag__NoReplace, "NoReplace" },
	{ (LONG64)vbox__FsObjRenameFlag__Replace, "Replace" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FsObjRenameFlag2s(struct soap *soap, enum vbox__FsObjRenameFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__FsObjRenameFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FsObjRenameFlag(struct soap *soap, const char *tag, int id, const enum vbox__FsObjRenameFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FsObjRenameFlag), type) || soap_send(soap, soap_vbox__FsObjRenameFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FsObjRenameFlag(struct soap *soap, const char *s, enum vbox__FsObjRenameFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FsObjRenameFlag, s);
	if (map)
		*a = (enum vbox__FsObjRenameFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FsObjRenameFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FsObjRenameFlag * SOAP_FMAC4 soap_in_vbox__FsObjRenameFlag(struct soap *soap, const char *tag, enum vbox__FsObjRenameFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FsObjRenameFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FsObjRenameFlag, sizeof(enum vbox__FsObjRenameFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FsObjRenameFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FsObjRenameFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FsObjRenameFlag, SOAP_TYPE_vbox__FsObjRenameFlag, sizeof(enum vbox__FsObjRenameFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FsObjRenameFlag * SOAP_FMAC4 soap_new_vbox__FsObjRenameFlag(struct soap *soap, int n)
{
	enum vbox__FsObjRenameFlag *a = static_cast<enum vbox__FsObjRenameFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FsObjRenameFlag)));
	for (enum vbox__FsObjRenameFlag *p = a; p && n--; ++p)
		soap_default_vbox__FsObjRenameFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FsObjRenameFlag(struct soap *soap, const enum vbox__FsObjRenameFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FsObjRenameFlag(soap, tag ? tag : "vbox:FsObjRenameFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FsObjRenameFlag * SOAP_FMAC4 soap_get_vbox__FsObjRenameFlag(struct soap *soap, enum vbox__FsObjRenameFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FsObjRenameFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DirectoryRemoveRecFlag[] =
{	{ (LONG64)vbox__DirectoryRemoveRecFlag__None, "None" },
	{ (LONG64)vbox__DirectoryRemoveRecFlag__ContentAndDir, "ContentAndDir" },
	{ (LONG64)vbox__DirectoryRemoveRecFlag__ContentOnly, "ContentOnly" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DirectoryRemoveRecFlag2s(struct soap *soap, enum vbox__DirectoryRemoveRecFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__DirectoryRemoveRecFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DirectoryRemoveRecFlag(struct soap *soap, const char *tag, int id, const enum vbox__DirectoryRemoveRecFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DirectoryRemoveRecFlag), type) || soap_send(soap, soap_vbox__DirectoryRemoveRecFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DirectoryRemoveRecFlag(struct soap *soap, const char *s, enum vbox__DirectoryRemoveRecFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DirectoryRemoveRecFlag, s);
	if (map)
		*a = (enum vbox__DirectoryRemoveRecFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DirectoryRemoveRecFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DirectoryRemoveRecFlag * SOAP_FMAC4 soap_in_vbox__DirectoryRemoveRecFlag(struct soap *soap, const char *tag, enum vbox__DirectoryRemoveRecFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DirectoryRemoveRecFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DirectoryRemoveRecFlag, sizeof(enum vbox__DirectoryRemoveRecFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DirectoryRemoveRecFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DirectoryRemoveRecFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DirectoryRemoveRecFlag, SOAP_TYPE_vbox__DirectoryRemoveRecFlag, sizeof(enum vbox__DirectoryRemoveRecFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DirectoryRemoveRecFlag * SOAP_FMAC4 soap_new_vbox__DirectoryRemoveRecFlag(struct soap *soap, int n)
{
	enum vbox__DirectoryRemoveRecFlag *a = static_cast<enum vbox__DirectoryRemoveRecFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DirectoryRemoveRecFlag)));
	for (enum vbox__DirectoryRemoveRecFlag *p = a; p && n--; ++p)
		soap_default_vbox__DirectoryRemoveRecFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DirectoryRemoveRecFlag(struct soap *soap, const enum vbox__DirectoryRemoveRecFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DirectoryRemoveRecFlag(soap, tag ? tag : "vbox:DirectoryRemoveRecFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DirectoryRemoveRecFlag * SOAP_FMAC4 soap_get_vbox__DirectoryRemoveRecFlag(struct soap *soap, enum vbox__DirectoryRemoveRecFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DirectoryRemoveRecFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DirectoryCopyFlag[] =
{	{ (LONG64)vbox__DirectoryCopyFlag__None, "None" },
	{ (LONG64)vbox__DirectoryCopyFlag__CopyIntoExisting, "CopyIntoExisting" },
	{ (LONG64)vbox__DirectoryCopyFlag__Recursive, "Recursive" },
	{ (LONG64)vbox__DirectoryCopyFlag__FollowLinks, "FollowLinks" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DirectoryCopyFlag2s(struct soap *soap, enum vbox__DirectoryCopyFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__DirectoryCopyFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DirectoryCopyFlag(struct soap *soap, const char *tag, int id, const enum vbox__DirectoryCopyFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DirectoryCopyFlag), type) || soap_send(soap, soap_vbox__DirectoryCopyFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DirectoryCopyFlag(struct soap *soap, const char *s, enum vbox__DirectoryCopyFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DirectoryCopyFlag, s);
	if (map)
		*a = (enum vbox__DirectoryCopyFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DirectoryCopyFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DirectoryCopyFlag * SOAP_FMAC4 soap_in_vbox__DirectoryCopyFlag(struct soap *soap, const char *tag, enum vbox__DirectoryCopyFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DirectoryCopyFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DirectoryCopyFlag, sizeof(enum vbox__DirectoryCopyFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DirectoryCopyFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DirectoryCopyFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DirectoryCopyFlag, SOAP_TYPE_vbox__DirectoryCopyFlag, sizeof(enum vbox__DirectoryCopyFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DirectoryCopyFlag * SOAP_FMAC4 soap_new_vbox__DirectoryCopyFlag(struct soap *soap, int n)
{
	enum vbox__DirectoryCopyFlag *a = static_cast<enum vbox__DirectoryCopyFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DirectoryCopyFlag)));
	for (enum vbox__DirectoryCopyFlag *p = a; p && n--; ++p)
		soap_default_vbox__DirectoryCopyFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DirectoryCopyFlag(struct soap *soap, const enum vbox__DirectoryCopyFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DirectoryCopyFlag(soap, tag ? tag : "vbox:DirectoryCopyFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DirectoryCopyFlag * SOAP_FMAC4 soap_get_vbox__DirectoryCopyFlag(struct soap *soap, enum vbox__DirectoryCopyFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DirectoryCopyFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DirectoryCreateFlag[] =
{	{ (LONG64)vbox__DirectoryCreateFlag__None, "None" },
	{ (LONG64)vbox__DirectoryCreateFlag__Parents, "Parents" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DirectoryCreateFlag2s(struct soap *soap, enum vbox__DirectoryCreateFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__DirectoryCreateFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DirectoryCreateFlag(struct soap *soap, const char *tag, int id, const enum vbox__DirectoryCreateFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DirectoryCreateFlag), type) || soap_send(soap, soap_vbox__DirectoryCreateFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DirectoryCreateFlag(struct soap *soap, const char *s, enum vbox__DirectoryCreateFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DirectoryCreateFlag, s);
	if (map)
		*a = (enum vbox__DirectoryCreateFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DirectoryCreateFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DirectoryCreateFlag * SOAP_FMAC4 soap_in_vbox__DirectoryCreateFlag(struct soap *soap, const char *tag, enum vbox__DirectoryCreateFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DirectoryCreateFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DirectoryCreateFlag, sizeof(enum vbox__DirectoryCreateFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DirectoryCreateFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DirectoryCreateFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DirectoryCreateFlag, SOAP_TYPE_vbox__DirectoryCreateFlag, sizeof(enum vbox__DirectoryCreateFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DirectoryCreateFlag * SOAP_FMAC4 soap_new_vbox__DirectoryCreateFlag(struct soap *soap, int n)
{
	enum vbox__DirectoryCreateFlag *a = static_cast<enum vbox__DirectoryCreateFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DirectoryCreateFlag)));
	for (enum vbox__DirectoryCreateFlag *p = a; p && n--; ++p)
		soap_default_vbox__DirectoryCreateFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DirectoryCreateFlag(struct soap *soap, const enum vbox__DirectoryCreateFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DirectoryCreateFlag(soap, tag ? tag : "vbox:DirectoryCreateFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DirectoryCreateFlag * SOAP_FMAC4 soap_get_vbox__DirectoryCreateFlag(struct soap *soap, enum vbox__DirectoryCreateFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DirectoryCreateFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FsObjMoveFlag[] =
{	{ (LONG64)vbox__FsObjMoveFlag__None, "None" },
	{ (LONG64)vbox__FsObjMoveFlag__Replace, "Replace" },
	{ (LONG64)vbox__FsObjMoveFlag__FollowLinks, "FollowLinks" },
	{ (LONG64)vbox__FsObjMoveFlag__AllowDirectoryMoves, "AllowDirectoryMoves" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FsObjMoveFlag2s(struct soap *soap, enum vbox__FsObjMoveFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__FsObjMoveFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FsObjMoveFlag(struct soap *soap, const char *tag, int id, const enum vbox__FsObjMoveFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FsObjMoveFlag), type) || soap_send(soap, soap_vbox__FsObjMoveFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FsObjMoveFlag(struct soap *soap, const char *s, enum vbox__FsObjMoveFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FsObjMoveFlag, s);
	if (map)
		*a = (enum vbox__FsObjMoveFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FsObjMoveFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FsObjMoveFlag * SOAP_FMAC4 soap_in_vbox__FsObjMoveFlag(struct soap *soap, const char *tag, enum vbox__FsObjMoveFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FsObjMoveFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FsObjMoveFlag, sizeof(enum vbox__FsObjMoveFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FsObjMoveFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FsObjMoveFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FsObjMoveFlag, SOAP_TYPE_vbox__FsObjMoveFlag, sizeof(enum vbox__FsObjMoveFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FsObjMoveFlag * SOAP_FMAC4 soap_new_vbox__FsObjMoveFlag(struct soap *soap, int n)
{
	enum vbox__FsObjMoveFlag *a = static_cast<enum vbox__FsObjMoveFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FsObjMoveFlag)));
	for (enum vbox__FsObjMoveFlag *p = a; p && n--; ++p)
		soap_default_vbox__FsObjMoveFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FsObjMoveFlag(struct soap *soap, const enum vbox__FsObjMoveFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FsObjMoveFlag(soap, tag ? tag : "vbox:FsObjMoveFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FsObjMoveFlag * SOAP_FMAC4 soap_get_vbox__FsObjMoveFlag(struct soap *soap, enum vbox__FsObjMoveFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FsObjMoveFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FileCopyFlag[] =
{	{ (LONG64)vbox__FileCopyFlag__None, "None" },
	{ (LONG64)vbox__FileCopyFlag__NoReplace, "NoReplace" },
	{ (LONG64)vbox__FileCopyFlag__FollowLinks, "FollowLinks" },
	{ (LONG64)vbox__FileCopyFlag__Update, "Update" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FileCopyFlag2s(struct soap *soap, enum vbox__FileCopyFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__FileCopyFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FileCopyFlag(struct soap *soap, const char *tag, int id, const enum vbox__FileCopyFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FileCopyFlag), type) || soap_send(soap, soap_vbox__FileCopyFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FileCopyFlag(struct soap *soap, const char *s, enum vbox__FileCopyFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FileCopyFlag, s);
	if (map)
		*a = (enum vbox__FileCopyFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FileCopyFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FileCopyFlag * SOAP_FMAC4 soap_in_vbox__FileCopyFlag(struct soap *soap, const char *tag, enum vbox__FileCopyFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FileCopyFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FileCopyFlag, sizeof(enum vbox__FileCopyFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FileCopyFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FileCopyFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FileCopyFlag, SOAP_TYPE_vbox__FileCopyFlag, sizeof(enum vbox__FileCopyFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FileCopyFlag * SOAP_FMAC4 soap_new_vbox__FileCopyFlag(struct soap *soap, int n)
{
	enum vbox__FileCopyFlag *a = static_cast<enum vbox__FileCopyFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FileCopyFlag)));
	for (enum vbox__FileCopyFlag *p = a; p && n--; ++p)
		soap_default_vbox__FileCopyFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FileCopyFlag(struct soap *soap, const enum vbox__FileCopyFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FileCopyFlag(soap, tag ? tag : "vbox:FileCopyFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FileCopyFlag * SOAP_FMAC4 soap_get_vbox__FileCopyFlag(struct soap *soap, enum vbox__FileCopyFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FileCopyFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ProcessWaitResult[] =
{	{ (LONG64)vbox__ProcessWaitResult__None, "None" },
	{ (LONG64)vbox__ProcessWaitResult__Start, "Start" },
	{ (LONG64)vbox__ProcessWaitResult__Terminate, "Terminate" },
	{ (LONG64)vbox__ProcessWaitResult__Status, "Status" },
	{ (LONG64)vbox__ProcessWaitResult__Error, "Error" },
	{ (LONG64)vbox__ProcessWaitResult__Timeout, "Timeout" },
	{ (LONG64)vbox__ProcessWaitResult__StdIn, "StdIn" },
	{ (LONG64)vbox__ProcessWaitResult__StdOut, "StdOut" },
	{ (LONG64)vbox__ProcessWaitResult__StdErr, "StdErr" },
	{ (LONG64)vbox__ProcessWaitResult__WaitFlagNotSupported, "WaitFlagNotSupported" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ProcessWaitResult2s(struct soap *soap, enum vbox__ProcessWaitResult n)
{
	const char *s = soap_code_str(soap_codes_vbox__ProcessWaitResult, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ProcessWaitResult(struct soap *soap, const char *tag, int id, const enum vbox__ProcessWaitResult *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ProcessWaitResult), type) || soap_send(soap, soap_vbox__ProcessWaitResult2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ProcessWaitResult(struct soap *soap, const char *s, enum vbox__ProcessWaitResult *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ProcessWaitResult, s);
	if (map)
		*a = (enum vbox__ProcessWaitResult)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 9)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ProcessWaitResult)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ProcessWaitResult * SOAP_FMAC4 soap_in_vbox__ProcessWaitResult(struct soap *soap, const char *tag, enum vbox__ProcessWaitResult *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ProcessWaitResult*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ProcessWaitResult, sizeof(enum vbox__ProcessWaitResult), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ProcessWaitResult(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ProcessWaitResult *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ProcessWaitResult, SOAP_TYPE_vbox__ProcessWaitResult, sizeof(enum vbox__ProcessWaitResult), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ProcessWaitResult * SOAP_FMAC4 soap_new_vbox__ProcessWaitResult(struct soap *soap, int n)
{
	enum vbox__ProcessWaitResult *a = static_cast<enum vbox__ProcessWaitResult *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ProcessWaitResult)));
	for (enum vbox__ProcessWaitResult *p = a; p && n--; ++p)
		soap_default_vbox__ProcessWaitResult(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ProcessWaitResult(struct soap *soap, const enum vbox__ProcessWaitResult *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ProcessWaitResult(soap, tag ? tag : "vbox:ProcessWaitResult", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ProcessWaitResult * SOAP_FMAC4 soap_get_vbox__ProcessWaitResult(struct soap *soap, enum vbox__ProcessWaitResult *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ProcessWaitResult(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ProcessWaitForFlag[] =
{	{ (LONG64)vbox__ProcessWaitForFlag__None, "None" },
	{ (LONG64)vbox__ProcessWaitForFlag__Start, "Start" },
	{ (LONG64)vbox__ProcessWaitForFlag__Terminate, "Terminate" },
	{ (LONG64)vbox__ProcessWaitForFlag__StdIn, "StdIn" },
	{ (LONG64)vbox__ProcessWaitForFlag__StdOut, "StdOut" },
	{ (LONG64)vbox__ProcessWaitForFlag__StdErr, "StdErr" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ProcessWaitForFlag2s(struct soap *soap, enum vbox__ProcessWaitForFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__ProcessWaitForFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ProcessWaitForFlag(struct soap *soap, const char *tag, int id, const enum vbox__ProcessWaitForFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ProcessWaitForFlag), type) || soap_send(soap, soap_vbox__ProcessWaitForFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ProcessWaitForFlag(struct soap *soap, const char *s, enum vbox__ProcessWaitForFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ProcessWaitForFlag, s);
	if (map)
		*a = (enum vbox__ProcessWaitForFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 5)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ProcessWaitForFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ProcessWaitForFlag * SOAP_FMAC4 soap_in_vbox__ProcessWaitForFlag(struct soap *soap, const char *tag, enum vbox__ProcessWaitForFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ProcessWaitForFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ProcessWaitForFlag, sizeof(enum vbox__ProcessWaitForFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ProcessWaitForFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ProcessWaitForFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ProcessWaitForFlag, SOAP_TYPE_vbox__ProcessWaitForFlag, sizeof(enum vbox__ProcessWaitForFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ProcessWaitForFlag * SOAP_FMAC4 soap_new_vbox__ProcessWaitForFlag(struct soap *soap, int n)
{
	enum vbox__ProcessWaitForFlag *a = static_cast<enum vbox__ProcessWaitForFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ProcessWaitForFlag)));
	for (enum vbox__ProcessWaitForFlag *p = a; p && n--; ++p)
		soap_default_vbox__ProcessWaitForFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ProcessWaitForFlag(struct soap *soap, const enum vbox__ProcessWaitForFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ProcessWaitForFlag(soap, tag ? tag : "vbox:ProcessWaitForFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ProcessWaitForFlag * SOAP_FMAC4 soap_get_vbox__ProcessWaitForFlag(struct soap *soap, enum vbox__ProcessWaitForFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ProcessWaitForFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ProcessOutputFlag[] =
{	{ (LONG64)vbox__ProcessOutputFlag__None, "None" },
	{ (LONG64)vbox__ProcessOutputFlag__StdErr, "StdErr" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ProcessOutputFlag2s(struct soap *soap, enum vbox__ProcessOutputFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__ProcessOutputFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ProcessOutputFlag(struct soap *soap, const char *tag, int id, const enum vbox__ProcessOutputFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ProcessOutputFlag), type) || soap_send(soap, soap_vbox__ProcessOutputFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ProcessOutputFlag(struct soap *soap, const char *s, enum vbox__ProcessOutputFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ProcessOutputFlag, s);
	if (map)
		*a = (enum vbox__ProcessOutputFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ProcessOutputFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ProcessOutputFlag * SOAP_FMAC4 soap_in_vbox__ProcessOutputFlag(struct soap *soap, const char *tag, enum vbox__ProcessOutputFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ProcessOutputFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ProcessOutputFlag, sizeof(enum vbox__ProcessOutputFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ProcessOutputFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ProcessOutputFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ProcessOutputFlag, SOAP_TYPE_vbox__ProcessOutputFlag, sizeof(enum vbox__ProcessOutputFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ProcessOutputFlag * SOAP_FMAC4 soap_new_vbox__ProcessOutputFlag(struct soap *soap, int n)
{
	enum vbox__ProcessOutputFlag *a = static_cast<enum vbox__ProcessOutputFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ProcessOutputFlag)));
	for (enum vbox__ProcessOutputFlag *p = a; p && n--; ++p)
		soap_default_vbox__ProcessOutputFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ProcessOutputFlag(struct soap *soap, const enum vbox__ProcessOutputFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ProcessOutputFlag(soap, tag ? tag : "vbox:ProcessOutputFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ProcessOutputFlag * SOAP_FMAC4 soap_get_vbox__ProcessOutputFlag(struct soap *soap, enum vbox__ProcessOutputFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ProcessOutputFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ProcessInputFlag[] =
{	{ (LONG64)vbox__ProcessInputFlag__None, "None" },
	{ (LONG64)vbox__ProcessInputFlag__EndOfFile, "EndOfFile" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ProcessInputFlag2s(struct soap *soap, enum vbox__ProcessInputFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__ProcessInputFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ProcessInputFlag(struct soap *soap, const char *tag, int id, const enum vbox__ProcessInputFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ProcessInputFlag), type) || soap_send(soap, soap_vbox__ProcessInputFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ProcessInputFlag(struct soap *soap, const char *s, enum vbox__ProcessInputFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ProcessInputFlag, s);
	if (map)
		*a = (enum vbox__ProcessInputFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ProcessInputFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ProcessInputFlag * SOAP_FMAC4 soap_in_vbox__ProcessInputFlag(struct soap *soap, const char *tag, enum vbox__ProcessInputFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ProcessInputFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ProcessInputFlag, sizeof(enum vbox__ProcessInputFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ProcessInputFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ProcessInputFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ProcessInputFlag, SOAP_TYPE_vbox__ProcessInputFlag, sizeof(enum vbox__ProcessInputFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ProcessInputFlag * SOAP_FMAC4 soap_new_vbox__ProcessInputFlag(struct soap *soap, int n)
{
	enum vbox__ProcessInputFlag *a = static_cast<enum vbox__ProcessInputFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ProcessInputFlag)));
	for (enum vbox__ProcessInputFlag *p = a; p && n--; ++p)
		soap_default_vbox__ProcessInputFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ProcessInputFlag(struct soap *soap, const enum vbox__ProcessInputFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ProcessInputFlag(soap, tag ? tag : "vbox:ProcessInputFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ProcessInputFlag * SOAP_FMAC4 soap_get_vbox__ProcessInputFlag(struct soap *soap, enum vbox__ProcessInputFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ProcessInputFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FileSeekOrigin[] =
{	{ (LONG64)vbox__FileSeekOrigin__Begin, "Begin" },
	{ (LONG64)vbox__FileSeekOrigin__Current, "Current" },
	{ (LONG64)vbox__FileSeekOrigin__End, "End" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FileSeekOrigin2s(struct soap *soap, enum vbox__FileSeekOrigin n)
{
	const char *s = soap_code_str(soap_codes_vbox__FileSeekOrigin, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FileSeekOrigin(struct soap *soap, const char *tag, int id, const enum vbox__FileSeekOrigin *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FileSeekOrigin), type) || soap_send(soap, soap_vbox__FileSeekOrigin2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FileSeekOrigin(struct soap *soap, const char *s, enum vbox__FileSeekOrigin *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FileSeekOrigin, s);
	if (map)
		*a = (enum vbox__FileSeekOrigin)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FileSeekOrigin)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FileSeekOrigin * SOAP_FMAC4 soap_in_vbox__FileSeekOrigin(struct soap *soap, const char *tag, enum vbox__FileSeekOrigin *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FileSeekOrigin*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FileSeekOrigin, sizeof(enum vbox__FileSeekOrigin), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FileSeekOrigin(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FileSeekOrigin *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FileSeekOrigin, SOAP_TYPE_vbox__FileSeekOrigin, sizeof(enum vbox__FileSeekOrigin), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FileSeekOrigin * SOAP_FMAC4 soap_new_vbox__FileSeekOrigin(struct soap *soap, int n)
{
	enum vbox__FileSeekOrigin *a = static_cast<enum vbox__FileSeekOrigin *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FileSeekOrigin)));
	for (enum vbox__FileSeekOrigin *p = a; p && n--; ++p)
		soap_default_vbox__FileSeekOrigin(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FileSeekOrigin(struct soap *soap, const enum vbox__FileSeekOrigin *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FileSeekOrigin(soap, tag ? tag : "vbox:FileSeekOrigin", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FileSeekOrigin * SOAP_FMAC4 soap_get_vbox__FileSeekOrigin(struct soap *soap, enum vbox__FileSeekOrigin *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FileSeekOrigin(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__GuestUserState[] =
{	{ (LONG64)vbox__GuestUserState__Unknown, "Unknown" },
	{ (LONG64)vbox__GuestUserState__LoggedIn, "LoggedIn" },
	{ (LONG64)vbox__GuestUserState__LoggedOut, "LoggedOut" },
	{ (LONG64)vbox__GuestUserState__Locked, "Locked" },
	{ (LONG64)vbox__GuestUserState__Unlocked, "Unlocked" },
	{ (LONG64)vbox__GuestUserState__Disabled, "Disabled" },
	{ (LONG64)vbox__GuestUserState__Idle, "Idle" },
	{ (LONG64)vbox__GuestUserState__InUse, "InUse" },
	{ (LONG64)vbox__GuestUserState__Created, "Created" },
	{ (LONG64)vbox__GuestUserState__Deleted, "Deleted" },
	{ (LONG64)vbox__GuestUserState__SessionChanged, "SessionChanged" },
	{ (LONG64)vbox__GuestUserState__CredentialsChanged, "CredentialsChanged" },
	{ (LONG64)vbox__GuestUserState__RoleChanged, "RoleChanged" },
	{ (LONG64)vbox__GuestUserState__GroupAdded, "GroupAdded" },
	{ (LONG64)vbox__GuestUserState__GroupRemoved, "GroupRemoved" },
	{ (LONG64)vbox__GuestUserState__Elevated, "Elevated" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__GuestUserState2s(struct soap *soap, enum vbox__GuestUserState n)
{
	const char *s = soap_code_str(soap_codes_vbox__GuestUserState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__GuestUserState(struct soap *soap, const char *tag, int id, const enum vbox__GuestUserState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__GuestUserState), type) || soap_send(soap, soap_vbox__GuestUserState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__GuestUserState(struct soap *soap, const char *s, enum vbox__GuestUserState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__GuestUserState, s);
	if (map)
		*a = (enum vbox__GuestUserState)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 15)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__GuestUserState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__GuestUserState * SOAP_FMAC4 soap_in_vbox__GuestUserState(struct soap *soap, const char *tag, enum vbox__GuestUserState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__GuestUserState*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__GuestUserState, sizeof(enum vbox__GuestUserState), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__GuestUserState(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__GuestUserState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__GuestUserState, SOAP_TYPE_vbox__GuestUserState, sizeof(enum vbox__GuestUserState), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__GuestUserState * SOAP_FMAC4 soap_new_vbox__GuestUserState(struct soap *soap, int n)
{
	enum vbox__GuestUserState *a = static_cast<enum vbox__GuestUserState *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__GuestUserState)));
	for (enum vbox__GuestUserState *p = a; p && n--; ++p)
		soap_default_vbox__GuestUserState(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__GuestUserState(struct soap *soap, const enum vbox__GuestUserState *a, const char *tag, const char *type)
{
	if (soap_out_vbox__GuestUserState(soap, tag ? tag : "vbox:GuestUserState", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__GuestUserState * SOAP_FMAC4 soap_get_vbox__GuestUserState(struct soap *soap, enum vbox__GuestUserState *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__GuestUserState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__GuestSessionWaitResult[] =
{	{ (LONG64)vbox__GuestSessionWaitResult__None, "None" },
	{ (LONG64)vbox__GuestSessionWaitResult__Start, "Start" },
	{ (LONG64)vbox__GuestSessionWaitResult__Terminate, "Terminate" },
	{ (LONG64)vbox__GuestSessionWaitResult__Status, "Status" },
	{ (LONG64)vbox__GuestSessionWaitResult__Error, "Error" },
	{ (LONG64)vbox__GuestSessionWaitResult__Timeout, "Timeout" },
	{ (LONG64)vbox__GuestSessionWaitResult__WaitFlagNotSupported, "WaitFlagNotSupported" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__GuestSessionWaitResult2s(struct soap *soap, enum vbox__GuestSessionWaitResult n)
{
	const char *s = soap_code_str(soap_codes_vbox__GuestSessionWaitResult, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__GuestSessionWaitResult(struct soap *soap, const char *tag, int id, const enum vbox__GuestSessionWaitResult *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__GuestSessionWaitResult), type) || soap_send(soap, soap_vbox__GuestSessionWaitResult2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__GuestSessionWaitResult(struct soap *soap, const char *s, enum vbox__GuestSessionWaitResult *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__GuestSessionWaitResult, s);
	if (map)
		*a = (enum vbox__GuestSessionWaitResult)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 6)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__GuestSessionWaitResult)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__GuestSessionWaitResult * SOAP_FMAC4 soap_in_vbox__GuestSessionWaitResult(struct soap *soap, const char *tag, enum vbox__GuestSessionWaitResult *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__GuestSessionWaitResult*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__GuestSessionWaitResult, sizeof(enum vbox__GuestSessionWaitResult), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__GuestSessionWaitResult(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__GuestSessionWaitResult *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__GuestSessionWaitResult, SOAP_TYPE_vbox__GuestSessionWaitResult, sizeof(enum vbox__GuestSessionWaitResult), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__GuestSessionWaitResult * SOAP_FMAC4 soap_new_vbox__GuestSessionWaitResult(struct soap *soap, int n)
{
	enum vbox__GuestSessionWaitResult *a = static_cast<enum vbox__GuestSessionWaitResult *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__GuestSessionWaitResult)));
	for (enum vbox__GuestSessionWaitResult *p = a; p && n--; ++p)
		soap_default_vbox__GuestSessionWaitResult(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__GuestSessionWaitResult(struct soap *soap, const enum vbox__GuestSessionWaitResult *a, const char *tag, const char *type)
{
	if (soap_out_vbox__GuestSessionWaitResult(soap, tag ? tag : "vbox:GuestSessionWaitResult", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__GuestSessionWaitResult * SOAP_FMAC4 soap_get_vbox__GuestSessionWaitResult(struct soap *soap, enum vbox__GuestSessionWaitResult *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__GuestSessionWaitResult(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__GuestSessionWaitForFlag[] =
{	{ (LONG64)vbox__GuestSessionWaitForFlag__None, "None" },
	{ (LONG64)vbox__GuestSessionWaitForFlag__Start, "Start" },
	{ (LONG64)vbox__GuestSessionWaitForFlag__Terminate, "Terminate" },
	{ (LONG64)vbox__GuestSessionWaitForFlag__Status, "Status" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__GuestSessionWaitForFlag2s(struct soap *soap, enum vbox__GuestSessionWaitForFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__GuestSessionWaitForFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__GuestSessionWaitForFlag(struct soap *soap, const char *tag, int id, const enum vbox__GuestSessionWaitForFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__GuestSessionWaitForFlag), type) || soap_send(soap, soap_vbox__GuestSessionWaitForFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__GuestSessionWaitForFlag(struct soap *soap, const char *s, enum vbox__GuestSessionWaitForFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__GuestSessionWaitForFlag, s);
	if (map)
		*a = (enum vbox__GuestSessionWaitForFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__GuestSessionWaitForFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__GuestSessionWaitForFlag * SOAP_FMAC4 soap_in_vbox__GuestSessionWaitForFlag(struct soap *soap, const char *tag, enum vbox__GuestSessionWaitForFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__GuestSessionWaitForFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__GuestSessionWaitForFlag, sizeof(enum vbox__GuestSessionWaitForFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__GuestSessionWaitForFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__GuestSessionWaitForFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__GuestSessionWaitForFlag, SOAP_TYPE_vbox__GuestSessionWaitForFlag, sizeof(enum vbox__GuestSessionWaitForFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__GuestSessionWaitForFlag * SOAP_FMAC4 soap_new_vbox__GuestSessionWaitForFlag(struct soap *soap, int n)
{
	enum vbox__GuestSessionWaitForFlag *a = static_cast<enum vbox__GuestSessionWaitForFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__GuestSessionWaitForFlag)));
	for (enum vbox__GuestSessionWaitForFlag *p = a; p && n--; ++p)
		soap_default_vbox__GuestSessionWaitForFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__GuestSessionWaitForFlag(struct soap *soap, const enum vbox__GuestSessionWaitForFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__GuestSessionWaitForFlag(soap, tag ? tag : "vbox:GuestSessionWaitForFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__GuestSessionWaitForFlag * SOAP_FMAC4 soap_get_vbox__GuestSessionWaitForFlag(struct soap *soap, enum vbox__GuestSessionWaitForFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__GuestSessionWaitForFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__GuestSessionStatus[] =
{	{ (LONG64)vbox__GuestSessionStatus__Undefined, "Undefined" },
	{ (LONG64)vbox__GuestSessionStatus__Starting, "Starting" },
	{ (LONG64)vbox__GuestSessionStatus__Started, "Started" },
	{ (LONG64)vbox__GuestSessionStatus__Terminating, "Terminating" },
	{ (LONG64)vbox__GuestSessionStatus__Terminated, "Terminated" },
	{ (LONG64)vbox__GuestSessionStatus__TimedOutKilled, "TimedOutKilled" },
	{ (LONG64)vbox__GuestSessionStatus__TimedOutAbnormally, "TimedOutAbnormally" },
	{ (LONG64)vbox__GuestSessionStatus__Down, "Down" },
	{ (LONG64)vbox__GuestSessionStatus__Error, "Error" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__GuestSessionStatus2s(struct soap *soap, enum vbox__GuestSessionStatus n)
{
	const char *s = soap_code_str(soap_codes_vbox__GuestSessionStatus, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__GuestSessionStatus(struct soap *soap, const char *tag, int id, const enum vbox__GuestSessionStatus *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__GuestSessionStatus), type) || soap_send(soap, soap_vbox__GuestSessionStatus2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__GuestSessionStatus(struct soap *soap, const char *s, enum vbox__GuestSessionStatus *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__GuestSessionStatus, s);
	if (map)
		*a = (enum vbox__GuestSessionStatus)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 8)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__GuestSessionStatus)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__GuestSessionStatus * SOAP_FMAC4 soap_in_vbox__GuestSessionStatus(struct soap *soap, const char *tag, enum vbox__GuestSessionStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__GuestSessionStatus*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__GuestSessionStatus, sizeof(enum vbox__GuestSessionStatus), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__GuestSessionStatus(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__GuestSessionStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__GuestSessionStatus, SOAP_TYPE_vbox__GuestSessionStatus, sizeof(enum vbox__GuestSessionStatus), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__GuestSessionStatus * SOAP_FMAC4 soap_new_vbox__GuestSessionStatus(struct soap *soap, int n)
{
	enum vbox__GuestSessionStatus *a = static_cast<enum vbox__GuestSessionStatus *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__GuestSessionStatus)));
	for (enum vbox__GuestSessionStatus *p = a; p && n--; ++p)
		soap_default_vbox__GuestSessionStatus(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__GuestSessionStatus(struct soap *soap, const enum vbox__GuestSessionStatus *a, const char *tag, const char *type)
{
	if (soap_out_vbox__GuestSessionStatus(soap, tag ? tag : "vbox:GuestSessionStatus", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__GuestSessionStatus * SOAP_FMAC4 soap_get_vbox__GuestSessionStatus(struct soap *soap, enum vbox__GuestSessionStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__GuestSessionStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__GuestShutdownFlag[] =
{	{ (LONG64)vbox__GuestShutdownFlag__None, "None" },
	{ (LONG64)vbox__GuestShutdownFlag__PowerOff, "PowerOff" },
	{ (LONG64)vbox__GuestShutdownFlag__Reboot, "Reboot" },
	{ (LONG64)vbox__GuestShutdownFlag__Force, "Force" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__GuestShutdownFlag2s(struct soap *soap, enum vbox__GuestShutdownFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__GuestShutdownFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__GuestShutdownFlag(struct soap *soap, const char *tag, int id, const enum vbox__GuestShutdownFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__GuestShutdownFlag), type) || soap_send(soap, soap_vbox__GuestShutdownFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__GuestShutdownFlag(struct soap *soap, const char *s, enum vbox__GuestShutdownFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__GuestShutdownFlag, s);
	if (map)
		*a = (enum vbox__GuestShutdownFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__GuestShutdownFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__GuestShutdownFlag * SOAP_FMAC4 soap_in_vbox__GuestShutdownFlag(struct soap *soap, const char *tag, enum vbox__GuestShutdownFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__GuestShutdownFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__GuestShutdownFlag, sizeof(enum vbox__GuestShutdownFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__GuestShutdownFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__GuestShutdownFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__GuestShutdownFlag, SOAP_TYPE_vbox__GuestShutdownFlag, sizeof(enum vbox__GuestShutdownFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__GuestShutdownFlag * SOAP_FMAC4 soap_new_vbox__GuestShutdownFlag(struct soap *soap, int n)
{
	enum vbox__GuestShutdownFlag *a = static_cast<enum vbox__GuestShutdownFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__GuestShutdownFlag)));
	for (enum vbox__GuestShutdownFlag *p = a; p && n--; ++p)
		soap_default_vbox__GuestShutdownFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__GuestShutdownFlag(struct soap *soap, const enum vbox__GuestShutdownFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__GuestShutdownFlag(soap, tag ? tag : "vbox:GuestShutdownFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__GuestShutdownFlag * SOAP_FMAC4 soap_get_vbox__GuestShutdownFlag(struct soap *soap, enum vbox__GuestShutdownFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__GuestShutdownFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AdditionsUpdateFlag[] =
{	{ (LONG64)vbox__AdditionsUpdateFlag__None, "None" },
	{ (LONG64)vbox__AdditionsUpdateFlag__WaitForUpdateStartOnly, "WaitForUpdateStartOnly" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AdditionsUpdateFlag2s(struct soap *soap, enum vbox__AdditionsUpdateFlag n)
{
	const char *s = soap_code_str(soap_codes_vbox__AdditionsUpdateFlag, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AdditionsUpdateFlag(struct soap *soap, const char *tag, int id, const enum vbox__AdditionsUpdateFlag *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AdditionsUpdateFlag), type) || soap_send(soap, soap_vbox__AdditionsUpdateFlag2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AdditionsUpdateFlag(struct soap *soap, const char *s, enum vbox__AdditionsUpdateFlag *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AdditionsUpdateFlag, s);
	if (map)
		*a = (enum vbox__AdditionsUpdateFlag)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AdditionsUpdateFlag)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AdditionsUpdateFlag * SOAP_FMAC4 soap_in_vbox__AdditionsUpdateFlag(struct soap *soap, const char *tag, enum vbox__AdditionsUpdateFlag *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AdditionsUpdateFlag*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AdditionsUpdateFlag, sizeof(enum vbox__AdditionsUpdateFlag), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AdditionsUpdateFlag(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AdditionsUpdateFlag *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AdditionsUpdateFlag, SOAP_TYPE_vbox__AdditionsUpdateFlag, sizeof(enum vbox__AdditionsUpdateFlag), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AdditionsUpdateFlag * SOAP_FMAC4 soap_new_vbox__AdditionsUpdateFlag(struct soap *soap, int n)
{
	enum vbox__AdditionsUpdateFlag *a = static_cast<enum vbox__AdditionsUpdateFlag *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AdditionsUpdateFlag)));
	for (enum vbox__AdditionsUpdateFlag *p = a; p && n--; ++p)
		soap_default_vbox__AdditionsUpdateFlag(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AdditionsUpdateFlag(struct soap *soap, const enum vbox__AdditionsUpdateFlag *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AdditionsUpdateFlag(soap, tag ? tag : "vbox:AdditionsUpdateFlag", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AdditionsUpdateFlag * SOAP_FMAC4 soap_get_vbox__AdditionsUpdateFlag(struct soap *soap, enum vbox__AdditionsUpdateFlag *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AdditionsUpdateFlag(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AdditionsRunLevelType[] =
{	{ (LONG64)vbox__AdditionsRunLevelType__None, "None" },
	{ (LONG64)vbox__AdditionsRunLevelType__System, "System" },
	{ (LONG64)vbox__AdditionsRunLevelType__Userland, "Userland" },
	{ (LONG64)vbox__AdditionsRunLevelType__Desktop, "Desktop" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AdditionsRunLevelType2s(struct soap *soap, enum vbox__AdditionsRunLevelType n)
{
	const char *s = soap_code_str(soap_codes_vbox__AdditionsRunLevelType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AdditionsRunLevelType(struct soap *soap, const char *tag, int id, const enum vbox__AdditionsRunLevelType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AdditionsRunLevelType), type) || soap_send(soap, soap_vbox__AdditionsRunLevelType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AdditionsRunLevelType(struct soap *soap, const char *s, enum vbox__AdditionsRunLevelType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AdditionsRunLevelType, s);
	if (map)
		*a = (enum vbox__AdditionsRunLevelType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AdditionsRunLevelType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AdditionsRunLevelType * SOAP_FMAC4 soap_in_vbox__AdditionsRunLevelType(struct soap *soap, const char *tag, enum vbox__AdditionsRunLevelType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AdditionsRunLevelType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AdditionsRunLevelType, sizeof(enum vbox__AdditionsRunLevelType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AdditionsRunLevelType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AdditionsRunLevelType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AdditionsRunLevelType, SOAP_TYPE_vbox__AdditionsRunLevelType, sizeof(enum vbox__AdditionsRunLevelType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AdditionsRunLevelType * SOAP_FMAC4 soap_new_vbox__AdditionsRunLevelType(struct soap *soap, int n)
{
	enum vbox__AdditionsRunLevelType *a = static_cast<enum vbox__AdditionsRunLevelType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AdditionsRunLevelType)));
	for (enum vbox__AdditionsRunLevelType *p = a; p && n--; ++p)
		soap_default_vbox__AdditionsRunLevelType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AdditionsRunLevelType(struct soap *soap, const enum vbox__AdditionsRunLevelType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AdditionsRunLevelType(soap, tag ? tag : "vbox:AdditionsRunLevelType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AdditionsRunLevelType * SOAP_FMAC4 soap_get_vbox__AdditionsRunLevelType(struct soap *soap, enum vbox__AdditionsRunLevelType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AdditionsRunLevelType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AdditionsFacilityStatus[] =
{	{ (LONG64)vbox__AdditionsFacilityStatus__Inactive, "Inactive" },
	{ (LONG64)vbox__AdditionsFacilityStatus__Paused, "Paused" },
	{ (LONG64)vbox__AdditionsFacilityStatus__PreInit, "PreInit" },
	{ (LONG64)vbox__AdditionsFacilityStatus__Init, "Init" },
	{ (LONG64)vbox__AdditionsFacilityStatus__Active, "Active" },
	{ (LONG64)vbox__AdditionsFacilityStatus__Terminating, "Terminating" },
	{ (LONG64)vbox__AdditionsFacilityStatus__Terminated, "Terminated" },
	{ (LONG64)vbox__AdditionsFacilityStatus__Failed, "Failed" },
	{ (LONG64)vbox__AdditionsFacilityStatus__Unknown, "Unknown" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AdditionsFacilityStatus2s(struct soap *soap, enum vbox__AdditionsFacilityStatus n)
{
	const char *s = soap_code_str(soap_codes_vbox__AdditionsFacilityStatus, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AdditionsFacilityStatus(struct soap *soap, const char *tag, int id, const enum vbox__AdditionsFacilityStatus *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AdditionsFacilityStatus), type) || soap_send(soap, soap_vbox__AdditionsFacilityStatus2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AdditionsFacilityStatus(struct soap *soap, const char *s, enum vbox__AdditionsFacilityStatus *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AdditionsFacilityStatus, s);
	if (map)
		*a = (enum vbox__AdditionsFacilityStatus)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 8)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AdditionsFacilityStatus)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AdditionsFacilityStatus * SOAP_FMAC4 soap_in_vbox__AdditionsFacilityStatus(struct soap *soap, const char *tag, enum vbox__AdditionsFacilityStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AdditionsFacilityStatus*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AdditionsFacilityStatus, sizeof(enum vbox__AdditionsFacilityStatus), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AdditionsFacilityStatus(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AdditionsFacilityStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AdditionsFacilityStatus, SOAP_TYPE_vbox__AdditionsFacilityStatus, sizeof(enum vbox__AdditionsFacilityStatus), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AdditionsFacilityStatus * SOAP_FMAC4 soap_new_vbox__AdditionsFacilityStatus(struct soap *soap, int n)
{
	enum vbox__AdditionsFacilityStatus *a = static_cast<enum vbox__AdditionsFacilityStatus *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AdditionsFacilityStatus)));
	for (enum vbox__AdditionsFacilityStatus *p = a; p && n--; ++p)
		soap_default_vbox__AdditionsFacilityStatus(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AdditionsFacilityStatus(struct soap *soap, const enum vbox__AdditionsFacilityStatus *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AdditionsFacilityStatus(soap, tag ? tag : "vbox:AdditionsFacilityStatus", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AdditionsFacilityStatus * SOAP_FMAC4 soap_get_vbox__AdditionsFacilityStatus(struct soap *soap, enum vbox__AdditionsFacilityStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AdditionsFacilityStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AdditionsFacilityClass[] =
{	{ (LONG64)vbox__AdditionsFacilityClass__None, "None" },
	{ (LONG64)vbox__AdditionsFacilityClass__Driver, "Driver" },
	{ (LONG64)vbox__AdditionsFacilityClass__Service, "Service" },
	{ (LONG64)vbox__AdditionsFacilityClass__Program, "Program" },
	{ (LONG64)vbox__AdditionsFacilityClass__Feature, "Feature" },
	{ (LONG64)vbox__AdditionsFacilityClass__ThirdParty, "ThirdParty" },
	{ (LONG64)vbox__AdditionsFacilityClass__All, "All" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AdditionsFacilityClass2s(struct soap *soap, enum vbox__AdditionsFacilityClass n)
{
	const char *s = soap_code_str(soap_codes_vbox__AdditionsFacilityClass, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AdditionsFacilityClass(struct soap *soap, const char *tag, int id, const enum vbox__AdditionsFacilityClass *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AdditionsFacilityClass), type) || soap_send(soap, soap_vbox__AdditionsFacilityClass2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AdditionsFacilityClass(struct soap *soap, const char *s, enum vbox__AdditionsFacilityClass *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AdditionsFacilityClass, s);
	if (map)
		*a = (enum vbox__AdditionsFacilityClass)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 6)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AdditionsFacilityClass)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AdditionsFacilityClass * SOAP_FMAC4 soap_in_vbox__AdditionsFacilityClass(struct soap *soap, const char *tag, enum vbox__AdditionsFacilityClass *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AdditionsFacilityClass*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AdditionsFacilityClass, sizeof(enum vbox__AdditionsFacilityClass), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AdditionsFacilityClass(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AdditionsFacilityClass *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AdditionsFacilityClass, SOAP_TYPE_vbox__AdditionsFacilityClass, sizeof(enum vbox__AdditionsFacilityClass), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AdditionsFacilityClass * SOAP_FMAC4 soap_new_vbox__AdditionsFacilityClass(struct soap *soap, int n)
{
	enum vbox__AdditionsFacilityClass *a = static_cast<enum vbox__AdditionsFacilityClass *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AdditionsFacilityClass)));
	for (enum vbox__AdditionsFacilityClass *p = a; p && n--; ++p)
		soap_default_vbox__AdditionsFacilityClass(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AdditionsFacilityClass(struct soap *soap, const enum vbox__AdditionsFacilityClass *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AdditionsFacilityClass(soap, tag ? tag : "vbox:AdditionsFacilityClass", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AdditionsFacilityClass * SOAP_FMAC4 soap_get_vbox__AdditionsFacilityClass(struct soap *soap, enum vbox__AdditionsFacilityClass *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AdditionsFacilityClass(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AdditionsFacilityType[] =
{	{ (LONG64)vbox__AdditionsFacilityType__None, "None" },
	{ (LONG64)vbox__AdditionsFacilityType__VBoxGuestDriver, "VBoxGuestDriver" },
	{ (LONG64)vbox__AdditionsFacilityType__AutoLogon, "AutoLogon" },
	{ (LONG64)vbox__AdditionsFacilityType__VBoxService, "VBoxService" },
	{ (LONG64)vbox__AdditionsFacilityType__VBoxTrayClient, "VBoxTrayClient" },
	{ (LONG64)vbox__AdditionsFacilityType__Seamless, "Seamless" },
	{ (LONG64)vbox__AdditionsFacilityType__Graphics, "Graphics" },
	{ (LONG64)vbox__AdditionsFacilityType__MonitorAttach, "MonitorAttach" },
	{ (LONG64)vbox__AdditionsFacilityType__All, "All" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AdditionsFacilityType2s(struct soap *soap, enum vbox__AdditionsFacilityType n)
{
	const char *s = soap_code_str(soap_codes_vbox__AdditionsFacilityType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AdditionsFacilityType(struct soap *soap, const char *tag, int id, const enum vbox__AdditionsFacilityType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AdditionsFacilityType), type) || soap_send(soap, soap_vbox__AdditionsFacilityType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AdditionsFacilityType(struct soap *soap, const char *s, enum vbox__AdditionsFacilityType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AdditionsFacilityType, s);
	if (map)
		*a = (enum vbox__AdditionsFacilityType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 8)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AdditionsFacilityType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AdditionsFacilityType * SOAP_FMAC4 soap_in_vbox__AdditionsFacilityType(struct soap *soap, const char *tag, enum vbox__AdditionsFacilityType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AdditionsFacilityType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AdditionsFacilityType, sizeof(enum vbox__AdditionsFacilityType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AdditionsFacilityType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AdditionsFacilityType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AdditionsFacilityType, SOAP_TYPE_vbox__AdditionsFacilityType, sizeof(enum vbox__AdditionsFacilityType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AdditionsFacilityType * SOAP_FMAC4 soap_new_vbox__AdditionsFacilityType(struct soap *soap, int n)
{
	enum vbox__AdditionsFacilityType *a = static_cast<enum vbox__AdditionsFacilityType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AdditionsFacilityType)));
	for (enum vbox__AdditionsFacilityType *p = a; p && n--; ++p)
		soap_default_vbox__AdditionsFacilityType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AdditionsFacilityType(struct soap *soap, const enum vbox__AdditionsFacilityType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AdditionsFacilityType(soap, tag ? tag : "vbox:AdditionsFacilityType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AdditionsFacilityType * SOAP_FMAC4 soap_get_vbox__AdditionsFacilityType(struct soap *soap, enum vbox__AdditionsFacilityType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AdditionsFacilityType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ProxyMode[] =
{	{ (LONG64)vbox__ProxyMode__System, "System" },
	{ (LONG64)vbox__ProxyMode__NoProxy, "NoProxy" },
	{ (LONG64)vbox__ProxyMode__Manual, "Manual" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ProxyMode2s(struct soap *soap, enum vbox__ProxyMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__ProxyMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ProxyMode(struct soap *soap, const char *tag, int id, const enum vbox__ProxyMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ProxyMode), type) || soap_send(soap, soap_vbox__ProxyMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ProxyMode(struct soap *soap, const char *s, enum vbox__ProxyMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ProxyMode, s);
	if (map)
		*a = (enum vbox__ProxyMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ProxyMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ProxyMode * SOAP_FMAC4 soap_in_vbox__ProxyMode(struct soap *soap, const char *tag, enum vbox__ProxyMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ProxyMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ProxyMode, sizeof(enum vbox__ProxyMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ProxyMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ProxyMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ProxyMode, SOAP_TYPE_vbox__ProxyMode, sizeof(enum vbox__ProxyMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ProxyMode * SOAP_FMAC4 soap_new_vbox__ProxyMode(struct soap *soap, int n)
{
	enum vbox__ProxyMode *a = static_cast<enum vbox__ProxyMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ProxyMode)));
	for (enum vbox__ProxyMode *p = a; p && n--; ++p)
		soap_default_vbox__ProxyMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ProxyMode(struct soap *soap, const enum vbox__ProxyMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ProxyMode(soap, tag ? tag : "vbox:ProxyMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ProxyMode * SOAP_FMAC4 soap_get_vbox__ProxyMode(struct soap *soap, enum vbox__ProxyMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ProxyMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__UpdateState[] =
{	{ (LONG64)vbox__UpdateState__Invalid, "Invalid" },
	{ (LONG64)vbox__UpdateState__Available, "Available" },
	{ (LONG64)vbox__UpdateState__NotAvailable, "NotAvailable" },
	{ (LONG64)vbox__UpdateState__Downloading, "Downloading" },
	{ (LONG64)vbox__UpdateState__Downloaded, "Downloaded" },
	{ (LONG64)vbox__UpdateState__Installing, "Installing" },
	{ (LONG64)vbox__UpdateState__Installed, "Installed" },
	{ (LONG64)vbox__UpdateState__UserInteraction, "UserInteraction" },
	{ (LONG64)vbox__UpdateState__Canceled, "Canceled" },
	{ (LONG64)vbox__UpdateState__Maintenance, "Maintenance" },
	{ (LONG64)vbox__UpdateState__Error, "Error" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__UpdateState2s(struct soap *soap, enum vbox__UpdateState n)
{
	const char *s = soap_code_str(soap_codes_vbox__UpdateState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__UpdateState(struct soap *soap, const char *tag, int id, const enum vbox__UpdateState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__UpdateState), type) || soap_send(soap, soap_vbox__UpdateState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__UpdateState(struct soap *soap, const char *s, enum vbox__UpdateState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__UpdateState, s);
	if (map)
		*a = (enum vbox__UpdateState)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 10)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__UpdateState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__UpdateState * SOAP_FMAC4 soap_in_vbox__UpdateState(struct soap *soap, const char *tag, enum vbox__UpdateState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__UpdateState*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__UpdateState, sizeof(enum vbox__UpdateState), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__UpdateState(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__UpdateState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__UpdateState, SOAP_TYPE_vbox__UpdateState, sizeof(enum vbox__UpdateState), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__UpdateState * SOAP_FMAC4 soap_new_vbox__UpdateState(struct soap *soap, int n)
{
	enum vbox__UpdateState *a = static_cast<enum vbox__UpdateState *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__UpdateState)));
	for (enum vbox__UpdateState *p = a; p && n--; ++p)
		soap_default_vbox__UpdateState(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__UpdateState(struct soap *soap, const enum vbox__UpdateState *a, const char *tag, const char *type)
{
	if (soap_out_vbox__UpdateState(soap, tag ? tag : "vbox:UpdateState", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__UpdateState * SOAP_FMAC4 soap_get_vbox__UpdateState(struct soap *soap, enum vbox__UpdateState *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__UpdateState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__UpdateSeverity[] =
{	{ (LONG64)vbox__UpdateSeverity__Invalid, "Invalid" },
	{ (LONG64)vbox__UpdateSeverity__Critical, "Critical" },
	{ (LONG64)vbox__UpdateSeverity__Major, "Major" },
	{ (LONG64)vbox__UpdateSeverity__Minor, "Minor" },
	{ (LONG64)vbox__UpdateSeverity__Testing, "Testing" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__UpdateSeverity2s(struct soap *soap, enum vbox__UpdateSeverity n)
{
	const char *s = soap_code_str(soap_codes_vbox__UpdateSeverity, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__UpdateSeverity(struct soap *soap, const char *tag, int id, const enum vbox__UpdateSeverity *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__UpdateSeverity), type) || soap_send(soap, soap_vbox__UpdateSeverity2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__UpdateSeverity(struct soap *soap, const char *s, enum vbox__UpdateSeverity *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__UpdateSeverity, s);
	if (map)
		*a = (enum vbox__UpdateSeverity)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__UpdateSeverity)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__UpdateSeverity * SOAP_FMAC4 soap_in_vbox__UpdateSeverity(struct soap *soap, const char *tag, enum vbox__UpdateSeverity *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__UpdateSeverity*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__UpdateSeverity, sizeof(enum vbox__UpdateSeverity), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__UpdateSeverity(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__UpdateSeverity *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__UpdateSeverity, SOAP_TYPE_vbox__UpdateSeverity, sizeof(enum vbox__UpdateSeverity), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__UpdateSeverity * SOAP_FMAC4 soap_new_vbox__UpdateSeverity(struct soap *soap, int n)
{
	enum vbox__UpdateSeverity *a = static_cast<enum vbox__UpdateSeverity *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__UpdateSeverity)));
	for (enum vbox__UpdateSeverity *p = a; p && n--; ++p)
		soap_default_vbox__UpdateSeverity(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__UpdateSeverity(struct soap *soap, const enum vbox__UpdateSeverity *a, const char *tag, const char *type)
{
	if (soap_out_vbox__UpdateSeverity(soap, tag ? tag : "vbox:UpdateSeverity", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__UpdateSeverity * SOAP_FMAC4 soap_get_vbox__UpdateSeverity(struct soap *soap, enum vbox__UpdateSeverity *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__UpdateSeverity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__UpdateChannel[] =
{	{ (LONG64)vbox__UpdateChannel__Invalid, "Invalid" },
	{ (LONG64)vbox__UpdateChannel__Stable, "Stable" },
	{ (LONG64)vbox__UpdateChannel__All, "All" },
	{ (LONG64)vbox__UpdateChannel__WithBetas, "WithBetas" },
	{ (LONG64)vbox__UpdateChannel__WithTesting, "WithTesting" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__UpdateChannel2s(struct soap *soap, enum vbox__UpdateChannel n)
{
	const char *s = soap_code_str(soap_codes_vbox__UpdateChannel, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__UpdateChannel(struct soap *soap, const char *tag, int id, const enum vbox__UpdateChannel *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__UpdateChannel), type) || soap_send(soap, soap_vbox__UpdateChannel2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__UpdateChannel(struct soap *soap, const char *s, enum vbox__UpdateChannel *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__UpdateChannel, s);
	if (map)
		*a = (enum vbox__UpdateChannel)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__UpdateChannel)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__UpdateChannel * SOAP_FMAC4 soap_in_vbox__UpdateChannel(struct soap *soap, const char *tag, enum vbox__UpdateChannel *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__UpdateChannel*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__UpdateChannel, sizeof(enum vbox__UpdateChannel), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__UpdateChannel(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__UpdateChannel *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__UpdateChannel, SOAP_TYPE_vbox__UpdateChannel, sizeof(enum vbox__UpdateChannel), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__UpdateChannel * SOAP_FMAC4 soap_new_vbox__UpdateChannel(struct soap *soap, int n)
{
	enum vbox__UpdateChannel *a = static_cast<enum vbox__UpdateChannel *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__UpdateChannel)));
	for (enum vbox__UpdateChannel *p = a; p && n--; ++p)
		soap_default_vbox__UpdateChannel(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__UpdateChannel(struct soap *soap, const enum vbox__UpdateChannel *a, const char *tag, const char *type)
{
	if (soap_out_vbox__UpdateChannel(soap, tag ? tag : "vbox:UpdateChannel", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__UpdateChannel * SOAP_FMAC4 soap_get_vbox__UpdateChannel(struct soap *soap, enum vbox__UpdateChannel *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__UpdateChannel(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__HostNetworkInterfaceType[] =
{	{ (LONG64)vbox__HostNetworkInterfaceType__Invalid, "Invalid" },
	{ (LONG64)vbox__HostNetworkInterfaceType__Bridged, "Bridged" },
	{ (LONG64)vbox__HostNetworkInterfaceType__HostOnly, "HostOnly" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__HostNetworkInterfaceType2s(struct soap *soap, enum vbox__HostNetworkInterfaceType n)
{
	const char *s = soap_code_str(soap_codes_vbox__HostNetworkInterfaceType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__HostNetworkInterfaceType(struct soap *soap, const char *tag, int id, const enum vbox__HostNetworkInterfaceType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__HostNetworkInterfaceType), type) || soap_send(soap, soap_vbox__HostNetworkInterfaceType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__HostNetworkInterfaceType(struct soap *soap, const char *s, enum vbox__HostNetworkInterfaceType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__HostNetworkInterfaceType, s);
	if (map)
		*a = (enum vbox__HostNetworkInterfaceType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__HostNetworkInterfaceType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__HostNetworkInterfaceType * SOAP_FMAC4 soap_in_vbox__HostNetworkInterfaceType(struct soap *soap, const char *tag, enum vbox__HostNetworkInterfaceType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__HostNetworkInterfaceType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__HostNetworkInterfaceType, sizeof(enum vbox__HostNetworkInterfaceType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__HostNetworkInterfaceType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__HostNetworkInterfaceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__HostNetworkInterfaceType, SOAP_TYPE_vbox__HostNetworkInterfaceType, sizeof(enum vbox__HostNetworkInterfaceType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__HostNetworkInterfaceType * SOAP_FMAC4 soap_new_vbox__HostNetworkInterfaceType(struct soap *soap, int n)
{
	enum vbox__HostNetworkInterfaceType *a = static_cast<enum vbox__HostNetworkInterfaceType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__HostNetworkInterfaceType)));
	for (enum vbox__HostNetworkInterfaceType *p = a; p && n--; ++p)
		soap_default_vbox__HostNetworkInterfaceType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__HostNetworkInterfaceType(struct soap *soap, const enum vbox__HostNetworkInterfaceType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__HostNetworkInterfaceType(soap, tag ? tag : "vbox:HostNetworkInterfaceType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__HostNetworkInterfaceType * SOAP_FMAC4 soap_get_vbox__HostNetworkInterfaceType(struct soap *soap, enum vbox__HostNetworkInterfaceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__HostNetworkInterfaceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__HostNetworkInterfaceStatus[] =
{	{ (LONG64)vbox__HostNetworkInterfaceStatus__Unknown, "Unknown" },
	{ (LONG64)vbox__HostNetworkInterfaceStatus__Up, "Up" },
	{ (LONG64)vbox__HostNetworkInterfaceStatus__Down, "Down" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__HostNetworkInterfaceStatus2s(struct soap *soap, enum vbox__HostNetworkInterfaceStatus n)
{
	const char *s = soap_code_str(soap_codes_vbox__HostNetworkInterfaceStatus, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__HostNetworkInterfaceStatus(struct soap *soap, const char *tag, int id, const enum vbox__HostNetworkInterfaceStatus *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__HostNetworkInterfaceStatus), type) || soap_send(soap, soap_vbox__HostNetworkInterfaceStatus2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__HostNetworkInterfaceStatus(struct soap *soap, const char *s, enum vbox__HostNetworkInterfaceStatus *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__HostNetworkInterfaceStatus, s);
	if (map)
		*a = (enum vbox__HostNetworkInterfaceStatus)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__HostNetworkInterfaceStatus)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__HostNetworkInterfaceStatus * SOAP_FMAC4 soap_in_vbox__HostNetworkInterfaceStatus(struct soap *soap, const char *tag, enum vbox__HostNetworkInterfaceStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__HostNetworkInterfaceStatus*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__HostNetworkInterfaceStatus, sizeof(enum vbox__HostNetworkInterfaceStatus), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__HostNetworkInterfaceStatus(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__HostNetworkInterfaceStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__HostNetworkInterfaceStatus, SOAP_TYPE_vbox__HostNetworkInterfaceStatus, sizeof(enum vbox__HostNetworkInterfaceStatus), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__HostNetworkInterfaceStatus * SOAP_FMAC4 soap_new_vbox__HostNetworkInterfaceStatus(struct soap *soap, int n)
{
	enum vbox__HostNetworkInterfaceStatus *a = static_cast<enum vbox__HostNetworkInterfaceStatus *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__HostNetworkInterfaceStatus)));
	for (enum vbox__HostNetworkInterfaceStatus *p = a; p && n--; ++p)
		soap_default_vbox__HostNetworkInterfaceStatus(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__HostNetworkInterfaceStatus(struct soap *soap, const enum vbox__HostNetworkInterfaceStatus *a, const char *tag, const char *type)
{
	if (soap_out_vbox__HostNetworkInterfaceStatus(soap, tag ? tag : "vbox:HostNetworkInterfaceStatus", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__HostNetworkInterfaceStatus * SOAP_FMAC4 soap_get_vbox__HostNetworkInterfaceStatus(struct soap *soap, enum vbox__HostNetworkInterfaceStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__HostNetworkInterfaceStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__HostNetworkInterfaceMediumType[] =
{	{ (LONG64)vbox__HostNetworkInterfaceMediumType__Unknown, "Unknown" },
	{ (LONG64)vbox__HostNetworkInterfaceMediumType__Ethernet, "Ethernet" },
	{ (LONG64)vbox__HostNetworkInterfaceMediumType__PPP, "PPP" },
	{ (LONG64)vbox__HostNetworkInterfaceMediumType__SLIP, "SLIP" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__HostNetworkInterfaceMediumType2s(struct soap *soap, enum vbox__HostNetworkInterfaceMediumType n)
{
	const char *s = soap_code_str(soap_codes_vbox__HostNetworkInterfaceMediumType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__HostNetworkInterfaceMediumType(struct soap *soap, const char *tag, int id, const enum vbox__HostNetworkInterfaceMediumType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__HostNetworkInterfaceMediumType), type) || soap_send(soap, soap_vbox__HostNetworkInterfaceMediumType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__HostNetworkInterfaceMediumType(struct soap *soap, const char *s, enum vbox__HostNetworkInterfaceMediumType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__HostNetworkInterfaceMediumType, s);
	if (map)
		*a = (enum vbox__HostNetworkInterfaceMediumType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__HostNetworkInterfaceMediumType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__HostNetworkInterfaceMediumType * SOAP_FMAC4 soap_in_vbox__HostNetworkInterfaceMediumType(struct soap *soap, const char *tag, enum vbox__HostNetworkInterfaceMediumType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__HostNetworkInterfaceMediumType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__HostNetworkInterfaceMediumType, sizeof(enum vbox__HostNetworkInterfaceMediumType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__HostNetworkInterfaceMediumType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__HostNetworkInterfaceMediumType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__HostNetworkInterfaceMediumType, SOAP_TYPE_vbox__HostNetworkInterfaceMediumType, sizeof(enum vbox__HostNetworkInterfaceMediumType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__HostNetworkInterfaceMediumType * SOAP_FMAC4 soap_new_vbox__HostNetworkInterfaceMediumType(struct soap *soap, int n)
{
	enum vbox__HostNetworkInterfaceMediumType *a = static_cast<enum vbox__HostNetworkInterfaceMediumType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__HostNetworkInterfaceMediumType)));
	for (enum vbox__HostNetworkInterfaceMediumType *p = a; p && n--; ++p)
		soap_default_vbox__HostNetworkInterfaceMediumType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__HostNetworkInterfaceMediumType(struct soap *soap, const enum vbox__HostNetworkInterfaceMediumType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__HostNetworkInterfaceMediumType(soap, tag ? tag : "vbox:HostNetworkInterfaceMediumType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__HostNetworkInterfaceMediumType * SOAP_FMAC4 soap_get_vbox__HostNetworkInterfaceMediumType(struct soap *soap, enum vbox__HostNetworkInterfaceMediumType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__HostNetworkInterfaceMediumType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__VMExecutionEngine[] =
{	{ (LONG64)vbox__VMExecutionEngine__NotSet, "NotSet" },
	{ (LONG64)vbox__VMExecutionEngine__Default, "Default" },
	{ (LONG64)vbox__VMExecutionEngine__HwVirt, "HwVirt" },
	{ (LONG64)vbox__VMExecutionEngine__NativeApi, "NativeApi" },
	{ (LONG64)vbox__VMExecutionEngine__Interpreter, "Interpreter" },
	{ (LONG64)vbox__VMExecutionEngine__Recompiler, "Recompiler" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__VMExecutionEngine2s(struct soap *soap, enum vbox__VMExecutionEngine n)
{
	const char *s = soap_code_str(soap_codes_vbox__VMExecutionEngine, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__VMExecutionEngine(struct soap *soap, const char *tag, int id, const enum vbox__VMExecutionEngine *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__VMExecutionEngine), type) || soap_send(soap, soap_vbox__VMExecutionEngine2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__VMExecutionEngine(struct soap *soap, const char *s, enum vbox__VMExecutionEngine *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__VMExecutionEngine, s);
	if (map)
		*a = (enum vbox__VMExecutionEngine)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 5)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__VMExecutionEngine)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__VMExecutionEngine * SOAP_FMAC4 soap_in_vbox__VMExecutionEngine(struct soap *soap, const char *tag, enum vbox__VMExecutionEngine *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__VMExecutionEngine*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__VMExecutionEngine, sizeof(enum vbox__VMExecutionEngine), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__VMExecutionEngine(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__VMExecutionEngine *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__VMExecutionEngine, SOAP_TYPE_vbox__VMExecutionEngine, sizeof(enum vbox__VMExecutionEngine), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__VMExecutionEngine * SOAP_FMAC4 soap_new_vbox__VMExecutionEngine(struct soap *soap, int n)
{
	enum vbox__VMExecutionEngine *a = static_cast<enum vbox__VMExecutionEngine *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__VMExecutionEngine)));
	for (enum vbox__VMExecutionEngine *p = a; p && n--; ++p)
		soap_default_vbox__VMExecutionEngine(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__VMExecutionEngine(struct soap *soap, const enum vbox__VMExecutionEngine *a, const char *tag, const char *type)
{
	if (soap_out_vbox__VMExecutionEngine(soap, tag ? tag : "vbox:VMExecutionEngine", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__VMExecutionEngine * SOAP_FMAC4 soap_get_vbox__VMExecutionEngine(struct soap *soap, enum vbox__VMExecutionEngine *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__VMExecutionEngine(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__IommuType[] =
{	{ (LONG64)vbox__IommuType__None, "None" },
	{ (LONG64)vbox__IommuType__Automatic, "Automatic" },
	{ (LONG64)vbox__IommuType__AMD, "AMD" },
	{ (LONG64)vbox__IommuType__Intel, "Intel" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__IommuType2s(struct soap *soap, enum vbox__IommuType n)
{
	const char *s = soap_code_str(soap_codes_vbox__IommuType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__IommuType(struct soap *soap, const char *tag, int id, const enum vbox__IommuType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__IommuType), type) || soap_send(soap, soap_vbox__IommuType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__IommuType(struct soap *soap, const char *s, enum vbox__IommuType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__IommuType, s);
	if (map)
		*a = (enum vbox__IommuType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__IommuType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__IommuType * SOAP_FMAC4 soap_in_vbox__IommuType(struct soap *soap, const char *tag, enum vbox__IommuType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__IommuType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__IommuType, sizeof(enum vbox__IommuType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__IommuType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__IommuType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__IommuType, SOAP_TYPE_vbox__IommuType, sizeof(enum vbox__IommuType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__IommuType * SOAP_FMAC4 soap_new_vbox__IommuType(struct soap *soap, int n)
{
	enum vbox__IommuType *a = static_cast<enum vbox__IommuType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__IommuType)));
	for (enum vbox__IommuType *p = a; p && n--; ++p)
		soap_default_vbox__IommuType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__IommuType(struct soap *soap, const enum vbox__IommuType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__IommuType(soap, tag ? tag : "vbox:IommuType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__IommuType * SOAP_FMAC4 soap_get_vbox__IommuType(struct soap *soap, enum vbox__IommuType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__IommuType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__VMProcPriority[] =
{	{ (LONG64)vbox__VMProcPriority__Invalid, "Invalid" },
	{ (LONG64)vbox__VMProcPriority__Default, "Default" },
	{ (LONG64)vbox__VMProcPriority__Flat, "Flat" },
	{ (LONG64)vbox__VMProcPriority__Low, "Low" },
	{ (LONG64)vbox__VMProcPriority__Normal, "Normal" },
	{ (LONG64)vbox__VMProcPriority__High, "High" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__VMProcPriority2s(struct soap *soap, enum vbox__VMProcPriority n)
{
	const char *s = soap_code_str(soap_codes_vbox__VMProcPriority, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__VMProcPriority(struct soap *soap, const char *tag, int id, const enum vbox__VMProcPriority *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__VMProcPriority), type) || soap_send(soap, soap_vbox__VMProcPriority2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__VMProcPriority(struct soap *soap, const char *s, enum vbox__VMProcPriority *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__VMProcPriority, s);
	if (map)
		*a = (enum vbox__VMProcPriority)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 5)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__VMProcPriority)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__VMProcPriority * SOAP_FMAC4 soap_in_vbox__VMProcPriority(struct soap *soap, const char *tag, enum vbox__VMProcPriority *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__VMProcPriority*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__VMProcPriority, sizeof(enum vbox__VMProcPriority), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__VMProcPriority(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__VMProcPriority *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__VMProcPriority, SOAP_TYPE_vbox__VMProcPriority, sizeof(enum vbox__VMProcPriority), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__VMProcPriority * SOAP_FMAC4 soap_new_vbox__VMProcPriority(struct soap *soap, int n)
{
	enum vbox__VMProcPriority *a = static_cast<enum vbox__VMProcPriority *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__VMProcPriority)));
	for (enum vbox__VMProcPriority *p = a; p && n--; ++p)
		soap_default_vbox__VMProcPriority(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__VMProcPriority(struct soap *soap, const enum vbox__VMProcPriority *a, const char *tag, const char *type)
{
	if (soap_out_vbox__VMProcPriority(soap, tag ? tag : "vbox:VMProcPriority", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__VMProcPriority * SOAP_FMAC4 soap_get_vbox__VMProcPriority(struct soap *soap, enum vbox__VMProcPriority *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__VMProcPriority(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AutostopType[] =
{	{ (LONG64)vbox__AutostopType__Disabled, "Disabled" },
	{ (LONG64)vbox__AutostopType__SaveState, "SaveState" },
	{ (LONG64)vbox__AutostopType__PowerOff, "PowerOff" },
	{ (LONG64)vbox__AutostopType__AcpiShutdown, "AcpiShutdown" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AutostopType2s(struct soap *soap, enum vbox__AutostopType n)
{
	const char *s = soap_code_str(soap_codes_vbox__AutostopType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AutostopType(struct soap *soap, const char *tag, int id, const enum vbox__AutostopType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AutostopType), type) || soap_send(soap, soap_vbox__AutostopType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AutostopType(struct soap *soap, const char *s, enum vbox__AutostopType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AutostopType, s);
	if (map)
		*a = (enum vbox__AutostopType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AutostopType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AutostopType * SOAP_FMAC4 soap_in_vbox__AutostopType(struct soap *soap, const char *tag, enum vbox__AutostopType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AutostopType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AutostopType, sizeof(enum vbox__AutostopType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AutostopType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AutostopType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AutostopType, SOAP_TYPE_vbox__AutostopType, sizeof(enum vbox__AutostopType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AutostopType * SOAP_FMAC4 soap_new_vbox__AutostopType(struct soap *soap, int n)
{
	enum vbox__AutostopType *a = static_cast<enum vbox__AutostopType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AutostopType)));
	for (enum vbox__AutostopType *p = a; p && n--; ++p)
		soap_default_vbox__AutostopType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AutostopType(struct soap *soap, const enum vbox__AutostopType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AutostopType(soap, tag ? tag : "vbox:AutostopType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AutostopType * SOAP_FMAC4 soap_get_vbox__AutostopType(struct soap *soap, enum vbox__AutostopType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AutostopType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__CloneOptions[] =
{	{ (LONG64)vbox__CloneOptions__Link, "Link" },
	{ (LONG64)vbox__CloneOptions__KeepAllMACs, "KeepAllMACs" },
	{ (LONG64)vbox__CloneOptions__KeepNATMACs, "KeepNATMACs" },
	{ (LONG64)vbox__CloneOptions__KeepDiskNames, "KeepDiskNames" },
	{ (LONG64)vbox__CloneOptions__KeepHwUUIDs, "KeepHwUUIDs" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__CloneOptions2s(struct soap *soap, enum vbox__CloneOptions n)
{
	const char *s = soap_code_str(soap_codes_vbox__CloneOptions, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__CloneOptions(struct soap *soap, const char *tag, int id, const enum vbox__CloneOptions *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__CloneOptions), type) || soap_send(soap, soap_vbox__CloneOptions2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__CloneOptions(struct soap *soap, const char *s, enum vbox__CloneOptions *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__CloneOptions, s);
	if (map)
		*a = (enum vbox__CloneOptions)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__CloneOptions)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__CloneOptions * SOAP_FMAC4 soap_in_vbox__CloneOptions(struct soap *soap, const char *tag, enum vbox__CloneOptions *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__CloneOptions*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__CloneOptions, sizeof(enum vbox__CloneOptions), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__CloneOptions(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__CloneOptions *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__CloneOptions, SOAP_TYPE_vbox__CloneOptions, sizeof(enum vbox__CloneOptions), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__CloneOptions * SOAP_FMAC4 soap_new_vbox__CloneOptions(struct soap *soap, int n)
{
	enum vbox__CloneOptions *a = static_cast<enum vbox__CloneOptions *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__CloneOptions)));
	for (enum vbox__CloneOptions *p = a; p && n--; ++p)
		soap_default_vbox__CloneOptions(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__CloneOptions(struct soap *soap, const enum vbox__CloneOptions *a, const char *tag, const char *type)
{
	if (soap_out_vbox__CloneOptions(soap, tag ? tag : "vbox:CloneOptions", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__CloneOptions * SOAP_FMAC4 soap_get_vbox__CloneOptions(struct soap *soap, enum vbox__CloneOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__CloneOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__CloneMode[] =
{	{ (LONG64)vbox__CloneMode__MachineState, "MachineState" },
	{ (LONG64)vbox__CloneMode__MachineAndChildStates, "MachineAndChildStates" },
	{ (LONG64)vbox__CloneMode__AllStates, "AllStates" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__CloneMode2s(struct soap *soap, enum vbox__CloneMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__CloneMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__CloneMode(struct soap *soap, const char *tag, int id, const enum vbox__CloneMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__CloneMode), type) || soap_send(soap, soap_vbox__CloneMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__CloneMode(struct soap *soap, const char *s, enum vbox__CloneMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__CloneMode, s);
	if (map)
		*a = (enum vbox__CloneMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__CloneMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__CloneMode * SOAP_FMAC4 soap_in_vbox__CloneMode(struct soap *soap, const char *tag, enum vbox__CloneMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__CloneMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__CloneMode, sizeof(enum vbox__CloneMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__CloneMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__CloneMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__CloneMode, SOAP_TYPE_vbox__CloneMode, sizeof(enum vbox__CloneMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__CloneMode * SOAP_FMAC4 soap_new_vbox__CloneMode(struct soap *soap, int n)
{
	enum vbox__CloneMode *a = static_cast<enum vbox__CloneMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__CloneMode)));
	for (enum vbox__CloneMode *p = a; p && n--; ++p)
		soap_default_vbox__CloneMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__CloneMode(struct soap *soap, const enum vbox__CloneMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__CloneMode(soap, tag ? tag : "vbox:CloneMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__CloneMode * SOAP_FMAC4 soap_get_vbox__CloneMode(struct soap *soap, enum vbox__CloneMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__CloneMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__CleanupMode[] =
{	{ (LONG64)vbox__CleanupMode__UnregisterOnly, "UnregisterOnly" },
	{ (LONG64)vbox__CleanupMode__DetachAllReturnNone, "DetachAllReturnNone" },
	{ (LONG64)vbox__CleanupMode__DetachAllReturnHardDisksOnly, "DetachAllReturnHardDisksOnly" },
	{ (LONG64)vbox__CleanupMode__Full, "Full" },
	{ (LONG64)vbox__CleanupMode__DetachAllReturnHardDisksAndVMRemovable, "DetachAllReturnHardDisksAndVMRemovable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__CleanupMode2s(struct soap *soap, enum vbox__CleanupMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__CleanupMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__CleanupMode(struct soap *soap, const char *tag, int id, const enum vbox__CleanupMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__CleanupMode), type) || soap_send(soap, soap_vbox__CleanupMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__CleanupMode(struct soap *soap, const char *s, enum vbox__CleanupMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__CleanupMode, s);
	if (map)
		*a = (enum vbox__CleanupMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__CleanupMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__CleanupMode * SOAP_FMAC4 soap_in_vbox__CleanupMode(struct soap *soap, const char *tag, enum vbox__CleanupMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__CleanupMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__CleanupMode, sizeof(enum vbox__CleanupMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__CleanupMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__CleanupMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__CleanupMode, SOAP_TYPE_vbox__CleanupMode, sizeof(enum vbox__CleanupMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__CleanupMode * SOAP_FMAC4 soap_new_vbox__CleanupMode(struct soap *soap, int n)
{
	enum vbox__CleanupMode *a = static_cast<enum vbox__CleanupMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__CleanupMode)));
	for (enum vbox__CleanupMode *p = a; p && n--; ++p)
		soap_default_vbox__CleanupMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__CleanupMode(struct soap *soap, const enum vbox__CleanupMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__CleanupMode(soap, tag ? tag : "vbox:CleanupMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__CleanupMode * SOAP_FMAC4 soap_get_vbox__CleanupMode(struct soap *soap, enum vbox__CleanupMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__CleanupMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__GraphicsFeature[] =
{	{ (LONG64)vbox__GraphicsFeature__None, "None" },
	{ (LONG64)vbox__GraphicsFeature__Acceleration3D, "Acceleration3D" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__GraphicsFeature2s(struct soap *soap, enum vbox__GraphicsFeature n)
{
	const char *s = soap_code_str(soap_codes_vbox__GraphicsFeature, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__GraphicsFeature(struct soap *soap, const char *tag, int id, const enum vbox__GraphicsFeature *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__GraphicsFeature), type) || soap_send(soap, soap_vbox__GraphicsFeature2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__GraphicsFeature(struct soap *soap, const char *s, enum vbox__GraphicsFeature *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__GraphicsFeature, s);
	if (map)
		*a = (enum vbox__GraphicsFeature)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__GraphicsFeature)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__GraphicsFeature * SOAP_FMAC4 soap_in_vbox__GraphicsFeature(struct soap *soap, const char *tag, enum vbox__GraphicsFeature *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__GraphicsFeature*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__GraphicsFeature, sizeof(enum vbox__GraphicsFeature), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__GraphicsFeature(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__GraphicsFeature *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__GraphicsFeature, SOAP_TYPE_vbox__GraphicsFeature, sizeof(enum vbox__GraphicsFeature), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__GraphicsFeature * SOAP_FMAC4 soap_new_vbox__GraphicsFeature(struct soap *soap, int n)
{
	enum vbox__GraphicsFeature *a = static_cast<enum vbox__GraphicsFeature *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__GraphicsFeature)));
	for (enum vbox__GraphicsFeature *p = a; p && n--; ++p)
		soap_default_vbox__GraphicsFeature(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__GraphicsFeature(struct soap *soap, const enum vbox__GraphicsFeature *a, const char *tag, const char *type)
{
	if (soap_out_vbox__GraphicsFeature(soap, tag ? tag : "vbox:GraphicsFeature", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__GraphicsFeature * SOAP_FMAC4 soap_get_vbox__GraphicsFeature(struct soap *soap, enum vbox__GraphicsFeature *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__GraphicsFeature(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__GraphicsControllerType[] =
{	{ (LONG64)vbox__GraphicsControllerType__Null, "Null" },
	{ (LONG64)vbox__GraphicsControllerType__VBoxVGA, "VBoxVGA" },
	{ (LONG64)vbox__GraphicsControllerType__VMSVGA, "VMSVGA" },
	{ (LONG64)vbox__GraphicsControllerType__VBoxSVGA, "VBoxSVGA" },
	{ (LONG64)vbox__GraphicsControllerType__QemuRamFB, "QemuRamFB" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__GraphicsControllerType2s(struct soap *soap, enum vbox__GraphicsControllerType n)
{
	const char *s = soap_code_str(soap_codes_vbox__GraphicsControllerType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__GraphicsControllerType(struct soap *soap, const char *tag, int id, const enum vbox__GraphicsControllerType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__GraphicsControllerType), type) || soap_send(soap, soap_vbox__GraphicsControllerType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__GraphicsControllerType(struct soap *soap, const char *s, enum vbox__GraphicsControllerType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__GraphicsControllerType, s);
	if (map)
		*a = (enum vbox__GraphicsControllerType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__GraphicsControllerType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__GraphicsControllerType * SOAP_FMAC4 soap_in_vbox__GraphicsControllerType(struct soap *soap, const char *tag, enum vbox__GraphicsControllerType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__GraphicsControllerType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__GraphicsControllerType, sizeof(enum vbox__GraphicsControllerType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__GraphicsControllerType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__GraphicsControllerType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__GraphicsControllerType, SOAP_TYPE_vbox__GraphicsControllerType, sizeof(enum vbox__GraphicsControllerType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__GraphicsControllerType * SOAP_FMAC4 soap_new_vbox__GraphicsControllerType(struct soap *soap, int n)
{
	enum vbox__GraphicsControllerType *a = static_cast<enum vbox__GraphicsControllerType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__GraphicsControllerType)));
	for (enum vbox__GraphicsControllerType *p = a; p && n--; ++p)
		soap_default_vbox__GraphicsControllerType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__GraphicsControllerType(struct soap *soap, const enum vbox__GraphicsControllerType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__GraphicsControllerType(soap, tag ? tag : "vbox:GraphicsControllerType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__GraphicsControllerType * SOAP_FMAC4 soap_get_vbox__GraphicsControllerType(struct soap *soap, enum vbox__GraphicsControllerType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__GraphicsControllerType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__UefiVariableAttributes[] =
{	{ (LONG64)vbox__UefiVariableAttributes__None, "None" },
	{ (LONG64)vbox__UefiVariableAttributes__NonVolatile, "NonVolatile" },
	{ (LONG64)vbox__UefiVariableAttributes__BootServiceAccess, "BootServiceAccess" },
	{ (LONG64)vbox__UefiVariableAttributes__RuntimeAccess, "RuntimeAccess" },
	{ (LONG64)vbox__UefiVariableAttributes__HwErrorRecord, "HwErrorRecord" },
	{ (LONG64)vbox__UefiVariableAttributes__AuthWriteAccess, "AuthWriteAccess" },
	{ (LONG64)vbox__UefiVariableAttributes__AuthTimeBasedWriteAccess, "AuthTimeBasedWriteAccess" },
	{ (LONG64)vbox__UefiVariableAttributes__AuthAppendWrite, "AuthAppendWrite" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__UefiVariableAttributes2s(struct soap *soap, enum vbox__UefiVariableAttributes n)
{
	const char *s = soap_code_str(soap_codes_vbox__UefiVariableAttributes, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__UefiVariableAttributes(struct soap *soap, const char *tag, int id, const enum vbox__UefiVariableAttributes *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__UefiVariableAttributes), type) || soap_send(soap, soap_vbox__UefiVariableAttributes2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__UefiVariableAttributes(struct soap *soap, const char *s, enum vbox__UefiVariableAttributes *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__UefiVariableAttributes, s);
	if (map)
		*a = (enum vbox__UefiVariableAttributes)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 7)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__UefiVariableAttributes)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__UefiVariableAttributes * SOAP_FMAC4 soap_in_vbox__UefiVariableAttributes(struct soap *soap, const char *tag, enum vbox__UefiVariableAttributes *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__UefiVariableAttributes*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__UefiVariableAttributes, sizeof(enum vbox__UefiVariableAttributes), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__UefiVariableAttributes(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__UefiVariableAttributes *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__UefiVariableAttributes, SOAP_TYPE_vbox__UefiVariableAttributes, sizeof(enum vbox__UefiVariableAttributes), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__UefiVariableAttributes * SOAP_FMAC4 soap_new_vbox__UefiVariableAttributes(struct soap *soap, int n)
{
	enum vbox__UefiVariableAttributes *a = static_cast<enum vbox__UefiVariableAttributes *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__UefiVariableAttributes)));
	for (enum vbox__UefiVariableAttributes *p = a; p && n--; ++p)
		soap_default_vbox__UefiVariableAttributes(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__UefiVariableAttributes(struct soap *soap, const enum vbox__UefiVariableAttributes *a, const char *tag, const char *type)
{
	if (soap_out_vbox__UefiVariableAttributes(soap, tag ? tag : "vbox:UefiVariableAttributes", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__UefiVariableAttributes * SOAP_FMAC4 soap_get_vbox__UefiVariableAttributes(struct soap *soap, enum vbox__UefiVariableAttributes *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__UefiVariableAttributes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__SignatureType[] =
{	{ (LONG64)vbox__SignatureType__X509, "X509" },
	{ (LONG64)vbox__SignatureType__Sha256, "Sha256" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__SignatureType2s(struct soap *soap, enum vbox__SignatureType n)
{
	const char *s = soap_code_str(soap_codes_vbox__SignatureType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__SignatureType(struct soap *soap, const char *tag, int id, const enum vbox__SignatureType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__SignatureType), type) || soap_send(soap, soap_vbox__SignatureType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__SignatureType(struct soap *soap, const char *s, enum vbox__SignatureType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__SignatureType, s);
	if (map)
		*a = (enum vbox__SignatureType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__SignatureType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__SignatureType * SOAP_FMAC4 soap_in_vbox__SignatureType(struct soap *soap, const char *tag, enum vbox__SignatureType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__SignatureType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__SignatureType, sizeof(enum vbox__SignatureType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__SignatureType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__SignatureType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__SignatureType, SOAP_TYPE_vbox__SignatureType, sizeof(enum vbox__SignatureType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__SignatureType * SOAP_FMAC4 soap_new_vbox__SignatureType(struct soap *soap, int n)
{
	enum vbox__SignatureType *a = static_cast<enum vbox__SignatureType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__SignatureType)));
	for (enum vbox__SignatureType *p = a; p && n--; ++p)
		soap_default_vbox__SignatureType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__SignatureType(struct soap *soap, const enum vbox__SignatureType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__SignatureType(soap, tag ? tag : "vbox:SignatureType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__SignatureType * SOAP_FMAC4 soap_get_vbox__SignatureType(struct soap *soap, enum vbox__SignatureType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__SignatureType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__RecordingState[] =
{	{ (LONG64)vbox__RecordingState__Unknown, "Unknown" },
	{ (LONG64)vbox__RecordingState__Initializing, "Initializing" },
	{ (LONG64)vbox__RecordingState__Started, "Started" },
	{ (LONG64)vbox__RecordingState__Paused, "Paused" },
	{ (LONG64)vbox__RecordingState__Resumed, "Resumed" },
	{ (LONG64)vbox__RecordingState__Finalizing, "Finalizing" },
	{ (LONG64)vbox__RecordingState__Stopped, "Stopped" },
	{ (LONG64)vbox__RecordingState__Canceled, "Canceled" },
	{ (LONG64)vbox__RecordingState__LimitReached, "LimitReached" },
	{ (LONG64)vbox__RecordingState__Error, "Error" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__RecordingState2s(struct soap *soap, enum vbox__RecordingState n)
{
	const char *s = soap_code_str(soap_codes_vbox__RecordingState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__RecordingState(struct soap *soap, const char *tag, int id, const enum vbox__RecordingState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__RecordingState), type) || soap_send(soap, soap_vbox__RecordingState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__RecordingState(struct soap *soap, const char *s, enum vbox__RecordingState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__RecordingState, s);
	if (map)
		*a = (enum vbox__RecordingState)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 9)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__RecordingState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__RecordingState * SOAP_FMAC4 soap_in_vbox__RecordingState(struct soap *soap, const char *tag, enum vbox__RecordingState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__RecordingState*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__RecordingState, sizeof(enum vbox__RecordingState), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__RecordingState(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__RecordingState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__RecordingState, SOAP_TYPE_vbox__RecordingState, sizeof(enum vbox__RecordingState), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__RecordingState * SOAP_FMAC4 soap_new_vbox__RecordingState(struct soap *soap, int n)
{
	enum vbox__RecordingState *a = static_cast<enum vbox__RecordingState *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__RecordingState)));
	for (enum vbox__RecordingState *p = a; p && n--; ++p)
		soap_default_vbox__RecordingState(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__RecordingState(struct soap *soap, const enum vbox__RecordingState *a, const char *tag, const char *type)
{
	if (soap_out_vbox__RecordingState(soap, tag ? tag : "vbox:RecordingState", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__RecordingState * SOAP_FMAC4 soap_get_vbox__RecordingState(struct soap *soap, enum vbox__RecordingState *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__RecordingState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__RecordingRateControlMode[] =
{	{ (LONG64)vbox__RecordingRateControlMode__ABR, "ABR" },
	{ (LONG64)vbox__RecordingRateControlMode__CBR, "CBR" },
	{ (LONG64)vbox__RecordingRateControlMode__VBR, "VBR" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__RecordingRateControlMode2s(struct soap *soap, enum vbox__RecordingRateControlMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__RecordingRateControlMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__RecordingRateControlMode(struct soap *soap, const char *tag, int id, const enum vbox__RecordingRateControlMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__RecordingRateControlMode), type) || soap_send(soap, soap_vbox__RecordingRateControlMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__RecordingRateControlMode(struct soap *soap, const char *s, enum vbox__RecordingRateControlMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__RecordingRateControlMode, s);
	if (map)
		*a = (enum vbox__RecordingRateControlMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__RecordingRateControlMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__RecordingRateControlMode * SOAP_FMAC4 soap_in_vbox__RecordingRateControlMode(struct soap *soap, const char *tag, enum vbox__RecordingRateControlMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__RecordingRateControlMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__RecordingRateControlMode, sizeof(enum vbox__RecordingRateControlMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__RecordingRateControlMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__RecordingRateControlMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__RecordingRateControlMode, SOAP_TYPE_vbox__RecordingRateControlMode, sizeof(enum vbox__RecordingRateControlMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__RecordingRateControlMode * SOAP_FMAC4 soap_new_vbox__RecordingRateControlMode(struct soap *soap, int n)
{
	enum vbox__RecordingRateControlMode *a = static_cast<enum vbox__RecordingRateControlMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__RecordingRateControlMode)));
	for (enum vbox__RecordingRateControlMode *p = a; p && n--; ++p)
		soap_default_vbox__RecordingRateControlMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__RecordingRateControlMode(struct soap *soap, const enum vbox__RecordingRateControlMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__RecordingRateControlMode(soap, tag ? tag : "vbox:RecordingRateControlMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__RecordingRateControlMode * SOAP_FMAC4 soap_get_vbox__RecordingRateControlMode(struct soap *soap, enum vbox__RecordingRateControlMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__RecordingRateControlMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__RecordingVideoScalingMode[] =
{	{ (LONG64)vbox__RecordingVideoScalingMode__None, "None" },
	{ (LONG64)vbox__RecordingVideoScalingMode__NearestNeighbor, "NearestNeighbor" },
	{ (LONG64)vbox__RecordingVideoScalingMode__Bilinear, "Bilinear" },
	{ (LONG64)vbox__RecordingVideoScalingMode__Bicubic, "Bicubic" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__RecordingVideoScalingMode2s(struct soap *soap, enum vbox__RecordingVideoScalingMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__RecordingVideoScalingMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__RecordingVideoScalingMode(struct soap *soap, const char *tag, int id, const enum vbox__RecordingVideoScalingMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__RecordingVideoScalingMode), type) || soap_send(soap, soap_vbox__RecordingVideoScalingMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__RecordingVideoScalingMode(struct soap *soap, const char *s, enum vbox__RecordingVideoScalingMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__RecordingVideoScalingMode, s);
	if (map)
		*a = (enum vbox__RecordingVideoScalingMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__RecordingVideoScalingMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__RecordingVideoScalingMode * SOAP_FMAC4 soap_in_vbox__RecordingVideoScalingMode(struct soap *soap, const char *tag, enum vbox__RecordingVideoScalingMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__RecordingVideoScalingMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__RecordingVideoScalingMode, sizeof(enum vbox__RecordingVideoScalingMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__RecordingVideoScalingMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__RecordingVideoScalingMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__RecordingVideoScalingMode, SOAP_TYPE_vbox__RecordingVideoScalingMode, sizeof(enum vbox__RecordingVideoScalingMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__RecordingVideoScalingMode * SOAP_FMAC4 soap_new_vbox__RecordingVideoScalingMode(struct soap *soap, int n)
{
	enum vbox__RecordingVideoScalingMode *a = static_cast<enum vbox__RecordingVideoScalingMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__RecordingVideoScalingMode)));
	for (enum vbox__RecordingVideoScalingMode *p = a; p && n--; ++p)
		soap_default_vbox__RecordingVideoScalingMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__RecordingVideoScalingMode(struct soap *soap, const enum vbox__RecordingVideoScalingMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__RecordingVideoScalingMode(soap, tag ? tag : "vbox:RecordingVideoScalingMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__RecordingVideoScalingMode * SOAP_FMAC4 soap_get_vbox__RecordingVideoScalingMode(struct soap *soap, enum vbox__RecordingVideoScalingMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__RecordingVideoScalingMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__RecordingVideoCodec[] =
{	{ (LONG64)vbox__RecordingVideoCodec__None, "None" },
	{ (LONG64)vbox__RecordingVideoCodec__MJPEG, "MJPEG" },
	{ (LONG64)vbox__RecordingVideoCodec__H262, "H262" },
	{ (LONG64)vbox__RecordingVideoCodec__H264, "H264" },
	{ (LONG64)vbox__RecordingVideoCodec__H265, "H265" },
	{ (LONG64)vbox__RecordingVideoCodec__H266, "H266" },
	{ (LONG64)vbox__RecordingVideoCodec__VP8, "VP8" },
	{ (LONG64)vbox__RecordingVideoCodec__VP9, "VP9" },
	{ (LONG64)vbox__RecordingVideoCodec__AV1, "AV1" },
	{ (LONG64)vbox__RecordingVideoCodec__Other, "Other" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__RecordingVideoCodec2s(struct soap *soap, enum vbox__RecordingVideoCodec n)
{
	const char *s = soap_code_str(soap_codes_vbox__RecordingVideoCodec, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__RecordingVideoCodec(struct soap *soap, const char *tag, int id, const enum vbox__RecordingVideoCodec *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__RecordingVideoCodec), type) || soap_send(soap, soap_vbox__RecordingVideoCodec2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__RecordingVideoCodec(struct soap *soap, const char *s, enum vbox__RecordingVideoCodec *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__RecordingVideoCodec, s);
	if (map)
		*a = (enum vbox__RecordingVideoCodec)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 9)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__RecordingVideoCodec)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__RecordingVideoCodec * SOAP_FMAC4 soap_in_vbox__RecordingVideoCodec(struct soap *soap, const char *tag, enum vbox__RecordingVideoCodec *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__RecordingVideoCodec*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__RecordingVideoCodec, sizeof(enum vbox__RecordingVideoCodec), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__RecordingVideoCodec(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__RecordingVideoCodec *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__RecordingVideoCodec, SOAP_TYPE_vbox__RecordingVideoCodec, sizeof(enum vbox__RecordingVideoCodec), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__RecordingVideoCodec * SOAP_FMAC4 soap_new_vbox__RecordingVideoCodec(struct soap *soap, int n)
{
	enum vbox__RecordingVideoCodec *a = static_cast<enum vbox__RecordingVideoCodec *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__RecordingVideoCodec)));
	for (enum vbox__RecordingVideoCodec *p = a; p && n--; ++p)
		soap_default_vbox__RecordingVideoCodec(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__RecordingVideoCodec(struct soap *soap, const enum vbox__RecordingVideoCodec *a, const char *tag, const char *type)
{
	if (soap_out_vbox__RecordingVideoCodec(soap, tag ? tag : "vbox:RecordingVideoCodec", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__RecordingVideoCodec * SOAP_FMAC4 soap_get_vbox__RecordingVideoCodec(struct soap *soap, enum vbox__RecordingVideoCodec *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__RecordingVideoCodec(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__RecordingCodecDeadline[] =
{	{ (LONG64)vbox__RecordingCodecDeadline__Default, "Default" },
	{ (LONG64)vbox__RecordingCodecDeadline__Realtime, "Realtime" },
	{ (LONG64)vbox__RecordingCodecDeadline__Good, "Good" },
	{ (LONG64)vbox__RecordingCodecDeadline__Best, "Best" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__RecordingCodecDeadline2s(struct soap *soap, enum vbox__RecordingCodecDeadline n)
{
	const char *s = soap_code_str(soap_codes_vbox__RecordingCodecDeadline, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__RecordingCodecDeadline(struct soap *soap, const char *tag, int id, const enum vbox__RecordingCodecDeadline *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__RecordingCodecDeadline), type) || soap_send(soap, soap_vbox__RecordingCodecDeadline2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__RecordingCodecDeadline(struct soap *soap, const char *s, enum vbox__RecordingCodecDeadline *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__RecordingCodecDeadline, s);
	if (map)
		*a = (enum vbox__RecordingCodecDeadline)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__RecordingCodecDeadline)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__RecordingCodecDeadline * SOAP_FMAC4 soap_in_vbox__RecordingCodecDeadline(struct soap *soap, const char *tag, enum vbox__RecordingCodecDeadline *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__RecordingCodecDeadline*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__RecordingCodecDeadline, sizeof(enum vbox__RecordingCodecDeadline), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__RecordingCodecDeadline(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__RecordingCodecDeadline *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__RecordingCodecDeadline, SOAP_TYPE_vbox__RecordingCodecDeadline, sizeof(enum vbox__RecordingCodecDeadline), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__RecordingCodecDeadline * SOAP_FMAC4 soap_new_vbox__RecordingCodecDeadline(struct soap *soap, int n)
{
	enum vbox__RecordingCodecDeadline *a = static_cast<enum vbox__RecordingCodecDeadline *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__RecordingCodecDeadline)));
	for (enum vbox__RecordingCodecDeadline *p = a; p && n--; ++p)
		soap_default_vbox__RecordingCodecDeadline(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__RecordingCodecDeadline(struct soap *soap, const enum vbox__RecordingCodecDeadline *a, const char *tag, const char *type)
{
	if (soap_out_vbox__RecordingCodecDeadline(soap, tag ? tag : "vbox:RecordingCodecDeadline", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__RecordingCodecDeadline * SOAP_FMAC4 soap_get_vbox__RecordingCodecDeadline(struct soap *soap, enum vbox__RecordingCodecDeadline *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__RecordingCodecDeadline(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__RecordingAudioCodec[] =
{	{ (LONG64)vbox__RecordingAudioCodec__None, "None" },
	{ (LONG64)vbox__RecordingAudioCodec__WavPCM, "WavPCM" },
	{ (LONG64)vbox__RecordingAudioCodec__MP3, "MP3" },
	{ (LONG64)vbox__RecordingAudioCodec__OggVorbis, "OggVorbis" },
	{ (LONG64)vbox__RecordingAudioCodec__Opus, "Opus" },
	{ (LONG64)vbox__RecordingAudioCodec__Other, "Other" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__RecordingAudioCodec2s(struct soap *soap, enum vbox__RecordingAudioCodec n)
{
	const char *s = soap_code_str(soap_codes_vbox__RecordingAudioCodec, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__RecordingAudioCodec(struct soap *soap, const char *tag, int id, const enum vbox__RecordingAudioCodec *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__RecordingAudioCodec), type) || soap_send(soap, soap_vbox__RecordingAudioCodec2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__RecordingAudioCodec(struct soap *soap, const char *s, enum vbox__RecordingAudioCodec *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__RecordingAudioCodec, s);
	if (map)
		*a = (enum vbox__RecordingAudioCodec)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 5)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__RecordingAudioCodec)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__RecordingAudioCodec * SOAP_FMAC4 soap_in_vbox__RecordingAudioCodec(struct soap *soap, const char *tag, enum vbox__RecordingAudioCodec *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__RecordingAudioCodec*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__RecordingAudioCodec, sizeof(enum vbox__RecordingAudioCodec), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__RecordingAudioCodec(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__RecordingAudioCodec *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__RecordingAudioCodec, SOAP_TYPE_vbox__RecordingAudioCodec, sizeof(enum vbox__RecordingAudioCodec), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__RecordingAudioCodec * SOAP_FMAC4 soap_new_vbox__RecordingAudioCodec(struct soap *soap, int n)
{
	enum vbox__RecordingAudioCodec *a = static_cast<enum vbox__RecordingAudioCodec *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__RecordingAudioCodec)));
	for (enum vbox__RecordingAudioCodec *p = a; p && n--; ++p)
		soap_default_vbox__RecordingAudioCodec(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__RecordingAudioCodec(struct soap *soap, const enum vbox__RecordingAudioCodec *a, const char *tag, const char *type)
{
	if (soap_out_vbox__RecordingAudioCodec(soap, tag ? tag : "vbox:RecordingAudioCodec", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__RecordingAudioCodec * SOAP_FMAC4 soap_get_vbox__RecordingAudioCodec(struct soap *soap, enum vbox__RecordingAudioCodec *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__RecordingAudioCodec(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__RecordingFeature[] =
{	{ (LONG64)vbox__RecordingFeature__None, "None" },
	{ (LONG64)vbox__RecordingFeature__Video, "Video" },
	{ (LONG64)vbox__RecordingFeature__Audio, "Audio" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__RecordingFeature2s(struct soap *soap, enum vbox__RecordingFeature n)
{
	const char *s = soap_code_str(soap_codes_vbox__RecordingFeature, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__RecordingFeature(struct soap *soap, const char *tag, int id, const enum vbox__RecordingFeature *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__RecordingFeature), type) || soap_send(soap, soap_vbox__RecordingFeature2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__RecordingFeature(struct soap *soap, const char *s, enum vbox__RecordingFeature *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__RecordingFeature, s);
	if (map)
		*a = (enum vbox__RecordingFeature)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__RecordingFeature)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__RecordingFeature * SOAP_FMAC4 soap_in_vbox__RecordingFeature(struct soap *soap, const char *tag, enum vbox__RecordingFeature *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__RecordingFeature*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__RecordingFeature, sizeof(enum vbox__RecordingFeature), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__RecordingFeature(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__RecordingFeature *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__RecordingFeature, SOAP_TYPE_vbox__RecordingFeature, sizeof(enum vbox__RecordingFeature), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__RecordingFeature * SOAP_FMAC4 soap_new_vbox__RecordingFeature(struct soap *soap, int n)
{
	enum vbox__RecordingFeature *a = static_cast<enum vbox__RecordingFeature *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__RecordingFeature)));
	for (enum vbox__RecordingFeature *p = a; p && n--; ++p)
		soap_default_vbox__RecordingFeature(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__RecordingFeature(struct soap *soap, const enum vbox__RecordingFeature *a, const char *tag, const char *type)
{
	if (soap_out_vbox__RecordingFeature(soap, tag ? tag : "vbox:RecordingFeature", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__RecordingFeature * SOAP_FMAC4 soap_get_vbox__RecordingFeature(struct soap *soap, enum vbox__RecordingFeature *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__RecordingFeature(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__RecordingDestination[] =
{	{ (LONG64)vbox__RecordingDestination__None, "None" },
	{ (LONG64)vbox__RecordingDestination__File, "File" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__RecordingDestination2s(struct soap *soap, enum vbox__RecordingDestination n)
{
	const char *s = soap_code_str(soap_codes_vbox__RecordingDestination, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__RecordingDestination(struct soap *soap, const char *tag, int id, const enum vbox__RecordingDestination *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__RecordingDestination), type) || soap_send(soap, soap_vbox__RecordingDestination2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__RecordingDestination(struct soap *soap, const char *s, enum vbox__RecordingDestination *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__RecordingDestination, s);
	if (map)
		*a = (enum vbox__RecordingDestination)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__RecordingDestination)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__RecordingDestination * SOAP_FMAC4 soap_in_vbox__RecordingDestination(struct soap *soap, const char *tag, enum vbox__RecordingDestination *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__RecordingDestination*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__RecordingDestination, sizeof(enum vbox__RecordingDestination), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__RecordingDestination(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__RecordingDestination *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__RecordingDestination, SOAP_TYPE_vbox__RecordingDestination, sizeof(enum vbox__RecordingDestination), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__RecordingDestination * SOAP_FMAC4 soap_new_vbox__RecordingDestination(struct soap *soap, int n)
{
	enum vbox__RecordingDestination *a = static_cast<enum vbox__RecordingDestination *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__RecordingDestination)));
	for (enum vbox__RecordingDestination *p = a; p && n--; ++p)
		soap_default_vbox__RecordingDestination(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__RecordingDestination(struct soap *soap, const enum vbox__RecordingDestination *a, const char *tag, const char *type)
{
	if (soap_out_vbox__RecordingDestination(soap, tag ? tag : "vbox:RecordingDestination", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__RecordingDestination * SOAP_FMAC4 soap_get_vbox__RecordingDestination(struct soap *soap, enum vbox__RecordingDestination *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__RecordingDestination(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__TpmType[] =
{	{ (LONG64)vbox__TpmType__None, "None" },
	{ (LONG64)vbox__TpmType__v1_USCORE2, "v1_2" },
	{ (LONG64)vbox__TpmType__v2_USCORE0, "v2_0" },
	{ (LONG64)vbox__TpmType__Host, "Host" },
	{ (LONG64)vbox__TpmType__Swtpm, "Swtpm" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__TpmType2s(struct soap *soap, enum vbox__TpmType n)
{
	const char *s = soap_code_str(soap_codes_vbox__TpmType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__TpmType(struct soap *soap, const char *tag, int id, const enum vbox__TpmType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__TpmType), type) || soap_send(soap, soap_vbox__TpmType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__TpmType(struct soap *soap, const char *s, enum vbox__TpmType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__TpmType, s);
	if (map)
		*a = (enum vbox__TpmType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__TpmType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__TpmType * SOAP_FMAC4 soap_in_vbox__TpmType(struct soap *soap, const char *tag, enum vbox__TpmType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__TpmType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__TpmType, sizeof(enum vbox__TpmType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__TpmType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__TpmType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__TpmType, SOAP_TYPE_vbox__TpmType, sizeof(enum vbox__TpmType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__TpmType * SOAP_FMAC4 soap_new_vbox__TpmType(struct soap *soap, int n)
{
	enum vbox__TpmType *a = static_cast<enum vbox__TpmType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__TpmType)));
	for (enum vbox__TpmType *p = a; p && n--; ++p)
		soap_default_vbox__TpmType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__TpmType(struct soap *soap, const enum vbox__TpmType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__TpmType(soap, tag ? tag : "vbox:TpmType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__TpmType * SOAP_FMAC4 soap_get_vbox__TpmType(struct soap *soap, enum vbox__TpmType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__TpmType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__VirtualSystemDescriptionValueType[] =
{	{ (LONG64)vbox__VirtualSystemDescriptionValueType__Reference, "Reference" },
	{ (LONG64)vbox__VirtualSystemDescriptionValueType__Original, "Original" },
	{ (LONG64)vbox__VirtualSystemDescriptionValueType__Auto, "Auto" },
	{ (LONG64)vbox__VirtualSystemDescriptionValueType__ExtraConfig, "ExtraConfig" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__VirtualSystemDescriptionValueType2s(struct soap *soap, enum vbox__VirtualSystemDescriptionValueType n)
{
	const char *s = soap_code_str(soap_codes_vbox__VirtualSystemDescriptionValueType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__VirtualSystemDescriptionValueType(struct soap *soap, const char *tag, int id, const enum vbox__VirtualSystemDescriptionValueType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__VirtualSystemDescriptionValueType), type) || soap_send(soap, soap_vbox__VirtualSystemDescriptionValueType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__VirtualSystemDescriptionValueType(struct soap *soap, const char *s, enum vbox__VirtualSystemDescriptionValueType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__VirtualSystemDescriptionValueType, s);
	if (map)
		*a = (enum vbox__VirtualSystemDescriptionValueType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__VirtualSystemDescriptionValueType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__VirtualSystemDescriptionValueType * SOAP_FMAC4 soap_in_vbox__VirtualSystemDescriptionValueType(struct soap *soap, const char *tag, enum vbox__VirtualSystemDescriptionValueType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__VirtualSystemDescriptionValueType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__VirtualSystemDescriptionValueType, sizeof(enum vbox__VirtualSystemDescriptionValueType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__VirtualSystemDescriptionValueType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__VirtualSystemDescriptionValueType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__VirtualSystemDescriptionValueType, SOAP_TYPE_vbox__VirtualSystemDescriptionValueType, sizeof(enum vbox__VirtualSystemDescriptionValueType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__VirtualSystemDescriptionValueType * SOAP_FMAC4 soap_new_vbox__VirtualSystemDescriptionValueType(struct soap *soap, int n)
{
	enum vbox__VirtualSystemDescriptionValueType *a = static_cast<enum vbox__VirtualSystemDescriptionValueType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__VirtualSystemDescriptionValueType)));
	for (enum vbox__VirtualSystemDescriptionValueType *p = a; p && n--; ++p)
		soap_default_vbox__VirtualSystemDescriptionValueType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__VirtualSystemDescriptionValueType(struct soap *soap, const enum vbox__VirtualSystemDescriptionValueType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__VirtualSystemDescriptionValueType(soap, tag ? tag : "vbox:VirtualSystemDescriptionValueType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__VirtualSystemDescriptionValueType * SOAP_FMAC4 soap_get_vbox__VirtualSystemDescriptionValueType(struct soap *soap, enum vbox__VirtualSystemDescriptionValueType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__VirtualSystemDescriptionValueType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__VirtualSystemDescriptionType[] =
{	{ (LONG64)vbox__VirtualSystemDescriptionType__Ignore, "Ignore" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__OS, "OS" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__Name, "Name" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__Product, "Product" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__Vendor, "Vendor" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__Version, "Version" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__ProductUrl, "ProductUrl" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__VendorUrl, "VendorUrl" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__Description, "Description" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__License, "License" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__Miscellaneous, "Miscellaneous" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CPU, "CPU" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__Memory, "Memory" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__HardDiskControllerIDE, "HardDiskControllerIDE" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__HardDiskControllerSATA, "HardDiskControllerSATA" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__HardDiskControllerSCSI, "HardDiskControllerSCSI" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__HardDiskControllerSAS, "HardDiskControllerSAS" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__HardDiskImage, "HardDiskImage" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__Floppy, "Floppy" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CDROM, "CDROM" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__NetworkAdapter, "NetworkAdapter" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__USBController, "USBController" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__SoundCard, "SoundCard" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__SettingsFile, "SettingsFile" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__BaseFolder, "BaseFolder" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__PrimaryGroup, "PrimaryGroup" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudInstanceShape, "CloudInstanceShape" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudDomain, "CloudDomain" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudBootDiskSize, "CloudBootDiskSize" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudBucket, "CloudBucket" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudOCIVCN, "CloudOCIVCN" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudPublicIP, "CloudPublicIP" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudProfileName, "CloudProfileName" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudOCISubnet, "CloudOCISubnet" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudKeepObject, "CloudKeepObject" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudLaunchInstance, "CloudLaunchInstance" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudInstanceId, "CloudInstanceId" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudImageId, "CloudImageId" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudInstanceState, "CloudInstanceState" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudImageState, "CloudImageState" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudInstanceDisplayName, "CloudInstanceDisplayName" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudImageDisplayName, "CloudImageDisplayName" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudOCILaunchMode, "CloudOCILaunchMode" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudPrivateIP, "CloudPrivateIP" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudBootVolumeId, "CloudBootVolumeId" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudOCIVCNCompartment, "CloudOCIVCNCompartment" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudOCISubnetCompartment, "CloudOCISubnetCompartment" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudPublicSSHKey, "CloudPublicSSHKey" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__BootingFirmware, "BootingFirmware" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudInitScriptPath, "CloudInitScriptPath" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudCompartmentId, "CloudCompartmentId" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudShapeCpus, "CloudShapeCpus" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudShapeMemory, "CloudShapeMemory" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudInstanceMetadata, "CloudInstanceMetadata" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudInstanceFreeFormTags, "CloudInstanceFreeFormTags" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__CloudImageFreeFormTags, "CloudImageFreeFormTags" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__HardDiskControllerVirtioSCSI, "HardDiskControllerVirtioSCSI" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__HardDiskControllerNVMe, "HardDiskControllerNVMe" },
	{ (LONG64)vbox__VirtualSystemDescriptionType__NVRAM, "NVRAM" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__VirtualSystemDescriptionType2s(struct soap *soap, enum vbox__VirtualSystemDescriptionType n)
{
	const char *s = soap_code_str(soap_codes_vbox__VirtualSystemDescriptionType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__VirtualSystemDescriptionType(struct soap *soap, const char *tag, int id, const enum vbox__VirtualSystemDescriptionType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__VirtualSystemDescriptionType), type) || soap_send(soap, soap_vbox__VirtualSystemDescriptionType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__VirtualSystemDescriptionType(struct soap *soap, const char *s, enum vbox__VirtualSystemDescriptionType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__VirtualSystemDescriptionType, s);
	if (map)
		*a = (enum vbox__VirtualSystemDescriptionType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 58)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__VirtualSystemDescriptionType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__VirtualSystemDescriptionType * SOAP_FMAC4 soap_in_vbox__VirtualSystemDescriptionType(struct soap *soap, const char *tag, enum vbox__VirtualSystemDescriptionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__VirtualSystemDescriptionType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__VirtualSystemDescriptionType, sizeof(enum vbox__VirtualSystemDescriptionType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__VirtualSystemDescriptionType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__VirtualSystemDescriptionType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__VirtualSystemDescriptionType, SOAP_TYPE_vbox__VirtualSystemDescriptionType, sizeof(enum vbox__VirtualSystemDescriptionType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__VirtualSystemDescriptionType * SOAP_FMAC4 soap_new_vbox__VirtualSystemDescriptionType(struct soap *soap, int n)
{
	enum vbox__VirtualSystemDescriptionType *a = static_cast<enum vbox__VirtualSystemDescriptionType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__VirtualSystemDescriptionType)));
	for (enum vbox__VirtualSystemDescriptionType *p = a; p && n--; ++p)
		soap_default_vbox__VirtualSystemDescriptionType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__VirtualSystemDescriptionType(struct soap *soap, const enum vbox__VirtualSystemDescriptionType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__VirtualSystemDescriptionType(soap, tag ? tag : "vbox:VirtualSystemDescriptionType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__VirtualSystemDescriptionType * SOAP_FMAC4 soap_get_vbox__VirtualSystemDescriptionType(struct soap *soap, enum vbox__VirtualSystemDescriptionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__VirtualSystemDescriptionType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__CertificateVersion[] =
{	{ (LONG64)vbox__CertificateVersion__V1, "V1" },
	{ (LONG64)vbox__CertificateVersion__V2, "V2" },
	{ (LONG64)vbox__CertificateVersion__V3, "V3" },
	{ (LONG64)vbox__CertificateVersion__Unknown, "Unknown" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__CertificateVersion2s(struct soap *soap, enum vbox__CertificateVersion n)
{
	const char *s = soap_code_str(soap_codes_vbox__CertificateVersion, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__CertificateVersion(struct soap *soap, const char *tag, int id, const enum vbox__CertificateVersion *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__CertificateVersion), type) || soap_send(soap, soap_vbox__CertificateVersion2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__CertificateVersion(struct soap *soap, const char *s, enum vbox__CertificateVersion *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__CertificateVersion, s);
	if (map)
		*a = (enum vbox__CertificateVersion)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__CertificateVersion)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__CertificateVersion * SOAP_FMAC4 soap_in_vbox__CertificateVersion(struct soap *soap, const char *tag, enum vbox__CertificateVersion *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__CertificateVersion*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__CertificateVersion, sizeof(enum vbox__CertificateVersion), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__CertificateVersion(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__CertificateVersion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__CertificateVersion, SOAP_TYPE_vbox__CertificateVersion, sizeof(enum vbox__CertificateVersion), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__CertificateVersion * SOAP_FMAC4 soap_new_vbox__CertificateVersion(struct soap *soap, int n)
{
	enum vbox__CertificateVersion *a = static_cast<enum vbox__CertificateVersion *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__CertificateVersion)));
	for (enum vbox__CertificateVersion *p = a; p && n--; ++p)
		soap_default_vbox__CertificateVersion(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__CertificateVersion(struct soap *soap, const enum vbox__CertificateVersion *a, const char *tag, const char *type)
{
	if (soap_out_vbox__CertificateVersion(soap, tag ? tag : "vbox:CertificateVersion", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__CertificateVersion * SOAP_FMAC4 soap_get_vbox__CertificateVersion(struct soap *soap, enum vbox__CertificateVersion *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__CertificateVersion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ExportOptions[] =
{	{ (LONG64)vbox__ExportOptions__CreateManifest, "CreateManifest" },
	{ (LONG64)vbox__ExportOptions__ExportDVDImages, "ExportDVDImages" },
	{ (LONG64)vbox__ExportOptions__StripAllMACs, "StripAllMACs" },
	{ (LONG64)vbox__ExportOptions__StripAllNonNATMACs, "StripAllNonNATMACs" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ExportOptions2s(struct soap *soap, enum vbox__ExportOptions n)
{
	const char *s = soap_code_str(soap_codes_vbox__ExportOptions, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ExportOptions(struct soap *soap, const char *tag, int id, const enum vbox__ExportOptions *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ExportOptions), type) || soap_send(soap, soap_vbox__ExportOptions2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ExportOptions(struct soap *soap, const char *s, enum vbox__ExportOptions *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ExportOptions, s);
	if (map)
		*a = (enum vbox__ExportOptions)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ExportOptions)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ExportOptions * SOAP_FMAC4 soap_in_vbox__ExportOptions(struct soap *soap, const char *tag, enum vbox__ExportOptions *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ExportOptions*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ExportOptions, sizeof(enum vbox__ExportOptions), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ExportOptions(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ExportOptions *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ExportOptions, SOAP_TYPE_vbox__ExportOptions, sizeof(enum vbox__ExportOptions), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ExportOptions * SOAP_FMAC4 soap_new_vbox__ExportOptions(struct soap *soap, int n)
{
	enum vbox__ExportOptions *a = static_cast<enum vbox__ExportOptions *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ExportOptions)));
	for (enum vbox__ExportOptions *p = a; p && n--; ++p)
		soap_default_vbox__ExportOptions(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ExportOptions(struct soap *soap, const enum vbox__ExportOptions *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ExportOptions(soap, tag ? tag : "vbox:ExportOptions", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ExportOptions * SOAP_FMAC4 soap_get_vbox__ExportOptions(struct soap *soap, enum vbox__ExportOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ExportOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ImportOptions[] =
{	{ (LONG64)vbox__ImportOptions__KeepAllMACs, "KeepAllMACs" },
	{ (LONG64)vbox__ImportOptions__KeepNATMACs, "KeepNATMACs" },
	{ (LONG64)vbox__ImportOptions__ImportToVDI, "ImportToVDI" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ImportOptions2s(struct soap *soap, enum vbox__ImportOptions n)
{
	const char *s = soap_code_str(soap_codes_vbox__ImportOptions, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ImportOptions(struct soap *soap, const char *tag, int id, const enum vbox__ImportOptions *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ImportOptions), type) || soap_send(soap, soap_vbox__ImportOptions2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ImportOptions(struct soap *soap, const char *s, enum vbox__ImportOptions *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ImportOptions, s);
	if (map)
		*a = (enum vbox__ImportOptions)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ImportOptions)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ImportOptions * SOAP_FMAC4 soap_in_vbox__ImportOptions(struct soap *soap, const char *tag, enum vbox__ImportOptions *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ImportOptions*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ImportOptions, sizeof(enum vbox__ImportOptions), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ImportOptions(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ImportOptions *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ImportOptions, SOAP_TYPE_vbox__ImportOptions, sizeof(enum vbox__ImportOptions), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ImportOptions * SOAP_FMAC4 soap_new_vbox__ImportOptions(struct soap *soap, int n)
{
	enum vbox__ImportOptions *a = static_cast<enum vbox__ImportOptions *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ImportOptions)));
	for (enum vbox__ImportOptions *p = a; p && n--; ++p)
		soap_default_vbox__ImportOptions(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ImportOptions(struct soap *soap, const enum vbox__ImportOptions *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ImportOptions(soap, tag ? tag : "vbox:ImportOptions", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ImportOptions * SOAP_FMAC4 soap_get_vbox__ImportOptions(struct soap *soap, enum vbox__ImportOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ImportOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__VFSType[] =
{	{ (LONG64)vbox__VFSType__File, "File" },
	{ (LONG64)vbox__VFSType__Cloud, "Cloud" },
	{ (LONG64)vbox__VFSType__S3, "S3" },
	{ (LONG64)vbox__VFSType__WebDav, "WebDav" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__VFSType2s(struct soap *soap, enum vbox__VFSType n)
{
	const char *s = soap_code_str(soap_codes_vbox__VFSType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__VFSType(struct soap *soap, const char *tag, int id, const enum vbox__VFSType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__VFSType), type) || soap_send(soap, soap_vbox__VFSType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__VFSType(struct soap *soap, const char *s, enum vbox__VFSType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__VFSType, s);
	if (map)
		*a = (enum vbox__VFSType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__VFSType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__VFSType * SOAP_FMAC4 soap_in_vbox__VFSType(struct soap *soap, const char *tag, enum vbox__VFSType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__VFSType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__VFSType, sizeof(enum vbox__VFSType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__VFSType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__VFSType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__VFSType, SOAP_TYPE_vbox__VFSType, sizeof(enum vbox__VFSType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__VFSType * SOAP_FMAC4 soap_new_vbox__VFSType(struct soap *soap, int n)
{
	enum vbox__VFSType *a = static_cast<enum vbox__VFSType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__VFSType)));
	for (enum vbox__VFSType *p = a; p && n--; ++p)
		soap_default_vbox__VFSType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__VFSType(struct soap *soap, const enum vbox__VFSType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__VFSType(soap, tag ? tag : "vbox:VFSType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__VFSType * SOAP_FMAC4 soap_get_vbox__VFSType(struct soap *soap, enum vbox__VFSType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__VFSType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DHCPGroupConditionType[] =
{	{ (LONG64)vbox__DHCPGroupConditionType__MAC, "MAC" },
	{ (LONG64)vbox__DHCPGroupConditionType__MACWildcard, "MACWildcard" },
	{ (LONG64)vbox__DHCPGroupConditionType__vendorClassID, "vendorClassID" },
	{ (LONG64)vbox__DHCPGroupConditionType__vendorClassIDWildcard, "vendorClassIDWildcard" },
	{ (LONG64)vbox__DHCPGroupConditionType__userClassID, "userClassID" },
	{ (LONG64)vbox__DHCPGroupConditionType__userClassIDWildcard, "userClassIDWildcard" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DHCPGroupConditionType2s(struct soap *soap, enum vbox__DHCPGroupConditionType n)
{
	const char *s = soap_code_str(soap_codes_vbox__DHCPGroupConditionType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DHCPGroupConditionType(struct soap *soap, const char *tag, int id, const enum vbox__DHCPGroupConditionType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DHCPGroupConditionType), type) || soap_send(soap, soap_vbox__DHCPGroupConditionType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DHCPGroupConditionType(struct soap *soap, const char *s, enum vbox__DHCPGroupConditionType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DHCPGroupConditionType, s);
	if (map)
		*a = (enum vbox__DHCPGroupConditionType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 5)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DHCPGroupConditionType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DHCPGroupConditionType * SOAP_FMAC4 soap_in_vbox__DHCPGroupConditionType(struct soap *soap, const char *tag, enum vbox__DHCPGroupConditionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DHCPGroupConditionType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DHCPGroupConditionType, sizeof(enum vbox__DHCPGroupConditionType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DHCPGroupConditionType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DHCPGroupConditionType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DHCPGroupConditionType, SOAP_TYPE_vbox__DHCPGroupConditionType, sizeof(enum vbox__DHCPGroupConditionType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DHCPGroupConditionType * SOAP_FMAC4 soap_new_vbox__DHCPGroupConditionType(struct soap *soap, int n)
{
	enum vbox__DHCPGroupConditionType *a = static_cast<enum vbox__DHCPGroupConditionType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DHCPGroupConditionType)));
	for (enum vbox__DHCPGroupConditionType *p = a; p && n--; ++p)
		soap_default_vbox__DHCPGroupConditionType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DHCPGroupConditionType(struct soap *soap, const enum vbox__DHCPGroupConditionType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DHCPGroupConditionType(soap, tag ? tag : "vbox:DHCPGroupConditionType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DHCPGroupConditionType * SOAP_FMAC4 soap_get_vbox__DHCPGroupConditionType(struct soap *soap, enum vbox__DHCPGroupConditionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DHCPGroupConditionType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DHCPConfigScope[] =
{	{ (LONG64)vbox__DHCPConfigScope__Global, "Global" },
	{ (LONG64)vbox__DHCPConfigScope__Group, "Group" },
	{ (LONG64)vbox__DHCPConfigScope__MachineNIC, "MachineNIC" },
	{ (LONG64)vbox__DHCPConfigScope__MAC, "MAC" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DHCPConfigScope2s(struct soap *soap, enum vbox__DHCPConfigScope n)
{
	const char *s = soap_code_str(soap_codes_vbox__DHCPConfigScope, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DHCPConfigScope(struct soap *soap, const char *tag, int id, const enum vbox__DHCPConfigScope *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DHCPConfigScope), type) || soap_send(soap, soap_vbox__DHCPConfigScope2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DHCPConfigScope(struct soap *soap, const char *s, enum vbox__DHCPConfigScope *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DHCPConfigScope, s);
	if (map)
		*a = (enum vbox__DHCPConfigScope)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DHCPConfigScope)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DHCPConfigScope * SOAP_FMAC4 soap_in_vbox__DHCPConfigScope(struct soap *soap, const char *tag, enum vbox__DHCPConfigScope *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DHCPConfigScope*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DHCPConfigScope, sizeof(enum vbox__DHCPConfigScope), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DHCPConfigScope(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DHCPConfigScope *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DHCPConfigScope, SOAP_TYPE_vbox__DHCPConfigScope, sizeof(enum vbox__DHCPConfigScope), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DHCPConfigScope * SOAP_FMAC4 soap_new_vbox__DHCPConfigScope(struct soap *soap, int n)
{
	enum vbox__DHCPConfigScope *a = static_cast<enum vbox__DHCPConfigScope *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DHCPConfigScope)));
	for (enum vbox__DHCPConfigScope *p = a; p && n--; ++p)
		soap_default_vbox__DHCPConfigScope(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DHCPConfigScope(struct soap *soap, const enum vbox__DHCPConfigScope *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DHCPConfigScope(soap, tag ? tag : "vbox:DHCPConfigScope", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DHCPConfigScope * SOAP_FMAC4 soap_get_vbox__DHCPConfigScope(struct soap *soap, enum vbox__DHCPConfigScope *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DHCPConfigScope(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DHCPOptionEncoding[] =
{	{ (LONG64)vbox__DHCPOptionEncoding__Normal, "Normal" },
	{ (LONG64)vbox__DHCPOptionEncoding__Hex, "Hex" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DHCPOptionEncoding2s(struct soap *soap, enum vbox__DHCPOptionEncoding n)
{
	const char *s = soap_code_str(soap_codes_vbox__DHCPOptionEncoding, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DHCPOptionEncoding(struct soap *soap, const char *tag, int id, const enum vbox__DHCPOptionEncoding *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DHCPOptionEncoding), type) || soap_send(soap, soap_vbox__DHCPOptionEncoding2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DHCPOptionEncoding(struct soap *soap, const char *s, enum vbox__DHCPOptionEncoding *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DHCPOptionEncoding, s);
	if (map)
		*a = (enum vbox__DHCPOptionEncoding)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DHCPOptionEncoding)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DHCPOptionEncoding * SOAP_FMAC4 soap_in_vbox__DHCPOptionEncoding(struct soap *soap, const char *tag, enum vbox__DHCPOptionEncoding *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DHCPOptionEncoding*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DHCPOptionEncoding, sizeof(enum vbox__DHCPOptionEncoding), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DHCPOptionEncoding(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DHCPOptionEncoding *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DHCPOptionEncoding, SOAP_TYPE_vbox__DHCPOptionEncoding, sizeof(enum vbox__DHCPOptionEncoding), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DHCPOptionEncoding * SOAP_FMAC4 soap_new_vbox__DHCPOptionEncoding(struct soap *soap, int n)
{
	enum vbox__DHCPOptionEncoding *a = static_cast<enum vbox__DHCPOptionEncoding *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DHCPOptionEncoding)));
	for (enum vbox__DHCPOptionEncoding *p = a; p && n--; ++p)
		soap_default_vbox__DHCPOptionEncoding(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DHCPOptionEncoding(struct soap *soap, const enum vbox__DHCPOptionEncoding *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DHCPOptionEncoding(soap, tag ? tag : "vbox:DHCPOptionEncoding", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DHCPOptionEncoding * SOAP_FMAC4 soap_get_vbox__DHCPOptionEncoding(struct soap *soap, enum vbox__DHCPOptionEncoding *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DHCPOptionEncoding(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DHCPOption[] =
{	{ (LONG64)vbox__DHCPOption__SubnetMask, "SubnetMask" },
	{ (LONG64)vbox__DHCPOption__TimeOffset, "TimeOffset" },
	{ (LONG64)vbox__DHCPOption__Routers, "Routers" },
	{ (LONG64)vbox__DHCPOption__TimeServers, "TimeServers" },
	{ (LONG64)vbox__DHCPOption__NameServers, "NameServers" },
	{ (LONG64)vbox__DHCPOption__DomainNameServers, "DomainNameServers" },
	{ (LONG64)vbox__DHCPOption__LogServers, "LogServers" },
	{ (LONG64)vbox__DHCPOption__CookieServers, "CookieServers" },
	{ (LONG64)vbox__DHCPOption__LPRServers, "LPRServers" },
	{ (LONG64)vbox__DHCPOption__ImpressServers, "ImpressServers" },
	{ (LONG64)vbox__DHCPOption__ResourseLocationServers, "ResourseLocationServers" },
	{ (LONG64)vbox__DHCPOption__HostName, "HostName" },
	{ (LONG64)vbox__DHCPOption__BootFileSize, "BootFileSize" },
	{ (LONG64)vbox__DHCPOption__MeritDumpFile, "MeritDumpFile" },
	{ (LONG64)vbox__DHCPOption__DomainName, "DomainName" },
	{ (LONG64)vbox__DHCPOption__SwapServer, "SwapServer" },
	{ (LONG64)vbox__DHCPOption__RootPath, "RootPath" },
	{ (LONG64)vbox__DHCPOption__ExtensionPath, "ExtensionPath" },
	{ (LONG64)vbox__DHCPOption__IPForwarding, "IPForwarding" },
	{ (LONG64)vbox__DHCPOption__OptNonLocalSourceRouting, "OptNonLocalSourceRouting" },
	{ (LONG64)vbox__DHCPOption__PolicyFilter, "PolicyFilter" },
	{ (LONG64)vbox__DHCPOption__MaxDgramReassemblySize, "MaxDgramReassemblySize" },
	{ (LONG64)vbox__DHCPOption__DefaultIPTTL, "DefaultIPTTL" },
	{ (LONG64)vbox__DHCPOption__PathMTUAgingTimeout, "PathMTUAgingTimeout" },
	{ (LONG64)vbox__DHCPOption__PathMTUPlateauTable, "PathMTUPlateauTable" },
	{ (LONG64)vbox__DHCPOption__InterfaceMTU, "InterfaceMTU" },
	{ (LONG64)vbox__DHCPOption__AllSubnetsAreLocal, "AllSubnetsAreLocal" },
	{ (LONG64)vbox__DHCPOption__BroadcastAddress, "BroadcastAddress" },
	{ (LONG64)vbox__DHCPOption__PerformMaskDiscovery, "PerformMaskDiscovery" },
	{ (LONG64)vbox__DHCPOption__MaskSupplier, "MaskSupplier" },
	{ (LONG64)vbox__DHCPOption__PerformRouterDiscovery, "PerformRouterDiscovery" },
	{ (LONG64)vbox__DHCPOption__RouterSolicitationAddress, "RouterSolicitationAddress" },
	{ (LONG64)vbox__DHCPOption__StaticRoute, "StaticRoute" },
	{ (LONG64)vbox__DHCPOption__TrailerEncapsulation, "TrailerEncapsulation" },
	{ (LONG64)vbox__DHCPOption__ARPCacheTimeout, "ARPCacheTimeout" },
	{ (LONG64)vbox__DHCPOption__EthernetEncapsulation, "EthernetEncapsulation" },
	{ (LONG64)vbox__DHCPOption__TCPDefaultTTL, "TCPDefaultTTL" },
	{ (LONG64)vbox__DHCPOption__TCPKeepaliveInterval, "TCPKeepaliveInterval" },
	{ (LONG64)vbox__DHCPOption__TCPKeepaliveGarbage, "TCPKeepaliveGarbage" },
	{ (LONG64)vbox__DHCPOption__NISDomain, "NISDomain" },
	{ (LONG64)vbox__DHCPOption__NISServers, "NISServers" },
	{ (LONG64)vbox__DHCPOption__NTPServers, "NTPServers" },
	{ (LONG64)vbox__DHCPOption__VendorSpecificInfo, "VendorSpecificInfo" },
	{ (LONG64)vbox__DHCPOption__NetBIOSNameServers, "NetBIOSNameServers" },
	{ (LONG64)vbox__DHCPOption__NetBIOSDatagramServers, "NetBIOSDatagramServers" },
	{ (LONG64)vbox__DHCPOption__NetBIOSNodeType, "NetBIOSNodeType" },
	{ (LONG64)vbox__DHCPOption__NetBIOSScope, "NetBIOSScope" },
	{ (LONG64)vbox__DHCPOption__XWindowsFontServers, "XWindowsFontServers" },
	{ (LONG64)vbox__DHCPOption__XWindowsDisplayManager, "XWindowsDisplayManager" },
	{ (LONG64)vbox__DHCPOption__NetWareIPDomainName, "NetWareIPDomainName" },
	{ (LONG64)vbox__DHCPOption__NetWareIPInformation, "NetWareIPInformation" },
	{ (LONG64)vbox__DHCPOption__NISPlusDomain, "NISPlusDomain" },
	{ (LONG64)vbox__DHCPOption__NISPlusServers, "NISPlusServers" },
	{ (LONG64)vbox__DHCPOption__TFTPServerName, "TFTPServerName" },
	{ (LONG64)vbox__DHCPOption__BootfileName, "BootfileName" },
	{ (LONG64)vbox__DHCPOption__MobileIPHomeAgents, "MobileIPHomeAgents" },
	{ (LONG64)vbox__DHCPOption__SMTPServers, "SMTPServers" },
	{ (LONG64)vbox__DHCPOption__POP3Servers, "POP3Servers" },
	{ (LONG64)vbox__DHCPOption__NNTPServers, "NNTPServers" },
	{ (LONG64)vbox__DHCPOption__WWWServers, "WWWServers" },
	{ (LONG64)vbox__DHCPOption__FingerServers, "FingerServers" },
	{ (LONG64)vbox__DHCPOption__IRCServers, "IRCServers" },
	{ (LONG64)vbox__DHCPOption__StreetTalkServers, "StreetTalkServers" },
	{ (LONG64)vbox__DHCPOption__STDAServers, "STDAServers" },
	{ (LONG64)vbox__DHCPOption__SLPDirectoryAgent, "SLPDirectoryAgent" },
	{ (LONG64)vbox__DHCPOption__SLPServiceScope, "SLPServiceScope" },
	{ (LONG64)vbox__DHCPOption__DomainSearch, "DomainSearch" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DHCPOption2s(struct soap *soap, enum vbox__DHCPOption n)
{
	const char *s = soap_code_str(soap_codes_vbox__DHCPOption, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DHCPOption(struct soap *soap, const char *tag, int id, const enum vbox__DHCPOption *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DHCPOption), type) || soap_send(soap, soap_vbox__DHCPOption2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DHCPOption(struct soap *soap, const char *s, enum vbox__DHCPOption *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DHCPOption, s);
	if (map)
		*a = (enum vbox__DHCPOption)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 66)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DHCPOption)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DHCPOption * SOAP_FMAC4 soap_in_vbox__DHCPOption(struct soap *soap, const char *tag, enum vbox__DHCPOption *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DHCPOption*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DHCPOption, sizeof(enum vbox__DHCPOption), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DHCPOption(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DHCPOption *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DHCPOption, SOAP_TYPE_vbox__DHCPOption, sizeof(enum vbox__DHCPOption), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DHCPOption * SOAP_FMAC4 soap_new_vbox__DHCPOption(struct soap *soap, int n)
{
	enum vbox__DHCPOption *a = static_cast<enum vbox__DHCPOption *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DHCPOption)));
	for (enum vbox__DHCPOption *p = a; p && n--; ++p)
		soap_default_vbox__DHCPOption(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DHCPOption(struct soap *soap, const enum vbox__DHCPOption *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DHCPOption(soap, tag ? tag : "vbox:DHCPOption", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DHCPOption * SOAP_FMAC4 soap_get_vbox__DHCPOption(struct soap *soap, enum vbox__DHCPOption *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DHCPOption(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__TrackedObjectState[] =
{	{ (LONG64)vbox__TrackedObjectState__None, "None" },
	{ (LONG64)vbox__TrackedObjectState__Alive, "Alive" },
	{ (LONG64)vbox__TrackedObjectState__Deleted, "Deleted" },
	{ (LONG64)vbox__TrackedObjectState__Invalid, "Invalid" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__TrackedObjectState2s(struct soap *soap, enum vbox__TrackedObjectState n)
{
	const char *s = soap_code_str(soap_codes_vbox__TrackedObjectState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__TrackedObjectState(struct soap *soap, const char *tag, int id, const enum vbox__TrackedObjectState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__TrackedObjectState), type) || soap_send(soap, soap_vbox__TrackedObjectState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__TrackedObjectState(struct soap *soap, const char *s, enum vbox__TrackedObjectState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__TrackedObjectState, s);
	if (map)
		*a = (enum vbox__TrackedObjectState)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__TrackedObjectState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__TrackedObjectState * SOAP_FMAC4 soap_in_vbox__TrackedObjectState(struct soap *soap, const char *tag, enum vbox__TrackedObjectState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__TrackedObjectState*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__TrackedObjectState, sizeof(enum vbox__TrackedObjectState), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__TrackedObjectState(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__TrackedObjectState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__TrackedObjectState, SOAP_TYPE_vbox__TrackedObjectState, sizeof(enum vbox__TrackedObjectState), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__TrackedObjectState * SOAP_FMAC4 soap_new_vbox__TrackedObjectState(struct soap *soap, int n)
{
	enum vbox__TrackedObjectState *a = static_cast<enum vbox__TrackedObjectState *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__TrackedObjectState)));
	for (enum vbox__TrackedObjectState *p = a; p && n--; ++p)
		soap_default_vbox__TrackedObjectState(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__TrackedObjectState(struct soap *soap, const enum vbox__TrackedObjectState *a, const char *tag, const char *type)
{
	if (soap_out_vbox__TrackedObjectState(soap, tag ? tag : "vbox:TrackedObjectState", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__TrackedObjectState * SOAP_FMAC4 soap_get_vbox__TrackedObjectState(struct soap *soap, enum vbox__TrackedObjectState *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__TrackedObjectState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__PartitionType[] =
{	{ (LONG64)vbox__PartitionType__Empty, "Empty" },
	{ (LONG64)vbox__PartitionType__FAT12, "FAT12" },
	{ (LONG64)vbox__PartitionType__FAT16, "FAT16" },
	{ (LONG64)vbox__PartitionType__FAT, "FAT" },
	{ (LONG64)vbox__PartitionType__IFS, "IFS" },
	{ (LONG64)vbox__PartitionType__FAT32CHS, "FAT32CHS" },
	{ (LONG64)vbox__PartitionType__FAT32LBA, "FAT32LBA" },
	{ (LONG64)vbox__PartitionType__FAT16B, "FAT16B" },
	{ (LONG64)vbox__PartitionType__Extended, "Extended" },
	{ (LONG64)vbox__PartitionType__WindowsRE, "WindowsRE" },
	{ (LONG64)vbox__PartitionType__LinuxSwapOld, "LinuxSwapOld" },
	{ (LONG64)vbox__PartitionType__LinuxOld, "LinuxOld" },
	{ (LONG64)vbox__PartitionType__DragonFlyBSDSlice, "DragonFlyBSDSlice" },
	{ (LONG64)vbox__PartitionType__LinuxSwap, "LinuxSwap" },
	{ (LONG64)vbox__PartitionType__Linux, "Linux" },
	{ (LONG64)vbox__PartitionType__LinuxExtended, "LinuxExtended" },
	{ (LONG64)vbox__PartitionType__LinuxLVM, "LinuxLVM" },
	{ (LONG64)vbox__PartitionType__BSDSlice, "BSDSlice" },
	{ (LONG64)vbox__PartitionType__AppleUFS, "AppleUFS" },
	{ (LONG64)vbox__PartitionType__AppleHFS, "AppleHFS" },
	{ (LONG64)vbox__PartitionType__Solaris, "Solaris" },
	{ (LONG64)vbox__PartitionType__GPT, "GPT" },
	{ (LONG64)vbox__PartitionType__EFI, "EFI" },
	{ (LONG64)vbox__PartitionType__Unknown, "Unknown" },
	{ (LONG64)vbox__PartitionType__MBR, "MBR" },
	{ (LONG64)vbox__PartitionType__iFFS, "iFFS" },
	{ (LONG64)vbox__PartitionType__SonyBoot, "SonyBoot" },
	{ (LONG64)vbox__PartitionType__LenovoBoot, "LenovoBoot" },
	{ (LONG64)vbox__PartitionType__WindowsMSR, "WindowsMSR" },
	{ (LONG64)vbox__PartitionType__WindowsBasicData, "WindowsBasicData" },
	{ (LONG64)vbox__PartitionType__WindowsLDMMeta, "WindowsLDMMeta" },
	{ (LONG64)vbox__PartitionType__WindowsLDMData, "WindowsLDMData" },
	{ (LONG64)vbox__PartitionType__WindowsRecovery, "WindowsRecovery" },
	{ (LONG64)vbox__PartitionType__WindowsStorageSpaces, "WindowsStorageSpaces" },
	{ (LONG64)vbox__PartitionType__WindowsStorageReplica, "WindowsStorageReplica" },
	{ (LONG64)vbox__PartitionType__IBMGPFS, "IBMGPFS" },
	{ (LONG64)vbox__PartitionType__LinuxData, "LinuxData" },
	{ (LONG64)vbox__PartitionType__LinuxRAID, "LinuxRAID" },
	{ (LONG64)vbox__PartitionType__LinuxRootX86, "LinuxRootX86" },
	{ (LONG64)vbox__PartitionType__LinuxRootAMD64, "LinuxRootAMD64" },
	{ (LONG64)vbox__PartitionType__LinuxRootARM32, "LinuxRootARM32" },
	{ (LONG64)vbox__PartitionType__LinuxRootARM64, "LinuxRootARM64" },
	{ (LONG64)vbox__PartitionType__LinuxHome, "LinuxHome" },
	{ (LONG64)vbox__PartitionType__LinuxSrv, "LinuxSrv" },
	{ (LONG64)vbox__PartitionType__LinuxPlainDmCrypt, "LinuxPlainDmCrypt" },
	{ (LONG64)vbox__PartitionType__LinuxLUKS, "LinuxLUKS" },
	{ (LONG64)vbox__PartitionType__LinuxReserved, "LinuxReserved" },
	{ (LONG64)vbox__PartitionType__FreeBSDBoot, "FreeBSDBoot" },
	{ (LONG64)vbox__PartitionType__FreeBSDData, "FreeBSDData" },
	{ (LONG64)vbox__PartitionType__FreeBSDSwap, "FreeBSDSwap" },
	{ (LONG64)vbox__PartitionType__FreeBSDUFS, "FreeBSDUFS" },
	{ (LONG64)vbox__PartitionType__FreeBSDVinum, "FreeBSDVinum" },
	{ (LONG64)vbox__PartitionType__FreeBSDZFS, "FreeBSDZFS" },
	{ (LONG64)vbox__PartitionType__FreeBSDUnknown, "FreeBSDUnknown" },
	{ (LONG64)vbox__PartitionType__AppleHFSPlus, "AppleHFSPlus" },
	{ (LONG64)vbox__PartitionType__AppleAPFS, "AppleAPFS" },
	{ (LONG64)vbox__PartitionType__AppleRAID, "AppleRAID" },
	{ (LONG64)vbox__PartitionType__AppleRAIDOffline, "AppleRAIDOffline" },
	{ (LONG64)vbox__PartitionType__AppleBoot, "AppleBoot" },
	{ (LONG64)vbox__PartitionType__AppleLabel, "AppleLabel" },
	{ (LONG64)vbox__PartitionType__AppleTvRecovery, "AppleTvRecovery" },
	{ (LONG64)vbox__PartitionType__AppleCoreStorage, "AppleCoreStorage" },
	{ (LONG64)vbox__PartitionType__SoftRAIDStatus, "SoftRAIDStatus" },
	{ (LONG64)vbox__PartitionType__SoftRAIDScratch, "SoftRAIDScratch" },
	{ (LONG64)vbox__PartitionType__SoftRAIDVolume, "SoftRAIDVolume" },
	{ (LONG64)vbox__PartitionType__SoftRAIDCache, "SoftRAIDCache" },
	{ (LONG64)vbox__PartitionType__AppleUnknown, "AppleUnknown" },
	{ (LONG64)vbox__PartitionType__SolarisBoot, "SolarisBoot" },
	{ (LONG64)vbox__PartitionType__SolarisRoot, "SolarisRoot" },
	{ (LONG64)vbox__PartitionType__SolarisSwap, "SolarisSwap" },
	{ (LONG64)vbox__PartitionType__SolarisBackup, "SolarisBackup" },
	{ (LONG64)vbox__PartitionType__SolarisUsr, "SolarisUsr" },
	{ (LONG64)vbox__PartitionType__SolarisVar, "SolarisVar" },
	{ (LONG64)vbox__PartitionType__SolarisHome, "SolarisHome" },
	{ (LONG64)vbox__PartitionType__SolarisAltSector, "SolarisAltSector" },
	{ (LONG64)vbox__PartitionType__SolarisReserved, "SolarisReserved" },
	{ (LONG64)vbox__PartitionType__SolarisUnknown, "SolarisUnknown" },
	{ (LONG64)vbox__PartitionType__NetBSDSwap, "NetBSDSwap" },
	{ (LONG64)vbox__PartitionType__NetBSDFFS, "NetBSDFFS" },
	{ (LONG64)vbox__PartitionType__NetBSDLFS, "NetBSDLFS" },
	{ (LONG64)vbox__PartitionType__NetBSDRAID, "NetBSDRAID" },
	{ (LONG64)vbox__PartitionType__NetBSDConcatenated, "NetBSDConcatenated" },
	{ (LONG64)vbox__PartitionType__NetBSDEncrypted, "NetBSDEncrypted" },
	{ (LONG64)vbox__PartitionType__NetBSDUnknown, "NetBSDUnknown" },
	{ (LONG64)vbox__PartitionType__ChromeOSKernel, "ChromeOSKernel" },
	{ (LONG64)vbox__PartitionType__ChromeOSRootFS, "ChromeOSRootFS" },
	{ (LONG64)vbox__PartitionType__ChromeOSFuture, "ChromeOSFuture" },
	{ (LONG64)vbox__PartitionType__ContLnxUsr, "ContLnxUsr" },
	{ (LONG64)vbox__PartitionType__ContLnxRoot, "ContLnxRoot" },
	{ (LONG64)vbox__PartitionType__ContLnxReserved, "ContLnxReserved" },
	{ (LONG64)vbox__PartitionType__ContLnxRootRAID, "ContLnxRootRAID" },
	{ (LONG64)vbox__PartitionType__HaikuBFS, "HaikuBFS" },
	{ (LONG64)vbox__PartitionType__MidntBSDBoot, "MidntBSDBoot" },
	{ (LONG64)vbox__PartitionType__MidntBSDData, "MidntBSDData" },
	{ (LONG64)vbox__PartitionType__MidntBSDSwap, "MidntBSDSwap" },
	{ (LONG64)vbox__PartitionType__MidntBSDUFS, "MidntBSDUFS" },
	{ (LONG64)vbox__PartitionType__MidntBSDVium, "MidntBSDVium" },
	{ (LONG64)vbox__PartitionType__MidntBSDZFS, "MidntBSDZFS" },
	{ (LONG64)vbox__PartitionType__MidntBSDUnknown, "MidntBSDUnknown" },
	{ (LONG64)vbox__PartitionType__OpenBSDData, "OpenBSDData" },
	{ (LONG64)vbox__PartitionType__QNXPowerSafeFS, "QNXPowerSafeFS" },
	{ (LONG64)vbox__PartitionType__Plan9, "Plan9" },
	{ (LONG64)vbox__PartitionType__VMWareVMKCore, "VMWareVMKCore" },
	{ (LONG64)vbox__PartitionType__VMWareVMFS, "VMWareVMFS" },
	{ (LONG64)vbox__PartitionType__VMWareReserved, "VMWareReserved" },
	{ (LONG64)vbox__PartitionType__VMWareUnknown, "VMWareUnknown" },
	{ (LONG64)vbox__PartitionType__AndroidX86Bootloader, "AndroidX86Bootloader" },
	{ (LONG64)vbox__PartitionType__AndroidX86Bootloader2, "AndroidX86Bootloader2" },
	{ (LONG64)vbox__PartitionType__AndroidX86Boot, "AndroidX86Boot" },
	{ (LONG64)vbox__PartitionType__AndroidX86Recovery, "AndroidX86Recovery" },
	{ (LONG64)vbox__PartitionType__AndroidX86Misc, "AndroidX86Misc" },
	{ (LONG64)vbox__PartitionType__AndroidX86Metadata, "AndroidX86Metadata" },
	{ (LONG64)vbox__PartitionType__AndroidX86System, "AndroidX86System" },
	{ (LONG64)vbox__PartitionType__AndroidX86Cache, "AndroidX86Cache" },
	{ (LONG64)vbox__PartitionType__AndroidX86Data, "AndroidX86Data" },
	{ (LONG64)vbox__PartitionType__AndroidX86Persistent, "AndroidX86Persistent" },
	{ (LONG64)vbox__PartitionType__AndroidX86Vendor, "AndroidX86Vendor" },
	{ (LONG64)vbox__PartitionType__AndroidX86Config, "AndroidX86Config" },
	{ (LONG64)vbox__PartitionType__AndroidX86Factory, "AndroidX86Factory" },
	{ (LONG64)vbox__PartitionType__AndroidX86FactoryAlt, "AndroidX86FactoryAlt" },
	{ (LONG64)vbox__PartitionType__AndroidX86Fastboot, "AndroidX86Fastboot" },
	{ (LONG64)vbox__PartitionType__AndroidX86OEM, "AndroidX86OEM" },
	{ (LONG64)vbox__PartitionType__AndroidARMMeta, "AndroidARMMeta" },
	{ (LONG64)vbox__PartitionType__AndroidARMExt, "AndroidARMExt" },
	{ (LONG64)vbox__PartitionType__ONIEBoot, "ONIEBoot" },
	{ (LONG64)vbox__PartitionType__ONIEConfig, "ONIEConfig" },
	{ (LONG64)vbox__PartitionType__PowerPCPrep, "PowerPCPrep" },
	{ (LONG64)vbox__PartitionType__XDGShrBootConfig, "XDGShrBootConfig" },
	{ (LONG64)vbox__PartitionType__CephBlock, "CephBlock" },
	{ (LONG64)vbox__PartitionType__CephBlockDB, "CephBlockDB" },
	{ (LONG64)vbox__PartitionType__CephBlockDBDmc, "CephBlockDBDmc" },
	{ (LONG64)vbox__PartitionType__CephBlockDBDmcLUKS, "CephBlockDBDmcLUKS" },
	{ (LONG64)vbox__PartitionType__CephBlockDmc, "CephBlockDmc" },
	{ (LONG64)vbox__PartitionType__CephBlockDmcLUKS, "CephBlockDmcLUKS" },
	{ (LONG64)vbox__PartitionType__CephBlockWALog, "CephBlockWALog" },
	{ (LONG64)vbox__PartitionType__CephBlockWALogDmc, "CephBlockWALogDmc" },
	{ (LONG64)vbox__PartitionType__CephBlockWALogDmcLUKS, "CephBlockWALogDmcLUKS" },
	{ (LONG64)vbox__PartitionType__CephDisk, "CephDisk" },
	{ (LONG64)vbox__PartitionType__CephDiskDmc, "CephDiskDmc" },
	{ (LONG64)vbox__PartitionType__CephJournal, "CephJournal" },
	{ (LONG64)vbox__PartitionType__CephJournalDmc, "CephJournalDmc" },
	{ (LONG64)vbox__PartitionType__CephJournalDmcLUKS, "CephJournalDmcLUKS" },
	{ (LONG64)vbox__PartitionType__CephLockbox, "CephLockbox" },
	{ (LONG64)vbox__PartitionType__CephMultipathBlock1, "CephMultipathBlock1" },
	{ (LONG64)vbox__PartitionType__CephMultipathBlock2, "CephMultipathBlock2" },
	{ (LONG64)vbox__PartitionType__CephMultipathBlockDB, "CephMultipathBlockDB" },
	{ (LONG64)vbox__PartitionType__CephMultipathBLockWALog, "CephMultipathBLockWALog" },
	{ (LONG64)vbox__PartitionType__CephMultipathJournal, "CephMultipathJournal" },
	{ (LONG64)vbox__PartitionType__CephMultipathOSD, "CephMultipathOSD" },
	{ (LONG64)vbox__PartitionType__CephOSD, "CephOSD" },
	{ (LONG64)vbox__PartitionType__CephOSDDmc, "CephOSDDmc" },
	{ (LONG64)vbox__PartitionType__CephOSDDmcLUKS, "CephOSDDmcLUKS" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__PartitionType2s(struct soap *soap, enum vbox__PartitionType n)
{
	const char *s = soap_code_str(soap_codes_vbox__PartitionType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__PartitionType(struct soap *soap, const char *tag, int id, const enum vbox__PartitionType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__PartitionType), type) || soap_send(soap, soap_vbox__PartitionType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__PartitionType(struct soap *soap, const char *s, enum vbox__PartitionType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__PartitionType, s);
	if (map)
		*a = (enum vbox__PartitionType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 151)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__PartitionType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__PartitionType * SOAP_FMAC4 soap_in_vbox__PartitionType(struct soap *soap, const char *tag, enum vbox__PartitionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__PartitionType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__PartitionType, sizeof(enum vbox__PartitionType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__PartitionType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__PartitionType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__PartitionType, SOAP_TYPE_vbox__PartitionType, sizeof(enum vbox__PartitionType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__PartitionType * SOAP_FMAC4 soap_new_vbox__PartitionType(struct soap *soap, int n)
{
	enum vbox__PartitionType *a = static_cast<enum vbox__PartitionType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__PartitionType)));
	for (enum vbox__PartitionType *p = a; p && n--; ++p)
		soap_default_vbox__PartitionType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__PartitionType(struct soap *soap, const enum vbox__PartitionType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__PartitionType(soap, tag ? tag : "vbox:PartitionType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__PartitionType * SOAP_FMAC4 soap_get_vbox__PartitionType(struct soap *soap, enum vbox__PartitionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__PartitionType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__PartitioningType[] =
{	{ (LONG64)vbox__PartitioningType__MBR, "MBR" },
	{ (LONG64)vbox__PartitioningType__GPT, "GPT" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__PartitioningType2s(struct soap *soap, enum vbox__PartitioningType n)
{
	const char *s = soap_code_str(soap_codes_vbox__PartitioningType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__PartitioningType(struct soap *soap, const char *tag, int id, const enum vbox__PartitioningType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__PartitioningType), type) || soap_send(soap, soap_vbox__PartitioningType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__PartitioningType(struct soap *soap, const char *s, enum vbox__PartitioningType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__PartitioningType, s);
	if (map)
		*a = (enum vbox__PartitioningType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__PartitioningType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__PartitioningType * SOAP_FMAC4 soap_in_vbox__PartitioningType(struct soap *soap, const char *tag, enum vbox__PartitioningType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__PartitioningType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__PartitioningType, sizeof(enum vbox__PartitioningType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__PartitioningType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__PartitioningType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__PartitioningType, SOAP_TYPE_vbox__PartitioningType, sizeof(enum vbox__PartitioningType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__PartitioningType * SOAP_FMAC4 soap_new_vbox__PartitioningType(struct soap *soap, int n)
{
	enum vbox__PartitioningType *a = static_cast<enum vbox__PartitioningType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__PartitioningType)));
	for (enum vbox__PartitioningType *p = a; p && n--; ++p)
		soap_default_vbox__PartitioningType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__PartitioningType(struct soap *soap, const enum vbox__PartitioningType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__PartitioningType(soap, tag ? tag : "vbox:PartitioningType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__PartitioningType * SOAP_FMAC4 soap_get_vbox__PartitioningType(struct soap *soap, enum vbox__PartitioningType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__PartitioningType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__BitmapFormat[] =
{	{ (LONG64)vbox__BitmapFormat__Opaque, "Opaque" },
	{ (LONG64)vbox__BitmapFormat__BGR, "BGR" },
	{ (LONG64)vbox__BitmapFormat__BGR0, "BGR0" },
	{ (LONG64)vbox__BitmapFormat__BGRA, "BGRA" },
	{ (LONG64)vbox__BitmapFormat__RGBA, "RGBA" },
	{ (LONG64)vbox__BitmapFormat__PNG, "PNG" },
	{ (LONG64)vbox__BitmapFormat__JPEG, "JPEG" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__BitmapFormat2s(struct soap *soap, enum vbox__BitmapFormat n)
{
	const char *s = soap_code_str(soap_codes_vbox__BitmapFormat, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__BitmapFormat(struct soap *soap, const char *tag, int id, const enum vbox__BitmapFormat *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__BitmapFormat), type) || soap_send(soap, soap_vbox__BitmapFormat2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__BitmapFormat(struct soap *soap, const char *s, enum vbox__BitmapFormat *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__BitmapFormat, s);
	if (map)
		*a = (enum vbox__BitmapFormat)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 6)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__BitmapFormat)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__BitmapFormat * SOAP_FMAC4 soap_in_vbox__BitmapFormat(struct soap *soap, const char *tag, enum vbox__BitmapFormat *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__BitmapFormat*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__BitmapFormat, sizeof(enum vbox__BitmapFormat), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__BitmapFormat(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__BitmapFormat *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__BitmapFormat, SOAP_TYPE_vbox__BitmapFormat, sizeof(enum vbox__BitmapFormat), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__BitmapFormat * SOAP_FMAC4 soap_new_vbox__BitmapFormat(struct soap *soap, int n)
{
	enum vbox__BitmapFormat *a = static_cast<enum vbox__BitmapFormat *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__BitmapFormat)));
	for (enum vbox__BitmapFormat *p = a; p && n--; ++p)
		soap_default_vbox__BitmapFormat(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__BitmapFormat(struct soap *soap, const enum vbox__BitmapFormat *a, const char *tag, const char *type)
{
	if (soap_out_vbox__BitmapFormat(soap, tag ? tag : "vbox:BitmapFormat", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__BitmapFormat * SOAP_FMAC4 soap_get_vbox__BitmapFormat(struct soap *soap, enum vbox__BitmapFormat *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__BitmapFormat(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__KeyboardHIDType[] =
{	{ (LONG64)vbox__KeyboardHIDType__None, "None" },
	{ (LONG64)vbox__KeyboardHIDType__PS2Keyboard, "PS2Keyboard" },
	{ (LONG64)vbox__KeyboardHIDType__USBKeyboard, "USBKeyboard" },
	{ (LONG64)vbox__KeyboardHIDType__ComboKeyboard, "ComboKeyboard" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__KeyboardHIDType2s(struct soap *soap, enum vbox__KeyboardHIDType n)
{
	const char *s = soap_code_str(soap_codes_vbox__KeyboardHIDType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__KeyboardHIDType(struct soap *soap, const char *tag, int id, const enum vbox__KeyboardHIDType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__KeyboardHIDType), type) || soap_send(soap, soap_vbox__KeyboardHIDType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__KeyboardHIDType(struct soap *soap, const char *s, enum vbox__KeyboardHIDType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__KeyboardHIDType, s);
	if (map)
		*a = (enum vbox__KeyboardHIDType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__KeyboardHIDType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__KeyboardHIDType * SOAP_FMAC4 soap_in_vbox__KeyboardHIDType(struct soap *soap, const char *tag, enum vbox__KeyboardHIDType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__KeyboardHIDType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__KeyboardHIDType, sizeof(enum vbox__KeyboardHIDType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__KeyboardHIDType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__KeyboardHIDType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__KeyboardHIDType, SOAP_TYPE_vbox__KeyboardHIDType, sizeof(enum vbox__KeyboardHIDType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__KeyboardHIDType * SOAP_FMAC4 soap_new_vbox__KeyboardHIDType(struct soap *soap, int n)
{
	enum vbox__KeyboardHIDType *a = static_cast<enum vbox__KeyboardHIDType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__KeyboardHIDType)));
	for (enum vbox__KeyboardHIDType *p = a; p && n--; ++p)
		soap_default_vbox__KeyboardHIDType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__KeyboardHIDType(struct soap *soap, const enum vbox__KeyboardHIDType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__KeyboardHIDType(soap, tag ? tag : "vbox:KeyboardHIDType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__KeyboardHIDType * SOAP_FMAC4 soap_get_vbox__KeyboardHIDType(struct soap *soap, enum vbox__KeyboardHIDType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__KeyboardHIDType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__PointingHIDType[] =
{	{ (LONG64)vbox__PointingHIDType__None, "None" },
	{ (LONG64)vbox__PointingHIDType__PS2Mouse, "PS2Mouse" },
	{ (LONG64)vbox__PointingHIDType__USBMouse, "USBMouse" },
	{ (LONG64)vbox__PointingHIDType__USBTablet, "USBTablet" },
	{ (LONG64)vbox__PointingHIDType__ComboMouse, "ComboMouse" },
	{ (LONG64)vbox__PointingHIDType__USBMultiTouch, "USBMultiTouch" },
	{ (LONG64)vbox__PointingHIDType__USBMultiTouchScreenPlusPad, "USBMultiTouchScreenPlusPad" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__PointingHIDType2s(struct soap *soap, enum vbox__PointingHIDType n)
{
	const char *s = soap_code_str(soap_codes_vbox__PointingHIDType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__PointingHIDType(struct soap *soap, const char *tag, int id, const enum vbox__PointingHIDType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__PointingHIDType), type) || soap_send(soap, soap_vbox__PointingHIDType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__PointingHIDType(struct soap *soap, const char *s, enum vbox__PointingHIDType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__PointingHIDType, s);
	if (map)
		*a = (enum vbox__PointingHIDType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 6)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__PointingHIDType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__PointingHIDType * SOAP_FMAC4 soap_in_vbox__PointingHIDType(struct soap *soap, const char *tag, enum vbox__PointingHIDType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__PointingHIDType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__PointingHIDType, sizeof(enum vbox__PointingHIDType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__PointingHIDType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__PointingHIDType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__PointingHIDType, SOAP_TYPE_vbox__PointingHIDType, sizeof(enum vbox__PointingHIDType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__PointingHIDType * SOAP_FMAC4 soap_new_vbox__PointingHIDType(struct soap *soap, int n)
{
	enum vbox__PointingHIDType *a = static_cast<enum vbox__PointingHIDType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__PointingHIDType)));
	for (enum vbox__PointingHIDType *p = a; p && n--; ++p)
		soap_default_vbox__PointingHIDType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__PointingHIDType(struct soap *soap, const enum vbox__PointingHIDType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__PointingHIDType(soap, tag ? tag : "vbox:PointingHIDType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__PointingHIDType * SOAP_FMAC4 soap_get_vbox__PointingHIDType(struct soap *soap, enum vbox__PointingHIDType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__PointingHIDType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FirmwareType[] =
{	{ (LONG64)vbox__FirmwareType__BIOS, "BIOS" },
	{ (LONG64)vbox__FirmwareType__EFI, "EFI" },
	{ (LONG64)vbox__FirmwareType__EFI32, "EFI32" },
	{ (LONG64)vbox__FirmwareType__EFI64, "EFI64" },
	{ (LONG64)vbox__FirmwareType__EFIDUAL, "EFIDUAL" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FirmwareType2s(struct soap *soap, enum vbox__FirmwareType n)
{
	const char *s = soap_code_str(soap_codes_vbox__FirmwareType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FirmwareType(struct soap *soap, const char *tag, int id, const enum vbox__FirmwareType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FirmwareType), type) || soap_send(soap, soap_vbox__FirmwareType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FirmwareType(struct soap *soap, const char *s, enum vbox__FirmwareType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FirmwareType, s);
	if (map)
		*a = (enum vbox__FirmwareType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FirmwareType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FirmwareType * SOAP_FMAC4 soap_in_vbox__FirmwareType(struct soap *soap, const char *tag, enum vbox__FirmwareType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FirmwareType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FirmwareType, sizeof(enum vbox__FirmwareType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FirmwareType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FirmwareType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FirmwareType, SOAP_TYPE_vbox__FirmwareType, sizeof(enum vbox__FirmwareType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FirmwareType * SOAP_FMAC4 soap_new_vbox__FirmwareType(struct soap *soap, int n)
{
	enum vbox__FirmwareType *a = static_cast<enum vbox__FirmwareType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FirmwareType)));
	for (enum vbox__FirmwareType *p = a; p && n--; ++p)
		soap_default_vbox__FirmwareType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FirmwareType(struct soap *soap, const enum vbox__FirmwareType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FirmwareType(soap, tag ? tag : "vbox:FirmwareType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FirmwareType * SOAP_FMAC4 soap_get_vbox__FirmwareType(struct soap *soap, enum vbox__FirmwareType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FirmwareType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ProcessorFeature[] =
{	{ (LONG64)vbox__ProcessorFeature__HWVirtEx, "HWVirtEx" },
	{ (LONG64)vbox__ProcessorFeature__PAE, "PAE" },
	{ (LONG64)vbox__ProcessorFeature__LongMode, "LongMode" },
	{ (LONG64)vbox__ProcessorFeature__NestedPaging, "NestedPaging" },
	{ (LONG64)vbox__ProcessorFeature__UnrestrictedGuest, "UnrestrictedGuest" },
	{ (LONG64)vbox__ProcessorFeature__NestedHWVirt, "NestedHWVirt" },
	{ (LONG64)vbox__ProcessorFeature__VirtVmsaveVmload, "VirtVmsaveVmload" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ProcessorFeature2s(struct soap *soap, enum vbox__ProcessorFeature n)
{
	const char *s = soap_code_str(soap_codes_vbox__ProcessorFeature, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ProcessorFeature(struct soap *soap, const char *tag, int id, const enum vbox__ProcessorFeature *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ProcessorFeature), type) || soap_send(soap, soap_vbox__ProcessorFeature2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ProcessorFeature(struct soap *soap, const char *s, enum vbox__ProcessorFeature *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ProcessorFeature, s);
	if (map)
		*a = (enum vbox__ProcessorFeature)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 6)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ProcessorFeature)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ProcessorFeature * SOAP_FMAC4 soap_in_vbox__ProcessorFeature(struct soap *soap, const char *tag, enum vbox__ProcessorFeature *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ProcessorFeature*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ProcessorFeature, sizeof(enum vbox__ProcessorFeature), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ProcessorFeature(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ProcessorFeature *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ProcessorFeature, SOAP_TYPE_vbox__ProcessorFeature, sizeof(enum vbox__ProcessorFeature), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ProcessorFeature * SOAP_FMAC4 soap_new_vbox__ProcessorFeature(struct soap *soap, int n)
{
	enum vbox__ProcessorFeature *a = static_cast<enum vbox__ProcessorFeature *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ProcessorFeature)));
	for (enum vbox__ProcessorFeature *p = a; p && n--; ++p)
		soap_default_vbox__ProcessorFeature(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ProcessorFeature(struct soap *soap, const enum vbox__ProcessorFeature *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ProcessorFeature(soap, tag ? tag : "vbox:ProcessorFeature", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ProcessorFeature * SOAP_FMAC4 soap_get_vbox__ProcessorFeature(struct soap *soap, enum vbox__ProcessorFeature *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ProcessorFeature(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__APICMode[] =
{	{ (LONG64)vbox__APICMode__Disabled, "Disabled" },
	{ (LONG64)vbox__APICMode__APIC, "APIC" },
	{ (LONG64)vbox__APICMode__X2APIC, "X2APIC" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__APICMode2s(struct soap *soap, enum vbox__APICMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__APICMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__APICMode(struct soap *soap, const char *tag, int id, const enum vbox__APICMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__APICMode), type) || soap_send(soap, soap_vbox__APICMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__APICMode(struct soap *soap, const char *s, enum vbox__APICMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__APICMode, s);
	if (map)
		*a = (enum vbox__APICMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__APICMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__APICMode * SOAP_FMAC4 soap_in_vbox__APICMode(struct soap *soap, const char *tag, enum vbox__APICMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__APICMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__APICMode, sizeof(enum vbox__APICMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__APICMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__APICMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__APICMode, SOAP_TYPE_vbox__APICMode, sizeof(enum vbox__APICMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__APICMode * SOAP_FMAC4 soap_new_vbox__APICMode(struct soap *soap, int n)
{
	enum vbox__APICMode *a = static_cast<enum vbox__APICMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__APICMode)));
	for (enum vbox__APICMode *p = a; p && n--; ++p)
		soap_default_vbox__APICMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__APICMode(struct soap *soap, const enum vbox__APICMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__APICMode(soap, tag ? tag : "vbox:APICMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__APICMode * SOAP_FMAC4 soap_get_vbox__APICMode(struct soap *soap, enum vbox__APICMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__APICMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__FirmwareBootMenuMode[] =
{	{ (LONG64)vbox__FirmwareBootMenuMode__Disabled, "Disabled" },
	{ (LONG64)vbox__FirmwareBootMenuMode__MenuOnly, "MenuOnly" },
	{ (LONG64)vbox__FirmwareBootMenuMode__MessageAndMenu, "MessageAndMenu" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__FirmwareBootMenuMode2s(struct soap *soap, enum vbox__FirmwareBootMenuMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__FirmwareBootMenuMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__FirmwareBootMenuMode(struct soap *soap, const char *tag, int id, const enum vbox__FirmwareBootMenuMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__FirmwareBootMenuMode), type) || soap_send(soap, soap_vbox__FirmwareBootMenuMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__FirmwareBootMenuMode(struct soap *soap, const char *s, enum vbox__FirmwareBootMenuMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__FirmwareBootMenuMode, s);
	if (map)
		*a = (enum vbox__FirmwareBootMenuMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__FirmwareBootMenuMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__FirmwareBootMenuMode * SOAP_FMAC4 soap_in_vbox__FirmwareBootMenuMode(struct soap *soap, const char *tag, enum vbox__FirmwareBootMenuMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__FirmwareBootMenuMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__FirmwareBootMenuMode, sizeof(enum vbox__FirmwareBootMenuMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__FirmwareBootMenuMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__FirmwareBootMenuMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__FirmwareBootMenuMode, SOAP_TYPE_vbox__FirmwareBootMenuMode, sizeof(enum vbox__FirmwareBootMenuMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__FirmwareBootMenuMode * SOAP_FMAC4 soap_new_vbox__FirmwareBootMenuMode(struct soap *soap, int n)
{
	enum vbox__FirmwareBootMenuMode *a = static_cast<enum vbox__FirmwareBootMenuMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__FirmwareBootMenuMode)));
	for (enum vbox__FirmwareBootMenuMode *p = a; p && n--; ++p)
		soap_default_vbox__FirmwareBootMenuMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__FirmwareBootMenuMode(struct soap *soap, const enum vbox__FirmwareBootMenuMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__FirmwareBootMenuMode(soap, tag ? tag : "vbox:FirmwareBootMenuMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__FirmwareBootMenuMode * SOAP_FMAC4 soap_get_vbox__FirmwareBootMenuMode(struct soap *soap, enum vbox__FirmwareBootMenuMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__FirmwareBootMenuMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__Scope[] =
{	{ (LONG64)vbox__Scope__Global, "Global" },
	{ (LONG64)vbox__Scope__Machine, "Machine" },
	{ (LONG64)vbox__Scope__Session, "Session" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__Scope2s(struct soap *soap, enum vbox__Scope n)
{
	const char *s = soap_code_str(soap_codes_vbox__Scope, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__Scope(struct soap *soap, const char *tag, int id, const enum vbox__Scope *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__Scope), type) || soap_send(soap, soap_vbox__Scope2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__Scope(struct soap *soap, const char *s, enum vbox__Scope *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__Scope, s);
	if (map)
		*a = (enum vbox__Scope)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__Scope)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__Scope * SOAP_FMAC4 soap_in_vbox__Scope(struct soap *soap, const char *tag, enum vbox__Scope *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__Scope*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__Scope, sizeof(enum vbox__Scope), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__Scope(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__Scope *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__Scope, SOAP_TYPE_vbox__Scope, sizeof(enum vbox__Scope), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__Scope * SOAP_FMAC4 soap_new_vbox__Scope(struct soap *soap, int n)
{
	enum vbox__Scope *a = static_cast<enum vbox__Scope *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__Scope)));
	for (enum vbox__Scope *p = a; p && n--; ++p)
		soap_default_vbox__Scope(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__Scope(struct soap *soap, const enum vbox__Scope *a, const char *tag, const char *type)
{
	if (soap_out_vbox__Scope(soap, tag ? tag : "vbox:Scope", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__Scope * SOAP_FMAC4 soap_get_vbox__Scope(struct soap *soap, enum vbox__Scope *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__Scope(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DnDMode[] =
{	{ (LONG64)vbox__DnDMode__Disabled, "Disabled" },
	{ (LONG64)vbox__DnDMode__HostToGuest, "HostToGuest" },
	{ (LONG64)vbox__DnDMode__GuestToHost, "GuestToHost" },
	{ (LONG64)vbox__DnDMode__Bidirectional, "Bidirectional" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DnDMode2s(struct soap *soap, enum vbox__DnDMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__DnDMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DnDMode(struct soap *soap, const char *tag, int id, const enum vbox__DnDMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DnDMode), type) || soap_send(soap, soap_vbox__DnDMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DnDMode(struct soap *soap, const char *s, enum vbox__DnDMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DnDMode, s);
	if (map)
		*a = (enum vbox__DnDMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DnDMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DnDMode * SOAP_FMAC4 soap_in_vbox__DnDMode(struct soap *soap, const char *tag, enum vbox__DnDMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DnDMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DnDMode, sizeof(enum vbox__DnDMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DnDMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DnDMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DnDMode, SOAP_TYPE_vbox__DnDMode, sizeof(enum vbox__DnDMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DnDMode * SOAP_FMAC4 soap_new_vbox__DnDMode(struct soap *soap, int n)
{
	enum vbox__DnDMode *a = static_cast<enum vbox__DnDMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DnDMode)));
	for (enum vbox__DnDMode *p = a; p && n--; ++p)
		soap_default_vbox__DnDMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DnDMode(struct soap *soap, const enum vbox__DnDMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DnDMode(soap, tag ? tag : "vbox:DnDMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DnDMode * SOAP_FMAC4 soap_get_vbox__DnDMode(struct soap *soap, enum vbox__DnDMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DnDMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ClipboardMode[] =
{	{ (LONG64)vbox__ClipboardMode__Disabled, "Disabled" },
	{ (LONG64)vbox__ClipboardMode__HostToGuest, "HostToGuest" },
	{ (LONG64)vbox__ClipboardMode__GuestToHost, "GuestToHost" },
	{ (LONG64)vbox__ClipboardMode__Bidirectional, "Bidirectional" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ClipboardMode2s(struct soap *soap, enum vbox__ClipboardMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__ClipboardMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ClipboardMode(struct soap *soap, const char *tag, int id, const enum vbox__ClipboardMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ClipboardMode), type) || soap_send(soap, soap_vbox__ClipboardMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ClipboardMode(struct soap *soap, const char *s, enum vbox__ClipboardMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ClipboardMode, s);
	if (map)
		*a = (enum vbox__ClipboardMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ClipboardMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ClipboardMode * SOAP_FMAC4 soap_in_vbox__ClipboardMode(struct soap *soap, const char *tag, enum vbox__ClipboardMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ClipboardMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ClipboardMode, sizeof(enum vbox__ClipboardMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ClipboardMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ClipboardMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ClipboardMode, SOAP_TYPE_vbox__ClipboardMode, sizeof(enum vbox__ClipboardMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ClipboardMode * SOAP_FMAC4 soap_new_vbox__ClipboardMode(struct soap *soap, int n)
{
	enum vbox__ClipboardMode *a = static_cast<enum vbox__ClipboardMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ClipboardMode)));
	for (enum vbox__ClipboardMode *p = a; p && n--; ++p)
		soap_default_vbox__ClipboardMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ClipboardMode(struct soap *soap, const enum vbox__ClipboardMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ClipboardMode(soap, tag ? tag : "vbox:ClipboardMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ClipboardMode * SOAP_FMAC4 soap_get_vbox__ClipboardMode(struct soap *soap, enum vbox__ClipboardMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ClipboardMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DeviceActivity[] =
{	{ (LONG64)vbox__DeviceActivity__Null, "Null" },
	{ (LONG64)vbox__DeviceActivity__Idle, "Idle" },
	{ (LONG64)vbox__DeviceActivity__Reading, "Reading" },
	{ (LONG64)vbox__DeviceActivity__Writing, "Writing" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DeviceActivity2s(struct soap *soap, enum vbox__DeviceActivity n)
{
	const char *s = soap_code_str(soap_codes_vbox__DeviceActivity, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DeviceActivity(struct soap *soap, const char *tag, int id, const enum vbox__DeviceActivity *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DeviceActivity), type) || soap_send(soap, soap_vbox__DeviceActivity2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DeviceActivity(struct soap *soap, const char *s, enum vbox__DeviceActivity *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DeviceActivity, s);
	if (map)
		*a = (enum vbox__DeviceActivity)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DeviceActivity)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DeviceActivity * SOAP_FMAC4 soap_in_vbox__DeviceActivity(struct soap *soap, const char *tag, enum vbox__DeviceActivity *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DeviceActivity*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DeviceActivity, sizeof(enum vbox__DeviceActivity), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DeviceActivity(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DeviceActivity *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DeviceActivity, SOAP_TYPE_vbox__DeviceActivity, sizeof(enum vbox__DeviceActivity), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DeviceActivity * SOAP_FMAC4 soap_new_vbox__DeviceActivity(struct soap *soap, int n)
{
	enum vbox__DeviceActivity *a = static_cast<enum vbox__DeviceActivity *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DeviceActivity)));
	for (enum vbox__DeviceActivity *p = a; p && n--; ++p)
		soap_default_vbox__DeviceActivity(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DeviceActivity(struct soap *soap, const enum vbox__DeviceActivity *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DeviceActivity(soap, tag ? tag : "vbox:DeviceActivity", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DeviceActivity * SOAP_FMAC4 soap_get_vbox__DeviceActivity(struct soap *soap, enum vbox__DeviceActivity *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DeviceActivity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__DeviceType[] =
{	{ (LONG64)vbox__DeviceType__Null, "Null" },
	{ (LONG64)vbox__DeviceType__Floppy, "Floppy" },
	{ (LONG64)vbox__DeviceType__DVD, "DVD" },
	{ (LONG64)vbox__DeviceType__HardDisk, "HardDisk" },
	{ (LONG64)vbox__DeviceType__Network, "Network" },
	{ (LONG64)vbox__DeviceType__USB, "USB" },
	{ (LONG64)vbox__DeviceType__SharedFolder, "SharedFolder" },
	{ (LONG64)vbox__DeviceType__Graphics3D, "Graphics3D" },
	{ (LONG64)vbox__DeviceType__End, "End" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__DeviceType2s(struct soap *soap, enum vbox__DeviceType n)
{
	const char *s = soap_code_str(soap_codes_vbox__DeviceType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__DeviceType(struct soap *soap, const char *tag, int id, const enum vbox__DeviceType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__DeviceType), type) || soap_send(soap, soap_vbox__DeviceType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__DeviceType(struct soap *soap, const char *s, enum vbox__DeviceType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__DeviceType, s);
	if (map)
		*a = (enum vbox__DeviceType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 8)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__DeviceType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__DeviceType * SOAP_FMAC4 soap_in_vbox__DeviceType(struct soap *soap, const char *tag, enum vbox__DeviceType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__DeviceType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__DeviceType, sizeof(enum vbox__DeviceType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__DeviceType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__DeviceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__DeviceType, SOAP_TYPE_vbox__DeviceType, sizeof(enum vbox__DeviceType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__DeviceType * SOAP_FMAC4 soap_new_vbox__DeviceType(struct soap *soap, int n)
{
	enum vbox__DeviceType *a = static_cast<enum vbox__DeviceType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__DeviceType)));
	for (enum vbox__DeviceType *p = a; p && n--; ++p)
		soap_default_vbox__DeviceType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__DeviceType(struct soap *soap, const enum vbox__DeviceType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__DeviceType(soap, tag ? tag : "vbox:DeviceType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__DeviceType * SOAP_FMAC4 soap_get_vbox__DeviceType(struct soap *soap, enum vbox__DeviceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__DeviceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__SessionType[] =
{	{ (LONG64)vbox__SessionType__Null, "Null" },
	{ (LONG64)vbox__SessionType__WriteLock, "WriteLock" },
	{ (LONG64)vbox__SessionType__Remote, "Remote" },
	{ (LONG64)vbox__SessionType__Shared, "Shared" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__SessionType2s(struct soap *soap, enum vbox__SessionType n)
{
	const char *s = soap_code_str(soap_codes_vbox__SessionType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__SessionType(struct soap *soap, const char *tag, int id, const enum vbox__SessionType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__SessionType), type) || soap_send(soap, soap_vbox__SessionType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__SessionType(struct soap *soap, const char *s, enum vbox__SessionType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__SessionType, s);
	if (map)
		*a = (enum vbox__SessionType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__SessionType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__SessionType * SOAP_FMAC4 soap_in_vbox__SessionType(struct soap *soap, const char *tag, enum vbox__SessionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__SessionType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__SessionType, sizeof(enum vbox__SessionType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__SessionType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__SessionType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__SessionType, SOAP_TYPE_vbox__SessionType, sizeof(enum vbox__SessionType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__SessionType * SOAP_FMAC4 soap_new_vbox__SessionType(struct soap *soap, int n)
{
	enum vbox__SessionType *a = static_cast<enum vbox__SessionType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__SessionType)));
	for (enum vbox__SessionType *p = a; p && n--; ++p)
		soap_default_vbox__SessionType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__SessionType(struct soap *soap, const enum vbox__SessionType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__SessionType(soap, tag ? tag : "vbox:SessionType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__SessionType * SOAP_FMAC4 soap_get_vbox__SessionType(struct soap *soap, enum vbox__SessionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__SessionType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__LockType[] =
{	{ (LONG64)vbox__LockType__Null, "Null" },
	{ (LONG64)vbox__LockType__Shared, "Shared" },
	{ (LONG64)vbox__LockType__Write, "Write" },
	{ (LONG64)vbox__LockType__VM, "VM" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__LockType2s(struct soap *soap, enum vbox__LockType n)
{
	const char *s = soap_code_str(soap_codes_vbox__LockType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__LockType(struct soap *soap, const char *tag, int id, const enum vbox__LockType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__LockType), type) || soap_send(soap, soap_vbox__LockType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__LockType(struct soap *soap, const char *s, enum vbox__LockType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__LockType, s);
	if (map)
		*a = (enum vbox__LockType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 3)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__LockType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__LockType * SOAP_FMAC4 soap_in_vbox__LockType(struct soap *soap, const char *tag, enum vbox__LockType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__LockType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__LockType, sizeof(enum vbox__LockType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__LockType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__LockType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__LockType, SOAP_TYPE_vbox__LockType, sizeof(enum vbox__LockType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__LockType * SOAP_FMAC4 soap_new_vbox__LockType(struct soap *soap, int n)
{
	enum vbox__LockType *a = static_cast<enum vbox__LockType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__LockType)));
	for (enum vbox__LockType *p = a; p && n--; ++p)
		soap_default_vbox__LockType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__LockType(struct soap *soap, const enum vbox__LockType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__LockType(soap, tag ? tag : "vbox:LockType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__LockType * SOAP_FMAC4 soap_get_vbox__LockType(struct soap *soap, enum vbox__LockType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__LockType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__ParavirtProvider[] =
{	{ (LONG64)vbox__ParavirtProvider__None, "None" },
	{ (LONG64)vbox__ParavirtProvider__Default, "Default" },
	{ (LONG64)vbox__ParavirtProvider__Legacy, "Legacy" },
	{ (LONG64)vbox__ParavirtProvider__Minimal, "Minimal" },
	{ (LONG64)vbox__ParavirtProvider__HyperV, "HyperV" },
	{ (LONG64)vbox__ParavirtProvider__KVM, "KVM" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__ParavirtProvider2s(struct soap *soap, enum vbox__ParavirtProvider n)
{
	const char *s = soap_code_str(soap_codes_vbox__ParavirtProvider, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__ParavirtProvider(struct soap *soap, const char *tag, int id, const enum vbox__ParavirtProvider *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__ParavirtProvider), type) || soap_send(soap, soap_vbox__ParavirtProvider2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__ParavirtProvider(struct soap *soap, const char *s, enum vbox__ParavirtProvider *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__ParavirtProvider, s);
	if (map)
		*a = (enum vbox__ParavirtProvider)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 5)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__ParavirtProvider)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__ParavirtProvider * SOAP_FMAC4 soap_in_vbox__ParavirtProvider(struct soap *soap, const char *tag, enum vbox__ParavirtProvider *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__ParavirtProvider*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__ParavirtProvider, sizeof(enum vbox__ParavirtProvider), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__ParavirtProvider(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__ParavirtProvider *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__ParavirtProvider, SOAP_TYPE_vbox__ParavirtProvider, sizeof(enum vbox__ParavirtProvider), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__ParavirtProvider * SOAP_FMAC4 soap_new_vbox__ParavirtProvider(struct soap *soap, int n)
{
	enum vbox__ParavirtProvider *a = static_cast<enum vbox__ParavirtProvider *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__ParavirtProvider)));
	for (enum vbox__ParavirtProvider *p = a; p && n--; ++p)
		soap_default_vbox__ParavirtProvider(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__ParavirtProvider(struct soap *soap, const enum vbox__ParavirtProvider *a, const char *tag, const char *type)
{
	if (soap_out_vbox__ParavirtProvider(soap, tag ? tag : "vbox:ParavirtProvider", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__ParavirtProvider * SOAP_FMAC4 soap_get_vbox__ParavirtProvider(struct soap *soap, enum vbox__ParavirtProvider *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__ParavirtProvider(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__HWVirtExPropertyType[] =
{	{ (LONG64)vbox__HWVirtExPropertyType__Null, "Null" },
	{ (LONG64)vbox__HWVirtExPropertyType__Enabled, "Enabled" },
	{ (LONG64)vbox__HWVirtExPropertyType__VPID, "VPID" },
	{ (LONG64)vbox__HWVirtExPropertyType__NestedPaging, "NestedPaging" },
	{ (LONG64)vbox__HWVirtExPropertyType__UnrestrictedExecution, "UnrestrictedExecution" },
	{ (LONG64)vbox__HWVirtExPropertyType__LargePages, "LargePages" },
	{ (LONG64)vbox__HWVirtExPropertyType__Force, "Force" },
	{ (LONG64)vbox__HWVirtExPropertyType__UseNativeApi, "UseNativeApi" },
	{ (LONG64)vbox__HWVirtExPropertyType__VirtVmsaveVmload, "VirtVmsaveVmload" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__HWVirtExPropertyType2s(struct soap *soap, enum vbox__HWVirtExPropertyType n)
{
	const char *s = soap_code_str(soap_codes_vbox__HWVirtExPropertyType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__HWVirtExPropertyType(struct soap *soap, const char *tag, int id, const enum vbox__HWVirtExPropertyType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__HWVirtExPropertyType), type) || soap_send(soap, soap_vbox__HWVirtExPropertyType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__HWVirtExPropertyType(struct soap *soap, const char *s, enum vbox__HWVirtExPropertyType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__HWVirtExPropertyType, s);
	if (map)
		*a = (enum vbox__HWVirtExPropertyType)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 8)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__HWVirtExPropertyType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__HWVirtExPropertyType * SOAP_FMAC4 soap_in_vbox__HWVirtExPropertyType(struct soap *soap, const char *tag, enum vbox__HWVirtExPropertyType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__HWVirtExPropertyType*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__HWVirtExPropertyType, sizeof(enum vbox__HWVirtExPropertyType), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__HWVirtExPropertyType(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__HWVirtExPropertyType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__HWVirtExPropertyType, SOAP_TYPE_vbox__HWVirtExPropertyType, sizeof(enum vbox__HWVirtExPropertyType), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__HWVirtExPropertyType * SOAP_FMAC4 soap_new_vbox__HWVirtExPropertyType(struct soap *soap, int n)
{
	enum vbox__HWVirtExPropertyType *a = static_cast<enum vbox__HWVirtExPropertyType *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__HWVirtExPropertyType)));
	for (enum vbox__HWVirtExPropertyType *p = a; p && n--; ++p)
		soap_default_vbox__HWVirtExPropertyType(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__HWVirtExPropertyType(struct soap *soap, const enum vbox__HWVirtExPropertyType *a, const char *tag, const char *type)
{
	if (soap_out_vbox__HWVirtExPropertyType(soap, tag ? tag : "vbox:HWVirtExPropertyType", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__HWVirtExPropertyType * SOAP_FMAC4 soap_get_vbox__HWVirtExPropertyType(struct soap *soap, enum vbox__HWVirtExPropertyType *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__HWVirtExPropertyType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__CPUPropertyTypeARM[] =
{	{ (LONG64)vbox__CPUPropertyTypeARM__Null, "Null" },
	{ (LONG64)vbox__CPUPropertyTypeARM__HWVirt, "HWVirt" },
	{ (LONG64)vbox__CPUPropertyTypeARM__GICITS, "GICITS" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__CPUPropertyTypeARM2s(struct soap *soap, enum vbox__CPUPropertyTypeARM n)
{
	const char *s = soap_code_str(soap_codes_vbox__CPUPropertyTypeARM, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__CPUPropertyTypeARM(struct soap *soap, const char *tag, int id, const enum vbox__CPUPropertyTypeARM *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__CPUPropertyTypeARM), type) || soap_send(soap, soap_vbox__CPUPropertyTypeARM2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__CPUPropertyTypeARM(struct soap *soap, const char *s, enum vbox__CPUPropertyTypeARM *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__CPUPropertyTypeARM, s);
	if (map)
		*a = (enum vbox__CPUPropertyTypeARM)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__CPUPropertyTypeARM)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__CPUPropertyTypeARM * SOAP_FMAC4 soap_in_vbox__CPUPropertyTypeARM(struct soap *soap, const char *tag, enum vbox__CPUPropertyTypeARM *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__CPUPropertyTypeARM*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__CPUPropertyTypeARM, sizeof(enum vbox__CPUPropertyTypeARM), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__CPUPropertyTypeARM(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__CPUPropertyTypeARM *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__CPUPropertyTypeARM, SOAP_TYPE_vbox__CPUPropertyTypeARM, sizeof(enum vbox__CPUPropertyTypeARM), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__CPUPropertyTypeARM * SOAP_FMAC4 soap_new_vbox__CPUPropertyTypeARM(struct soap *soap, int n)
{
	enum vbox__CPUPropertyTypeARM *a = static_cast<enum vbox__CPUPropertyTypeARM *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__CPUPropertyTypeARM)));
	for (enum vbox__CPUPropertyTypeARM *p = a; p && n--; ++p)
		soap_default_vbox__CPUPropertyTypeARM(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__CPUPropertyTypeARM(struct soap *soap, const enum vbox__CPUPropertyTypeARM *a, const char *tag, const char *type)
{
	if (soap_out_vbox__CPUPropertyTypeARM(soap, tag ? tag : "vbox:CPUPropertyTypeARM", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__CPUPropertyTypeARM * SOAP_FMAC4 soap_get_vbox__CPUPropertyTypeARM(struct soap *soap, enum vbox__CPUPropertyTypeARM *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__CPUPropertyTypeARM(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__CPUPropertyTypeX86[] =
{	{ (LONG64)vbox__CPUPropertyTypeX86__Null, "Null" },
	{ (LONG64)vbox__CPUPropertyTypeX86__PAE, "PAE" },
	{ (LONG64)vbox__CPUPropertyTypeX86__LongMode, "LongMode" },
	{ (LONG64)vbox__CPUPropertyTypeX86__TripleFaultReset, "TripleFaultReset" },
	{ (LONG64)vbox__CPUPropertyTypeX86__APIC, "APIC" },
	{ (LONG64)vbox__CPUPropertyTypeX86__X2APIC, "X2APIC" },
	{ (LONG64)vbox__CPUPropertyTypeX86__IBPBOnVMExit, "IBPBOnVMExit" },
	{ (LONG64)vbox__CPUPropertyTypeX86__IBPBOnVMEntry, "IBPBOnVMEntry" },
	{ (LONG64)vbox__CPUPropertyTypeX86__HWVirt, "HWVirt" },
	{ (LONG64)vbox__CPUPropertyTypeX86__SpecCtrl, "SpecCtrl" },
	{ (LONG64)vbox__CPUPropertyTypeX86__SpecCtrlByHost, "SpecCtrlByHost" },
	{ (LONG64)vbox__CPUPropertyTypeX86__L1DFlushOnEMTScheduling, "L1DFlushOnEMTScheduling" },
	{ (LONG64)vbox__CPUPropertyTypeX86__L1DFlushOnVMEntry, "L1DFlushOnVMEntry" },
	{ (LONG64)vbox__CPUPropertyTypeX86__MDSClearOnEMTScheduling, "MDSClearOnEMTScheduling" },
	{ (LONG64)vbox__CPUPropertyTypeX86__MDSClearOnVMEntry, "MDSClearOnVMEntry" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__CPUPropertyTypeX862s(struct soap *soap, enum vbox__CPUPropertyTypeX86 n)
{
	const char *s = soap_code_str(soap_codes_vbox__CPUPropertyTypeX86, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__CPUPropertyTypeX86(struct soap *soap, const char *tag, int id, const enum vbox__CPUPropertyTypeX86 *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__CPUPropertyTypeX86), type) || soap_send(soap, soap_vbox__CPUPropertyTypeX862s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__CPUPropertyTypeX86(struct soap *soap, const char *s, enum vbox__CPUPropertyTypeX86 *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__CPUPropertyTypeX86, s);
	if (map)
		*a = (enum vbox__CPUPropertyTypeX86)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 14)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__CPUPropertyTypeX86)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__CPUPropertyTypeX86 * SOAP_FMAC4 soap_in_vbox__CPUPropertyTypeX86(struct soap *soap, const char *tag, enum vbox__CPUPropertyTypeX86 *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__CPUPropertyTypeX86*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__CPUPropertyTypeX86, sizeof(enum vbox__CPUPropertyTypeX86), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__CPUPropertyTypeX86(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__CPUPropertyTypeX86 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__CPUPropertyTypeX86, SOAP_TYPE_vbox__CPUPropertyTypeX86, sizeof(enum vbox__CPUPropertyTypeX86), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__CPUPropertyTypeX86 * SOAP_FMAC4 soap_new_vbox__CPUPropertyTypeX86(struct soap *soap, int n)
{
	enum vbox__CPUPropertyTypeX86 *a = static_cast<enum vbox__CPUPropertyTypeX86 *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__CPUPropertyTypeX86)));
	for (enum vbox__CPUPropertyTypeX86 *p = a; p && n--; ++p)
		soap_default_vbox__CPUPropertyTypeX86(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__CPUPropertyTypeX86(struct soap *soap, const enum vbox__CPUPropertyTypeX86 *a, const char *tag, const char *type)
{
	if (soap_out_vbox__CPUPropertyTypeX86(soap, tag ? tag : "vbox:CPUPropertyTypeX86", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__CPUPropertyTypeX86 * SOAP_FMAC4 soap_get_vbox__CPUPropertyTypeX86(struct soap *soap, enum vbox__CPUPropertyTypeX86 *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__CPUPropertyTypeX86(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__CPUArchitecture[] =
{	{ (LONG64)vbox__CPUArchitecture__Any, "Any" },
	{ (LONG64)vbox__CPUArchitecture__x86, "x86" },
	{ (LONG64)vbox__CPUArchitecture__AMD64, "AMD64" },
	{ (LONG64)vbox__CPUArchitecture__ARMv8_USCORE32, "ARMv8_32" },
	{ (LONG64)vbox__CPUArchitecture__ARMv8_USCORE64, "ARMv8_64" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__CPUArchitecture2s(struct soap *soap, enum vbox__CPUArchitecture n)
{
	const char *s = soap_code_str(soap_codes_vbox__CPUArchitecture, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__CPUArchitecture(struct soap *soap, const char *tag, int id, const enum vbox__CPUArchitecture *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__CPUArchitecture), type) || soap_send(soap, soap_vbox__CPUArchitecture2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__CPUArchitecture(struct soap *soap, const char *s, enum vbox__CPUArchitecture *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__CPUArchitecture, s);
	if (map)
		*a = (enum vbox__CPUArchitecture)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__CPUArchitecture)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__CPUArchitecture * SOAP_FMAC4 soap_in_vbox__CPUArchitecture(struct soap *soap, const char *tag, enum vbox__CPUArchitecture *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__CPUArchitecture*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__CPUArchitecture, sizeof(enum vbox__CPUArchitecture), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__CPUArchitecture(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__CPUArchitecture *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__CPUArchitecture, SOAP_TYPE_vbox__CPUArchitecture, sizeof(enum vbox__CPUArchitecture), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__CPUArchitecture * SOAP_FMAC4 soap_new_vbox__CPUArchitecture(struct soap *soap, int n)
{
	enum vbox__CPUArchitecture *a = static_cast<enum vbox__CPUArchitecture *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__CPUArchitecture)));
	for (enum vbox__CPUArchitecture *p = a; p && n--; ++p)
		soap_default_vbox__CPUArchitecture(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__CPUArchitecture(struct soap *soap, const enum vbox__CPUArchitecture *a, const char *tag, const char *type)
{
	if (soap_out_vbox__CPUArchitecture(soap, tag ? tag : "vbox:CPUArchitecture", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__CPUArchitecture * SOAP_FMAC4 soap_get_vbox__CPUArchitecture(struct soap *soap, enum vbox__CPUArchitecture *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__CPUArchitecture(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__PlatformArchitecture[] =
{	{ (LONG64)vbox__PlatformArchitecture__None, "None" },
	{ (LONG64)vbox__PlatformArchitecture__x86, "x86" },
	{ (LONG64)vbox__PlatformArchitecture__ARM, "ARM" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__PlatformArchitecture2s(struct soap *soap, enum vbox__PlatformArchitecture n)
{
	const char *s = soap_code_str(soap_codes_vbox__PlatformArchitecture, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__PlatformArchitecture(struct soap *soap, const char *tag, int id, const enum vbox__PlatformArchitecture *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__PlatformArchitecture), type) || soap_send(soap, soap_vbox__PlatformArchitecture2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__PlatformArchitecture(struct soap *soap, const char *s, enum vbox__PlatformArchitecture *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__PlatformArchitecture, s);
	if (map)
		*a = (enum vbox__PlatformArchitecture)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 2)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__PlatformArchitecture)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__PlatformArchitecture * SOAP_FMAC4 soap_in_vbox__PlatformArchitecture(struct soap *soap, const char *tag, enum vbox__PlatformArchitecture *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__PlatformArchitecture*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__PlatformArchitecture, sizeof(enum vbox__PlatformArchitecture), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__PlatformArchitecture(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__PlatformArchitecture *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__PlatformArchitecture, SOAP_TYPE_vbox__PlatformArchitecture, sizeof(enum vbox__PlatformArchitecture), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__PlatformArchitecture * SOAP_FMAC4 soap_new_vbox__PlatformArchitecture(struct soap *soap, int n)
{
	enum vbox__PlatformArchitecture *a = static_cast<enum vbox__PlatformArchitecture *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__PlatformArchitecture)));
	for (enum vbox__PlatformArchitecture *p = a; p && n--; ++p)
		soap_default_vbox__PlatformArchitecture(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__PlatformArchitecture(struct soap *soap, const enum vbox__PlatformArchitecture *a, const char *tag, const char *type)
{
	if (soap_out_vbox__PlatformArchitecture(soap, tag ? tag : "vbox:PlatformArchitecture", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__PlatformArchitecture * SOAP_FMAC4 soap_get_vbox__PlatformArchitecture(struct soap *soap, enum vbox__PlatformArchitecture *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__PlatformArchitecture(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__SessionState[] =
{	{ (LONG64)vbox__SessionState__Null, "Null" },
	{ (LONG64)vbox__SessionState__Unlocked, "Unlocked" },
	{ (LONG64)vbox__SessionState__Locked, "Locked" },
	{ (LONG64)vbox__SessionState__Spawning, "Spawning" },
	{ (LONG64)vbox__SessionState__Unlocking, "Unlocking" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__SessionState2s(struct soap *soap, enum vbox__SessionState n)
{
	const char *s = soap_code_str(soap_codes_vbox__SessionState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__SessionState(struct soap *soap, const char *tag, int id, const enum vbox__SessionState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__SessionState), type) || soap_send(soap, soap_vbox__SessionState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__SessionState(struct soap *soap, const char *s, enum vbox__SessionState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__SessionState, s);
	if (map)
		*a = (enum vbox__SessionState)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 4)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__SessionState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__SessionState * SOAP_FMAC4 soap_in_vbox__SessionState(struct soap *soap, const char *tag, enum vbox__SessionState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__SessionState*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__SessionState, sizeof(enum vbox__SessionState), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__SessionState(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__SessionState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__SessionState, SOAP_TYPE_vbox__SessionState, sizeof(enum vbox__SessionState), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__SessionState * SOAP_FMAC4 soap_new_vbox__SessionState(struct soap *soap, int n)
{
	enum vbox__SessionState *a = static_cast<enum vbox__SessionState *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__SessionState)));
	for (enum vbox__SessionState *p = a; p && n--; ++p)
		soap_default_vbox__SessionState(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__SessionState(struct soap *soap, const enum vbox__SessionState *a, const char *tag, const char *type)
{
	if (soap_out_vbox__SessionState(soap, tag ? tag : "vbox:SessionState", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__SessionState * SOAP_FMAC4 soap_get_vbox__SessionState(struct soap *soap, enum vbox__SessionState *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__SessionState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__MachineState[] =
{	{ (LONG64)vbox__MachineState__Null, "Null" },
	{ (LONG64)vbox__MachineState__PoweredOff, "PoweredOff" },
	{ (LONG64)vbox__MachineState__Saved, "Saved" },
	{ (LONG64)vbox__MachineState__Teleported, "Teleported" },
	{ (LONG64)vbox__MachineState__Aborted, "Aborted" },
	{ (LONG64)vbox__MachineState__AbortedSaved, "AbortedSaved" },
	{ (LONG64)vbox__MachineState__Running, "Running" },
	{ (LONG64)vbox__MachineState__Paused, "Paused" },
	{ (LONG64)vbox__MachineState__Stuck, "Stuck" },
	{ (LONG64)vbox__MachineState__Teleporting, "Teleporting" },
	{ (LONG64)vbox__MachineState__LiveSnapshotting, "LiveSnapshotting" },
	{ (LONG64)vbox__MachineState__Starting, "Starting" },
	{ (LONG64)vbox__MachineState__Stopping, "Stopping" },
	{ (LONG64)vbox__MachineState__Saving, "Saving" },
	{ (LONG64)vbox__MachineState__Restoring, "Restoring" },
	{ (LONG64)vbox__MachineState__TeleportingPausedVM, "TeleportingPausedVM" },
	{ (LONG64)vbox__MachineState__TeleportingIn, "TeleportingIn" },
	{ (LONG64)vbox__MachineState__DeletingSnapshotOnline, "DeletingSnapshotOnline" },
	{ (LONG64)vbox__MachineState__DeletingSnapshotPaused, "DeletingSnapshotPaused" },
	{ (LONG64)vbox__MachineState__OnlineSnapshotting, "OnlineSnapshotting" },
	{ (LONG64)vbox__MachineState__RestoringSnapshot, "RestoringSnapshot" },
	{ (LONG64)vbox__MachineState__DeletingSnapshot, "DeletingSnapshot" },
	{ (LONG64)vbox__MachineState__SettingUp, "SettingUp" },
	{ (LONG64)vbox__MachineState__Snapshotting, "Snapshotting" },
	{ (LONG64)vbox__MachineState__FirstOnline, "FirstOnline" },
	{ (LONG64)vbox__MachineState__LastOnline, "LastOnline" },
	{ (LONG64)vbox__MachineState__FirstTransient, "FirstTransient" },
	{ (LONG64)vbox__MachineState__LastTransient, "LastTransient" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__MachineState2s(struct soap *soap, enum vbox__MachineState n)
{
	const char *s = soap_code_str(soap_codes_vbox__MachineState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__MachineState(struct soap *soap, const char *tag, int id, const enum vbox__MachineState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__MachineState), type) || soap_send(soap, soap_vbox__MachineState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__MachineState(struct soap *soap, const char *s, enum vbox__MachineState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__MachineState, s);
	if (map)
		*a = (enum vbox__MachineState)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 27)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__MachineState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__MachineState * SOAP_FMAC4 soap_in_vbox__MachineState(struct soap *soap, const char *tag, enum vbox__MachineState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__MachineState*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__MachineState, sizeof(enum vbox__MachineState), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__MachineState(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__MachineState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__MachineState, SOAP_TYPE_vbox__MachineState, sizeof(enum vbox__MachineState), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__MachineState * SOAP_FMAC4 soap_new_vbox__MachineState(struct soap *soap, int n)
{
	enum vbox__MachineState *a = static_cast<enum vbox__MachineState *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__MachineState)));
	for (enum vbox__MachineState *p = a; p && n--; ++p)
		soap_default_vbox__MachineState(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__MachineState(struct soap *soap, const enum vbox__MachineState *a, const char *tag, const char *type)
{
	if (soap_out_vbox__MachineState(soap, tag ? tag : "vbox:MachineState", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__MachineState * SOAP_FMAC4 soap_get_vbox__MachineState(struct soap *soap, enum vbox__MachineState *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__MachineState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__AccessMode[] =
{	{ (LONG64)vbox__AccessMode__ReadOnly, "ReadOnly" },
	{ (LONG64)vbox__AccessMode__ReadWrite, "ReadWrite" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__AccessMode2s(struct soap *soap, enum vbox__AccessMode n)
{
	const char *s = soap_code_str(soap_codes_vbox__AccessMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__AccessMode(struct soap *soap, const char *tag, int id, const enum vbox__AccessMode *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__AccessMode), type) || soap_send(soap, soap_vbox__AccessMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__AccessMode(struct soap *soap, const char *s, enum vbox__AccessMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__AccessMode, s);
	if (map)
		*a = (enum vbox__AccessMode)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__AccessMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__AccessMode * SOAP_FMAC4 soap_in_vbox__AccessMode(struct soap *soap, const char *tag, enum vbox__AccessMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__AccessMode*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__AccessMode, sizeof(enum vbox__AccessMode), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__AccessMode(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__AccessMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__AccessMode, SOAP_TYPE_vbox__AccessMode, sizeof(enum vbox__AccessMode), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__AccessMode * SOAP_FMAC4 soap_new_vbox__AccessMode(struct soap *soap, int n)
{
	enum vbox__AccessMode *a = static_cast<enum vbox__AccessMode *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__AccessMode)));
	for (enum vbox__AccessMode *p = a; p && n--; ++p)
		soap_default_vbox__AccessMode(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__AccessMode(struct soap *soap, const enum vbox__AccessMode *a, const char *tag, const char *type)
{
	if (soap_out_vbox__AccessMode(soap, tag ? tag : "vbox:AccessMode", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__AccessMode * SOAP_FMAC4 soap_get_vbox__AccessMode(struct soap *soap, enum vbox__AccessMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__AccessMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

static const struct soap_code_map soap_codes_vbox__SettingsVersion[] =
{	{ (LONG64)vbox__SettingsVersion__Null, "Null" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE0, "v1_0" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE1, "v1_1" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE2, "v1_2" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE3pre, "v1_3pre" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE3, "v1_3" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE4, "v1_4" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE5, "v1_5" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE6, "v1_6" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE7, "v1_7" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE8, "v1_8" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE9, "v1_9" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE10, "v1_10" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE11, "v1_11" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE12, "v1_12" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE13, "v1_13" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE14, "v1_14" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE15, "v1_15" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE16, "v1_16" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE17, "v1_17" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE18, "v1_18" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE19, "v1_19" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE20, "v1_20" },
	{ (LONG64)vbox__SettingsVersion__v1_USCORE21, "v1_21" },
	{ (LONG64)vbox__SettingsVersion__Future, "Future" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_vbox__SettingsVersion2s(struct soap *soap, enum vbox__SettingsVersion n)
{
	const char *s = soap_code_str(soap_codes_vbox__SettingsVersion, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_vbox__SettingsVersion(struct soap *soap, const char *tag, int id, const enum vbox__SettingsVersion *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_vbox__SettingsVersion), type) || soap_send(soap, soap_vbox__SettingsVersion2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2vbox__SettingsVersion(struct soap *soap, const char *s, enum vbox__SettingsVersion *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_vbox__SettingsVersion, s);
	if (map)
		*a = (enum vbox__SettingsVersion)map->code;
	else if (!*s)
		return soap->error = SOAP_EMPTY;
	else
	{	int n;
		if (soap_s2int(soap, s, &n) || n < 0 || n > 24)
			return soap->error = SOAP_TYPE;
		*a = (enum vbox__SettingsVersion)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum vbox__SettingsVersion * SOAP_FMAC4 soap_in_vbox__SettingsVersion(struct soap *soap, const char *tag, enum vbox__SettingsVersion *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum vbox__SettingsVersion*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_vbox__SettingsVersion, sizeof(enum vbox__SettingsVersion), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (*soap->href != '#')
	{	int err = soap_s2vbox__SettingsVersion(soap, soap_value(soap), a);
		if ((soap->body && soap_element_end_in(soap, tag)) || err)
			return NULL;
	}
	else
	{	a = (enum vbox__SettingsVersion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_vbox__SettingsVersion, SOAP_TYPE_vbox__SettingsVersion, sizeof(enum vbox__SettingsVersion), 0, NULL, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 enum vbox__SettingsVersion * SOAP_FMAC4 soap_new_vbox__SettingsVersion(struct soap *soap, int n)
{
	enum vbox__SettingsVersion *a = static_cast<enum vbox__SettingsVersion *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(enum vbox__SettingsVersion)));
	for (enum vbox__SettingsVersion *p = a; p && n--; ++p)
		soap_default_vbox__SettingsVersion(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_vbox__SettingsVersion(struct soap *soap, const enum vbox__SettingsVersion *a, const char *tag, const char *type)
{
	if (soap_out_vbox__SettingsVersion(soap, tag ? tag : "vbox:SettingsVersion", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum vbox__SettingsVersion * SOAP_FMAC4 soap_get_vbox__SettingsVersion(struct soap *soap, enum vbox__SettingsVersion *p, const char *tag, const char *type)
{
	if ((p = soap_in_vbox__SettingsVersion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->_vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse::returnval);
}

void _vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_std__string(soap, &this->_vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse::returnval);
#endif
}

int _vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse(struct soap *soap, const char *tag, int id, const _vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse), type))
		return soap->error;
	if (soap_out_std__string(soap, "returnval", -1, &a->_vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse::returnval, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{
	return soap_in__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse(soap, tag, this, type);
}

SOAP_FMAC3 _vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse * SOAP_FMAC4 soap_in__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse(struct soap *soap, const char *tag, _vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse*)soap_id_enter(soap, soap->id, a, SOAP_TYPE__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse, sizeof(_vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag_returnval1 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnval1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_std__string(soap, "returnval", &a->_vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse::returnval, "xsd:string"))
				{	soap_flag_returnval1--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnval1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (_vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse, SOAP_TYPE__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse, sizeof(_vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse * SOAP_FMAC2 soap_instantiate__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse *p;
	size_t k = sizeof(_vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, _vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse);
		if (p)
			p->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, _vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				p[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

int _vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse(soap, tag ? tag : "vbox:ILanguageChangedEvent_getLanguageIdResponse", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse(soap, this, tag, type);
}

SOAP_FMAC3 _vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse * SOAP_FMAC4 soap_get__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse(struct soap *soap, _vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__vbox__ILanguageChangedEvent_USCOREgetLanguageIdResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _vbox__ILanguageChangedEvent_USCOREgetLanguageId::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->_vbox__ILanguageChangedEvent_USCOREgetLanguageId::_USCOREthis);
}

void _vbox__ILanguageChangedEvent_USCOREgetLanguageId::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_std__string(soap, &this->_vbox__ILanguageChangedEvent_USCOREgetLanguageId::_USCOREthis);
#endif
}

int _vbox__ILanguageChangedEvent_USCOREgetLanguageId::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__vbox__ILanguageChangedEvent_USCOREgetLanguageId(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__vbox__ILanguageChangedEvent_USCOREgetLanguageId(struct soap *soap, const char *tag, int id, const _vbox__ILanguageChangedEvent_USCOREgetLanguageId *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__vbox__ILanguageChangedEvent_USCOREgetLanguageId), type))
		return soap->error;
	if (soap_out_std__string(soap, "_this", -1, &a->_vbox__ILanguageChangedEvent_USCOREgetLanguageId::_USCOREthis, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_vbox__ILanguageChangedEvent_USCOREgetLanguageId::soap_in(struct soap *soap, const char *tag, const char *type)
{
	return soap_in__vbox__ILanguageChangedEvent_USCOREgetLanguageId(soap, tag, this, type);
}

SOAP_FMAC3 _vbox__ILanguageChangedEvent_USCOREgetLanguageId * SOAP_FMAC4 soap_in__vbox__ILanguageChangedEvent_USCOREgetLanguageId(struct soap *soap, const char *tag, _vbox__ILanguageChangedEvent_USCOREgetLanguageId *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_vbox__ILanguageChangedEvent_USCOREgetLanguageId*)soap_id_enter(soap, soap->id, a, SOAP_TYPE__vbox__ILanguageChangedEvent_USCOREgetLanguageId, sizeof(_vbox__ILanguageChangedEvent_USCOREgetLanguageId), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__vbox__ILanguageChangedEvent_USCOREgetLanguageId)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_vbox__ILanguageChangedEvent_USCOREgetLanguageId *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag__USCOREthis1 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__USCOREthis1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_std__string(soap, "_this", &a->_vbox__ILanguageChangedEvent_USCOREgetLanguageId::_USCOREthis, "xsd:string"))
				{	soap_flag__USCOREthis1--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__USCOREthis1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (_vbox__ILanguageChangedEvent_USCOREgetLanguageId *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__vbox__ILanguageChangedEvent_USCOREgetLanguageId, SOAP_TYPE__vbox__ILanguageChangedEvent_USCOREgetLanguageId, sizeof(_vbox__ILanguageChangedEvent_USCOREgetLanguageId), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _vbox__ILanguageChangedEvent_USCOREgetLanguageId * SOAP_FMAC2 soap_instantiate__vbox__ILanguageChangedEvent_USCOREgetLanguageId(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__vbox__ILanguageChangedEvent_USCOREgetLanguageId(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_vbox__ILanguageChangedEvent_USCOREgetLanguageId *p;
	size_t k = sizeof(_vbox__ILanguageChangedEvent_USCOREgetLanguageId);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE__vbox__ILanguageChangedEvent_USCOREgetLanguageId, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, _vbox__ILanguageChangedEvent_USCOREgetLanguageId);
		if (p)
			p->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, _vbox__ILanguageChangedEvent_USCOREgetLanguageId, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				p[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _vbox__ILanguageChangedEvent_USCOREgetLanguageId location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

int _vbox__ILanguageChangedEvent_USCOREgetLanguageId::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__vbox__ILanguageChangedEvent_USCOREgetLanguageId(soap, tag ? tag : "vbox:ILanguageChangedEvent_getLanguageId", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_vbox__ILanguageChangedEvent_USCOREgetLanguageId::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__vbox__ILanguageChangedEvent_USCOREgetLanguageId(soap, this, tag, type);
}

SOAP_FMAC3 _vbox__ILanguageChangedEvent_USCOREgetLanguageId * SOAP_FMAC4 soap_get__vbox__ILanguageChangedEvent_USCOREgetLanguageId(struct soap *soap, _vbox__ILanguageChangedEvent_USCOREgetLanguageId *p, const char *tag, const char *type)
{
	if ((p = soap_in__vbox__ILanguageChangedEvent_USCOREgetLanguageId(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _vbox__ICloudProfileChangedEvent_USCOREgetNameResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->_vbox__ICloudProfileChangedEvent_USCOREgetNameResponse::returnval);
}

void _vbox__ICloudProfileChangedEvent_USCOREgetNameResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_std__string(soap, &this->_vbox__ICloudProfileChangedEvent_USCOREgetNameResponse::returnval);
#endif
}

int _vbox__ICloudProfileChangedEvent_USCOREgetNameResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse(struct soap *soap, const char *tag, int id, const _vbox__ICloudProfileChangedEvent_USCOREgetNameResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse), type))
		return soap->error;
	if (soap_out_std__string(soap, "returnval", -1, &a->_vbox__ICloudProfileChangedEvent_USCOREgetNameResponse::returnval, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_vbox__ICloudProfileChangedEvent_USCOREgetNameResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{
	return soap_in__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse(soap, tag, this, type);
}

SOAP_FMAC3 _vbox__ICloudProfileChangedEvent_USCOREgetNameResponse * SOAP_FMAC4 soap_in__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse(struct soap *soap, const char *tag, _vbox__ICloudProfileChangedEvent_USCOREgetNameResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_vbox__ICloudProfileChangedEvent_USCOREgetNameResponse*)soap_id_enter(soap, soap->id, a, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse, sizeof(_vbox__ICloudProfileChangedEvent_USCOREgetNameResponse), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_vbox__ICloudProfileChangedEvent_USCOREgetNameResponse *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag_returnval1 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnval1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_std__string(soap, "returnval", &a->_vbox__ICloudProfileChangedEvent_USCOREgetNameResponse::returnval, "xsd:string"))
				{	soap_flag_returnval1--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnval1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (_vbox__ICloudProfileChangedEvent_USCOREgetNameResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse, sizeof(_vbox__ICloudProfileChangedEvent_USCOREgetNameResponse), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _vbox__ICloudProfileChangedEvent_USCOREgetNameResponse * SOAP_FMAC2 soap_instantiate__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_vbox__ICloudProfileChangedEvent_USCOREgetNameResponse *p;
	size_t k = sizeof(_vbox__ICloudProfileChangedEvent_USCOREgetNameResponse);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, _vbox__ICloudProfileChangedEvent_USCOREgetNameResponse);
		if (p)
			p->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, _vbox__ICloudProfileChangedEvent_USCOREgetNameResponse, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				p[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _vbox__ICloudProfileChangedEvent_USCOREgetNameResponse location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

int _vbox__ICloudProfileChangedEvent_USCOREgetNameResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse(soap, tag ? tag : "vbox:ICloudProfileChangedEvent_getNameResponse", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_vbox__ICloudProfileChangedEvent_USCOREgetNameResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse(soap, this, tag, type);
}

SOAP_FMAC3 _vbox__ICloudProfileChangedEvent_USCOREgetNameResponse * SOAP_FMAC4 soap_get__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse(struct soap *soap, _vbox__ICloudProfileChangedEvent_USCOREgetNameResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__vbox__ICloudProfileChangedEvent_USCOREgetNameResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _vbox__ICloudProfileChangedEvent_USCOREgetName::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->_vbox__ICloudProfileChangedEvent_USCOREgetName::_USCOREthis);
}

void _vbox__ICloudProfileChangedEvent_USCOREgetName::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_std__string(soap, &this->_vbox__ICloudProfileChangedEvent_USCOREgetName::_USCOREthis);
#endif
}

int _vbox__ICloudProfileChangedEvent_USCOREgetName::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__vbox__ICloudProfileChangedEvent_USCOREgetName(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__vbox__ICloudProfileChangedEvent_USCOREgetName(struct soap *soap, const char *tag, int id, const _vbox__ICloudProfileChangedEvent_USCOREgetName *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetName), type))
		return soap->error;
	if (soap_out_std__string(soap, "_this", -1, &a->_vbox__ICloudProfileChangedEvent_USCOREgetName::_USCOREthis, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_vbox__ICloudProfileChangedEvent_USCOREgetName::soap_in(struct soap *soap, const char *tag, const char *type)
{
	return soap_in__vbox__ICloudProfileChangedEvent_USCOREgetName(soap, tag, this, type);
}

SOAP_FMAC3 _vbox__ICloudProfileChangedEvent_USCOREgetName * SOAP_FMAC4 soap_in__vbox__ICloudProfileChangedEvent_USCOREgetName(struct soap *soap, const char *tag, _vbox__ICloudProfileChangedEvent_USCOREgetName *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_vbox__ICloudProfileChangedEvent_USCOREgetName*)soap_id_enter(soap, soap->id, a, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetName, sizeof(_vbox__ICloudProfileChangedEvent_USCOREgetName), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetName)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_vbox__ICloudProfileChangedEvent_USCOREgetName *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag__USCOREthis1 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__USCOREthis1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_std__string(soap, "_this", &a->_vbox__ICloudProfileChangedEvent_USCOREgetName::_USCOREthis, "xsd:string"))
				{	soap_flag__USCOREthis1--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__USCOREthis1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (_vbox__ICloudProfileChangedEvent_USCOREgetName *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetName, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetName, sizeof(_vbox__ICloudProfileChangedEvent_USCOREgetName), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _vbox__ICloudProfileChangedEvent_USCOREgetName * SOAP_FMAC2 soap_instantiate__vbox__ICloudProfileChangedEvent_USCOREgetName(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__vbox__ICloudProfileChangedEvent_USCOREgetName(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_vbox__ICloudProfileChangedEvent_USCOREgetName *p;
	size_t k = sizeof(_vbox__ICloudProfileChangedEvent_USCOREgetName);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetName, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, _vbox__ICloudProfileChangedEvent_USCOREgetName);
		if (p)
			p->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, _vbox__ICloudProfileChangedEvent_USCOREgetName, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				p[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _vbox__ICloudProfileChangedEvent_USCOREgetName location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

int _vbox__ICloudProfileChangedEvent_USCOREgetName::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__vbox__ICloudProfileChangedEvent_USCOREgetName(soap, tag ? tag : "vbox:ICloudProfileChangedEvent_getName", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_vbox__ICloudProfileChangedEvent_USCOREgetName::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__vbox__ICloudProfileChangedEvent_USCOREgetName(soap, this, tag, type);
}

SOAP_FMAC3 _vbox__ICloudProfileChangedEvent_USCOREgetName * SOAP_FMAC4 soap_get__vbox__ICloudProfileChangedEvent_USCOREgetName(struct soap *soap, _vbox__ICloudProfileChangedEvent_USCOREgetName *p, const char *tag, const char *type)
{
	if ((p = soap_in__vbox__ICloudProfileChangedEvent_USCOREgetName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->_vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse::returnval);
}

void _vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_std__string(soap, &this->_vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse::returnval);
#endif
}

int _vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse(struct soap *soap, const char *tag, int id, const _vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse), type))
		return soap->error;
	if (soap_out_std__string(soap, "returnval", -1, &a->_vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse::returnval, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{
	return soap_in__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse(soap, tag, this, type);
}

SOAP_FMAC3 _vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse * SOAP_FMAC4 soap_in__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse(struct soap *soap, const char *tag, _vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse*)soap_id_enter(soap, soap->id, a, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse, sizeof(_vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag_returnval1 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnval1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_std__string(soap, "returnval", &a->_vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse::returnval, "xsd:string"))
				{	soap_flag_returnval1--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnval1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (_vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse, sizeof(_vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse * SOAP_FMAC2 soap_instantiate__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse *p;
	size_t k = sizeof(_vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, _vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse);
		if (p)
			p->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, _vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				p[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

int _vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse(soap, tag ? tag : "vbox:ICloudProfileChangedEvent_getProviderIdResponse", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse(soap, this, tag, type);
}

SOAP_FMAC3 _vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse * SOAP_FMAC4 soap_get__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse(struct soap *soap, _vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__vbox__ICloudProfileChangedEvent_USCOREgetProviderIdResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _vbox__ICloudProfileChangedEvent_USCOREgetProviderId::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->_vbox__ICloudProfileChangedEvent_USCOREgetProviderId::_USCOREthis);
}

void _vbox__ICloudProfileChangedEvent_USCOREgetProviderId::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_std__string(soap, &this->_vbox__ICloudProfileChangedEvent_USCOREgetProviderId::_USCOREthis);
#endif
}

int _vbox__ICloudProfileChangedEvent_USCOREgetProviderId::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__vbox__ICloudProfileChangedEvent_USCOREgetProviderId(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__vbox__ICloudProfileChangedEvent_USCOREgetProviderId(struct soap *soap, const char *tag, int id, const _vbox__ICloudProfileChangedEvent_USCOREgetProviderId *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetProviderId), type))
		return soap->error;
	if (soap_out_std__string(soap, "_this", -1, &a->_vbox__ICloudProfileChangedEvent_USCOREgetProviderId::_USCOREthis, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_vbox__ICloudProfileChangedEvent_USCOREgetProviderId::soap_in(struct soap *soap, const char *tag, const char *type)
{
	return soap_in__vbox__ICloudProfileChangedEvent_USCOREgetProviderId(soap, tag, this, type);
}

SOAP_FMAC3 _vbox__ICloudProfileChangedEvent_USCOREgetProviderId * SOAP_FMAC4 soap_in__vbox__ICloudProfileChangedEvent_USCOREgetProviderId(struct soap *soap, const char *tag, _vbox__ICloudProfileChangedEvent_USCOREgetProviderId *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_vbox__ICloudProfileChangedEvent_USCOREgetProviderId*)soap_id_enter(soap, soap->id, a, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetProviderId, sizeof(_vbox__ICloudProfileChangedEvent_USCOREgetProviderId), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetProviderId)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_vbox__ICloudProfileChangedEvent_USCOREgetProviderId *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag__USCOREthis1 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__USCOREthis1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_std__string(soap, "_this", &a->_vbox__ICloudProfileChangedEvent_USCOREgetProviderId::_USCOREthis, "xsd:string"))
				{	soap_flag__USCOREthis1--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__USCOREthis1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (_vbox__ICloudProfileChangedEvent_USCOREgetProviderId *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetProviderId, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetProviderId, sizeof(_vbox__ICloudProfileChangedEvent_USCOREgetProviderId), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _vbox__ICloudProfileChangedEvent_USCOREgetProviderId * SOAP_FMAC2 soap_instantiate__vbox__ICloudProfileChangedEvent_USCOREgetProviderId(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__vbox__ICloudProfileChangedEvent_USCOREgetProviderId(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_vbox__ICloudProfileChangedEvent_USCOREgetProviderId *p;
	size_t k = sizeof(_vbox__ICloudProfileChangedEvent_USCOREgetProviderId);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE__vbox__ICloudProfileChangedEvent_USCOREgetProviderId, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, _vbox__ICloudProfileChangedEvent_USCOREgetProviderId);
		if (p)
			p->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, _vbox__ICloudProfileChangedEvent_USCOREgetProviderId, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				p[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _vbox__ICloudProfileChangedEvent_USCOREgetProviderId location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

int _vbox__ICloudProfileChangedEvent_USCOREgetProviderId::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__vbox__ICloudProfileChangedEvent_USCOREgetProviderId(soap, tag ? tag : "vbox:ICloudProfileChangedEvent_getProviderId", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_vbox__ICloudProfileChangedEvent_USCOREgetProviderId::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__vbox__ICloudProfileChangedEvent_USCOREgetProviderId(soap, this, tag, type);
}

SOAP_FMAC3 _vbox__ICloudProfileChangedEvent_USCOREgetProviderId * SOAP_FMAC4 soap_get__vbox__ICloudProfileChangedEvent_USCOREgetProviderId(struct soap *soap, _vbox__ICloudProfileChangedEvent_USCOREgetProviderId *p, const char *tag, const char *type)
{
	if ((p = soap_in__vbox__ICloudProfileChangedEvent_USCOREgetProviderId(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &this->_vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse::returnval);
}

void _vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
#endif
}

int _vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse(struct soap *soap, const char *tag, int id, const _vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse), type))
		return soap->error;
	if (soap_out_bool(soap, "returnval", -1, &a->_vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse::returnval, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{
	return soap_in__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse(soap, tag, this, type);
}

SOAP_FMAC3 _vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse * SOAP_FMAC4 soap_in__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse(struct soap *soap, const char *tag, _vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse*)soap_id_enter(soap, soap->id, a, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse, sizeof(_vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag_returnval1 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnval1 && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_bool(soap, "returnval", &a->_vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse::returnval, "xsd:boolean"))
				{	soap_flag_returnval1--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnval1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (_vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse, sizeof(_vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse * SOAP_FMAC2 soap_instantiate__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse *p;
	size_t k = sizeof(_vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, _vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse);
		if (p)
			p->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, _vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				p[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

int _vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse(soap, tag ? tag : "vbox:ICloudProfileRegisteredEvent_getRegisteredResponse", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse(soap, this, tag, type);
}

SOAP_FMAC3 _vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse * SOAP_FMAC4 soap_get__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse(struct soap *soap, _vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__vbox__ICloudProfileRegisteredEvent_USCOREgetRegisteredResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->_vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered::_USCOREthis);
}

void _vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_std__string(soap, &this->_vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered::_USCOREthis);
#endif
}

int _vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered(struct soap *soap, const char *tag, int id, const _vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered), type))
		return soap->error;
	if (soap_out_std__string(soap, "_this", -1, &a->_vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered::_USCOREthis, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered::soap_in(struct soap *soap, const char *tag, const char *type)
{
	return soap_in__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered(soap, tag, this, type);
}

SOAP_FMAC3 _vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered * SOAP_FMAC4 soap_in__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered(struct soap *soap, const char *tag, _vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered*)soap_id_enter(soap, soap->id, a, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered, sizeof(_vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag__USCOREthis1 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__USCOREthis1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_std__string(soap, "_this", &a->_vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered::_USCOREthis, "xsd:string"))
				{	soap_flag__USCOREthis1--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__USCOREthis1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (_vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered, sizeof(_vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered * SOAP_FMAC2 soap_instantiate__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered *p;
	size_t k = sizeof(_vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered);
	struct soap_clist *cp = soap_link(soap, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered, n, soap_fdelete);
	if (!cp && soap && n != SOAP_NO_LINK_TO_DELETE)
		return NULL;
	if (n < 0)
	{	p = SOAP_NEW(soap, _vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered);
		if (p)
			p->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(soap, _vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				p[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered location=%p n=%d\n", (void*)p, n));
	if (size)
		*size = k;
	if (!p)
		soap->error = SOAP_EOM;
	else if (cp)
		cp->ptr = (void*)p;
	return p;
}

int _vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered(soap, tag ? tag : "vbox:ICloudProfileRegisteredEvent_getRegistered", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered(soap, this, tag, type);
}

SOAP_FMAC3 _vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered * SOAP_FMAC4 soap_get__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered(struct soap *soap, _vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered *p, const char *tag, const char *type)
{
	if ((p = soap_in__vbox__ICloudProfileRegisteredEvent_USCOREgetRegistered(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->_vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse::returnval);
}

void _vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_std__string(soap, &this->_vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse::returnval);
#endif
}

int _vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse(struct soap *soap, const char *tag, int id, const _vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse), type))
		return soap->error;
	if (soap_out_std__string(soap, "returnval", -1, &a->_vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse::returnval, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{
	return soap_in__vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse(soap, tag, this, type);
}

SOAP_FMAC3 _vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse * SOAP_FMAC4 soap_in__vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse(struct soap *soap, const char *tag, _vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse*)soap_id_enter(soap, soap->id, a, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse, sizeof(_vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag_returnval1 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnval1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_std__string(soap, "returnval", &a->_vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse::returnval, "xsd:string"))
				{	soap_flag_returnval1--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnval1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	}
	else if ((soap->mode & SOAP_XML_STRICT) && *soap->href != '#')
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	else
	{	a = (_vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse, SOAP_TYPE__vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse, sizeof(_vbox__ICloudProfileRegisteredEvent_USCOREgetNameResponse), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}
